/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.iptransport;

import java.util.ArrayList;
import java.util.Map;
import se.ericsson.cello.equipment.PiuUtils;
import se.ericsson.cello.indications.fropxy.MaoFroIndicationHandler;
import se.ericsson.cello.indications.fropxy.MaoFroIndicationSubscriber;
import se.ericsson.cello.ipoam.IpInterfaceGroupBuildIF;
import se.ericsson.cello.iptransport.IpAccessHostEtMo;
import se.ericsson.cello.iptransport.IpInterfaceGroupMo;
import se.ericsson.cello.iptransport.IpInterfaceMo;
import se.ericsson.cello.managedelement.MoDataRecoveryHelper;
import se.ericsson.cello.mao.CelloMao;
import se.ericsson.cello.mao.ConfigurationMismatchException;
import se.ericsson.cello.mao.FroInfo;
import se.ericsson.cello.mao.InvalidReferenceException;
import se.ericsson.cello.mao.MaoFroTypeConverter;
import se.ericsson.cello.mao.MoAttributeValidator;
import se.ericsson.cello.mao.MoNotPossibleToReserveException;
import se.ericsson.cello.mao.MoReservedNotDeletableException;
import se.ericsson.cello.mao.Reservable;
import se.ericsson.cello.mao.ReservableImpl;
import se.ericsson.cello.maofro.framework.FroData;
import se.ericsson.cello.maofro.framework.FroProxy;
import se.ericsson.cello.maofro.framework.Parameter;
import se.ericsson.cello.maofro.framework.SignedIntParameter;
import se.ericsson.cello.maofro.framework.StructParameter;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoCanNotBeCreatedException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.moframework.SequenceAttribute;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.moframework.WrongAttributeTypeException;
import se.ericsson.cello.transaction.Coordinator;

public class IpInterfaceGroupMoImpl
extends CelloMao
implements IpInterfaceGroupMo,
Reservable,
FroInfo,
IpInterfaceGroupBuildIF {
    private MoData data;
    private FroProxy genIpInterfaceGroupProxy = null;
    private MaoFroIndicationHandler indicationHandler = null;
    private static final String IP_INTERFACE_GROUP_FRO_ID = "ipInterfaceGroupFroId";
    private static final int MAX_NO_IP_INTERFACE_GROUP = 16;
    protected static final String PIU_FRO_ID = "piuFroId";
    protected static final String DH_FRO_ID = "dhFroId";
    private static final int MO_DATA_REVISION_9000 = 9000;
    private static final int MO_DATA_REVISION_LATEST = 9000;
    private static Class[] ipInterfaceClassName = new Class[]{IpInterfaceMo.class};
    static /* synthetic */ Class class$java$lang$String;

    public static synchronized ManagedObject create(ManagedObject managedObject, AttrList attrList, String string, ManagedObject managedObject2, Coordinator coordinator, FroProxy froProxy, MaoFroIndicationHandler maoFroIndicationHandler) throws MoAccessException {
        boolean bl;
        MoAttributeValidator.checkTransaction((Coordinator)coordinator);
        MoAttributeValidator.checkIdentity((String)"IpInterfaceGroup", (String)string);
        MoAttributeValidator.checkParent((ManagedObject)managedObject, (String)"IpSystem");
        MoAttributeValidator.checkNoOfSiblings((ManagedObject)managedObject, (String)"IpInterfaceGroup", (int)16);
        String string2 = MoAttributeValidator.checkAndGetStringAttributeWithLength((String)"userLabel", (AttrList)attrList, (boolean)false, (String)"", (String)"IpInterfaceGroup", (int)128, (int)0);
        IpInterfaceMo ipInterfaceMo = (IpInterfaceMo)MoAttributeValidator.checkAndGetReferenceAttribute((String)"primaryIpInterfaceRef", (AttrList)attrList, (boolean)true, (Class[])ipInterfaceClassName, (String)"IpInterfaceGroup");
        IpInterfaceMo ipInterfaceMo2 = (IpInterfaceMo)MoAttributeValidator.checkAndGetReferenceAttribute((String)"secondaryIpInterfaceRef", (AttrList)attrList, (boolean)true, (Class[])ipInterfaceClassName, (String)"IpInterfaceGroup");
        if (!ipInterfaceMo.getSubnet(coordinator).equals(ipInterfaceMo2.getSubnet(coordinator))) {
            throw new MoCanNotBeCreatedException("PrimaryIpInterfaceRef and SecondaryIpInterfaceRef must belong to the same subnet. IpInterfaceGroup");
        }
        if (PiuUtils.findPiuParent((ManagedObject)ipInterfaceMo) == PiuUtils.findPiuParent((ManagedObject)ipInterfaceMo2)) {
            throw new MoCanNotBeCreatedException("PrimaryIpInterfaceRef and SecondaryIpInterfaceRef must belong to the different PlugInUnits. IpInterfaceGroup");
        }
        boolean bl2 = ipInterfaceMo.getVLan(coordinator);
        if (bl2 == (bl = ipInterfaceMo2.getVLan(coordinator))) {
            if (bl2 && ipInterfaceMo.getVid(coordinator) != ipInterfaceMo2.getVid(coordinator)) {
                throw new MoCanNotBeCreatedException("PrimaryIpInterfaceRef and SecondaryIpInterfaceRef must have same Vid if their Vlan is true. IpInterfaceGroup");
            }
            ManagedObject managedObject3 = ipInterfaceMo.getVlanRef(coordinator);
            ManagedObject managedObject4 = ipInterfaceMo2.getVlanRef(coordinator);
            if (managedObject3 != null && managedObject4 != null && managedObject3 != managedObject4) {
                throw new MoCanNotBeCreatedException("PrimaryIpInterfaceRef and SecondaryIpInterfaceRef must be in same Vlan. IpInterfaceGroup");
            }
        } else {
            throw new MoCanNotBeCreatedException("PrimaryIpInterfaceRef and SecondaryIpInterfaceRef must have the same Vlan. IpInterfaceGroup");
        }
        MoAttributeValidator.checkOtherAttributes((AttrList)attrList, (String)"IpInterfaceGroup");
        return new IpInterfaceGroupMoImpl(managedObject, string, string2, ipInterfaceMo, ipInterfaceMo2, coordinator, froProxy, maoFroIndicationHandler);
    }

    private IpInterfaceGroupMoImpl(ManagedObject managedObject, String string, String string2, ManagedObject managedObject2, ManagedObject managedObject3, Coordinator coordinator, FroProxy froProxy, MaoFroIndicationHandler maoFroIndicationHandler) throws MoAccessException {
        super(managedObject, "IpInterfaceGroup", string, coordinator);
        this.genIpInterfaceGroupProxy = froProxy;
        this.indicationHandler = maoFroIndicationHandler;
        if (managedObject2 == null || managedObject3 == null) {
            throw new MoCanNotBeCreatedException("PrimaryIpInterfaceRef or SecondaryIpInterfaceRef can not be null. IpInterfaceGroup");
        }
        this.data = new MoData(this.getLocalDistinguishedName(), this.getType(), true, coordinator);
        this.data.registerPersistentAttr((Attribute)new StringAttribute("userLabel", true, string2));
        this.data.registerPersistentAttr((Attribute)new SequenceAttribute("reservedBy", false));
        if (managedObject2 != null) {
            ((Reservable)managedObject2).reserve((ManagedObject)this, coordinator);
        }
        if (managedObject3 != null) {
            ((Reservable)managedObject3).reserve((ManagedObject)this, coordinator);
        }
        int n = this.createIpInterfaceGroupFro(coordinator, managedObject2, managedObject3);
        this.data.registerPersistentAttr((Attribute)new IntegerAttribute(IP_INTERFACE_GROUP_FRO_ID, false, n));
        this.data.setRevision(9000);
        this.indicationHandler.registerForNotifications(coordinator, (MaoFroIndicationSubscriber)this, n);
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
    }

    public IpInterfaceGroupMoImpl(MoData moData, FroProxy froProxy, MaoFroIndicationHandler maoFroIndicationHandler) throws MoNameAlreadyTakenException {
        super(moData.getLocalDistinguishedName());
        this.data = moData;
        this.genIpInterfaceGroupProxy = froProxy;
        this.indicationHandler = maoFroIndicationHandler;
        MoDataRecoveryHelper moDataRecoveryHelper = new MoDataRecoveryHelper(this.data, (ManagedObject)this);
        moDataRecoveryHelper.assertMoDataRevision(9000);
        moDataRecoveryHelper.assertAttribute("userLabel");
        moDataRecoveryHelper.assertAttribute(IP_INTERFACE_GROUP_FRO_ID);
        moDataRecoveryHelper.assertAttribute("reservedBy");
        this.indicationHandler.registerForNotifications(null, (MaoFroIndicationSubscriber)this, ((IntegerAttribute)this.data.getAttribute(IP_INTERFACE_GROUP_FRO_ID)).getValue(null));
    }

    public void delete(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        if (this.getReservedBy(coordinator).length != 0) {
            throw new MoReservedNotDeletableException((ManagedObject)this);
        }
        ((Reservable)this.getPrimaryIpInterfaceRef(coordinator)).release((ManagedObject)this, coordinator);
        ((Reservable)this.getSecondaryIpInterfaceRef(coordinator)).release((ManagedObject)this, coordinator);
        this.indicationHandler.deregisterForNotifications(coordinator, this.getFroId(coordinator));
        this.genIpInterfaceGroupProxy.delete(coordinator, this.getFroId(coordinator), null);
        super.delete(coordinator);
        this.data.delete(coordinator);
    }

    public void reserve(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        if (managedObject == null) {
            throw new InvalidReferenceException("IpInterfaceGroup", "null");
        }
        ManagedObject[] managedObjectArray = ReservableImpl.retrieveRefArrayFromSequence((SequenceAttribute)((SequenceAttribute)this.data.getAttribute("reservedBy")), (Coordinator)coordinator);
        for (int i = 0; i < managedObjectArray.length; ++i) {
            if (!(managedObject instanceof IpAccessHostEtMo) || !(managedObjectArray[i] instanceof IpAccessHostEtMo)) continue;
            throw new MoNotPossibleToReserveException("Only one IpAccessHostEt instance is allowed to reserve IpInterfaceGroup, Already reserved by: " + managedObjectArray[i], "IpInterfaceGroup");
        }
        ReservableImpl.reserve((ManagedObject)managedObject, (Coordinator)coordinator, (MoData)this.data, (String)"reservedBy");
    }

    public void release(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        ReservableImpl.release((ManagedObject)managedObject, (Coordinator)coordinator, (MoData)this.data, (String)"reservedBy");
    }

    public ManagedObject[] getReservedBy(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return ReservableImpl.retrieveRefArrayFromSequence((SequenceAttribute)((SequenceAttribute)this.data.getAttribute("reservedBy")), (Coordinator)coordinator);
    }

    public String getUserLabel(Coordinator coordinator) throws MoAccessException {
        return (String)this.getAttribute("userLabel", coordinator);
    }

    public void setUserLabel(String string, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("userLabel", string, coordinator);
    }

    public ManagedObject getPrimaryIpInterfaceRef(Coordinator coordinator) throws MoAccessException {
        return (ManagedObject)this.getAttribute("primaryIpInterfaceRef", coordinator);
    }

    public ManagedObject getSecondaryIpInterfaceRef(Coordinator coordinator) throws MoAccessException {
        return (ManagedObject)this.getAttribute("secondaryIpInterfaceRef", coordinator);
    }

    public ManagedObject getActiveIpInterfaceRef(Coordinator coordinator) throws MoAccessException {
        return (ManagedObject)this.getAttribute("activeIpInterfaceRef", coordinator);
    }

    public String getType() {
        return "IpInterfaceGroup";
    }

    public int getFroId(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return ((IntegerAttribute)this.data.getAttribute(IP_INTERFACE_GROUP_FRO_ID)).getValue(coordinator);
    }

    public String getIpInterfaceGroupId(Coordinator coordinator) throws MoAccessException {
        return (String)this.getAttribute(this.getType() + "Id", coordinator);
    }

    public Object getAttribute(String string, Coordinator coordinator) throws MoAccessException, NoSuchAttributeException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        String[] stringArray = new String[]{string};
        Object[] objectArray = this.getAttributes(stringArray, coordinator);
        return objectArray[0];
    }

    public Object[] getAttributes(String[] stringArray, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        Object[] objectArray = new Object[stringArray.length];
        Map map = null;
        for (int i = 0; i < stringArray.length; ++i) {
            SignedIntParameter signedIntParameter;
            StructParameter structParameter;
            if (stringArray[i].equalsIgnoreCase("userLabel")) {
                objectArray[i] = ((StringAttribute)this.data.getAttribute("userLabel")).getValue(coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase(this.getType() + "Id")) {
                objectArray[i] = super.getNamingAttributeValue();
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("reservedBy")) {
                objectArray[i] = this.getReservedBy(coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("primaryIpInterfaceRef")) {
                map = this.getAttrFromRes(map, coordinator);
                objectArray[i] = null;
                structParameter = (StructParameter)map.get("primaryIpInterfaceRef");
                if (structParameter == null || (signedIntParameter = (SignedIntParameter)structParameter.get(DH_FRO_ID)).getValue() == 0) continue;
                objectArray[i] = MaoFroTypeConverter.froId2MaoInstance((String)"IpInterface", (int)signedIntParameter.getValue(), (Coordinator)coordinator);
                if (objectArray[i] != null) continue;
                throw new ConfigurationMismatchException("Failed to fetch reference for dhFroId=" + signedIntParameter.getValue(), "IpInterfaceGroup", "primaryIpInterfaceRef");
            }
            if (stringArray[i].equalsIgnoreCase("secondaryIpInterfaceRef")) {
                map = this.getAttrFromRes(map, coordinator);
                objectArray[i] = null;
                structParameter = (StructParameter)map.get("secondaryIpInterfaceRef");
                if (structParameter == null || (signedIntParameter = (SignedIntParameter)structParameter.get(DH_FRO_ID)).getValue() == 0) continue;
                objectArray[i] = MaoFroTypeConverter.froId2MaoInstance((String)"IpInterface", (int)signedIntParameter.getValue(), (Coordinator)coordinator);
                if (objectArray[i] != null) continue;
                throw new ConfigurationMismatchException("Failed to fetch reference ", "IpInterfaceGroup", "secondaryIpInterfaceRef");
            }
            if (stringArray[i].equalsIgnoreCase("activeIpInterfaceRef")) {
                map = this.getAttrFromRes(map, coordinator);
                objectArray[i] = null;
                structParameter = (StructParameter)map.get("activeIpInterfaceRef");
                if (structParameter == null || (signedIntParameter = (SignedIntParameter)structParameter.get(DH_FRO_ID)).getValue() == 0) continue;
                objectArray[i] = MaoFroTypeConverter.froId2MaoInstance((String)"IpInterface", (int)signedIntParameter.getValue(), (Coordinator)coordinator);
                if (objectArray[i] != null) continue;
                throw new ConfigurationMismatchException("Failed to fetch reference ", "IpInterfaceGroup", "activeIpInterfaceRef");
            }
            throw new NoSuchAttributeException(stringArray[i], "IpInterfaceGroup");
        }
        return objectArray;
    }

    public void setAttribute(String string, Object object, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        String[] stringArray = new String[]{string};
        Object[] objectArray = new Object[]{object};
        this.setAttributes(stringArray, objectArray, coordinator);
    }

    public void setAttributes(String[] stringArray, Object[] objectArray, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        boolean bl = false;
        Object var5_5 = null;
        Object var6_6 = null;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equalsIgnoreCase("userLabel")) {
                if (!objectArray[i].getClass().equals(class$java$lang$String == null ? IpInterfaceGroupMoImpl.class$("java.lang.String") : class$java$lang$String)) {
                    throw new WrongAttributeTypeException("userLabel", "IpInterfaceGroup");
                }
            } else {
                throw new NoSuchAttributeException(stringArray[i], "IpInterfaceGroup");
            }
            MoAttributeValidator.checkStringWithLength((String)((String)objectArray[i]), (String)"userLabel", (String)"IpInterfaceGroup", (int)128, (int)0);
            ((StringAttribute)this.data.getAttribute("userLabel")).setValue((String)objectArray[i]);
        }
    }

    private Map getAttrFromRes(Map map, Coordinator coordinator) throws MoAccessException {
        if (map == null) {
            return this.getFroAttributes(coordinator);
        }
        return map;
    }

    private Map getFroAttributes(Coordinator coordinator) throws MoAccessException {
        Map map = this.genIpInterfaceGroupProxy.getAttributes(coordinator, this.getFroId(coordinator));
        return map;
    }

    private int createIpInterfaceGroupFro(Coordinator coordinator, ManagedObject managedObject, ManagedObject managedObject2) throws MoAccessException {
        ArrayList<StructParameter> arrayList = new ArrayList<StructParameter>();
        this.createStructParameter("primaryIpInterfaceRef", managedObject, coordinator);
        arrayList.add(this.createStructParameter("primaryIpInterfaceRef", managedObject, coordinator));
        arrayList.add(this.createStructParameter("secondaryIpInterfaceRef", managedObject2, coordinator));
        FroData froData = this.genIpInterfaceGroupProxy.create(coordinator, arrayList);
        return froData.getFroId();
    }

    private StructParameter createStructParameter(String string, ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        StructParameter structParameter = new StructParameter(string);
        IpInterfaceMo ipInterfaceMo = (IpInterfaceMo)managedObject;
        structParameter.add((Parameter)new SignedIntParameter(DH_FRO_ID, ipInterfaceMo.getFroId(coordinator)));
        int n = PiuUtils.findPiuParentFroId((ManagedObject)managedObject);
        structParameter.add((Parameter)new SignedIntParameter(PIU_FRO_ID, n));
        return structParameter;
    }
}

