/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.iptransport;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import se.ericsson.cello.iptransport.IpAccessHostEtMo;
import se.ericsson.cello.iptransport.IpAccessHostEtMoImpl;
import se.ericsson.cello.iptransport.IpMuxMo;
import se.ericsson.cello.iptransport.Ipv6InterfaceMo;
import se.ericsson.cello.managedelement.MoDataRecoveryHelper;
import se.ericsson.cello.mao.CelloMao;
import se.ericsson.cello.mao.FroInfo;
import se.ericsson.cello.mao.MoAttributeValidator;
import se.ericsson.cello.mao.Reservable;
import se.ericsson.cello.maofro.framework.FroData;
import se.ericsson.cello.maofro.framework.FroProxy;
import se.ericsson.cello.maofro.framework.SignedIntParameter;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoCanNotBeCreatedException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.moframework.NotificationSender;
import se.ericsson.cello.moframework.ReferenceAttribute;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.moframework.WrongAttributeTypeException;
import se.ericsson.cello.transaction.Coordinator;

public class IpMuxMoImpl
extends CelloMao
implements IpMuxMo {
    private MoData data;
    private static final int MO_DATA_REVISION_8 = 8000;
    private static final int MO_DATA_REVISION_LATEST = 8000;
    private static final int MAX_NO_IP_MUX = 64;
    private FroProxy ipMuxProxy = null;
    protected static final String IPMUXMI_HOSTPIU_ID = "hostPiuId";
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Integer;

    public static synchronized ManagedObject create(ManagedObject managedObject, AttrList attrList, String string, ManagedObject managedObject2, Coordinator coordinator, FroProxy froProxy) throws MoAccessException {
        MoAttributeValidator.checkTransaction((Coordinator)coordinator);
        MoAttributeValidator.checkIdentity((String)"IpMux", (String)string);
        MoAttributeValidator.checkParent((ManagedObject)managedObject, (String)"IpSystem");
        MoAttributeValidator.checkNoOfSiblings((ManagedObject)managedObject, (String)"IpMux", (int)64);
        ArrayList<SignedIntParameter> arrayList = new ArrayList<SignedIntParameter>();
        String string2 = MoAttributeValidator.checkAndGetStringAttributeWithLength((String)"userLabel", (AttrList)attrList, (boolean)false, (String)"", (String)"IpMux", (int)128, (int)0);
        ManagedObject managedObject3 = MoAttributeValidator.checkAndGetReferenceAttribute((String)"ipAccessHostEtRef", (AttrList)attrList, (boolean)true, (Class)IpAccessHostEtMo.class, (String)"IpMux");
        int n = MoAttributeValidator.checkAndGetIntegerAttribute((String)"maxMuxPacketSize", (AttrList)attrList, (boolean)false, (int)1500, (int)576, (int)1500, (String)"IpMux");
        MoAttributeValidator.checkOtherAttributes((AttrList)attrList, (String)"IpMux");
        ManagedObject managedObject4 = ((IpAccessHostEtMo)managedObject3).getIpInterfaceMoRef(coordinator);
        if (managedObject4 instanceof Ipv6InterfaceMo) {
            throw new MoCanNotBeCreatedException("IpMux");
        }
        int n2 = ((FroInfo)managedObject3).getFroId(coordinator);
        SignedIntParameter signedIntParameter = new SignedIntParameter("ipAccessHostEtRef", n2);
        arrayList.add(signedIntParameter);
        int n3 = ((IpAccessHostEtMoImpl)managedObject3).getPlugInUnitHostId(coordinator);
        SignedIntParameter signedIntParameter2 = new SignedIntParameter(IPMUXMI_HOSTPIU_ID, n3);
        arrayList.add(signedIntParameter2);
        SignedIntParameter signedIntParameter3 = new SignedIntParameter("maxMuxPacketSize", n);
        arrayList.add(signedIntParameter3);
        return new IpMuxMoImpl(managedObject, string, string2, managedObject3, n, arrayList, coordinator, froProxy);
    }

    private IpMuxMoImpl(ManagedObject managedObject, String string, String string2, ManagedObject managedObject2, int n, ArrayList arrayList, Coordinator coordinator, FroProxy froProxy) throws MoAccessException {
        super(managedObject, "IpMux", string, coordinator);
        this.ipMuxProxy = froProxy;
        this.data = new MoData(this.getLocalDistinguishedName(), this.getType(), true, coordinator);
        FroData froData = this.ipMuxProxy.create(coordinator, (Collection)arrayList);
        int n2 = froData.getFroId();
        ((Reservable)managedObject2).reserve((ManagedObject)this, coordinator);
        this.data.registerPersistentAttr((Attribute)new StringAttribute("userLabel", true, string2));
        this.data.registerPersistentAttr((Attribute)new IntegerAttribute("maxMuxPacketSize", false, n));
        this.data.registerPersistentAttr((Attribute)new IntegerAttribute("froId", false, n2));
        this.data.registerPersistentAttr((Attribute)new ReferenceAttribute("ipAccessHostEtRef", true, managedObject2));
        this.data.setRevision(8000);
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
    }

    public IpMuxMoImpl(MoData moData, FroProxy froProxy) throws MoNameAlreadyTakenException {
        super(moData.getLocalDistinguishedName());
        this.data = moData;
        this.ipMuxProxy = froProxy;
        MoDataRecoveryHelper moDataRecoveryHelper = new MoDataRecoveryHelper(this.data, (ManagedObject)this);
        moDataRecoveryHelper.assertMoDataRevision(8000);
        moDataRecoveryHelper.assertAttribute("froId");
        moDataRecoveryHelper.assertAttribute("userLabel");
        moDataRecoveryHelper.assertAttribute("ipAccessHostEtRef");
    }

    public void delete(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        ManagedObject managedObject = this.getIpAccessHostEtRef(coordinator);
        ((Reservable)managedObject).release((ManagedObject)this, coordinator);
        this.ipMuxProxy.delete(coordinator, this.getFroId(coordinator), null);
        super.delete(coordinator);
        this.data.delete(coordinator);
    }

    public String getType() {
        return "IpMux";
    }

    public int getFroId(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return ((IntegerAttribute)this.data.getAttribute("froId")).getValue(coordinator);
    }

    public String getUserLabel(Coordinator coordinator) throws MoAccessException {
        return (String)this.getAttribute("userLabel", coordinator);
    }

    public void setUserLabel(String string, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("userLabel", string, coordinator);
    }

    public ManagedObject getIpAccessHostEtRef(Coordinator coordinator) throws MoAccessException {
        return (ManagedObject)this.getAttribute("ipAccessHostEtRef", coordinator);
    }

    public int getMaxMuxPacketSize(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("maxMuxPacketSize", coordinator);
    }

    public void setMaxMuxPacketSize(int n, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("maxMuxPacketSize", new Integer(n), coordinator);
    }

    public String getIpMuxId(Coordinator coordinator) throws MoAccessException {
        return (String)this.getAttribute(this.getType() + "Id", coordinator);
    }

    public int getPmIpMuxNotApplied(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIpMuxNotApplied", coordinator);
    }

    public String[] getCurrentPmRegister(Coordinator coordinator) throws MoAccessException {
        return (String[])this.getAttribute("currentPmRegister", coordinator);
    }

    private Map getFroAttributes(Coordinator coordinator) throws MoAccessException {
        Map map = this.ipMuxProxy.getAttributes(coordinator, this.getFroId(coordinator));
        return map;
    }

    public Object getAttribute(String string, Coordinator coordinator) throws MoAccessException, NoSuchAttributeException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        String[] stringArray = new String[]{string};
        Object[] objectArray = this.getAttributes(stringArray, coordinator);
        return objectArray[0];
    }

    public Object[] getAttributes(String[] stringArray, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        Object[] objectArray = new Object[stringArray.length];
        Map map = null;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equalsIgnoreCase("userLabel")) {
                objectArray[i] = ((StringAttribute)this.data.getAttribute("userLabel")).getValue(coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase(this.getType() + "Id")) {
                objectArray[i] = super.getNamingAttributeValue();
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("froId")) {
                objectArray[i] = super.getNamingAttributeValue();
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("ipAccessHostEtRef")) {
                objectArray[i] = ((ReferenceAttribute)this.data.getAttribute("ipAccessHostEtRef")).getValue(coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("maxMuxPacketSize")) {
                map = this.getAttrFromRes(map, coordinator);
                SignedIntParameter signedIntParameter = (SignedIntParameter)map.get("maxMuxPacketSize");
                objectArray[i] = new Integer(signedIntParameter.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmIpMuxNotApplied")) {
                objectArray[i] = new Integer(super.getPmAttribute("pmIpMuxNotApplied", coordinator));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("currentPmRegister")) {
                objectArray[i] = super.getCurrentPmRegister(coordinator);
                continue;
            }
            throw new NoSuchAttributeException(stringArray[i], "IpMux");
        }
        return objectArray;
    }

    private Map getAttrFromRes(Map map, Coordinator coordinator) throws MoAccessException {
        if (map == null) {
            return this.getFroAttributes(coordinator);
        }
        return map;
    }

    public void setAttribute(String string, Object object, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        String[] stringArray = new String[]{string};
        Object[] objectArray = new Object[]{object};
        this.setAttributes(stringArray, objectArray, coordinator);
    }

    private void sendNotification(String string, Object object, Coordinator coordinator) {
        String[] stringArray = new String[]{string};
        Object[] objectArray = new Object[]{object};
        if (coordinator == null) {
            NotificationSender.instance().pushAVC((ManagedObject)this, stringArray, objectArray);
        } else {
            NotificationSender.instance().pushAVC((ManagedObject)this, stringArray, objectArray, coordinator);
        }
    }

    public void setAttributes(String[] stringArray, Object[] objectArray, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        int n = 0;
        ArrayList<SignedIntParameter> arrayList = new ArrayList<SignedIntParameter>();
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equalsIgnoreCase("userLabel")) {
                if (!objectArray[i].getClass().equals(class$java$lang$String == null ? IpMuxMoImpl.class$("java.lang.String") : class$java$lang$String)) {
                    throw new WrongAttributeTypeException("userLabel", "IpMux");
                }
                MoAttributeValidator.checkStringWithLength((String)((String)objectArray[i]), (String)"userLabel", (String)"IpMux", (int)128, (int)0);
                ((StringAttribute)this.data.getAttribute("userLabel")).setValue((String)objectArray[i]);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("maxMuxPacketSize")) {
                if (!objectArray[i].getClass().equals(class$java$lang$Integer == null ? IpMuxMoImpl.class$("java.lang.Integer") : class$java$lang$Integer)) {
                    throw new WrongAttributeTypeException("maxMuxPacketSize", "IpMux");
                }
                n = (Integer)objectArray[i];
                MoAttributeValidator.checkIntegerAttribute((String)"maxMuxPacketSize", (int)n, (int)576, (int)1500, (String)"IpMux");
                arrayList.add(new SignedIntParameter("maxMuxPacketSize", n));
                this.sendNotification("maxMuxPacketSize", new Integer(n), coordinator);
                continue;
            }
            throw new NoSuchAttributeException(stringArray[i], "IpMux");
        }
        if (arrayList.size() > 0) {
            this.ipMuxProxy.setAttributes(coordinator, this.getFroId(coordinator), arrayList);
        }
    }
}

