/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.common;

import se.ericsson.cello.net.FTPClient;
import se.ericsson.cello.net.FTPException;
import se.ericsson.cello.net.IllegalArgumentException;
import se.ericsson.cello.net.OutOfResourcesException;
import se.ericsson.wcdma.rbs.boam.common.FtpUtilityException;
import se.ericsson.wcdma.rbs.boam.common.Strings;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.excep.FileMissingOnServerException;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.excep.FtpServerNotAccessibleException;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.excep.OperationFailedException;

public abstract class FtpUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void ftpGet(String remote_host, String username, String pwd, String remote_path, String local_path) throws OperationFailedException, FileMissingOnServerException, FtpServerNotAccessibleException {
        FTPClient ftpClient = null;
        FtpStatus ftpStatus = new FtpStatus(0, null);
        try {
            MessageLog.trace(9, FtpUtil.class, "The file: " + remote_path + " is starting to fetch into local file path:" + local_path);
            ftpClient = new FTPClient();
            ftpClient.get(remote_host, username, pwd, local_path, remote_path);
            MessageLog.trace(9, FtpUtil.class, "The file: " + remote_path + " is already fetched into local file path:" + local_path);
        }
        catch (OutOfResourcesException e) {
            ftpStatus.setStatus(1);
            ftpStatus.setException((Exception)((Object)e));
        }
        catch (FTPException e) {
            ftpStatus.setStatus(1);
            ftpStatus.setException((Exception)((Object)e));
        }
        catch (IllegalArgumentException e) {
            ftpStatus.setStatus(1);
            ftpStatus.setException((Exception)((Object)e));
        }
        finally {
            ftpClient = null;
        }
        if (ftpStatus.getStatus() == 1) {
            int errorCode = ftpStatus.getErrorCode();
            if (errorCode == -1) {
                MessageLog.trace(9, FtpUtil.class, "File could not be fetched: " + ftpStatus.getErrorMsg());
                throw new OperationFailedException(ftpStatus.getErrorMsg());
            }
            if (errorCode == 1004 || errorCode == 1006 || errorCode == 15 || errorCode == 9) {
                MessageLog.trace(9, FtpUtil.class, "File could not be fetched: " + ftpStatus.getErrorMsg());
                throw new FileMissingOnServerException(ftpStatus.getErrorMsg());
            }
            MessageLog.trace(9, FtpUtil.class, "File could not be fetched: " + ftpStatus.getErrorMsg());
            throw new FtpServerNotAccessibleException(ftpStatus.getErrorMsg());
        }
    }

    public static void ftpPut(boolean isBsa, String remote_host, String username, String pwd, String local_path, String remote_path) throws FtpUtilityException {
        FTPClient ftpClient = null;
        try {
            MessageLog.traceEnter(FtpUtil.class, "ftpPut()<-- : remoteHost:" + remote_host + " , username: " + username + " remote_path" + ", localPath: " + local_path);
            ftpClient = new FTPClient();
            if (isBsa) {
                ftpClient.putBsa(remote_host, username, pwd, local_path, remote_path);
            } else {
                ftpClient.put(remote_host, username, pwd, local_path, remote_path);
            }
            MessageLog.trace(9, FtpUtil.class, "The file: " + local_path + " is stored into remote filePath:" + remote_path);
        }
        catch (OutOfResourcesException e) {
            MessageLog.traceError(FtpUtil.class, "File could not be uploaded: " + e.getMessage());
            throw new FtpUtilityException(e.getMessage());
        }
        catch (FTPException e) {
            MessageLog.traceError(FtpUtil.class, "File could not be uploaded: " + e.getMessage());
            throw new FtpUtilityException(e);
        }
        catch (IllegalArgumentException e) {
            MessageLog.traceError(FtpUtil.class, "File could not be uploaded: " + e.getMessage());
            throw new FtpUtilityException(e.getMessage());
        }
        finally {
            ftpClient = null;
        }
    }

    public static boolean checkIP(String strIP) {
        if (Strings.countNrOfOccurrences(strIP, '.') != 3) {
            return false;
        }
        String[] addr = Strings.split(strIP, ".");
        if (addr.length != 4) {
            return false;
        }
        for (int i = 0; i < addr.length; ++i) {
            try {
                if (Integer.parseInt(addr[i]) >= 0 && Integer.parseInt(addr[i]) <= 255) continue;
                return false;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        return true;
    }

    private static class FtpStatus {
        public static final int OK = 0;
        public static final int NOK = 1;
        public static final int ERROR_CODE_UNKNOWN = -1;
        private Exception exception;
        private int status;

        public FtpStatus(int status, Exception exception) {
            this.status = status == 0 ? status : 1;
            this.exception = exception;
        }

        public void setException(Exception exception) {
            this.exception = exception;
        }

        public int getStatus() {
            return this.status;
        }

        public void setStatus(int status) {
            this.status = status;
        }

        public String getErrorMsg() {
            if (this.exception != null) {
                return this.exception.getClass() + ": " + this.exception.getMessage();
            }
            return "";
        }

        public int getErrorCode() {
            if (this.exception != null && this.exception instanceof FTPException) {
                return ((FTPException)this.exception).getErrorCode();
            }
            return -1;
        }
    }
}

