/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.fpx.chmi.proxies;

import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.wcdma.rbs.boam.common.FroNotAccessibleException;
import se.ericsson.wcdma.rbs.boam.common.FroRequestFailedException;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.proxies.ChcGenericProxy;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.ChcCreateIubdsParamReqS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.ChcCreateIubdsParamRspS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.ChcGetIubdsParamReqS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.ChcGetIubdsParamRspS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.ChcIubdsFaultIndS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.ChcIubdsFaultceaseIndS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.ChcServiceNameT;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.ChcSetRbsFeatDualstackReqS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.ChcSubscIubdsFaultReqS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.ChcTransportOptionT;

public class ChcIubdsProxy
extends ChcGenericProxy {
    private static ChcIubdsProxy theOneAndOnly = null;
    private static final String SERVICE_NAME = "lrsIubDsResMgr";
    public static final String CURRENT_CLASS = ChcIubdsProxy.class.getName();
    private int clientID = 0;

    private ChcIubdsProxy() {
        super(SERVICE_NAME);
        MessageLog.traceEnter(this.getClass(), "ChcIubdsProxy constructor");
        this.boamSignalPort.addSignalObserver(this, ChcIubdsFaultIndS.class);
        this.boamSignalPort.addSignalObserver(this, ChcIubdsFaultceaseIndS.class);
    }

    public static synchronized ChcIubdsProxy instance() {
        if (theOneAndOnly == null) {
            theOneAndOnly = new ChcIubdsProxy();
        }
        return theOneAndOnly;
    }

    public ChcGetIubdsParamRspS getIubdsParam(int clientId, int transactionId) throws FroRequestFailedException, FroNotAccessibleException {
        ChcGetIubdsParamReqS reqSig = new ChcGetIubdsParamReqS(clientId, transactionId);
        return (ChcGetIubdsParamRspS)this.sendAndRec(reqSig);
    }

    public void setFeatureStateForDualStackIub(int clientId, int transactionId, int featureState) throws FroRequestFailedException, FroNotAccessibleException {
        ChcSetRbsFeatDualstackReqS reqSig = new ChcSetRbsFeatDualstackReqS(transactionId, clientId, featureState);
        this.sendAndRec(reqSig);
    }

    public ChcCreateIubdsParamRspS createIubdsParam(int clientId, ChcTransportOptionT userPlaneTransportOption, int ipAccessHostEtFroId, int transactionId) throws FroRequestFailedException, FroNotAccessibleException {
        ChcCreateIubdsParamReqS reqSig = new ChcCreateIubdsParamReqS(clientId, userPlaneTransportOption, ipAccessHostEtFroId, transactionId);
        return (ChcCreateIubdsParamRspS)this.sendAndRec(reqSig);
    }

    public void subscribeToFroNotification() {
        MessageLog.traceEnter(this.getClass(), "subscribeToFroNotification");
        try {
            this.subscribeAlarms();
        }
        catch (FroRequestFailedException e) {
            MessageLog.traceError(this.getClass(), "Received result NOK from resource when subscribing to the notifications" + (Object)((Object)e));
        }
        catch (FroNotAccessibleException e) {
            MessageLog.traceError(this.getClass(), "Received result NOK from resource when subscribing to the notifications" + (Object)((Object)e));
        }
        catch (MoAccessException e) {
            MessageLog.traceError(this.getClass(), "Received result NOK from resource when subscribing to the notifications" + (Object)((Object)e));
        }
    }

    private void subscribeAlarms() throws FroRequestFailedException, FroNotAccessibleException, MoAccessException {
        ChcServiceNameT chcServiceName = new ChcServiceNameT(this.signalPort.getServiceName());
        ChcSubscIubdsFaultReqS reqSig = new ChcSubscIubdsFaultReqS(this.clientID, 0, chcServiceName);
        this.sendAndRec(reqSig);
    }
}

