/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.fpx.ecmi.proxies;

import enea.ose.system.UnlinkedSignal;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.common.FroNotAccessibleException;
import se.ericsson.wcdma.rbs.boam.common.FroRequestFailedException;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.fpx.common.FroAttribute;
import se.ericsson.wcdma.rbs.boam.fpx.common.FroAttributeHelper;
import se.ericsson.wcdma.rbs.boam.fpx.common.FroProxyOperations;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.proxies.EcGenericProxy;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.LrsAllocatePossDeviceReqS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.LrsAllocatePossDeviceRspS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.LrsCreateBattReqS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.LrsCreatePossReqS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.LrsCreatePossRspS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.LrsDeallocatePossDeviceReqS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.LrsDeallocatePossDeviceRspS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.LrsDeleteBattReqS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.LrsDeletePossReqS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.LrsDeletePossRspS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.LrsGetBattParamReqS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.LrsGetBattParamRspS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.LrsGetPossParamReqS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.LrsGetPossParamRspS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.LrsPossBattEventIndS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.LrsPossFaultCeaseIndS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.LrsPossFaultIndS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.LrsSetBattParamReqS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.LrsSetPossParamReqS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.LrsSetPossParamRspS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.LrsStartPossBattTestReqS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.LrsStopPossBattTestReqS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.LrsSubscPossBattEventReqS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.LrsSubscPossBattEventRspS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.LrsSubscPossFaultReqS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.LrsSubscPossFaultRspS;
import se.ericsson.wcdma.rbs.boam.mao.common.ValidateAttributes;

public class EcPowerProxy
extends EcGenericProxy
implements FroProxyOperations {
    public static final int POSS_REG_FOR_NOTIF_ID = 1;
    public static final int PODS_REG_FOR_NOTIF_ID = 2;
    private static EcPowerProxy theOneAndOnly = null;
    private static final String SERVICE_NAME = "lrsPowerResMgr";

    private EcPowerProxy() {
        super(SERVICE_NAME);
        MessageLog.traceEnter(this.getClass(), "Constructor");
        this.boamSignalPort.addSignalObserver(this, LrsPossFaultIndS.class);
        this.boamSignalPort.addSignalObserver(this, LrsPossFaultCeaseIndS.class);
        this.boamSignalPort.addSignalObserver(this, LrsPossBattEventIndS.class);
    }

    public static synchronized EcPowerProxy instance() {
        if (theOneAndOnly == null) {
            theOneAndOnly = new EcPowerProxy();
        }
        return theOneAndOnly;
    }

    public UnlinkedSignal createRo(FroAttribute[] froAttributes, String moTypeName, Coordinator c) throws MoAccessException {
        if (moTypeName.equalsIgnoreCase("Battery")) {
            this.createBattery(ValidateAttributes.getTxIdTransactional(c), 0, FroAttributeHelper.getIntFroAttribute(froAttributes, "batteryCapacityDefaultValue"), FroAttributeHelper.getIntFroAttribute(froAttributes, "batteryVoltageDefaultValue"), FroAttributeHelper.getIntFroAttribute(froAttributes, "tempCharging"), FroAttributeHelper.getIntFroAttribute(froAttributes, "compFactor"), FroAttributeHelper.getIntFroAttribute(froAttributes, "cyclicChargeInterval"), FroAttributeHelper.getIntFroAttribute(froAttributes, "batteryTestEndLimit"), FroAttributeHelper.getIntFroAttribute(froAttributes, "remainingBackupTime"), FroAttributeHelper.getIntFroAttribute(froAttributes, "dischargeLimit"), FroAttributeHelper.getIntFroAttribute(froAttributes, "chargeTimeLimit"), FroAttributeHelper.getIntFroAttribute(froAttributes, "chargeLimit"), FroAttributeHelper.getIntFroAttribute(froAttributes, "initialBatteryTestStartTime"), FroAttributeHelper.getIntFroAttribute(froAttributes, "minDaysBeforeCyclicCharge"), FroAttributeHelper.getIntFroAttribute(froAttributes, "chargeOffset"));
        } else if (moTypeName.equalsIgnoreCase("PowerSupplySystem")) {
            return this.createPoss(ValidateAttributes.getTxIdTransactional(c), 0, FroAttributeHelper.getIntFroAttribute(froAttributes, "systemOvervoltageAlarmLevel"), FroAttributeHelper.getIntFroAttribute(froAttributes, "systemOvervoltageAlarmCeaseOffset"), FroAttributeHelper.getIntFroAttribute(froAttributes, "systemUndervoltageAlarmLevel"), FroAttributeHelper.getIntFroAttribute(froAttributes, "systemUndervoltageAlarmCeaseOffset"), FroAttributeHelper.getIntFroAttribute(froAttributes, "batteryOvertempAlarmLevel"), FroAttributeHelper.getIntFroAttribute(froAttributes, "batteryOvertempAlarmCeaseOffset"), FroAttributeHelper.getIntFroAttribute(froAttributes, "temperatureDisconnect"), FroAttributeHelper.getIntFroAttribute(froAttributes, "temperatureDisconnectCeaseOffset"), FroAttributeHelper.getIntFroAttribute(froAttributes, "undervoltageDisconnectCeaseOffset"), FroAttributeHelper.getIntFroAttribute(froAttributes, "mainLoadUndervoltageDisconnect"), FroAttributeHelper.getIntFroAttribute(froAttributes, "priorityLoadUndervoltageDisconnect"), FroAttributeHelper.getIntFroAttribute(froAttributes, "batteryTestEnable"), FroAttributeHelper.getIntFroAttribute(froAttributes, "secureTransmEnable"), FroAttributeHelper.getIntFroAttribute(froAttributes, "secureTransmBatteryBackupTimeLimit"), FroAttributeHelper.getIntFroAttribute(froAttributes, "cyclicBattTestStartTime"), FroAttributeHelper.getIntFroAttribute(froAttributes, "monthBatteryTest"));
        }
        return null;
    }

    public void deleteRo(FroAttribute[] froAttributes, String moTypeName, Coordinator c) throws MoAccessException {
        if (moTypeName.equalsIgnoreCase("Battery")) {
            this.deleteBattery(ValidateAttributes.getTxIdTransactional(c), 0);
        } else if (moTypeName.equalsIgnoreCase("PowerSupplySystem")) {
            this.deletePoss(ValidateAttributes.getTxIdTransactional(c), 0, FroAttributeHelper.getFroId(froAttributes));
        }
    }

    public Object getRo(FroAttribute[] froAttributes, String attributeName, String moTypeName, Coordinator c) throws MoAccessException {
        if (moTypeName.equalsIgnoreCase("PowerSupplySystem")) {
            if (attributeName.equalsIgnoreCase("mainPrioCurrentLoad")) {
                return new Integer(this.getPossParam((int)ValidateAttributes.getTxIdNonTransactional((Coordinator)c), (int)0, (int)FroAttributeHelper.getFroId((FroAttribute[])froAttributes)).mainPrioCurrentLoad);
            }
            if (attributeName.equalsIgnoreCase("systemPowerLoad")) {
                return new Integer(this.getPossParam((int)ValidateAttributes.getTxIdNonTransactional((Coordinator)c), (int)0, (int)FroAttributeHelper.getFroId((FroAttribute[])froAttributes)).systemPowerLoad);
            }
            if (attributeName.equalsIgnoreCase("batteryCurrent")) {
                return new Integer(this.getPossParam((int)ValidateAttributes.getTxIdNonTransactional((Coordinator)c), (int)0, (int)FroAttributeHelper.getFroId((FroAttribute[])froAttributes)).batteryCurrent);
            }
            if (attributeName.equalsIgnoreCase("systemVoltage")) {
                return new Integer(this.getPossParam((int)ValidateAttributes.getTxIdNonTransactional((Coordinator)c), (int)0, (int)FroAttributeHelper.getFroId((FroAttribute[])froAttributes)).systemVoltage);
            }
            if (attributeName.equalsIgnoreCase("batteryVoltage")) {
                return new Integer(this.getPossParam((int)ValidateAttributes.getTxIdNonTransactional((Coordinator)c), (int)0, (int)FroAttributeHelper.getFroId((FroAttribute[])froAttributes)).batteryVoltage);
            }
            if (attributeName.equalsIgnoreCase("systemOvervoltageAlarmLevel")) {
                return new Integer(this.getPossParam((int)ValidateAttributes.getTxIdNonTransactional((Coordinator)c), (int)0, (int)FroAttributeHelper.getFroId((FroAttribute[])froAttributes)).systemOvervoltageAlarmLevel);
            }
            if (attributeName.equalsIgnoreCase("systemOvervoltageAlarmCeaseOffset")) {
                return new Integer(this.getPossParam((int)ValidateAttributes.getTxIdNonTransactional((Coordinator)c), (int)0, (int)FroAttributeHelper.getFroId((FroAttribute[])froAttributes)).systemOvervoltageAlarmCeaseOffset);
            }
            if (attributeName.equalsIgnoreCase("systemUndervoltageAlarmLevel")) {
                return new Integer(this.getPossParam((int)ValidateAttributes.getTxIdNonTransactional((Coordinator)c), (int)0, (int)FroAttributeHelper.getFroId((FroAttribute[])froAttributes)).systemUndervoltageAlarmLevel);
            }
            if (attributeName.equalsIgnoreCase("systemUndervoltageAlarmCeaseOffset")) {
                return new Integer(this.getPossParam((int)ValidateAttributes.getTxIdNonTransactional((Coordinator)c), (int)0, (int)FroAttributeHelper.getFroId((FroAttribute[])froAttributes)).systemUndervoltageAlarmCeaseOffset);
            }
            if (attributeName.equalsIgnoreCase("batteryOvertempAlarmLevel")) {
                return new Integer(this.getPossParam((int)ValidateAttributes.getTxIdNonTransactional((Coordinator)c), (int)0, (int)FroAttributeHelper.getFroId((FroAttribute[])froAttributes)).batteryOvertempAlarmLevel);
            }
            if (attributeName.equalsIgnoreCase("batteryOvertempAlarmCeaseOffset")) {
                return new Integer(this.getPossParam((int)ValidateAttributes.getTxIdNonTransactional((Coordinator)c), (int)0, (int)FroAttributeHelper.getFroId((FroAttribute[])froAttributes)).batteryOvertempAlarmCeaseOffset);
            }
            if (attributeName.equalsIgnoreCase("temperatureDisconnect")) {
                return new Integer(this.getPossParam((int)ValidateAttributes.getTxIdNonTransactional((Coordinator)c), (int)0, (int)FroAttributeHelper.getFroId((FroAttribute[])froAttributes)).tempDisconnect);
            }
            if (attributeName.equalsIgnoreCase("temperatureDisconnectCeaseOffset")) {
                return new Integer(this.getPossParam((int)ValidateAttributes.getTxIdNonTransactional((Coordinator)c), (int)0, (int)FroAttributeHelper.getFroId((FroAttribute[])froAttributes)).tempDisconnectCeaseOffset);
            }
            if (attributeName.equalsIgnoreCase("undervoltageDisconnectCeaseOffset")) {
                return new Integer(this.getPossParam((int)ValidateAttributes.getTxIdNonTransactional((Coordinator)c), (int)0, (int)FroAttributeHelper.getFroId((FroAttribute[])froAttributes)).undervoltageDisconnectCeaseOffset);
            }
            if (attributeName.equalsIgnoreCase("mainLoadUndervoltageDisconnect")) {
                return new Integer(this.getPossParam((int)ValidateAttributes.getTxIdNonTransactional((Coordinator)c), (int)0, (int)FroAttributeHelper.getFroId((FroAttribute[])froAttributes)).mainLoadUndervoltageDisconnect);
            }
            if (attributeName.equalsIgnoreCase("priorityLoadUndervoltageDisconnect")) {
                return new Integer(this.getPossParam((int)ValidateAttributes.getTxIdNonTransactional((Coordinator)c), (int)0, (int)FroAttributeHelper.getFroId((FroAttribute[])froAttributes)).priorityLoadUndervoltageDisconnect);
            }
            if (attributeName.equalsIgnoreCase("batteryTestEnable")) {
                return this.getPossParam((int)ValidateAttributes.getTxIdNonTransactional((Coordinator)c), (int)0, (int)FroAttributeHelper.getFroId((FroAttribute[])froAttributes)).batteryTestEnable == 1;
            }
            if (attributeName.equalsIgnoreCase("secureTransmEnable")) {
                return this.getPossParam((int)ValidateAttributes.getTxIdNonTransactional((Coordinator)c), (int)0, (int)FroAttributeHelper.getFroId((FroAttribute[])froAttributes)).secureTransmEnable == 1;
            }
            if (attributeName.equalsIgnoreCase("secureTransmBatteryBackupTimeLimit")) {
                return new Integer(this.getPossParam((int)ValidateAttributes.getTxIdNonTransactional((Coordinator)c), (int)0, (int)FroAttributeHelper.getFroId((FroAttribute[])froAttributes)).secureTransmBatteryBackupTimeLimit);
            }
            if (attributeName.equalsIgnoreCase("cyclicBattTestStartTime")) {
                return new Integer(this.getPossParam((int)ValidateAttributes.getTxIdNonTransactional((Coordinator)c), (int)0, (int)FroAttributeHelper.getFroId((FroAttribute[])froAttributes)).cyclicBattTestStartTime);
            }
            if (attributeName.equalsIgnoreCase("monthBatteryTest")) {
                return new Integer(this.getPossParam((int)ValidateAttributes.getTxIdNonTransactional((Coordinator)c), (int)0, (int)FroAttributeHelper.getFroId((FroAttribute[])froAttributes)).monthBatteryTest);
            }
            if (attributeName.equalsIgnoreCase("operationalState")) {
                return new Integer(this.getPossParam((int)ValidateAttributes.getTxIdNonTransactional((Coordinator)c), (int)0, (int)FroAttributeHelper.getFroId((FroAttribute[])froAttributes)).operationalState);
            }
            if (attributeName.equalsIgnoreCase("availabilityStatus")) {
                return new Integer(this.getPossParam((int)ValidateAttributes.getTxIdNonTransactional((Coordinator)c), (int)0, (int)FroAttributeHelper.getFroId((FroAttribute[])froAttributes)).availabilityStatus);
            }
        } else if (moTypeName.equalsIgnoreCase("Battery")) {
            if (attributeName.equalsIgnoreCase("batteryCapacityDefaultValue")) {
                return new Integer(this.getBattParam((int)ValidateAttributes.getTxIdNonTransactional((Coordinator)c), (int)0).batteryCapacityDefaultValue);
            }
            if (attributeName.equalsIgnoreCase("batteryVoltageDefaultValue")) {
                return new Integer(this.getBattParam((int)ValidateAttributes.getTxIdNonTransactional((Coordinator)c), (int)0).batteryVoltageDefaultValue);
            }
            if (attributeName.equalsIgnoreCase("tempCharging")) {
                return new Integer(this.getBattParam((int)ValidateAttributes.getTxIdNonTransactional((Coordinator)c), (int)0).tempCharging);
            }
            if (attributeName.equalsIgnoreCase("compFactor")) {
                return new Integer(this.getBattParam((int)ValidateAttributes.getTxIdNonTransactional((Coordinator)c), (int)0).compFactor);
            }
            if (attributeName.equalsIgnoreCase("cyclicChargeInterval")) {
                return new Integer(this.getBattParam((int)ValidateAttributes.getTxIdNonTransactional((Coordinator)c), (int)0).cyclicChargeInterval);
            }
            if (attributeName.equalsIgnoreCase("batteryTestEndLimit")) {
                return new Integer(this.getBattParam((int)ValidateAttributes.getTxIdNonTransactional((Coordinator)c), (int)0).batteryTestEndLimit);
            }
            if (attributeName.equalsIgnoreCase("remainingBackupTime")) {
                return new Integer(this.getBattParam((int)ValidateAttributes.getTxIdNonTransactional((Coordinator)c), (int)0).remainingBackupTime);
            }
            if (attributeName.equalsIgnoreCase("dischargeLimit")) {
                return new Integer(this.getBattParam((int)ValidateAttributes.getTxIdNonTransactional((Coordinator)c), (int)0).dischargeLimit);
            }
            if (attributeName.equalsIgnoreCase("chargeTimeLimit")) {
                return new Integer(this.getBattParam((int)ValidateAttributes.getTxIdNonTransactional((Coordinator)c), (int)0).chargeTimeLimit);
            }
            if (attributeName.equalsIgnoreCase("chargeLimit")) {
                return new Integer(this.getBattParam((int)ValidateAttributes.getTxIdNonTransactional((Coordinator)c), (int)0).chargeLimit);
            }
            if (attributeName.equalsIgnoreCase("initialBatteryTestStartTime")) {
                return new Integer(this.getBattParam((int)ValidateAttributes.getTxIdNonTransactional((Coordinator)c), (int)0).initialBatteryTestStartTime);
            }
            if (attributeName.equalsIgnoreCase("minDaysBeforeCyclicCharge")) {
                return new Integer(this.getBattParam((int)ValidateAttributes.getTxIdNonTransactional((Coordinator)c), (int)0).minDaysBeforeCyclicCharge);
            }
            if (attributeName.equalsIgnoreCase("chargeOffset")) {
                return new Integer(this.getBattParam((int)ValidateAttributes.getTxIdNonTransactional((Coordinator)c), (int)0).chargeOffset);
            }
        }
        return null;
    }

    public void setRo(FroAttribute[] froAttributes, String moTypeName, Coordinator c) throws MoAccessException {
        if (moTypeName.equalsIgnoreCase("Battery")) {
            this.setBattParam(ValidateAttributes.getTxIdTransactional(c), 0, FroAttributeHelper.getIntFroAttribute(froAttributes, "paramId"), FroAttributeHelper.getIntFroAttribute(froAttributes, "value"));
        } else if (moTypeName.equalsIgnoreCase("PowerSupplySystem")) {
            this.setPossParam(ValidateAttributes.getTxIdTransactional(c), 0, FroAttributeHelper.getFroId(froAttributes), FroAttributeHelper.getIntFroAttribute(froAttributes, "paramId"), FroAttributeHelper.getIntFroAttribute(froAttributes, "value"));
        }
    }

    public FroAttribute[] getAllRo(String moTypeName, Coordinator c) throws MoAccessException {
        return new FroAttribute[0];
    }

    public Object actionReadAccessRo(FroAttribute[] froAttributes, String actionName, String moTypeName, Coordinator c) throws MoAccessException {
        return null;
    }

    public void actionWriteAccessRo(FroAttribute[] froAttributes, String actionName, String moTypeName, Coordinator c) throws MoAccessException {
        if (moTypeName.equalsIgnoreCase("PowerSupplySystem")) {
            if (actionName.equalsIgnoreCase("actionStartBatteryTest")) {
                this.startPossBattTest(0);
            } else if (actionName.equalsIgnoreCase("actionStopBatteryTest")) {
                this.stopPossBattTest(0);
            }
        }
    }

    public LrsAllocatePossDeviceRspS allocatePossDevice(int transactionId, int clientId, int deviceFroId, int deviceType) throws FroRequestFailedException, FroNotAccessibleException {
        MessageLog.traceEnter(this.getClass(), "allocatePossDevice()");
        LrsAllocatePossDeviceReqS reqSig = new LrsAllocatePossDeviceReqS(transactionId, clientId, deviceFroId, deviceType);
        return (LrsAllocatePossDeviceRspS)this.sendAndRec(reqSig);
    }

    public LrsDeallocatePossDeviceRspS deallocatePossDevice(int transactionId, int clientId, int deviceFroId, int deviceType) throws FroRequestFailedException, FroNotAccessibleException {
        MessageLog.traceEnter(this.getClass(), "deallocatePossDevice()");
        LrsDeallocatePossDeviceReqS reqSig = new LrsDeallocatePossDeviceReqS(transactionId, clientId, deviceFroId, deviceType);
        return (LrsDeallocatePossDeviceRspS)this.sendAndRec(reqSig);
    }

    private LrsSubscPossFaultRspS subscPossFault(int clientId, int subscribeOperation) throws FroRequestFailedException, FroNotAccessibleException {
        MessageLog.traceEnter(this.getClass(), "subscPossFault()");
        LrsSubscPossFaultReqS reqSig = new LrsSubscPossFaultReqS(clientId, subscribeOperation, this.signalPort.getServiceName());
        return (LrsSubscPossFaultRspS)this.sendAndRec(reqSig);
    }

    private LrsSubscPossBattEventRspS subscPossBattEvent(int clientId, int subscribeOperation) throws FroRequestFailedException, FroNotAccessibleException {
        MessageLog.traceEnter(this.getClass(), "subscPossBattEvent()");
        LrsSubscPossBattEventReqS reqSig = new LrsSubscPossBattEventReqS(clientId, subscribeOperation, this.signalPort.getServiceName());
        return (LrsSubscPossBattEventRspS)this.sendAndRec(reqSig);
    }

    public void subscribeToFroNotification() {
        MessageLog.traceEnter(this.getClass(), "subscribeToFroNotification");
        int CLIENT_ID = 0;
        try {
            this.subscPossFault(CLIENT_ID, 0);
            this.subscPossBattEvent(CLIENT_ID, 0);
        }
        catch (FroRequestFailedException e) {
            MessageLog.traceError(this.getClass(), "Received result NOK from resource when subscribing to the notifications" + (Object)((Object)e));
        }
        catch (FroNotAccessibleException e) {
            MessageLog.traceError(this.getClass(), "Received result NOK from resource when subscribing to the notifications" + (Object)((Object)e));
        }
    }

    private void createBattery(int transactionId, int clientId, int batteryCapacityDefaultValue, int batteryVoltageDefaultValue, int tempCharging, int compFactor, int cyclicChargeInterval, int batteryTestEndLimit, int remainingBackupTime, int dischargeLimit, int chargeTimeLimit, int chargeLimit, int initialBatteryTestStartTime, int minDaysBeforeCyclicCharge, int chargeOffset) throws FroRequestFailedException, FroNotAccessibleException {
        MessageLog.traceEnter(this.getClass(), "createBattery()");
        LrsCreateBattReqS reqSig = new LrsCreateBattReqS(transactionId, clientId, batteryCapacityDefaultValue, batteryVoltageDefaultValue, tempCharging, compFactor, cyclicChargeInterval, batteryTestEndLimit, remainingBackupTime, dischargeLimit, chargeTimeLimit, chargeLimit, initialBatteryTestStartTime, minDaysBeforeCyclicCharge, chargeOffset);
        this.sendAndRec(reqSig);
    }

    private void deleteBattery(int transactionId, int clientId) throws FroRequestFailedException, FroNotAccessibleException {
        MessageLog.traceEnter(this.getClass(), "deleteBattery()");
        LrsDeleteBattReqS reqSig = new LrsDeleteBattReqS(transactionId, clientId);
        this.sendAndRec(reqSig);
    }

    private LrsGetBattParamRspS getBattParam(int transactionId, int clientId) throws FroRequestFailedException, FroNotAccessibleException {
        MessageLog.traceEnter(this.getClass(), "getBattParam()");
        LrsGetBattParamReqS reqSig = new LrsGetBattParamReqS(transactionId, clientId);
        return (LrsGetBattParamRspS)this.sendAndRec(reqSig);
    }

    private void setBattParam(int transactionId, int clientId, int paramId, int value) throws FroRequestFailedException, FroNotAccessibleException {
        MessageLog.traceEnter(this.getClass(), "setBattParam()");
        LrsSetBattParamReqS reqSig = new LrsSetBattParamReqS(transactionId, clientId, paramId, value);
        this.sendAndRec(reqSig);
    }

    private LrsCreatePossRspS createPoss(int transactionId, int clientId, int systemOvervoltageAlarmLevel, int systemOvervoltageAlarmCeaseOffset, int systemUndervoltageAlarmLevel, int systemUndervoltageAlarmCeaseOffset, int batteryOvertempAlarmLevel, int batteryOvertempAlarmCeaseOffset, int tempDisconnect, int tempDisconnectCeaseOffset, int undervoltageDisconnectCeaseOffset, int mainLoadUndervoltageDisconnect, int priorityLoadUndervoltageDisconnect, int batteryTestEnable, int secureTransmEnable, int secureTransmBatteryBackupTimeLimit, int cyclicBattTestStartTime, int monthBatteryTest) throws FroRequestFailedException, FroNotAccessibleException {
        MessageLog.traceEnter(this.getClass(), "createPoss()");
        LrsCreatePossReqS reqSig = new LrsCreatePossReqS(transactionId, clientId, systemOvervoltageAlarmLevel, systemOvervoltageAlarmCeaseOffset, systemUndervoltageAlarmLevel, systemUndervoltageAlarmCeaseOffset, batteryOvertempAlarmLevel, batteryOvertempAlarmCeaseOffset, tempDisconnect, tempDisconnectCeaseOffset, undervoltageDisconnectCeaseOffset, mainLoadUndervoltageDisconnect, priorityLoadUndervoltageDisconnect, batteryTestEnable, secureTransmEnable, secureTransmBatteryBackupTimeLimit, cyclicBattTestStartTime, monthBatteryTest);
        return (LrsCreatePossRspS)this.sendAndRec(reqSig);
    }

    private LrsDeletePossRspS deletePoss(int transactionId, int clientId, int possFroId) throws FroRequestFailedException, FroNotAccessibleException {
        MessageLog.traceEnter(this.getClass(), "deletePoss()");
        LrsDeletePossReqS reqSig = new LrsDeletePossReqS(transactionId, clientId, possFroId);
        return (LrsDeletePossRspS)this.sendAndRec(reqSig);
    }

    private LrsGetPossParamRspS getPossParam(int transactionId, int clientId, int possFroId) throws FroRequestFailedException, FroNotAccessibleException {
        MessageLog.traceEnter(this.getClass(), "getPossParam()");
        LrsGetPossParamReqS reqSig = new LrsGetPossParamReqS(transactionId, clientId, possFroId);
        return (LrsGetPossParamRspS)this.sendAndRec(reqSig);
    }

    private LrsSetPossParamRspS setPossParam(int transactionId, int clientId, int possFroId, int paramId, int value) throws FroRequestFailedException, FroNotAccessibleException {
        MessageLog.traceEnter(this.getClass(), "setPossParam()");
        LrsSetPossParamReqS reqSig = new LrsSetPossParamReqS(transactionId, clientId, possFroId, paramId, value);
        return (LrsSetPossParamRspS)this.sendAndRec(reqSig);
    }

    private void startPossBattTest(int clientId) throws FroRequestFailedException, FroNotAccessibleException {
        MessageLog.traceEnter(this.getClass(), "startPossBattTest()");
        LrsStartPossBattTestReqS reqSig = new LrsStartPossBattTestReqS(clientId);
        this.sendAndRec(reqSig);
    }

    private void stopPossBattTest(int clientId) throws FroRequestFailedException, FroNotAccessibleException {
        MessageLog.traceEnter(this.getClass(), "StopPossBattTest()");
        LrsStopPossBattTestReqS reqSig = new LrsStopPossBattTestReqS(clientId);
        this.sendAndRec(reqSig);
    }
}

