/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs;

import enea.ose.io.SignalInputStream;
import enea.ose.io.SignalOutputStream;
import enea.ose.system.UnlinkedSignal;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.wcdma.rbs.boam.fpx.common.PmCounterTableManager;
import se.ericsson.wcdma.rbs.boam.fpx.proxies.ScannedValue;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.excep.InternalErrorException;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.excep.ParameterValueErrorException;

public class EcGetPmRspS
extends UnlinkedSignal {
    public static final int SIG_NO = 16816086;
    public int clientId;
    public int measType;
    public int resFroId;
    public int result;
    public int errorCode;
    public int noOfCounters;
    public int pmDataSize;
    public int[] data = new int[1];
    public List counterList = null;

    public EcGetPmRspS() {
        super(16816086);
    }

    public EcGetPmRspS(int clientId, int measType, int resFroId, int result2, int errorCode, int noOfCounters, int pmDataSize, int[] data) {
        super(16816086);
        this.clientId = clientId;
        this.measType = measType;
        this.resFroId = resFroId;
        this.result = result2;
        this.errorCode = errorCode;
        this.noOfCounters = noOfCounters;
        this.pmDataSize = pmDataSize;
        this.data = data;
    }

    public void initReceive() {
        SignalInputStream in = this.getSignalInputStream();
        try {
            this.counterList = this.decode(in);
        }
        catch (ParameterValueErrorException e) {
            MessageLog.traceError(((Object)((Object)this)).getClass(), (String)("initReceive failed in EcGetPmRspS: " + (Object)((Object)e)));
        }
    }

    public void initSend() {
        SignalOutputStream out = this.getSignalOutputStream();
        try {
            out.writeS32(this.clientId);
            out.writeS32(this.measType);
            out.writeS32(this.resFroId);
            out.writeS32(this.result);
            out.writeS32(this.errorCode);
            out.writeS32(this.noOfCounters);
            out.writeS32(this.pmDataSize);
            out.writeS32Array(this.data);
        }
        catch (IOException e) {
            MessageLog.traceError(((Object)((Object)this)).getClass(), (String)("initSend failed in EcGetPmRspS: " + e));
        }
    }

    private List decode(SignalInputStream in) throws ParameterValueErrorException {
        ArrayList<ScannedValue> counterList = new ArrayList<ScannedValue>();
        try {
            this.clientId = in.readS32();
            this.measType = in.readS32();
            this.resFroId = in.readS32();
            this.result = in.readS32();
            this.errorCode = in.readS32();
            this.noOfCounters = in.readS32();
            this.pmDataSize = in.readS32();
            MessageLog.trace((int)3, ((Object)((Object)this)).getClass(), (String)("EcGetPmRspS initReceive pmDataSize=" + this.pmDataSize));
            if (0 != this.pmDataSize % 4) {
                throw new ParameterValueErrorException("Wrong pmDataLength " + this.pmDataSize + " in EcGetPmRspS");
            }
            int counterId = -1;
            int counterSize = -1;
            int pmDataLength = this.pmDataSize / 4;
            for (int coursor = 0; coursor < pmDataLength; coursor += 2 + counterSize) {
                counterId = in.readS32();
                MessageLog.trace((int)3, ((Object)((Object)this)).getClass(), (String)("EcGetPmRspS initReceive counterId " + counterId));
                String counterName = PmCounterTableManager.getCounterNameFromCounterId(counterId);
                if (null == counterName) {
                    throw new ParameterValueErrorException("Wrong counterId " + counterId + " in EcGetPmRspS or no counterId defined in PmCounterTable");
                }
                MessageLog.trace((int)3, ((Object)((Object)this)).getClass(), (String)("EcGetPmRspS initReceive counterName " + counterName));
                counterSize = in.readS32();
                counterList.add(new ScannedValue(counterName, in.readS32Array(counterSize)));
            }
            MessageLog.trace((int)3, ((Object)((Object)this)).getClass(), (String)("EcGetPmRspS initReceive counterList " + counterList));
        }
        catch (IOException e) {
            MessageLog.traceError(((Object)((Object)this)).getClass(), (String)("initReceive failed in EcGetPmRspS: " + e));
        }
        catch (InternalErrorException e) {
            MessageLog.traceError(((Object)((Object)this)).getClass(), (String)("Got unexpected counterName or counterValues in ScannedValue: " + (Object)((Object)e)));
        }
        return counterList;
    }
}

