/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.fpx.scmi.proxies;

import enea.ose.system.InSignal;
import java.util.ArrayList;
import se.ericsson.cello.managedelement.DataCollectionGenerationMo;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.wcdma.rbs.boam.common.FroNotAccessibleException;
import se.ericsson.wcdma.rbs.boam.common.FroRequestFailedException;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.proxies.ChcHsdpaCellServiceProxy;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.ChcGetCarrierPmDlCodeRspS;
import se.ericsson.wcdma.rbs.boam.fpx.proxies.ScannedValue;
import se.ericsson.wcdma.rbs.boam.fpx.scmi.proxies.ScGenericProxy;
import se.ericsson.wcdma.rbs.boam.fpx.scmi.sigs.BcCellActivateOcnsReqS;
import se.ericsson.wcdma.rbs.boam.fpx.scmi.sigs.BcCellConfigOcnsReqS;
import se.ericsson.wcdma.rbs.boam.fpx.scmi.sigs.BcCellDeactivateOcnsReqS;
import se.ericsson.wcdma.rbs.boam.fpx.scmi.sigs.BcCellFaultCeaseIndS;
import se.ericsson.wcdma.rbs.boam.fpx.scmi.sigs.BcCellFaultIndS;
import se.ericsson.wcdma.rbs.boam.fpx.scmi.sigs.BcCellGetNbapParamReqS;
import se.ericsson.wcdma.rbs.boam.fpx.scmi.sigs.BcCellGetNbapParamRspS;
import se.ericsson.wcdma.rbs.boam.fpx.scmi.sigs.BcCellGetOcnsReqS;
import se.ericsson.wcdma.rbs.boam.fpx.scmi.sigs.BcCellGetOcnsRspS;
import se.ericsson.wcdma.rbs.boam.fpx.scmi.sigs.BcCellGetParamReqS;
import se.ericsson.wcdma.rbs.boam.fpx.scmi.sigs.BcCellGetParamRspS;
import se.ericsson.wcdma.rbs.boam.fpx.scmi.sigs.BcCellRbsFaultCeaseIndS;
import se.ericsson.wcdma.rbs.boam.fpx.scmi.sigs.BcCellRbsFaultIndS;
import se.ericsson.wcdma.rbs.boam.fpx.scmi.sigs.BcCellReleaseOcnsReqS;
import se.ericsson.wcdma.rbs.boam.fpx.scmi.sigs.BcCreateCellReqS;
import se.ericsson.wcdma.rbs.boam.fpx.scmi.sigs.BcCreateCellRspS;
import se.ericsson.wcdma.rbs.boam.fpx.scmi.sigs.BcDeleteCellReqS;
import se.ericsson.wcdma.rbs.boam.fpx.scmi.sigs.BcDeleteCellRspS;
import se.ericsson.wcdma.rbs.boam.fpx.scmi.sigs.BcSetCellReqS;
import se.ericsson.wcdma.rbs.boam.fpx.scmi.sigs.BcSetCellRspS;
import se.ericsson.wcdma.rbs.boam.fpx.scmi.sigs.BcSubscFmCellReqS;
import se.ericsson.wcdma.rbs.boam.fpx.scmi.sigs.SccCellAvcIndS;
import se.ericsson.wcdma.rbs.boam.fpx.scmi.sigs.SccCellPhChannCreatedIndS;
import se.ericsson.wcdma.rbs.boam.fpx.scmi.sigs.SccCellPhChannDeletedIndS;
import se.ericsson.wcdma.rbs.boam.fpx.scmi.sigs.SccGetNodebParamReqS;
import se.ericsson.wcdma.rbs.boam.fpx.scmi.sigs.SccGetNodebParamRspS;
import se.ericsson.wcdma.rbs.boam.fpx.scmi.sigs.SccSetNodebParamReqS;
import se.ericsson.wcdma.rbs.boam.fpx.scmi.sigs.SccSubscAvcCellReqS;
import se.ericsson.wcdma.rbs.boam.fpx.scmi.sigs.SccSubscCmCellReqS;
import se.ericsson.wcdma.rbs.boam.fpx.scmi.sigs.SccSubscCmCellRspS;
import se.ericsson.wcdma.rbs.boam.mao.bcm.BoamHelper;
import se.ericsson.wcdma.rbs.boam.pms.iface.ProxyScanner;

public class ScCellProxy
extends ScGenericProxy
implements ProxyScanner {
    private static final Class THIS_CLASS = ScCellProxy.class;
    private static final String SERVICE_NAME = "bcCemCellManager";
    private static final String DCG_TYPE = "emiax";
    private static ScCellProxy instance = null;

    private ScCellProxy() {
        super(SERVICE_NAME);
        MessageLog.traceEnter(this.getClass(), "constructor ");
        this.boamSignalPort.addSignalObserver(this, BcCellFaultIndS.class);
        this.boamSignalPort.addSignalObserver(this, BcCellFaultCeaseIndS.class);
        this.boamSignalPort.addSignalObserver(this, BcCellRbsFaultIndS.class);
        this.boamSignalPort.addSignalObserver(this, BcCellRbsFaultCeaseIndS.class);
        this.boamSignalPort.addSignalObserver(this, SccCellAvcIndS.class);
        this.boamSignalPort.addSignalObserver(this, SccCellPhChannCreatedIndS.class);
        this.boamSignalPort.addSignalObserver(this, SccCellPhChannDeletedIndS.class);
    }

    public static synchronized ScCellProxy instance() {
        if (instance == null) {
            instance = new ScCellProxy();
        }
        return instance;
    }

    public void subscribeToFroNotification() {
        MessageLog.traceEnter(THIS_CLASS, "subscribeToFroNotification()<---");
        try {
            this.subscribeFmCell(0, 0);
            this.subscribeAvcCell(0, 0);
            this.subscCmCell(0, 0, 1);
        }
        catch (FroRequestFailedException e) {
            MessageLog.traceError(this.getClass(), "Received result NOK from resource when subscribing to the notifications" + (Object)((Object)e));
        }
        catch (FroNotAccessibleException e) {
            MessageLog.traceError(this.getClass(), "Received result NOK from resource when subscribing to the notifications" + (Object)((Object)e));
        }
    }

    private SccSubscCmCellRspS subscCmCell(int clientId, int subscribeOperation, int subscribeOnCreateDelete) throws FroRequestFailedException, FroNotAccessibleException {
        MessageLog.traceEnter(this.getClass(), "subscCmCell()");
        SccSubscCmCellReqS reqSig = new SccSubscCmCellReqS(clientId, subscribeOperation, subscribeOnCreateDelete, this.signalPort.getServiceName());
        return (SccSubscCmCellRspS)this.sendAndRec(reqSig);
    }

    private void subscribeFmCell(int clientId, int subscriptionRequest) throws FroRequestFailedException, FroNotAccessibleException {
        MessageLog.traceEnter(THIS_CLASS, "subscribeFmCell()<---");
        BcSubscFmCellReqS reqSig = new BcSubscFmCellReqS(clientId, subscriptionRequest, this.signalPort.getServiceName());
        this.sendAndRec(reqSig);
    }

    private void subscribeAvcCell(int clientId, int subscriptionRequest) throws FroRequestFailedException, FroNotAccessibleException {
        MessageLog.traceEnter(THIS_CLASS, "subscribeAvcCell()<---");
        SccSubscAvcCellReqS reqSig = new SccSubscAvcCellReqS(clientId, subscriptionRequest, this.signalPort.getServiceName());
        this.sendAndRec(reqSig);
    }

    public BcCreateCellRspS createCell(int transactionId, int clientId, int localCellId, int[] cellCarriersFroId, int cellRange, int coherenceMode, int featureStateMimo, int operatingBand, String localCellRdn) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "createCell()");
        int[] tmpCellCarriersFroId = new int[6];
        for (int i = 0; i < 6; ++i) {
            tmpCellCarriersFroId[i] = i >= cellCarriersFroId.length ? -1 : cellCarriersFroId[i];
        }
        BcCreateCellReqS reqSig = new BcCreateCellReqS(transactionId, clientId, localCellId, tmpCellCarriersFroId, cellRange, coherenceMode, featureStateMimo, operatingBand, localCellRdn);
        return (BcCreateCellRspS)this.sendAndRec(reqSig);
    }

    public BcDeleteCellRspS deleteCell(int transactionId, int clientId, int cellFroId) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "deleteCell()");
        BcDeleteCellReqS reqSig = new BcDeleteCellReqS(transactionId, clientId, cellFroId);
        return (BcDeleteCellRspS)this.sendAndRec(reqSig);
    }

    public BcSetCellRspS setCell(int transactionId, int clientId, int cellFroId, int parameterId, int value) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setCell()");
        BcSetCellReqS reqSig = new BcSetCellReqS(transactionId, clientId, cellFroId, parameterId, value);
        return (BcSetCellRspS)this.sendAndRec(reqSig);
    }

    public BcCellGetParamRspS cellGetParam(int clientId, int cellFroId, int transactionId) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "cellGetParam()");
        BcCellGetParamReqS reqSig = new BcCellGetParamReqS(clientId, cellFroId, transactionId);
        return (BcCellGetParamRspS)this.sendAndRec(reqSig);
    }

    public SccGetNodebParamRspS getNodeBParam(int clientId) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getLicenseStateMimo()");
        SccGetNodebParamReqS reqSig = new SccGetNodebParamReqS(clientId);
        return (SccGetNodebParamRspS)this.sendAndRec(reqSig);
    }

    public SccGetNodebParamRspS getSccGetNodebParamRspS(int clientId) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getLicenseStateMimo()");
        SccGetNodebParamReqS reqSig = new SccGetNodebParamReqS(clientId);
        return (SccGetNodebParamRspS)this.sendAndRec(reqSig);
    }

    public BcCellGetNbapParamRspS cellGetNbapParam(int clientId, int cellFroId, int transactionId) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "cellGetNbapParam()");
        BcCellGetNbapParamReqS reqSig = new BcCellGetNbapParamReqS(clientId, cellFroId, transactionId);
        return (BcCellGetNbapParamRspS)this.sendAndRec(reqSig);
    }

    public BcCellGetOcnsRspS cellGetOcnsParams(int clientId, int cellFroId, int transactionId) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "cellGetOcnsParams()");
        BcCellGetOcnsReqS reqSig = new BcCellGetOcnsReqS(clientId, cellFroId, transactionId);
        return (BcCellGetOcnsRspS)this.sendAndRec(reqSig);
    }

    public void activateOcns(int transactionId, int clientId, int cellFroId) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "activateOcns()");
        BcCellActivateOcnsReqS reqSig = new BcCellActivateOcnsReqS(transactionId, clientId, cellFroId);
        this.sendAndRec(reqSig);
    }

    public void deactivateOcns(int transactionId, int clientId, int cellFroId) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "deactivateOcns()");
        BcCellDeactivateOcnsReqS reqSig = new BcCellDeactivateOcnsReqS(transactionId, clientId, cellFroId);
        this.sendAndRec(reqSig);
    }

    public void configureOcns(int transactionId, int clientId, int cellFroId, int powerVariation, boolean continuousTransmissionOn, int standardDeviation, int correlationTime, int speechNumOfUsers, int[] speechAvgPow, int speechActivityFactor, boolean speechRandomizationOn, int interactiveNumOfUsers, int[] interactiveAvgPow, int interactiveAvgRequestSize, int interactiveAvgRequestInterArrivalTime, boolean interactiveRandomizationOn, int videoNumOfUsers, int[] videoAvgPow, int hsdpaNumOfUsers, int hsdpaTransmissionProbability) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "configureOcns()");
        int continuousTransmissionOnInt = continuousTransmissionOn ? 1 : 0;
        int speechRandomizationOnInt = speechRandomizationOn ? 1 : 0;
        int interactiveRandomizationOnInt = interactiveRandomizationOn ? 1 : 0;
        BcCellConfigOcnsReqS tmp = new BcCellConfigOcnsReqS();
        int maxSpeechNumOfUsers = tmp.speechAvgPow.length;
        int maxInteractiveNumOfUsers = tmp.interactiveAvgPow.length;
        int maxVideoNumOfUsers = tmp.videoAvgPow.length;
        int[] _speechAvgPow = new int[maxSpeechNumOfUsers];
        int[] _interactiveAvgPow = new int[maxInteractiveNumOfUsers];
        int[] _videoAvgPow = new int[maxVideoNumOfUsers];
        try {
            System.arraycopy(speechAvgPow, 0, _speechAvgPow, 0, speechNumOfUsers);
            System.arraycopy(interactiveAvgPow, 0, _interactiveAvgPow, 0, interactiveNumOfUsers);
            System.arraycopy(videoAvgPow, 0, _videoAvgPow, 0, videoNumOfUsers);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            MessageLog.traceError(this.getClass(), "Array too large:" + e.getMessage());
        }
        BcCellConfigOcnsReqS reqSig = new BcCellConfigOcnsReqS(transactionId, clientId, cellFroId, powerVariation, continuousTransmissionOnInt, standardDeviation, correlationTime, speechNumOfUsers, _speechAvgPow, speechActivityFactor, speechRandomizationOnInt, interactiveNumOfUsers, _interactiveAvgPow, interactiveAvgRequestSize, interactiveAvgRequestInterArrivalTime, interactiveRandomizationOnInt, videoNumOfUsers, _videoAvgPow, hsdpaNumOfUsers, hsdpaTransmissionProbability);
        this.sendAndRec(reqSig);
    }

    public void releaseOcns(int transactionId, int clientId, int cellFroId) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "releaseOcns()");
        BcCellReleaseOcnsReqS reqSig = new BcCellReleaseOcnsReqS(transactionId, clientId, cellFroId);
        this.sendAndRec(reqSig);
    }

    public void setFeatureState(int transactionId, int clientId, int parameterId, int value) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setFeatureState()");
        SccSetNodebParamReqS reqSig = new SccSetNodebParamReqS(transactionId, clientId, parameterId, value);
        this.sendAndRec(reqSig);
    }

    public ScannedValue[] getPmsAttribute(String name, int froId, int bbPoolId, int[] additionalInfo) throws MoAccessException {
        ArrayList<ScannedValue> valueList = new ArrayList<ScannedValue>();
        if (name.equals("pmsUsedDlCodesGrp")) {
            ChcGetCarrierPmDlCodeRspS rspSig = ChcHsdpaCellServiceProxy.instance().getCellCarrierPmUsedDlCodes(0, froId);
            ScannedValue aValue = new ScannedValue("pmSumUsedDlCodes", new int[]{rspSig.pmSumUsedDlCodes});
            valueList.add(aValue);
            aValue = new ScannedValue("pmSampledUsedDlCodes", new int[]{rspSig.pmSampledUsedDlCodes});
            valueList.add(aValue);
            aValue = new ScannedValue("pmUsedDlCodesUtilisation", rspSig.pmUsedDlCodesUtilisation);
            valueList.add(aValue);
        } else {
            MessageLog.traceError(this.getClass(), "Unexpected counter or group name" + name);
        }
        return valueList.toArray(new ScannedValue[valueList.size()]);
    }

    public void pmsStart(String name, int granularityPeriod, int froId, int bbPoolId, int[] additionalInfo) throws MoAccessException {
        if (name.equals("pmsUsedDlCodesGrp")) {
            int measType = 32;
            ChcHsdpaCellServiceProxy.instance().chcCellCarrierStartPm(0, measType, froId, granularityPeriod);
        } else {
            MessageLog.traceError(this.getClass(), "Unexpected counter or group name" + name);
        }
    }

    public void pmsStop(String name, int froId, int bbPoolId, int[] additionalInfo) throws MoAccessException {
        if (name.equals("pmsUsedDlCodesGrp")) {
            int measType = 32;
            ChcHsdpaCellServiceProxy.instance().chcCellCarrierStopPm(0, measType, froId);
        } else {
            MessageLog.traceError(this.getClass(), "Unexpected counter or group name" + name);
        }
    }

    public void signalReceived(InSignal inSig) {
        BcCellFaultIndS cellFaultSig;
        int specificProblem;
        MessageLog.traceEnter(this.getClass(), "signalReceived");
        if (inSig instanceof BcCellFaultIndS && (specificProblem = (cellFaultSig = (BcCellFaultIndS)inSig).getSpecificProblem()) == 37471) {
            this.runDCG();
        }
        super.signalReceived(inSig);
    }

    private void runDCG() {
        MessageLog.traceEnter(this.getClass(), "runDCG");
        DataCollectionGenerationMo dcgMo = (DataCollectionGenerationMo)BoamHelper.getFirstMatchingMo("DataCollectionGeneration");
        if (dcgMo == null) {
            MessageLog.traceError(this.getClass(), "Cannot find DataCollectionGeneration Mo");
            return;
        }
        try {
            int dcgState = dcgMo.getDcgState(null);
            MessageLog.trace(7, this.getClass(), "dcgState=" + dcgState);
            if (dcgState != 1) {
                dcgMo.actionRunDcg(DCG_TYPE, 0, null);
            }
        }
        catch (MoAccessException e) {
            MessageLog.traceError(this.getClass(), "exception when runDCG, cause " + e.getReasonTag());
        }
    }
}

