/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.fpx.scmi.proxies;

import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.wcdma.rbs.boam.common.FroNotAccessibleException;
import se.ericsson.wcdma.rbs.boam.common.FroRequestFailedException;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.fpx.scmi.proxies.ScGenericProxy;
import se.ericsson.wcdma.rbs.boam.fpx.scmi.sigs.LrsRfapAddCarrierReqS;
import se.ericsson.wcdma.rbs.boam.fpx.scmi.sigs.LrsRfapAddCarrierRspS;
import se.ericsson.wcdma.rbs.boam.fpx.scmi.sigs.LrsRfapAvpowerOffReqS;
import se.ericsson.wcdma.rbs.boam.fpx.scmi.sigs.LrsRfapAvpowerOffRspS;
import se.ericsson.wcdma.rbs.boam.fpx.scmi.sigs.LrsRfapAvpowerOnReqS;
import se.ericsson.wcdma.rbs.boam.fpx.scmi.sigs.LrsRfapAvpowerOnRspS;
import se.ericsson.wcdma.rbs.boam.fpx.scmi.sigs.LrsRfapCarrierFaultIndS;
import se.ericsson.wcdma.rbs.boam.fpx.scmi.sigs.LrsRfapCarrierFaultceaseIndS;
import se.ericsson.wcdma.rbs.boam.fpx.scmi.sigs.LrsRfapGetAvpowerReqS;
import se.ericsson.wcdma.rbs.boam.fpx.scmi.sigs.LrsRfapGetAvpowerRspS;
import se.ericsson.wcdma.rbs.boam.fpx.scmi.sigs.LrsStartFmPowMeasReqS;
import se.ericsson.wcdma.rbs.boam.fpx.scmi.sigs.LrsStartFmPowMeasRspS;
import se.ericsson.wcdma.rbs.boam.fpx.scmi.sigs.LrsSubscFmRfapCarrierReqS;
import se.ericsson.wcdma.rbs.boam.fpx.scmi.sigs.LrsSubscFmRfapCarrierRspS;

public class ScRfAccessCarrierProxy
extends ScGenericProxy {
    private static ScRfAccessCarrierProxy theOneAndOnly = null;
    private static final String SERVICE_NAME = "lrsRcRfAccessResMgr";

    private ScRfAccessCarrierProxy() {
        super(SERVICE_NAME);
        MessageLog.traceEnter(this.getClass(), "Constructor");
        this.boamSignalPort.addSignalObserver(this, LrsRfapCarrierFaultIndS.class);
        this.boamSignalPort.addSignalObserver(this, LrsRfapCarrierFaultceaseIndS.class);
    }

    public static synchronized ScRfAccessCarrierProxy instance() {
        if (theOneAndOnly == null) {
            theOneAndOnly = new ScRfAccessCarrierProxy();
        }
        return theOneAndOnly;
    }

    public LrsRfapAvpowerOnRspS avpowerOn(int clientId, int rfAccessPointFroId, int cellCarrierFroId) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "avpowerOn()");
        LrsRfapAvpowerOnReqS reqSig = new LrsRfapAvpowerOnReqS(clientId, rfAccessPointFroId, cellCarrierFroId);
        return (LrsRfapAvpowerOnRspS)this.sendAndRec(reqSig);
    }

    public LrsRfapAvpowerOffRspS avpowerOff(int clientId, int rfAccessPointFroId, int cellCarrierFroId) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "avpowerOff()");
        LrsRfapAvpowerOffReqS reqSig = new LrsRfapAvpowerOffReqS(clientId, rfAccessPointFroId, cellCarrierFroId);
        return (LrsRfapAvpowerOffRspS)this.sendAndRec(reqSig);
    }

    public LrsStartFmPowMeasRspS rfPowMeas(int clientId, int rfAccessPointFroId, int frequencyPlane) throws FroRequestFailedException, FroNotAccessibleException {
        MessageLog.traceEnter(this.getClass(), "rfPowMeas()");
        LrsStartFmPowMeasReqS reqSig = new LrsStartFmPowMeasReqS(clientId, rfAccessPointFroId, frequencyPlane);
        return (LrsStartFmPowMeasRspS)this.sendAndRec(reqSig);
    }

    public LrsRfapGetAvpowerRspS getPowLimSwitchOn(int clientId, int rfAccessPointFroId, int cellCarrierFroId) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getPowLimSwitchOn()");
        LrsRfapGetAvpowerReqS reqSig = new LrsRfapGetAvpowerReqS(clientId, rfAccessPointFroId, cellCarrierFroId);
        return (LrsRfapGetAvpowerRspS)this.sendAndRec(reqSig);
    }

    public LrsRfapAddCarrierRspS rfapAddCarrier(int transactionId, int clientId, int rfAccessPointFroId, int cellCarrierFroId, int aiReallocation) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "rfapAddCarrier()");
        LrsRfapAddCarrierReqS reqSig = new LrsRfapAddCarrierReqS(clientId, transactionId, rfAccessPointFroId, cellCarrierFroId, aiReallocation);
        return (LrsRfapAddCarrierRspS)this.sendAndRec(reqSig);
    }

    private LrsSubscFmRfapCarrierRspS subscFmRfapCarrier(int clientId, int subscribeOperation) throws FroRequestFailedException, FroNotAccessibleException {
        MessageLog.traceEnter(this.getClass(), "subscFmRfapCarrier()");
        LrsSubscFmRfapCarrierReqS reqSig = new LrsSubscFmRfapCarrierReqS(clientId, subscribeOperation, this.signalPort.getServiceName());
        return (LrsSubscFmRfapCarrierRspS)this.sendAndRec(reqSig);
    }

    public void subscribeToFroNotification() {
        try {
            this.subscFmRfapCarrier(0, 0);
        }
        catch (FroRequestFailedException e) {
            MessageLog.traceError(this.getClass(), "Received result NOK from resource when subscribing to the notifications" + (Object)((Object)e));
        }
        catch (FroNotAccessibleException e) {
            MessageLog.traceError(this.getClass(), "Received result NOK from resource when subscribing to the notifications" + (Object)((Object)e));
        }
    }
}

