/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.fpx.scmi.sigs;

import enea.ose.io.SignalInputStream;
import enea.ose.io.SignalOutputStream;
import enea.ose.system.UnlinkedSignal;
import java.io.IOException;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.wcdma.rbs.boam.common.Strings;
import se.ericsson.wcdma.rbs.boam.fpx.scmi.sigs.SccRetDeviceDataS;

public class LrsRetGetParamRspS
extends UnlinkedSignal {
    public static final int SIG_NO = 16802046;
    public int clientId;
    public int minTilt;
    public int maxTilt;
    public SccRetDeviceDataS deviceData = new SccRetDeviceDataS();
    public int result;
    public int errorCode;

    public LrsRetGetParamRspS() {
        super(16802046);
    }

    public LrsRetGetParamRspS(int clientId, int minTilt, int maxTilt, SccRetDeviceDataS deviceData, int result2, int errorCode) {
        super(16802046);
        this.clientId = clientId;
        this.minTilt = minTilt;
        this.maxTilt = maxTilt;
        this.deviceData = deviceData;
        this.result = result2;
        this.errorCode = errorCode;
    }

    public void initReceive() {
        SignalInputStream in = this.getSignalInputStream();
        try {
            this.clientId = in.readS32();
            this.minTilt = in.readS32();
            this.maxTilt = in.readS32();
            this.deviceData.antennaModelNumber = Strings.toString(in.readS8Array(16));
            this.deviceData.antennaSerialNumber = Strings.toString(in.readS8Array(18));
            this.deviceData.antennaOperatingBand = in.readU16();
            this.deviceData.beamwidth = in.readU16Array(4);
            this.deviceData.gain = in.readU8Array(4);
            this.deviceData.maxTilt = in.readS16();
            this.deviceData.minTilt = in.readS16();
            this.deviceData.installationDate = Strings.toString(in.readS8Array(7));
            this.deviceData.installerID = Strings.toString(in.readS8Array(6));
            this.deviceData.baseStationID = Strings.toString(in.readS8Array(33));
            this.deviceData.sectorID = Strings.toString(in.readS8Array(33));
            this.deviceData.antennaBearing = in.readU16();
            this.deviceData.installedMechanicalTilt = in.readS16();
            this.result = in.readS32();
            this.errorCode = in.readS32();
        }
        catch (IOException e) {
            MessageLog.traceError(((Object)((Object)this)).getClass(), (String)("initReceive failed in LrsRetGetParamRspS: " + e));
        }
    }

    public void initSend() {
        SignalOutputStream out = this.getSignalOutputStream();
        try {
            out.writeS32(this.clientId);
            out.writeS32(this.minTilt);
            out.writeS32(this.maxTilt);
            out.writeS8Array(Strings.getBytes(this.deviceData.antennaModelNumber, 16));
            out.writeS8Array(Strings.getBytes(this.deviceData.antennaSerialNumber, 18));
            out.writeU16(this.deviceData.antennaOperatingBand);
            out.writeU16Array(this.deviceData.beamwidth);
            out.writeU8Array(this.deviceData.gain);
            out.writeS16(this.deviceData.maxTilt);
            out.writeS16(this.deviceData.minTilt);
            out.writeS8Array(Strings.getBytes(this.deviceData.installationDate, 7));
            out.writeS8Array(Strings.getBytes(this.deviceData.installerID, 6));
            out.writeS8Array(Strings.getBytes(this.deviceData.baseStationID, 33));
            out.writeS8Array(Strings.getBytes(this.deviceData.sectorID, 33));
            out.writeU16(this.deviceData.antennaBearing);
            out.writeS16(this.deviceData.installedMechanicalTilt);
            out.writeS32(this.result);
            out.writeS32(this.errorCode);
        }
        catch (IOException e) {
            MessageLog.traceError(((Object)((Object)this)).getClass(), (String)("initSend failed in LrsRetGetParamRspS: " + e));
        }
    }
}

