/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.mao.autoconf.oss;

import org.omg.CORBA.SystemException;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.wcdma.rbs.boam.common.log.AiMessageLog;
import se.ericsson.wcdma.rbs.boam.mao.autoconf.oss.OssInformer;
import se.ericsson.wcdma.rbs.boam.mao.autoconf.oss.OssInformerHelper;
import se.ericsson.wcdma.rbs.boam.mao.autoconf.oss.OssInformerStatusHandler;
import se.ericsson.wcdma.rbs.boam.mao.autoconf.oss.ipaddresschange.NodeIpAddressChange;
import se.ericsson.wcdma.rbs.boam.mao.autoconf.oss.ipaddresschange.NodeIpAddressChangePackage.NotAcceptedException;
import se.ericsson.wcdma.rbs.boam.mao.autoconf.oss.ipaddresschange.OssNodeIpAddressChangedException;
import se.ericsson.wcdma.rbs.boam.mao.autoconf.oss.ipaddresschange.OssNodeIpAddressChangedResolver;
import se.ericsson.wcdma.rbs.boam.mao.autoconf.oss.ipaddresschange.OssNodeIpAddressChangedResolverFactory;
import se.ericsson.wcdma.rbs.boam.mao.autoconf.oss.ipaddresschange.Reason;
import se.ericsson.wcdma.rbs.boam.mao.autoconf.oss.nodediscover.IpSecLevel;
import se.ericsson.wcdma.rbs.boam.mao.autoconf.oss.nodediscover.NodeDiscovery;
import se.ericsson.wcdma.rbs.boam.mao.autoconf.oss.nodediscover.NodeSecurityIntegration;
import se.ericsson.wcdma.rbs.boam.mao.autoconf.oss.nodediscover.OssNodeDiscoveryException;
import se.ericsson.wcdma.rbs.boam.mao.autoconf.oss.nodediscover.OssNodeDiscoveryResolver;
import se.ericsson.wcdma.rbs.boam.mao.autoconf.oss.nodediscover.OssNodeDiscoveryResolverFactory;
import se.ericsson.wcdma.rbs.boam.mao.autoconf.oss.nodediscover.SecurityLevel;
import se.ericsson.wcdma.rbs.boam.mao.autoconf.smartmos.RbsConfigurationMoImpl;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.excep.RbsConfigurationFailedException;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.RbsConfigurationMo;

public class OssInformerImpl
implements OssInformer {
    private final Class THIS_CLASS = OssInformerImpl.class;
    protected final String INFORMING_THREAD_NAME = "WCDMA_Boam_RbsConfiguration_oss_informer";
    private long MAX_OPERATION_TIME = 5000L;
    protected Thread ossInformerThread = null;
    private long currentOssThreadSleepingTime = 30000L;
    protected long currentTimeoutTime = 0L;
    private long supervisionSleepTime;
    private RbsConfigurationMo rbsConfigMo;

    public OssInformerImpl(RbsConfigurationMo aRbsConfigMo, long supervisionSleepTime) {
        this.rbsConfigMo = aRbsConfigMo;
        this.supervisionSleepTime = supervisionSleepTime;
    }

    public Thread getOssInformingThread() {
        return this.ossInformerThread;
    }

    public void setOssThreadSleepingTime(long ossThreadSleepingTime) {
        this.currentOssThreadSleepingTime = ossThreadSleepingTime;
    }

    public void ossNodeUp(OssInformerStatusHandler statusHandler, String rbsIpAddress, int maxNumRetries) {
        AiMessageLog.traceEnter(this.THIS_CLASS, "informOss()" + rbsIpAddress + " maxNumRestries = " + maxNumRetries);
        OssInformerHelper ossInformerHelper = new OssInformerHelper(this.rbsConfigMo);
        this.ossInformerThread = new OssNodeUpThread(statusHandler, rbsIpAddress, ossInformerHelper, maxNumRetries);
        this.ossInformerThread.setDaemon(true);
        Runnable supervisor = this.createSupervisor();
        Thread supervisorThread = new Thread(supervisor);
        supervisorThread.setDaemon(true);
        this.ossInformerThread.start();
        supervisorThread.start();
        AiMessageLog.traceReturn(this.THIS_CLASS, "informOss()");
    }

    private Runnable createSupervisor() {
        return new Runnable(){

            public void run() {
                while (OssInformerImpl.this.ossInformerThread.isAlive()) {
                    try {
                        Thread.sleep(OssInformerImpl.this.supervisionSleepTime);
                    }
                    catch (InterruptedException e) {
                        AiMessageLog.traceError(OssInformerImpl.this.THIS_CLASS, "Interrupted in supervision thread");
                    }
                    if (OssInformerImpl.this.ossInformerThread.isAlive() && ((OssNodeUpThread)OssInformerImpl.this.ossInformerThread).isPerformingInformOssOp()) {
                        long startTime;
                        long currentTime = System.currentTimeMillis();
                        if (currentTime - (startTime = ((OssNodeUpThread)OssInformerImpl.this.ossInformerThread).getStartTime()) <= OssInformerImpl.this.MAX_OPERATION_TIME) continue;
                        AiMessageLog.trace(2, OssInformerImpl.this.THIS_CLASS, "OSS Nodeuping thread is still running, will interrupt");
                        OssInformerImpl.this.ossInformerThread.interrupt();
                        continue;
                    }
                    AiMessageLog.trace(2, OssInformerImpl.this.THIS_CLASS, "OSS Nodeing thread is executing normally, no need to interrupt");
                }
            }
        };
    }

    public void nodeSecurityUp(final String rbsIpAddress, final String sshKey, final String installerName, final int wantedSecLevel, final int minimumSecLevel, int reachedSecLevel, final String securityChecksum, final String securityChecksumVersion, final String oamCertSerNo, final String oamCertFingerPrint, final int wantedIpSecLevel, final int reachedIpSecLevel, final String iPSecCUSCertSerNo, final String iPSecCUSCertFingerPrint) {
        AiMessageLog.traceEnter(this.THIS_CLASS, "nodeSecurityUp()");
        final OssInformerHelper ossInformerHelper = new OssInformerHelper(this.rbsConfigMo);
        final int correctedReachedSecLevel = reachedSecLevel == 4 ? 3 : reachedSecLevel;
        AiMessageLog.trace(1, this.THIS_CLASS, "nodeSecurityUp(): will report reached security level " + correctedReachedSecLevel);
        Runnable ossInformer = new Runnable(){

            public void run() {
                long startTime = System.currentTimeMillis();
                while (!OssInformerImpl.this.doNodeSecurityUp(rbsIpAddress, sshKey, installerName, OssInformerImpl.this.convertToSecurityLevelEnum(wantedSecLevel), OssInformerImpl.this.convertToSecurityLevelEnum(minimumSecLevel), OssInformerImpl.this.convertToSecurityLevelEnum(correctedReachedSecLevel), securityChecksum, securityChecksumVersion, oamCertSerNo, oamCertFingerPrint, IpSecLevel.from_int(wantedIpSecLevel), IpSecLevel.from_int(reachedIpSecLevel), iPSecCUSCertSerNo, iPSecCUSCertFingerPrint, ossInformerHelper)) {
                    long currentTime;
                    if (OssInformerImpl.this.currentTimeoutTime > 0L && (currentTime = System.currentTimeMillis()) >= startTime + OssInformerImpl.this.currentTimeoutTime) {
                        AiMessageLog.trace(1, OssInformerImpl.this.THIS_CLASS, "informOss() timed out after " + OssInformerImpl.this.currentTimeoutTime + " milliseconds.");
                        break;
                    }
                    try {
                        Thread.sleep(OssInformerImpl.this.currentOssThreadSleepingTime);
                    }
                    catch (InterruptedException ie) {
                        AiMessageLog.traceError(OssInformerImpl.this.THIS_CLASS, "Could not sleep in OSS nodeuping thread. " + ie.getMessage(), ie);
                    }
                }
            }
        };
        this.ossInformerThread = new Thread(ossInformer, "WCDMA_Boam_RbsConfiguration_oss_informer");
        this.ossInformerThread.setDaemon(true);
        this.ossInformerThread.start();
        AiMessageLog.traceReturn(this.THIS_CLASS, "nodeSecurityUp()");
    }

    public void notificationOfChangedIpAddress(RbsConfigurationMo rbsConfigMo, String nodeId, String oldIp, String newIp, Reason reason, String hash) throws MoAccessException, NotAcceptedException, OssNodeIpAddressChangedException {
        String nameServerAddress = "Not set yet";
        int nameServerPort = -1;
        String nodeIpAddressChangeServiceName = "Not set yet";
        try {
            OssInformerHelper ossInformerHelper = new OssInformerHelper(rbsConfigMo);
            nameServerAddress = ossInformerHelper.getOssAddress();
            nameServerPort = this.getOssPort();
            nodeIpAddressChangeServiceName = ossInformerHelper.getOssNodeIpAddressChangeServiceName();
            OssNodeIpAddressChangedResolver ossNodeIpAddressChangedResolver = OssNodeIpAddressChangedResolverFactory.createOssNodeIpAddressChangedResolver(nameServerAddress, nameServerPort, nodeIpAddressChangeServiceName);
            NodeIpAddressChange nodeIpAddressChange = null;
            nodeIpAddressChange = ossNodeIpAddressChangedResolver.resolveNodeIpAddressChange();
            nodeIpAddressChange.notificationOfChangedIpAddress(nodeId, oldIp, newIp, reason, hash);
        }
        catch (MoAccessException mae) {
            String errorMsg = "Failed to retrieve name server address";
            throw new RbsConfigurationFailedException("Failed to retrieve name server address");
        }
        catch (OssNodeIpAddressChangedException oniace) {
            String errorMsg = "Failed to resolve \"" + nodeIpAddressChangeServiceName + "\" from OSS name service, \"" + nameServerAddress + "\", on port, " + nameServerPort;
            throw new OssNodeIpAddressChangedException(errorMsg, oniace);
        }
        catch (NotAcceptedException nae) {
            String errorMsg = "Failed to notify \"" + nodeIpAddressChangeServiceName + "\"";
            throw new NotAcceptedException(errorMsg, nae.nodeId, nae.oldIp, nae.newIp, nae.reason);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private boolean doOssNodeUp(String rbsIpAddress, OssInformerHelper ossInformerHelper) {
        block19: {
            AiMessageLog.traceEnter(this.THIS_CLASS, "doOssNodeUp(" + rbsIpAddress + ")");
            success = false;
            errorMsg = "";
            debugPrintInfo = "";
            nodeDiscovery = null;
            try {
                nameServerAddress = ossInformerHelper.getOssAddress();
                nameServerPort = this.getOssPort();
                nodeDiscoveryServiceName = ossInformerHelper.getOssNodeDiscoveryServiceName();
                debugPrintInfo = " nameServerAddress = " + nameServerAddress + ", nameServerPort = " + nameServerPort + ", nodeDiscoveryServiceName = " + nodeDiscoveryServiceName + ", rbsIpAddress" + rbsIpAddress;
                AiMessageLog.trace(1, this.THIS_CLASS, "doOssNodeUp: calling doResolveNodeInterface with " + debugPrintInfo);
                nodeDiscovery = this.doResolveNodeInterface(nameServerAddress, nameServerPort, nodeDiscoveryServiceName);
                AiMessageLog.trace(1, this.THIS_CLASS, "doOssNodeUp: doResolveNodeSecurityInterface returned nodeDiscovery = " + nodeDiscovery);
                nodeDiscovery.nodeUp(rbsIpAddress);
                AiMessageLog.trace(1, this.THIS_CLASS, "Informed OSS about node up and running.");
                success = true;
                var11_14 = null;
                ** if (nodeDiscovery == null) goto lbl-1000
            }
            catch (Throwable var10_24) {
                var11_18 = null;
                if (nodeDiscovery != null) {
                    try {
                        nodeDiscovery._release();
                    }
                    catch (SystemException systemException) {
                        AiMessageLog.info(this.THIS_CLASS, "Failed to release NodeDiscoveryStub, reason " + systemException.getMessage());
                    }
                }
                throw var10_24;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    nodeDiscovery._release();
                }
                catch (SystemException systemException) {
                    AiMessageLog.info(this.THIS_CLASS, "Failed to release NodeDiscoveryStub, reason " + systemException.getMessage());
                }
            }
lbl-1000:
            // 2 sources

            {
                break block19;
                catch (OssNodeDiscoveryException onde) {
                    errorMsg = "Generic Failure. " + onde.getMessage() + ". Retrying...";
                    var11_15 = null;
                    if (nodeDiscovery != null) {
                        try {
                            nodeDiscovery._release();
                        }
                        catch (SystemException systemException) {
                            AiMessageLog.info(this.THIS_CLASS, "Failed to release NodeDiscoveryStub, reason " + systemException.getMessage());
                        }
                    }
                    break block19;
                }
                catch (se.ericsson.wcdma.rbs.boam.mao.autoconf.oss.nodediscover.NodeDiscoveryPackage.NotAcceptedException nae) {
                    errorMsg = "OSS did not accept the Node Discovery message. Retrying...";
                    var11_16 = null;
                    if (nodeDiscovery != null) {
                        try {
                            nodeDiscovery._release();
                        }
                        catch (SystemException systemException) {
                            AiMessageLog.info(this.THIS_CLASS, "Failed to release NodeDiscoveryStub, reason " + systemException.getMessage());
                        }
                    }
                    break block19;
                }
                catch (ThreadDeath threadDeath) {
                    throw threadDeath;
                }
                catch (Throwable throwable) {
                    errorMsg = "Unsystemized error: " + throwable + " " + throwable.getMessage();
                    AiMessageLog.traceError(this.THIS_CLASS, "Received unsystemized error", throwable);
                    var11_17 = null;
                    if (nodeDiscovery != null) {
                        try {
                            nodeDiscovery._release();
                        }
                        catch (SystemException systemException) {
                            AiMessageLog.info(this.THIS_CLASS, "Failed to release NodeDiscoveryStub, reason " + systemException.getMessage());
                        }
                    }
                }
            }
        }
        if (!success) {
            AiMessageLog.info(this.THIS_CLASS, errorMsg + debugPrintInfo + ".Retrying...");
        }
        AiMessageLog.traceReturn(this.THIS_CLASS, "doOssNodeUp(" + rbsIpAddress + "), Success = " + success);
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private boolean doNodeSecurityUp(String rbsIpAddress, String sshKey, String installerName, SecurityLevel wantedSecLevel, SecurityLevel minimumSecLevel, SecurityLevel reachedSecLevel, String securityChecksum, String securityChecksumVersion, String oamCertSerNo, String oamCertFingerPrint, IpSecLevel wantedIpSecLevel, IpSecLevel reachedIpSecLevel, String iPSecCUSCertSerNo, String iPSecCUSCertFingerPrint, OssInformerHelper ossInformerHelper) {
        block29: {
            AiMessageLog.traceEnter(this.THIS_CLASS, "doNodeSecurityUp(" + rbsIpAddress + ")");
            errorMsg = "";
            success = false;
            nodeDiscovery = null;
            try {
                nameServerAddress = ossInformerHelper.getOssAddress();
                nameServerPort = this.getOssPort();
                nodeSecurityUpServiceName = ossInformerHelper.getOssNodeSecurityIntegrationServiceName(nameServerAddress);
                nodeDiscoveryServiceName = ossInformerHelper.getOssNodeDiscoveryServiceName();
                nodeSecurityIntegration = null;
                try {
                    AiMessageLog.trace(1, this.THIS_CLASS, "doNodeSecurityUp: calling doResolveNodeSecurityInterface with nameServerAddress = " + nameServerAddress + ", nameServerPort = " + nameServerPort + ", nodeSecurityUpServiceName = " + nodeSecurityUpServiceName);
                    nodeSecurityIntegration = this.doResolveNodeSecurityInterface(nameServerAddress, nameServerPort, nodeSecurityUpServiceName);
                    AiMessageLog.trace(1, this.THIS_CLASS, "doNodeSecurityUp: doResolveNodeSecurityInterface returned nodeSecurityIntegration = " + nodeSecurityIntegration);
                }
                catch (OssNodeDiscoveryException onde) {
                    nodeSecurityIntegration = null;
                    AiMessageLog.trace(1, this.THIS_CLASS, "doNodeSecurityUp: doResolveNodeSecurityInterface failed..., OssNodeDiscoveryException " + onde.getMessage());
                }
                if (nodeSecurityIntegration == null) {
                    AiMessageLog.trace(1, this.THIS_CLASS, "doNodeSecurityUp: calling doResolveNodeInterface with nameServerAddress = " + nameServerAddress + ", nameServerPort = " + nameServerPort + ", nodeDiscoveryServiceName = " + nodeDiscoveryServiceName);
                    nodeDiscovery = this.doResolveNodeInterface(nameServerAddress, nameServerPort, nodeDiscoveryServiceName);
                    AiMessageLog.trace(1, this.THIS_CLASS, "doNodeSecurityUp: doResolveNodeInterface returned nodeDiscovery = " + nodeDiscovery);
                    nodeDiscovery.nodeUp(rbsIpAddress);
                    AiMessageLog.trace(1, this.THIS_CLASS, "doNodeSecurityUp: successfully called nodeUp");
                } else {
                    AiMessageLog.trace(1, this.THIS_CLASS, "doNodeSecurityUp: calling nodeSecurityUp...");
                    nodeSecurityIntegration.nodeSecurityUp(rbsIpAddress, sshKey, installerName, wantedSecLevel, minimumSecLevel, reachedSecLevel, securityChecksum, securityChecksumVersion, oamCertSerNo, oamCertFingerPrint, wantedIpSecLevel, reachedIpSecLevel, iPSecCUSCertSerNo, iPSecCUSCertFingerPrint);
                    AiMessageLog.trace(1, this.THIS_CLASS, "doNodeSecurityUp: nodeSecurityUp successful");
                }
                AiMessageLog.trace(1, this.THIS_CLASS, "Informed OSS about node up and running.");
                success = true;
                var26_31 = null;
                ** if (nodeDiscovery == null) goto lbl-1000
            }
            catch (Throwable var25_45) {
                var26_37 = null;
                if (nodeDiscovery != null) {
                    try {
                        nodeDiscovery._release();
                    }
                    catch (SystemException systemException) {
                        AiMessageLog.info(this.THIS_CLASS, "Failed to release NodeDiscoveryStub, reason " + systemException.getMessage());
                    }
                }
                throw var25_45;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    nodeDiscovery._release();
                }
                catch (SystemException systemException) {
                    AiMessageLog.info(this.THIS_CLASS, "Failed to release NodeDiscoveryStub, reason " + systemException.getMessage());
                }
            }
lbl-1000:
            // 2 sources

            {
                break block29;
                catch (OssNodeDiscoveryException onde) {
                    errorMsg = "Generic Failure. " + onde.getMessage() + ". Retrying...";
                    var26_32 = null;
                    if (nodeDiscovery != null) {
                        try {
                            nodeDiscovery._release();
                        }
                        catch (SystemException systemException) {
                            AiMessageLog.info(this.THIS_CLASS, "Failed to release NodeDiscoveryStub, reason " + systemException.getMessage());
                        }
                    }
                    break block29;
                }
                catch (MoAccessException mae) {
                    errorMsg = "Generic Failure. " + mae.getVariablesAsString() + ". Retrying...";
                    var26_33 = null;
                    if (nodeDiscovery != null) {
                        try {
                            nodeDiscovery._release();
                        }
                        catch (SystemException systemException) {
                            AiMessageLog.info(this.THIS_CLASS, "Failed to release NodeDiscoveryStub, reason " + systemException.getMessage());
                        }
                    }
                    break block29;
                }
                catch (se.ericsson.wcdma.rbs.boam.mao.autoconf.oss.nodediscover.NodeDiscoveryPackage.NotAcceptedException nae2) {
                    errorMsg = "OSS did not accept the Node Security Integration message. Retrying...";
                    var26_34 = null;
                    if (nodeDiscovery != null) {
                        try {
                            nodeDiscovery._release();
                        }
                        catch (SystemException systemException) {
                            AiMessageLog.info(this.THIS_CLASS, "Failed to release NodeDiscoveryStub, reason " + systemException.getMessage());
                        }
                    }
                    break block29;
                }
                catch (se.ericsson.wcdma.rbs.boam.mao.autoconf.oss.nodediscover.NodeSecurityIntegrationPackage.NotAcceptedException nae) {
                    errorMsg = "OSS did not accept the Node Discovery message. Retrying...";
                    var26_35 = null;
                    if (nodeDiscovery != null) {
                        try {
                            nodeDiscovery._release();
                        }
                        catch (SystemException systemException) {
                            AiMessageLog.info(this.THIS_CLASS, "Failed to release NodeDiscoveryStub, reason " + systemException.getMessage());
                        }
                    }
                    break block29;
                }
                catch (ThreadDeath threadDeath) {
                    throw threadDeath;
                }
                catch (Throwable throwable) {
                    errorMsg = "Unsystemized error: " + throwable + " " + throwable.getMessage();
                    var26_36 = null;
                    if (nodeDiscovery != null) {
                        try {
                            nodeDiscovery._release();
                        }
                        catch (SystemException systemException) {
                            AiMessageLog.info(this.THIS_CLASS, "Failed to release NodeDiscoveryStub, reason " + systemException.getMessage());
                        }
                    }
                }
            }
        }
        if (!success) {
            this.reportRetrying(errorMsg);
        }
        AiMessageLog.traceReturn(this.THIS_CLASS, "doNodeSecurityUp(" + rbsIpAddress + ")");
        return success;
    }

    private SecurityLevel convertToSecurityLevelEnum(int secLevel) {
        SecurityLevel result2;
        switch (secLevel) {
            case 1: {
                result2 = SecurityLevel.level_1;
                break;
            }
            case 2: {
                result2 = SecurityLevel.level_2;
                break;
            }
            case 3: 
            case 4: {
                result2 = SecurityLevel.level_3;
                break;
            }
            default: {
                result2 = SecurityLevel.level_1;
            }
        }
        return result2;
    }

    private NodeDiscovery doResolveNodeInterface(String nameServerAddress, int nameServerPort, String nodeDiscoveryServiceName) throws OssNodeDiscoveryException {
        OssNodeDiscoveryResolver ossNodeDiscoveryResolver = OssNodeDiscoveryResolverFactory.createOssNodeDiscoveryResolver(nameServerAddress, nameServerPort, nodeDiscoveryServiceName);
        return ossNodeDiscoveryResolver.resolveNodeDiscovery();
    }

    private NodeSecurityIntegration doResolveNodeSecurityInterface(String nameServerAddress, int nameServerPort, String nodeSecurityServiceName) throws OssNodeDiscoveryException {
        OssNodeDiscoveryResolver ossNodeDiscoveryResolver = OssNodeDiscoveryResolverFactory.createOssNodeDiscoveryResolver(nameServerAddress, nameServerPort, nodeSecurityServiceName);
        return ossNodeDiscoveryResolver.resolveNodeSecurityIntegration();
    }

    private void reportRetrying(String errorMsg) {
        AiMessageLog.traceError(this.THIS_CLASS, errorMsg);
    }

    private int getOssPort() throws MoAccessException {
        AiMessageLog.traceEnter(this.THIS_CLASS, "getOSSPort()");
        int port = ((RbsConfigurationMoImpl)this.rbsConfigMo).getOssCorbaNameServicePort(null);
        AiMessageLog.traceReturn(this.THIS_CLASS, "getOSSPort() - " + port);
        return port;
    }

    public void setTimeoutTime(long timeoutTime) {
        this.currentTimeoutTime = timeoutTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private boolean doNodeAddressChanged(String nodeId, String newIp, OssInformerHelper ossInformerHelper) {
        block22: {
            AiMessageLog.traceEnter(this.THIS_CLASS, "doNodeAddressChanged() -- START");
            errorMsg = "";
            success = false;
            nodeSecurityIntegration = null;
            try {
                nameServerAddress = ossInformerHelper.getOssAddress();
                nameServerPort = this.getOssPort();
                nodeSecurityIntergrationName = ossInformerHelper.getOssNodeSecurityIntegrationServiceName(nameServerAddress);
                try {
                    nodeSecurityIntegration = this.doResolveNodeSecurityInterface(nameServerAddress, nameServerPort, nodeSecurityIntergrationName);
                    AiMessageLog.trace(1, this.THIS_CLASS, "doNodeAddressChanged: doResolveNodeSecurityInterface returned nodeSecurityIntegration = " + nodeSecurityIntegration);
                }
                catch (OssNodeDiscoveryException onde) {
                    nodeSecurityIntegration = null;
                    AiMessageLog.traceError(this.THIS_CLASS, "doNodeAddressChanged: doResolveNodeSecurityInterface failed..., OssNodeDiscoveryException " + onde.getMessage());
                }
                if (nodeSecurityIntegration != null) {
                    nodeSecurityIntegration.nodeAddressChanged(nodeId, newIp);
                }
                success = true;
                var12_15 = null;
                ** if (nodeSecurityIntegration == null) goto lbl-1000
            }
            catch (Throwable var11_25) {
                var12_19 = null;
                if (nodeSecurityIntegration != null) {
                    try {
                        nodeSecurityIntegration._release();
                    }
                    catch (SystemException systemException) {
                        AiMessageLog.info(this.THIS_CLASS, "Failed to release nodeSecurityIntegration, reason " + systemException.getMessage());
                    }
                }
                throw var11_25;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    nodeSecurityIntegration._release();
                }
                catch (SystemException systemException) {
                    AiMessageLog.info(this.THIS_CLASS, "Failed to release nodeSecurityIntegration, reason " + systemException.getMessage());
                }
            }
lbl-1000:
            // 2 sources

            {
                break block22;
                catch (MoAccessException mae) {
                    errorMsg = "Generic Failure. " + mae.getVariablesAsString() + ". Retrying...";
                    var12_16 = null;
                    if (nodeSecurityIntegration != null) {
                        try {
                            nodeSecurityIntegration._release();
                        }
                        catch (SystemException systemException) {
                            AiMessageLog.info(this.THIS_CLASS, "Failed to release nodeSecurityIntegration, reason " + systemException.getMessage());
                        }
                    }
                    break block22;
                }
                catch (se.ericsson.wcdma.rbs.boam.mao.autoconf.oss.nodediscover.NodeSecurityIntegrationPackage.NotAcceptedException nae) {
                    errorMsg = "OSS did not accept the Node Security Intergration message. Retrying...";
                    var12_17 = null;
                    if (nodeSecurityIntegration != null) {
                        try {
                            nodeSecurityIntegration._release();
                        }
                        catch (SystemException systemException) {
                            AiMessageLog.info(this.THIS_CLASS, "Failed to release nodeSecurityIntegration, reason " + systemException.getMessage());
                        }
                    }
                    break block22;
                }
                catch (ThreadDeath threadDeath) {
                    throw threadDeath;
                }
                catch (Throwable throwable) {
                    errorMsg = "Unsystemized error: " + throwable + " " + throwable.getMessage();
                    var12_18 = null;
                    if (nodeSecurityIntegration != null) {
                        try {
                            nodeSecurityIntegration._release();
                        }
                        catch (SystemException systemException) {
                            AiMessageLog.info(this.THIS_CLASS, "Failed to release nodeSecurityIntegration, reason " + systemException.getMessage());
                        }
                    }
                }
            }
        }
        if (!success) {
            this.reportRetrying(errorMsg);
        }
        AiMessageLog.traceReturn(this.THIS_CLASS, "doNodeAddressChanged() -- END");
        return success;
    }

    public void nodeAddressChanged(final String nodeId, final String newIp, final int maxNumRetries) {
        AiMessageLog.traceEnter(this.THIS_CLASS, "nodeAddressChanged()");
        final OssInformerHelper ossInformerHelper = new OssInformerHelper(this.rbsConfigMo);
        Runnable ossInformer = new Runnable(){

            public void run() {
                long startTime = System.currentTimeMillis();
                int numTries = 0;
                AiMessageLog.traceEnter(OssInformerImpl.this.THIS_CLASS, "nodeAddressChanged()-->ossInformer run-->in Thread...");
                while (!OssInformerImpl.this.doNodeAddressChanged(nodeId, newIp, ossInformerHelper)) {
                    long currentTime;
                    if (OssInformerImpl.this.currentTimeoutTime <= 0L && ++numTries >= maxNumRetries) {
                        AiMessageLog.traceError(OssInformerImpl.this.THIS_CLASS, "Could not contact OSS ! Maximum nuber of retries (" + maxNumRetries + ") has succeded");
                        break;
                    }
                    if (OssInformerImpl.this.currentTimeoutTime > 0L && (currentTime = System.currentTimeMillis()) >= startTime + OssInformerImpl.this.currentTimeoutTime) {
                        AiMessageLog.trace(1, OssInformerImpl.this.THIS_CLASS, "nodeAddressChanged() timed out after " + OssInformerImpl.this.currentTimeoutTime + " milliseconds.");
                        break;
                    }
                    try {
                        Thread.sleep(OssInformerImpl.this.currentOssThreadSleepingTime);
                    }
                    catch (InterruptedException ie) {
                        AiMessageLog.traceError(OssInformerImpl.this.THIS_CLASS, "Could not sleep in OSS informing thread. " + ie.getMessage(), ie);
                    }
                }
            }
        };
        this.ossInformerThread = new Thread(ossInformer, "WCDMA_Boam_RbsConfiguration_oss_informer");
        this.ossInformerThread.setDaemon(false);
        this.ossInformerThread.start();
        if (this.currentTimeoutTime <= 0L) {
            try {
                this.ossInformerThread.join();
            }
            catch (InterruptedException e) {
                AiMessageLog.traceError(this.THIS_CLASS, "nodeAddressChanged thread is interupted. " + e.getMessage(), e);
            }
        }
        AiMessageLog.traceReturn(this.THIS_CLASS, "nodeAddressChanged()");
    }

    private class OssNodeUpThread
    extends Thread {
        private String rbsIpAddress;
        private OssInformerHelper ossInformerHelper;
        private int maxNumRetries;
        private boolean isPerformingOssInformOp;
        private Object lock;
        private long informOpStartTime;
        private OssInformerStatusHandler statusHandler;

        public OssNodeUpThread(OssInformerStatusHandler statusHandler, String rbsIpAddress, OssInformerHelper ossInformerHelper, int maxNumRetries) {
            super("WCDMA_Boam_RbsConfiguration_oss_informer");
            this.lock = new Object();
            this.rbsIpAddress = rbsIpAddress;
            this.ossInformerHelper = ossInformerHelper;
            this.maxNumRetries = maxNumRetries;
            this.isPerformingOssInformOp = false;
            this.statusHandler = statusHandler;
        }

        public void run() {
            long startTime = System.currentTimeMillis();
            long numTries = 0L;
            boolean success = false;
            while (!success) {
                success = this.attemptToInformOss();
                if (!success) {
                    long currentTime;
                    if (this.maxNumRetries != -1 && ++numTries >= (long)this.maxNumRetries) {
                        AiMessageLog.info(OssInformerImpl.this.THIS_CLASS, "Could not contact OSS");
                        this.statusHandler.ossConnectionFailed("Maximum nuber of retries (" + this.maxNumRetries + ") has succeded");
                        break;
                    }
                    if (OssInformerImpl.this.currentTimeoutTime > 0L && (currentTime = System.currentTimeMillis()) >= startTime + OssInformerImpl.this.currentTimeoutTime) {
                        AiMessageLog.trace(1, OssInformerImpl.this.THIS_CLASS, "informOss() timed out after " + OssInformerImpl.this.currentTimeoutTime + " milliseconds.");
                        break;
                    }
                    this.waitForNextAttempt();
                    continue;
                }
                this.statusHandler.ossCommunicationSuccessful();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean attemptToInformOss() {
            Object object;
            boolean success;
            this.informOpStartTime = System.currentTimeMillis();
            Object object2 = this.lock;
            synchronized (object2) {
                this.isPerformingOssInformOp = true;
            }
            try {
                success = OssInformerImpl.this.doOssNodeUp(this.rbsIpAddress, this.ossInformerHelper);
                Object var5_4 = null;
                object = this.lock;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                Object object3 = this.lock;
                synchronized (object3) {
                    this.isPerformingOssInformOp = false;
                }
                throw throwable;
            }
            synchronized (object) {
                this.isPerformingOssInformOp = false;
            }
            return success;
        }

        private void waitForNextAttempt() {
            try {
                Thread.sleep(OssInformerImpl.this.currentOssThreadSleepingTime);
            }
            catch (InterruptedException ie) {
                AiMessageLog.trace(2, OssInformerImpl.this.THIS_CLASS, "Could not sleep in OSS informing thread. " + ie.getMessage());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isPerformingInformOssOp() {
            Object object = this.lock;
            synchronized (object) {
                return this.isPerformingOssInformOp;
            }
        }

        public long getStartTime() {
            return this.informOpStartTime;
        }
    }
}

