/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.mao.autoconf.smartmos;

import java.io.File;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.transaction.Control;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.cello.transaction.TransactionRolledBackException;
import se.ericsson.cello.transaction.TransactionServiceImpl;
import se.ericsson.wcdma.rbs.boam.common.RbsErrorException;
import se.ericsson.wcdma.rbs.boam.common.log.AiMessageLog;
import se.ericsson.wcdma.rbs.boam.common.xmlutil.NlhFileEncryptDecryption;
import se.ericsson.wcdma.rbs.boam.common.xmlutil.NlhFileParser;
import se.ericsson.wcdma.rbs.boam.common.xmlutil.XmlHelper;
import se.ericsson.wcdma.rbs.boam.mao.autoconf.smartmos.ActionResult;
import se.ericsson.wcdma.rbs.boam.mao.autoconf.smartmos.ActionResultObserver;
import se.ericsson.wcdma.rbs.boam.mao.autoconf.smartmos.AiConfiguration;
import se.ericsson.wcdma.rbs.boam.mao.autoconf.smartmos.ConfigurationVersionHelper;
import se.ericsson.wcdma.rbs.boam.mao.autoconf.smartmos.NbaHandler;
import se.ericsson.wcdma.rbs.boam.mao.autoconf.smartmos.UpgradePackageHandler;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.excep.RbsConfigurationFailedException;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.RbsConfigurationMo;

public class AutoIntegrationHandler
implements ActionResultObserver {
    private static Map nlhStatusMap = new HashMap();
    private static final int EMPTY_ACTION_QUEUE = -1;
    private String nlhFilePath;
    private String cabinetConfigFilePath;
    private String oamConfigFilePath;
    private String siteConfigFilePath;
    private RbsConfigurationMo rbsConfigurationMo;
    private NbaHandler nbaHandler;
    private ArrayList actionQueue = new ArrayList(4);
    private Control tx;
    private Coordinator c = null;
    private String siteInstallationFilePath;

    public AutoIntegrationHandler(RbsConfigurationMo rbsConfigurationMo, AiConfiguration aiConfiguration, NbaHandler nbaHandler) {
        this.rbsConfigurationMo = rbsConfigurationMo;
        this.nbaHandler = nbaHandler;
        this.nbaHandler.setActionResultObserver(this);
        this.nlhFilePath = aiConfiguration.getNlhFilePath();
        this.siteInstallationFilePath = aiConfiguration.getSiteInstallationFilePath();
    }

    public void performConfigurationIfNeeded() throws MoAccessException {
        AiMessageLog.traceEnter(this.getClass(), "performConfigurationIfNeeded()");
        if (this.isFileExisting(this.nlhFilePath) && !this.isConfigurationDone()) {
            AiMessageLog.trace(2, this.getClass(), "Nlh file exists and configuration is not done, will start configuration");
            this.handleAiWithoutLaptop();
        } else if (this.isConfigurationOngoing()) {
            AiMessageLog.trace(2, this.getClass(), "Configuration is ongoing, will continue configuration");
            this.performConfiguration(false);
        } else if (this.isFileExisting(this.nlhFilePath) && this.rbsConfigurationMo.getRbsConfigLevel(null) == 12) {
            this.startTransaction();
            this.rbsConfigurationMo.setRbsConfigLevel(14, this.c);
            this.endTransaction();
        } else {
            AiMessageLog.trace(2, this.getClass(), "The NLH file is not present on the node or configuration is already done, automatic configuration will not be performed");
        }
    }

    private void handleAiWithoutLaptop() {
        AiMessageLog.traceEnter(this.getClass(), "handleAiWithoutLaptop()");
        this.rbsConfigurationMo.setIntegrationType(1);
        try {
            int nlhStatus;
            if (this.isNlhParsingNeeded()) {
                UpgradePackageHandler upgradePackageHandler;
                boolean upgradeFinished;
                this.startTransaction();
                this.parseNlhFileAndSetAttributes();
                this.endTransaction();
                ConfigurationVersionHelper configurationVersionHelper = new ConfigurationVersionHelper();
                String rollbackCvName = this.getRollbackCvName();
                if (null != this.siteInstallationFilePath && !this.siteInstallationFilePath.equals("") && !(upgradeFinished = (upgradePackageHandler = new UpgradePackageHandler(this.siteInstallationFilePath)).startUpgrade())) {
                    return;
                }
                if (configurationVersionHelper.isCvInStoredConfigurationVersionsAndHasStatusOk(rollbackCvName)) {
                    configurationVersionHelper.setCvFirstInRollbackList(rollbackCvName);
                } else {
                    AiMessageLog.traceError(this.getClass(), "The rollbackCvName stored in the NLH-file is missing in the stored configuration version. Could not set it first in rollback list ");
                }
            }
            if ((nlhStatus = this.rbsConfigurationMo.getNlhStatus(this.c)) != 1) {
                throw new NlhFileParser.NlhParserException("NlhStatus in NLH file is set to " + nlhStatus + " no automatic configuration will be done");
            }
            this.setConfigurationFileAttributesIfNeeded();
            this.performConfiguration(true);
        }
        catch (NlhFileParser.NlhParserException e) {
            this.handleNlhParseError(e);
        }
        catch (Exception e) {
            String msg = "Failure during configuration (wo laptop), will initiate rollback";
            AiMessageLog.traceError(this.getClass(), msg, e);
            this.initiateRollback(msg);
        }
    }

    private void handleNlhParseError(NlhFileParser.NlhParserException e) {
        AiMessageLog.traceError(this.getClass(), "Failure when parsing NLH file", e);
    }

    private void parseNlhFileAndSetAttributes() throws NlhFileParser.NlhParserException, RbsConfigurationFailedException, MoAccessException {
        AiMessageLog.traceEnter(this.getClass(), "parseNlhFileAndSetAttributes()");
        NlhFileParser nlhFileParser = null;
        String encryptKey = null;
        boolean decryptRet = false;
        try {
            encryptKey = NlhFileEncryptDecryption.getXmlEncryptionKey();
            if (encryptKey == null) {
                AiMessageLog.traceError(this.getClass(), "Error occurred when getting the encrypt key, decrypt nlh file unsuccessfully.");
                return;
            }
            nlhFileParser = new NlhFileParser(new File(this.nlhFilePath));
            decryptRet = nlhFileParser.decryptAndParseXML(encryptKey);
            if (!decryptRet) {
                AiMessageLog.traceError(this.getClass(), "Decrypt and parse nlh file unsuccessfully.");
                return;
            }
            AiMessageLog.info(this.getClass(), "Decrypt and parse nlh file successfully.");
            nlhFileParser.parseAndValidate();
        }
        catch (NlhFileParser.NlhParserException e) {
            this.handleNlhParseError(e);
        }
        String rbCvName = nlhFileParser.getNLRollbackCvName();
        int nlhStatus = this.convertNlhStatus(nlhFileParser.getNlhStatus());
        this.rbsConfigurationMo.setNlhStatusValue(nlhStatus);
        this.rbsConfigurationMo.setRbCvName(rbCvName);
        this.cabinetConfigFilePath = nlhFileParser.getCabinetFilePath();
        this.oamConfigFilePath = nlhFileParser.getOamAccessFilePath();
        this.siteConfigFilePath = nlhFileParser.getSiteEquipmentFilePath();
        if (decryptRet) {
            try {
                nlhFileParser.encryptNlhFile(encryptKey);
            }
            catch (GeneralSecurityException e) {
                String msg = "Failure when doing encryption for file:" + this.nlhFilePath;
                AiMessageLog.traceError(this.getClass(), msg, e);
            }
            catch (IOException e) {
                String msg = "Failure when doing encryption for file:" + this.nlhFilePath;
                AiMessageLog.traceError(this.getClass(), msg, e);
            }
        }
    }

    private void initiateRollback(String reasonForRollback) {
        AiMessageLog.traceEnter(this.getClass(), "initiateRollback()");
        this.rbsConfigurationMo.setIntegrationType(0);
        try {
            this.rbsConfigurationMo.initiateRollback(this.getRollbackCvName(), reasonForRollback, null);
        }
        catch (RbsConfigurationFailedException e) {
            AiMessageLog.traceError(this.getClass(), "RbsConfigurationFailedException: Failed initiating rollback", (Throwable)((Object)e));
        }
        catch (MoAccessException e) {
            AiMessageLog.traceError(this.getClass(), "MoAccessException: Failed initiating rollback", e);
        }
    }

    private int convertNlhStatus(String nlhStatus) throws RbsConfigurationFailedException {
        AiMessageLog.traceEnter(this.getClass(), "convertNlhStatus()");
        if (!nlhStatusMap.containsKey(nlhStatus)) {
            throw new RbsConfigurationFailedException("Could not convert nlhStatus from NLH file");
        }
        Integer mappedValue = (Integer)nlhStatusMap.get(nlhStatus);
        int result2 = mappedValue;
        return result2;
    }

    private boolean isConfigurationOngoing() throws MoAccessException {
        String rbsConfigPhase = this.rbsConfigurationMo.getRbsConfigPhase(this.c);
        int rbsConfigLevel = this.rbsConfigurationMo.getRbsConfigLevel(this.c);
        AiMessageLog.traceEnter(this.getClass(), "isConfigurationOngoing(..) rbsConfigLevel: " + rbsConfigLevel + " , rbsConfigPhase: " + rbsConfigPhase);
        return rbsConfigLevel != 0 && !rbsConfigPhase.equals("") && !rbsConfigPhase.equals("Cabinet configuration completed") && !rbsConfigPhase.equals("OaM configuration completed") && !rbsConfigPhase.equals("Site configuration completed");
    }

    private void setConfigurationFileAttributesIfNeeded() throws Exception {
        AiMessageLog.traceEnter(this.getClass(), "setAttributesFromSummaryFile()");
        if (this.rbsConfigurationMo.getCabinetConfigFile(this.c).equals("") || this.rbsConfigurationMo.getOamConfigFile(this.c).equals("") || this.rbsConfigurationMo.getSiteConfigFile(this.c).equals("")) {
            AiMessageLog.trace(2, this.getClass(), "Need to set configuration attributes");
            String value = "";
            this.startTransaction();
            value = this.readFileToString(this.cabinetConfigFilePath);
            this.rbsConfigurationMo.setCabinetConfigFile(value, this.c);
            value = this.readFileToString(this.oamConfigFilePath);
            this.rbsConfigurationMo.setOamConfigFile(value, this.c);
            value = this.readFileToString(this.siteConfigFilePath);
            this.rbsConfigurationMo.setSiteConfigFile(value, this.c);
            this.endTransaction();
        }
    }

    private String readFileToString(String filePath) throws Exception {
        AiMessageLog.traceEnter(this.getClass(), "readFileToString()");
        File file = new File(filePath);
        if (!file.exists()) {
            throw new RbsErrorException("Could not find file: " + filePath);
        }
        XmlHelper xmlHelper = new XmlHelper(file);
        return xmlHelper.getXmlFileAsString();
    }

    private boolean isNlhParsingNeeded() throws MoAccessException {
        AiMessageLog.traceEnter(this.getClass(), "isNlhParsingNeeded()");
        int nlhStatus = this.rbsConfigurationMo.getNlhStatus(this.c);
        String rbCvName = this.rbsConfigurationMo.getRollbackCvName(this.c);
        return nlhStatus == 0 || rbCvName == null || !rbCvName.equals("");
    }

    private boolean isFileExisting(String filePath) {
        boolean result2 = false;
        if (filePath != null) {
            File file = new File(filePath);
            result2 = file.exists();
        }
        AiMessageLog.traceReturn(this.getClass(), "Check if file on path " + filePath + " exists resulted in: " + result2);
        return result2;
    }

    private boolean isConfigurationDone() throws MoAccessException {
        AiMessageLog.traceEnter(this.getClass(), "isConfigurationDone()");
        boolean result2 = false;
        if (this.rbsConfigurationMo.getRbsConfigLevel(this.c) >= 6) {
            result2 = true;
        }
        AiMessageLog.traceReturn(this.getClass(), "Configuration done = " + result2);
        return result2;
    }

    private void performConfiguration(boolean performAllConfiguration) throws MoAccessException {
        AiMessageLog.traceEnter(this.getClass(), "performConfiguration()");
        int configLevel = this.rbsConfigurationMo.getRbsConfigLevel(this.c);
        AiMessageLog.trace(2, this.getClass(), "Will perform configuration, configLevel is " + configLevel);
        this.clearActionQueue();
        switch (configLevel) {
            case 1: {
                this.addActionToQueue(2);
                if (!performAllConfiguration) break;
                this.addActionToQueue(3);
                this.addActionToQueue(4);
                break;
            }
            case 2: {
                this.addActionToQueue(3);
                if (!performAllConfiguration) break;
                this.addActionToQueue(4);
                break;
            }
            case 3: {
                this.addActionToQueue(4);
                break;
            }
            default: {
                AiMessageLog.trace(2, this.getClass(), "No automatic configuration will be done since rbsConfigLevel is set to " + configLevel);
            }
        }
        this.executeNextActionFromQueue();
    }

    public void onResult(ActionResult actionResult) {
        AiMessageLog.traceEnter(this.getClass(), "Got actionResult!! = " + (Object)((Object)actionResult));
        String errorMsg = "";
        try {
            if (actionResult != null && actionResult.getInfo() == 0) {
                this.resetIntegrationTypeIfFinishedAi(actionResult);
                this.executeNextActionFromQueue();
            } else {
                String additionalInfo = "Action result is null";
                if (actionResult != null) {
                    additionalInfo = actionResult.getAdditionalInfo();
                }
                String restartMsg = "Action result is not successful, will initiate rollback. ";
                errorMsg = restartMsg + "AdditionalInfo: " + additionalInfo;
                AiMessageLog.traceError(this.getClass(), errorMsg);
                this.initiateRollback(restartMsg);
            }
        }
        catch (MoAccessException e) {
            errorMsg = "MoAccessException, problem to get info from actionResult!";
            AiMessageLog.traceError(this.getClass(), errorMsg, e);
            this.initiateRollback(errorMsg);
        }
    }

    private void resetIntegrationTypeIfFinishedAi(ActionResult actionResult) throws MoAccessException {
        AiMessageLog.traceEnter(this.getClass(), "resetIntegrationTypeIfFinishedAi()");
        if (actionResult.getTypeOfInvokedAction() == 4 && !this.rbsConfigurationMo.isOssAttributesSet()) {
            this.rbsConfigurationMo.setIntegrationType(0);
        }
    }

    private synchronized void executeNextActionFromQueue() {
        AiMessageLog.traceEnter(this.getClass(), "executeNextActionFromQueue()");
        int action = -1;
        try {
            action = this.dequeueActionFromQueue();
            if (action == -1) {
                AiMessageLog.trace(2, this.getClass(), "Action queue is empty, will return");
                return;
            }
            AiMessageLog.trace(2, this.getClass(), "action to start from queue: " + action);
            switch (action) {
                case 2: {
                    this.rbsConfigurationMo.actionActivateCabinetConfiguration(this.c);
                    break;
                }
                case 3: {
                    this.rbsConfigurationMo.actionActivateOaMConfiguration(this.c);
                    break;
                }
                case 4: {
                    this.rbsConfigurationMo.actionActivateSiteConfiguration(this.c);
                    break;
                }
                default: {
                    String errorMsg = "Invalid RbsConfigurationInvokedAction no action will be started.";
                    AiMessageLog.traceError(this.getClass(), errorMsg);
                    this.initiateRollback(errorMsg);
                    break;
                }
            }
        }
        catch (RbsConfigurationFailedException e) {
            String errorMsg = "RbsConfigurationFailedException";
            AiMessageLog.traceError(this.getClass(), errorMsg, (Throwable)((Object)e));
            this.initiateRollback(errorMsg);
        }
        catch (MoAccessException e) {
            String errorMsg = "MoAccessException when invoking action: " + action;
            AiMessageLog.traceError(this.getClass(), errorMsg, e);
            this.initiateRollback(errorMsg);
        }
    }

    private synchronized int dequeueActionFromQueue() {
        AiMessageLog.traceEnter(this.getClass(), "dequeueActionFromQueue()");
        if (this.actionQueue.isEmpty()) {
            AiMessageLog.trace(2, this.getClass(), "Action queue is empty");
            return -1;
        }
        return (Integer)this.actionQueue.remove(0);
    }

    private synchronized void addActionToQueue(int action) {
        AiMessageLog.traceEnter(this.getClass(), "addActionToQueue()");
        if (this.actionQueue != null) {
            this.actionQueue.add(new Integer(action));
        }
    }

    private synchronized void clearActionQueue() {
        AiMessageLog.traceEnter(this.getClass(), "clearActionQueue()");
        if (this.actionQueue != null) {
            this.actionQueue.clear();
        }
    }

    private void startTransaction() {
        try {
            this.tx = TransactionServiceImpl.instance().getTransactionFactory().create(0);
            this.c = this.tx.getCoordinator();
        }
        catch (TransactionRolledBackException e) {
            AiMessageLog.traceError(this.getClass(), "TransactionRolledBackException: failed to start transaction" + e.getMessage(), e);
        }
    }

    private void endTransaction() {
        try {
            this.tx.getTerminator().commit();
            this.c = null;
        }
        catch (TransactionRolledBackException e) {
            AiMessageLog.traceError(this.getClass(), "TransactionRolledBackException: failed to commit transaction" + e.getMessage(), e);
        }
        catch (InactiveTransactionException e) {
            AiMessageLog.traceError(this.getClass(), "InactiveTransactionException: failed to commit transaction" + e.getMessage(), e);
        }
    }

    private String getRollbackCvName() throws MoAccessException {
        AiMessageLog.traceEnter(this.getClass(), "getRollbackCvName()");
        String cvName = this.rbsConfigurationMo.getRollbackCvName(null);
        if (cvName == null || cvName.equals("")) {
            try {
                this.parseNlhFileAndSetAttributes();
            }
            catch (NlhFileParser.NlhParserException e) {
                this.handleNlhParseError(e);
            }
            cvName = this.rbsConfigurationMo.getRollbackCvName(null);
        }
        return cvName;
    }

    static {
        nlhStatusMap.put("FilesDownloadedSuccessfully", new Integer(1));
    }
}

