/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.mao.autoconf.smartmos;

import edu.emory.mathcs.backport.java.util.concurrent.TimeoutException;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoFactory;
import se.ericsson.cello.moframework.MoFactoryMgr;
import se.ericsson.cello.swmanagement.SwManagementMo;
import se.ericsson.cello.transaction.Control;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.cello.transaction.TransactionRolledBackException;
import se.ericsson.cello.transaction.TransactionServiceImpl;
import se.ericsson.cello.upgradepackage.main.interfaces.UpgradePackageMo;
import se.ericsson.wcdma.rbs.boam.common.Strings;
import se.ericsson.wcdma.rbs.boam.common.log.AiMessageLog;
import se.ericsson.wcdma.rbs.boam.mao.bcm.BoamHelper;
import se.ericsson.wcdma.rbs.boam.mao.common.AttrListImpl;

public class UpgradePackageHelp {
    private String packageName;
    private UpgradePackageMo upgradePackageMo;
    private Control control;
    private Coordinator context;
    private static final int SECOND_MAX_LENGTH = 1;
    private static final int JVM_RESTART_REQ = 23;

    public boolean upgradePackageInit(String upFilePathOnFtpServer, String address, String userName, String password) throws MoAccessException, TimeoutException, TransactionRolledBackException, InactiveTransactionException, InterruptedException {
        AiMessageLog.traceEnter(this.getClass(), "Start upgrade !");
        this.packageName = this.getUpgradePackageName(upFilePathOnFtpServer);
        this.upgradePackageMo = (UpgradePackageMo)BoamHelper.getFirstMatchingMo("UpgradePackage", this.packageName);
        if (null == this.upgradePackageMo) {
            this.upgradePackageMo = this.createUpgradePackage(this.packageName, upFilePathOnFtpServer, address, userName, password);
        }
        if (this.upgradePackageMo.getState(null) == 0) {
            this.upgradePackageMo.actionInstall(null);
        }
        if (this.upgradePackageMo.getState(null) == 1) {
            this.upgradePackageMo.actionRebootNodeUpgrade(null);
        }
        return this.upgradePackageMo.getState(null) == 1 && this.upgradePackageMo.getProgressHeader(null) == 23 || this.upgradePackageMo.getState(null) == 7;
    }

    private UpgradePackageMo createUpgradePackage(String packageName, String upFilePathOnFtpServer, String ftpServerIpAddress, String user, String password) throws TransactionRolledBackException, MoAccessException, InactiveTransactionException {
        AiMessageLog.traceEnter(this.getClass(), "Create UpgradePackageMo !");
        AttrListImpl attributes = new AttrListImpl();
        attributes.insert("ftpServerIpAddress", ftpServerIpAddress);
        attributes.insert("upFilePathOnFtpServer", upFilePathOnFtpServer);
        attributes.insert("user", user);
        attributes.insert("password", password);
        this.startTransaction();
        SwManagementMo swManagementMo = (SwManagementMo)BoamHelper.getFirstMatchingMo("SwManagement");
        MoFactory moFactory = MoFactoryMgr.instance().lookup("UpgradePackage");
        UpgradePackageMo upMo = (UpgradePackageMo)moFactory.createMo((ManagedObject)swManagementMo, (AttrList)attributes, packageName, null, this.context);
        this.endTransaction();
        return upMo;
    }

    private void startTransaction() throws TransactionRolledBackException {
        this.control = TransactionServiceImpl.instance().getTransactionFactory().create(0);
        this.context = this.control.getCoordinator();
    }

    private void endTransaction() throws TransactionRolledBackException, InactiveTransactionException {
        this.control.getTerminator().commit();
        this.context = null;
    }

    public String getUpgradePackageName(String upFilePathOnFtpServer) {
        AiMessageLog.traceEnter(this.getClass(), "get packageName from upFilePathOnFtpServer !");
        if (null == upFilePathOnFtpServer || upFilePathOnFtpServer.equals("")) {
            return "";
        }
        String[] upPath = Strings.split(upFilePathOnFtpServer, "/");
        this.packageName = upPath[upPath.length - 1];
        int firstCxp = this.packageName.indexOf("CXP");
        if (firstCxp < 0) {
            return "";
        }
        int lastXml = this.packageName.lastIndexOf(".xml");
        this.packageName = this.packageName.substring(firstCxp, lastXml);
        return this.packageName;
    }
}

