/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.mao.common;

import java.lang.reflect.Field;
import java.util.Vector;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.AttrMissingAtCreateException;
import se.ericsson.cello.moframework.IllegalParentException;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoCanNotBeCreatedException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoNotFoundException;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.moframework.NotHandledAttributeTypeException;
import se.ericsson.cello.moframework.SoftwareErrorException;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.moframework.StructImpl;
import se.ericsson.cello.moframework.TransactionRequiredException;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.moframework.WrongAttributeTypeException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.excep.InternalErrorException;

public final class ValidateAttributes {
    private static final String MANDATORY = "mandatory";
    private static final String OPTIONAL = "optional";

    private ValidateAttributes() {
    }

    public static void checkTransaction(Coordinator context) throws TransactionRequiredException {
        if (context == null) {
            throw new TransactionRequiredException();
        }
    }

    public static int getTxIdNonTransactional(Coordinator context) {
        if (context == null) {
            return 0;
        }
        return context.getTransactionID();
    }

    public static int getTxIdTransactional(Coordinator context) throws TransactionRequiredException {
        ValidateAttributes.checkTransaction(context);
        return context.getTransactionID();
    }

    public static void intValueRangeCheck(String valueName, int value, int minValue, int maxValue, String thisTypeName) throws ValueOutOfRangeException {
        if (value < minValue || value > maxValue) {
            throw new ValueOutOfRangeException(valueName, thisTypeName);
        }
    }

    public static void intValueRangeCheck(String valueName, int value, int[] minValues, int[] maxValues, String thisTypeName) throws ValueOutOfRangeException {
        if (minValues.length != maxValues.length) {
            throw new ValueOutOfRangeException(valueName, thisTypeName, "Inconsistent range in check");
        }
        for (int i = 0; i < minValues.length; ++i) {
            if (value < minValues[i] || value > maxValues[i]) continue;
            return;
        }
        throw new ValueOutOfRangeException(valueName, thisTypeName);
    }

    public static void intValueInSetCheck(String valueName, int value, int[] possibleValues, String thisTypeName) throws ValueOutOfRangeException {
        if (!ValidateAttributes.contains(value, possibleValues)) {
            throw new ValueOutOfRangeException(valueName, thisTypeName);
        }
    }

    public static void intValueInEnumerationCheck(String valueName, int value, Class enumerationClass, String thisTypeName) throws ValueOutOfRangeException {
        Field[] fields = enumerationClass.getFields();
        for (int i = 0; i < fields.length; ++i) {
            try {
                if (fields[i].getInt(enumerationClass) != value) continue;
                return;
            }
            catch (IllegalArgumentException e) {
                continue;
            }
            catch (IllegalAccessException e) {
                // empty catch block
            }
        }
        throw new ValueOutOfRangeException(valueName, thisTypeName);
    }

    public static void stringValueRangeCheck(String valueName, String value, int maxLength, String thisTypeName) throws ValueOutOfRangeException {
        if (value.length() > maxLength) {
            throw new ValueOutOfRangeException(valueName, thisTypeName);
        }
    }

    public static void stringValueInSetCheck(String valueName, String value, String[] possibleValues, String thisTypeName) throws ValueOutOfRangeException {
        if (!ValidateAttributes.contains(value, possibleValues)) {
            throw new ValueOutOfRangeException(valueName, thisTypeName);
        }
    }

    public static void checkOtherAttributes(AttrList attributes, String thisTypeName) throws NoSuchAttributeException {
        if (attributes.size() != 0) {
            throw new NoSuchAttributeException(attributes.getName(0), thisTypeName);
        }
    }

    public static int checkAndGetIntAttribute(AttrList attributes, String attrName, String thisTypeName) throws MoNotFoundException, NotHandledAttributeTypeException, AttrMissingAtCreateException {
        int index = attributes.indexOf(attrName);
        if (index == -1) {
            throw new AttrMissingAtCreateException(attrName, thisTypeName);
        }
        return (Integer)attributes.getValue(index);
    }

    public static int checkAndGetIntAttribute(AttrList attributes, String attrName, String attrType, int defaultValue, int[] minValues, int[] maxValues, String thisTypeName) throws ValueOutOfRangeException, MoNotFoundException, NotHandledAttributeTypeException, AttrMissingAtCreateException, WrongAttributeTypeException, SoftwareErrorException {
        int index = attributes.indexOf(attrName);
        if (index == -1) {
            if (attrType.equalsIgnoreCase(MANDATORY)) {
                throw new AttrMissingAtCreateException(attrName, thisTypeName);
            }
            if (attrType.equalsIgnoreCase(OPTIONAL)) {
                ValidateAttributes.intValueRangeCheck(attrName, defaultValue, minValues, maxValues, thisTypeName);
                return defaultValue;
            }
            throw new SoftwareErrorException();
        }
        Object attribute = attributes.getValue(index);
        if (!(attribute instanceof Integer)) {
            throw new WrongAttributeTypeException(attrName, thisTypeName);
        }
        int attributeValue = (Integer)attribute;
        ValidateAttributes.intValueRangeCheck(attrName, attributeValue, minValues, maxValues, thisTypeName);
        attributes.removeElementAt(index);
        return attributeValue;
    }

    public static int checkAndGetIntAttribute(AttrList attributes, String attrName, String attrType, int defaultValue, int minValue, int maxValue, String thisTypeName) throws ValueOutOfRangeException, MoNotFoundException, NotHandledAttributeTypeException, AttrMissingAtCreateException, WrongAttributeTypeException, SoftwareErrorException {
        return ValidateAttributes.checkAndGetIntAttribute(attributes, attrName, attrType, defaultValue, new int[]{minValue}, new int[]{maxValue}, thisTypeName);
    }

    public static boolean checkAndGetBooleanAttribute(AttrList attributes, String attrName, String attrType, boolean defaultValue, boolean minValue, boolean maxValue, String thisTypeName) throws ValueOutOfRangeException, MoNotFoundException, NotHandledAttributeTypeException, AttrMissingAtCreateException, WrongAttributeTypeException, SoftwareErrorException {
        if (minValue || !maxValue) {
            throw new SoftwareErrorException();
        }
        int index = attributes.indexOf(attrName);
        if (index == -1) {
            if (attrType.equalsIgnoreCase(MANDATORY)) {
                throw new AttrMissingAtCreateException(attrName, thisTypeName);
            }
            if (attrType.equalsIgnoreCase(OPTIONAL)) {
                return defaultValue;
            }
            throw new SoftwareErrorException();
        }
        Object attribute = attributes.getValue(index);
        if (!(attribute instanceof Boolean)) {
            throw new WrongAttributeTypeException(attrName, thisTypeName);
        }
        boolean attributeValue = (Boolean)attribute;
        attributes.removeElementAt(index);
        return attributeValue;
    }

    public static String checkAndGetStringAttribute(AttrList attributes, String attrName, String attrType, String defaultValue, int minLength, int maxLength, String thisTypeName) throws ValueOutOfRangeException, MoNotFoundException, NotHandledAttributeTypeException, AttrMissingAtCreateException, WrongAttributeTypeException, SoftwareErrorException {
        int index = attributes.indexOf(attrName);
        if (index == -1) {
            if (attrType.equalsIgnoreCase(MANDATORY)) {
                throw new AttrMissingAtCreateException(attrName, thisTypeName);
            }
            if (attrType.equalsIgnoreCase(OPTIONAL)) {
                if (defaultValue.length() < minLength || defaultValue.length() > maxLength) {
                    throw new ValueOutOfRangeException(attrName, thisTypeName);
                }
                return defaultValue;
            }
            throw new SoftwareErrorException();
        }
        Object attribute = attributes.getValue(index);
        if (!(attribute instanceof String)) {
            throw new WrongAttributeTypeException(attrName, thisTypeName);
        }
        String attributeValue = (String)attribute;
        if (attributeValue.length() < minLength || attributeValue.length() > maxLength) {
            throw new ValueOutOfRangeException(attrName, thisTypeName);
        }
        attributes.removeElementAt(index);
        return attributeValue;
    }

    public static ManagedObject checkAndGetReferenceAttribute(String attrName, AttrList attributes, String attrType, String[] refMoTypeNames, String thisTypeName) throws MoAccessException {
        int index = attributes.indexOf(attrName);
        if (index == -1) {
            if (attrType.equalsIgnoreCase(MANDATORY)) {
                throw new AttrMissingAtCreateException(attrName, thisTypeName);
            }
            if (attrType.equalsIgnoreCase(OPTIONAL)) {
                return null;
            }
            throw new SoftwareErrorException();
        }
        Object attribute = attributes.getValue(index);
        if (!(attribute instanceof ManagedObject)) {
            throw new WrongAttributeTypeException(attrName, thisTypeName);
        }
        ManagedObject attributeValue = (ManagedObject)attribute;
        ValidateAttributes.isAcceptedClass(attributeValue, attrName, thisTypeName, refMoTypeNames);
        attributes.removeElementAt(index);
        return attributeValue;
    }

    private static void isAcceptedClass(ManagedObject mo, String attrName, String thisTypeName, String[] refMoTypeNames) throws MoAccessException {
        for (int i = 0; i < refMoTypeNames.length; ++i) {
            if (!mo.getType().equals(refMoTypeNames[i])) continue;
            return;
        }
        throw new WrongAttributeTypeException(attrName, thisTypeName);
    }

    public static Struct checkAndGetStructAttribute(AttrList attributes, String attrName, String attrType, String thisTypeName) throws ValueOutOfRangeException, MoNotFoundException, NotHandledAttributeTypeException, AttrMissingAtCreateException, WrongAttributeTypeException, SoftwareErrorException {
        int index = attributes.indexOf(attrName);
        if (index == -1) {
            if (attrType.equalsIgnoreCase(MANDATORY)) {
                throw new AttrMissingAtCreateException(attrName, thisTypeName);
            }
            if (attrType.equalsIgnoreCase(OPTIONAL)) {
                return new StructImpl(new String[0], new Object[0]);
            }
            throw new SoftwareErrorException();
        }
        Object attribute = attributes.getValue(index);
        if (!(attribute instanceof Struct)) {
            throw new WrongAttributeTypeException(attrName, thisTypeName);
        }
        attributes.removeElementAt(index);
        return (Struct)attribute;
    }

    public static int[] checkAndGetIntSeqAttribute(AttrList attributes, String attrName, String attrType, int[] defaultValues, int[] minValue, int[] maxValue, int intSeqSize, String thisTypeName) throws ValueOutOfRangeException, MoNotFoundException, NotHandledAttributeTypeException, AttrMissingAtCreateException, WrongAttributeTypeException, InternalErrorException, SoftwareErrorException {
        return ValidateAttributes.checkAndGetIntSeqAttribute(attributes, attrName, attrType, defaultValues, minValue, maxValue, intSeqSize, intSeqSize, thisTypeName);
    }

    public static int[] checkAndGetIntSeqAttribute(AttrList attributes, String attrName, String attrType, int[] defaultValues, int minValue, int maxValue, int intSeqSize, String thisTypeName) throws ValueOutOfRangeException, MoNotFoundException, NotHandledAttributeTypeException, AttrMissingAtCreateException, WrongAttributeTypeException, InternalErrorException, SoftwareErrorException {
        return ValidateAttributes.checkAndGetIntSeqAttribute(attributes, attrName, attrType, defaultValues, new int[]{minValue}, new int[]{maxValue}, intSeqSize, intSeqSize, thisTypeName);
    }

    public static int[] checkAndGetIntSeqAttribute(AttrList attributes, String attrName, String attrType, int[] defaultValues, int minValue, int maxValue, int intSeqSize, int defaultSeqSize, String thisTypeName) throws ValueOutOfRangeException, MoNotFoundException, NotHandledAttributeTypeException, AttrMissingAtCreateException, WrongAttributeTypeException, InternalErrorException, SoftwareErrorException {
        return ValidateAttributes.checkAndGetIntSeqAttribute(attributes, attrName, attrType, defaultValues, new int[]{minValue}, new int[]{maxValue}, intSeqSize, defaultSeqSize, thisTypeName);
    }

    private static int[] checkAndGetIntSeqAttribute(AttrList attributes, String attrName, String attrType, int[] defaultValues, int[] minValues, int[] maxValues, int intSeqSize, int defaultSeqSize, String thisTypeName) throws ValueOutOfRangeException, MoNotFoundException, NotHandledAttributeTypeException, AttrMissingAtCreateException, WrongAttributeTypeException, InternalErrorException, SoftwareErrorException {
        int index = attributes.indexOf(attrName);
        if (index == -1) {
            if (attrType.equalsIgnoreCase(MANDATORY)) {
                throw new AttrMissingAtCreateException(attrName, thisTypeName);
            }
            if (attrType.equalsIgnoreCase(OPTIONAL)) {
                if (defaultValues.length != defaultSeqSize) {
                    throw new SoftwareErrorException();
                }
                for (int i = 0; i < defaultValues.length; ++i) {
                    ValidateAttributes.intValueRangeCheck(attrName, defaultValues[i], minValues, maxValues, thisTypeName);
                }
                return (int[])defaultValues.clone();
            }
            throw new SoftwareErrorException();
        }
        if (!(attributes.getValue(index) instanceof int[])) {
            throw new WrongAttributeTypeException(attrName, thisTypeName);
        }
        int[] result2 = (int[])attributes.getValue(index);
        if (result2.length > intSeqSize) {
            throw new ValueOutOfRangeException(attrName, thisTypeName);
        }
        for (int i = 0; i < result2.length; ++i) {
            ValidateAttributes.intValueRangeCheck(attrName, result2[i], minValues, maxValues, thisTypeName);
        }
        attributes.removeElementAt(index);
        return result2;
    }

    public static ManagedObject[] checkandGetRefSeqAttribute(AttrList attributes, String attrName, String attrType, String[] refMoTypeNames, int refSeqSize, String thisTypeName) throws MoAccessException {
        int index = attributes.indexOf(attrName);
        if (index == -1 || ((ManagedObject[])attributes.getValue(index)).length == 0) {
            if (attrType.equalsIgnoreCase(MANDATORY)) {
                throw new AttrMissingAtCreateException(attrName, thisTypeName);
            }
            if (attrType.equalsIgnoreCase(OPTIONAL)) {
                return new ManagedObject[0];
            }
            throw new SoftwareErrorException();
        }
        ManagedObject[] attribute = (ManagedObject[])attributes.getValue(index);
        if (attribute.length > refSeqSize) {
            throw new ValueOutOfRangeException(attrName, thisTypeName);
        }
        Vector<ManagedObject> tmpRefAttribute = new Vector<ManagedObject>(refSeqSize);
        for (int i = 0; i < attribute.length; ++i) {
            if (attribute[i] == null) continue;
            if (!(attribute[i] instanceof ManagedObject)) {
                throw new WrongAttributeTypeException(attrName, thisTypeName);
            }
            ValidateAttributes.isAcceptedClass(attribute[i], attrName, thisTypeName, refMoTypeNames);
            tmpRefAttribute.add(attribute[i]);
        }
        ManagedObject[] tmpAttrs = tmpRefAttribute.toArray(new ManagedObject[tmpRefAttribute.size()]);
        attributes.removeElementAt(index);
        return tmpAttrs;
    }

    public static int[] checkAndGetIntSeqSpecValAttribute(AttrList attributes, String attrName, String attrType, int[] defaultValues, int[] specificValuesOutsideRange, int minValue, int maxValue, int intSeqSize, String thisTypeName) throws ValueOutOfRangeException, MoNotFoundException, NotHandledAttributeTypeException, AttrMissingAtCreateException, WrongAttributeTypeException, SoftwareErrorException {
        int index = attributes.indexOf(attrName);
        if (index == -1) {
            if (attrType.equalsIgnoreCase(MANDATORY)) {
                throw new AttrMissingAtCreateException(attrName, thisTypeName);
            }
            if (attrType.equalsIgnoreCase(OPTIONAL)) {
                for (int i = 0; i < defaultValues.length; ++i) {
                    if (ValidateAttributes.contains(defaultValues[i], specificValuesOutsideRange)) continue;
                    ValidateAttributes.intValueRangeCheck(attrName, defaultValues[i], minValue, maxValue, thisTypeName);
                }
                return (int[])defaultValues.clone();
            }
            throw new SoftwareErrorException();
        }
        if (!(attributes.getValue(index) instanceof int[])) {
            throw new WrongAttributeTypeException(attrName, thisTypeName);
        }
        int[] intSeq = (int[])attributes.getValue(index);
        if (intSeq.length > intSeqSize) {
            throw new ValueOutOfRangeException(attrName, thisTypeName);
        }
        for (int i = 0; i < intSeq.length; ++i) {
            if (ValidateAttributes.contains(intSeq[i], specificValuesOutsideRange)) continue;
            ValidateAttributes.intValueRangeCheck(attrName, intSeq[i], minValue, maxValue, thisTypeName);
        }
        attributes.removeElementAt(index);
        return intSeq;
    }

    private static boolean contains(int value, int[] values) {
        for (int i = 0; i < values.length; ++i) {
            if (value != values[i]) continue;
            return true;
        }
        return false;
    }

    private static boolean contains(String value, String[] values) {
        for (int i = 0; i < values.length; ++i) {
            if (!values[i].equals(value)) continue;
            return true;
        }
        return false;
    }

    public static void checkParent(ManagedObject parent, String typeName, String id) throws MoAccessException {
        if (parent == null) {
            throw new NullParentException(typeName, id);
        }
    }

    public static void checkParent(ManagedObject parent, String parentTypeName) throws MoAccessException {
        if (parent == null || !parent.getType().equals(parentTypeName)) {
            throw new IllegalParentException(parentTypeName);
        }
    }

    public static void checkParent(ManagedObject parent, String[] parentTypeName) throws MoAccessException {
        if (parentTypeName == null || parentTypeName.length == 0) {
            throw new IllegalParentException("parentTypeName is not correct");
        }
        if (parent == null) {
            throw new IllegalParentException("parent is null");
        }
        for (int i = 0; i < parentTypeName.length; ++i) {
            if (!parent.getType().equals(parentTypeName[i])) continue;
            return;
        }
        throw new IllegalParentException("parent isn't expected");
    }

    public static void intValueRangeWithResolutionCheck(String valueName, int value, int[] minValues, int[] maxValues, int resolution, String thisTypeName) throws ValueOutOfRangeException {
        if (minValues.length != 1 || maxValues.length != 1) {
            throw new ValueOutOfRangeException(valueName, thisTypeName);
        }
        ValidateAttributes.intValueRangeCheck(valueName, value, minValues[0], maxValues[0], thisTypeName);
        if (!ValidateAttributes.intValueResolutionCheck(value, minValues[0], resolution)) {
            throw new ValueOutOfRangeException(valueName + " (wrong resolution)", thisTypeName);
        }
    }

    private static boolean intValueResolutionCheck(int value, int minValue, int resolution) {
        return (value - minValue) % resolution == 0;
    }

    public static void checkMaxCardinality(ManagedObject parent, String moTypeName, int maxCardinality) throws MoCanNotBeCreatedException {
        int noOfInstances = 0;
        MoIterator ch = parent.getChildren();
        while (ch.hasMoreElements()) {
            ManagedObject element = (ManagedObject)ch.nextElement();
            if (!element.getType().equalsIgnoreCase(moTypeName)) continue;
            ++noOfInstances;
        }
        if (noOfInstances >= maxCardinality) {
            throw new MoCanNotBeCreatedException(moTypeName);
        }
    }

    public static int intValue(boolean b) {
        return b ? 1 : 0;
    }

    public static class NullParentException
    extends IllegalParentException {
        private static final long serialVersionUID = 5724468842582924728L;

        public NullParentException(String typeName, String id) {
            super(typeName);
            this.addVariableValue("msg", "attempt to create " + typeName + "=" + id + " with null parent");
        }
    }
}

