/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.mao.dmo.auxdevice;

import enea.ose.system.InSignal;
import se.ericsson.cello.equipment.PlugInUnitMo;
import se.ericsson.cello.equipment.SlotMo;
import se.ericsson.cello.equipment.SubrackMaoi;
import se.ericsson.cello.equipment.SubrackMo;
import se.ericsson.cello.faultmanagement.AdditionalInfo;
import se.ericsson.cello.faultmanagement.Event;
import se.ericsson.cello.managedelement.ManagedElementMo;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MibMgr;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.MoNotFoundException;
import se.ericsson.cello.moframework.NotificationSender;
import se.ericsson.cello.moframework.ResourceLockedException;
import se.ericsson.cello.moframework.TransactionRequiredException;
import se.ericsson.cello.moframework.UndeletableMoException;
import se.ericsson.cello.support.sigutil.PortManager;
import se.ericsson.cello.support.sigutil.SignalPort;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.common.AvailabilityStatusIntToEnum;
import se.ericsson.wcdma.rbs.boam.common.FroRequestFailedException;
import se.ericsson.wcdma.rbs.boam.common.MoEventable;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.proxies.EqcBdhIndProxy;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.proxies.EqcDeviceGroupProxy;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EcSetGrpPiuPositionRspS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EqcCreateGroupRspS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EqcGetGroupParametersRspS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EqcGroupEventIndS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EqcGroupHwLogConfigIndS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EqcGroupStartedIndS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EqcTestGroupEndIndS;
import se.ericsson.wcdma.rbs.boam.mao.alarm.MoAlarms;
import se.ericsson.wcdma.rbs.boam.mao.bcm.BoamHelper;
import se.ericsson.wcdma.rbs.boam.mao.bcm.BoamManagedObjectWithAlarms;
import se.ericsson.wcdma.rbs.boam.mao.common.MaoHasFro;
import se.ericsson.wcdma.rbs.boam.mao.common.ValidateAttributes;
import se.ericsson.wcdma.rbs.boam.mao.dmo.common.MoHelper;
import se.ericsson.wcdma.rbs.boam.mao.event.MoEvents;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.excep.AlreadyInitiatedException;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.excep.FunctionNotSupportedException;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.excep.MoNotLockedException;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.excep.OperationFailedException;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.excep.TestBoardDependencyException;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.AuxDeviceGroupMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.AuxDeviceSetMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.AuxPlugInUnitMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.CuSubrackMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.DeviceSetMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.McpaSubrackMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.PowerSupplySubrackMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.RbsSlotMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.RbsSubrackMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.RbsSynchronizationMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.SectorAntennaMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.SectorMo;
import se.ericsson.wcdma.rbs.boam.mao.pnp.PlugAndPlay;

public abstract class AuxDeviceGroupMoImpl
extends BoamManagedObjectWithAlarms
implements AuxDeviceGroupMo,
MoEventable,
MaoHasFro {
    static final int NO_OF_RETRY = 50;
    protected static final int SUP_CLIENT_ID = 0;
    protected static final int CELLO_TRANSACTION_CREATION = 1000;
    public static final String USER_LABEL_NAME = "userLabel";
    public static final String USER_LABEL_DEF_VAL = "";
    public static final int USER_LABEL_MIN_LEN = 0;
    public static final int USER_LABEL_MAX_LEN = 128;
    public static final String USAGE_STATE_NAME = "usageState";
    public static final int USAGE_STATE_DEF_VAL = 0;
    public static final int USAGE_STATE_MIN_VAL = 0;
    public static final int USAGE_STATE_MAX_VAL = 2;
    private static final String IDENTITY = "identity";
    protected static final String AUX_GROUP_FRO_ID = "auxGroupFroId";
    protected static final SignalPort portManager = PortManager.instance();
    protected MoEvents myMoEvents = null;
    public PlugAndPlay myPnP = null;
    protected EqcDeviceGroupProxy eqcDeviceGroupProxy = EqcDeviceGroupProxy.instance();
    protected EqcBdhIndProxy eqcBdhIndProxy = EqcBdhIndProxy.instance();

    public AuxDeviceGroupMoImpl(ManagedObject parent, String thisMoName, String identity, Coordinator context) throws MoAccessException {
        super(parent, thisMoName, identity, context);
        MessageLog.traceEnter(this.getClass(), "Normal constructor");
        this.myData = new MoData(this.getLocalDistinguishedName(), this.getType(), true, context);
        this.bcmStoreAndRegisterStringAttribute(IDENTITY, identity);
        this.bcmStoreAndRegisterIntAttribute("hwTestResult", 3);
    }

    public AuxDeviceGroupMoImpl(ManagedObject parent, String thisMoName, String identity, Coordinator context, int maxNoOfChildren) throws MoAccessException {
        super(parent, thisMoName, identity, context, maxNoOfChildren);
        MessageLog.traceEnter(this.getClass(), "Normal constructor");
        this.myData = new MoData(this.getLocalDistinguishedName(), this.getType(), true, context);
        this.bcmStoreAndRegisterStringAttribute(IDENTITY, identity);
        this.bcmStoreAndRegisterIntAttribute("hwTestResult", 3);
    }

    public AuxDeviceGroupMoImpl(MoData recoveredData) throws MoNameAlreadyTakenException {
        super(recoveredData);
        MessageLog.traceEnter(this.getClass(), "Recovery constructor");
        this.myData = recoveredData;
        IntegerAttribute attribute = (IntegerAttribute)recoveredData.getAttribute("hwTestResult");
        if (attribute != null) {
            attribute.setValue(3);
        } else {
            IntegerAttribute tmpIntegerAttr = new IntegerAttribute("hwTestResult", false);
            tmpIntegerAttr.setValue(3);
            this.myData.registerTransientAttr((Attribute)tmpIntegerAttr);
        }
    }

    public EqcCreateGroupRspS createAuxDeviceGroupResource(ManagedObject mo, int auxGroupType, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "createAuxDeviceGroupResource()");
        MessageLog.trace(1, this.getClass(), "Create auxiliary device group resource with auxGroupType = " + auxGroupType);
        MaoHasFro auxPlugInUnitMo = (MaoHasFro)mo;
        int auxPiuFroId = auxPlugInUnitMo.getFroId(context);
        int slotPosition = this.findSlotPosition(mo.getParent(), context);
        int subrackFroId = this.findSubrackFroId(mo.getParent(), context);
        ManagedObject positionRef = null;
        String boardLDN = mo.getLocalDistinguishedName();
        if (mo instanceof AuxPlugInUnitMo) {
            AuxPlugInUnitMo auxPiu = (AuxPlugInUnitMo)mo;
            positionRef = auxPiu.getPositionRef(context);
        }
        String posRef = USER_LABEL_DEF_VAL;
        if (positionRef != null) {
            posRef = positionRef.getLocalDistinguishedName();
        }
        MessageLog.trace(1, this.getClass(), "auxPiuFroId  =  " + auxPiuFroId + "subrackFroId =  " + subrackFroId + "slotPosition =  " + slotPosition);
        return this.eqcDeviceGroupProxy.createGroup(this.getTxIdTransactional(context), 0L, auxGroupType, auxPiuFroId, subrackFroId, slotPosition, posRef, boardLDN);
    }

    private int findSlotPosition(ManagedObject slot, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "findSlotPosition()");
        int slotPosition = 0;
        if (slot instanceof RbsSlotMo) {
            return ((RbsSlotMo)slot).getSlotPosition(context);
        }
        return slotPosition;
    }

    private int findSubrackFroId(ManagedObject parent, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "findSubrackFroId()");
        int srFroId = 0;
        ManagedObject sr = null;
        sr = parent instanceof RbsSlotMo ? parent.getParent() : parent;
        if (sr instanceof RbsSubrackMo) {
            return ((RbsSubrackMo)sr).getRbsSubrackFroId(context);
        }
        if (sr instanceof McpaSubrackMo) {
            return ((McpaSubrackMo)sr).getMcpaSubrackFroId(context);
        }
        if (sr instanceof CuSubrackMo) {
            return ((CuSubrackMo)sr).getCuSubrackFroId(context);
        }
        if (sr instanceof PowerSupplySubrackMo) {
            return ((PowerSupplySubrackMo)sr).getPowerSupplySubrackFroId(context);
        }
        if (sr instanceof SubrackMaoi) {
            return ((SubrackMaoi)sr).getResourceId(context);
        }
        if (sr instanceof SectorAntennaMo) {
            return this.getSectorMoRef((SectorAntennaMo)sr, context).getSectorFroId(context);
        }
        return srFroId;
    }

    private SectorMo getSectorMoRef(SectorAntennaMo sr, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getSectorMoRef() ");
        ManagedObject[] reservers = sr.getReservedBy(context);
        for (int i = 0; i < reservers.length; ++i) {
            if (!reservers[i].getType().equals("Sector")) continue;
            return (SectorMo)reservers[i];
        }
        throw new MoNotFoundException("no Sector refers to: " + this);
    }

    public void delete(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "delete()");
        ValidateAttributes.checkTransaction(context);
        if (this.isReserved(context)) {
            throw new UndeletableMoException((ManagedObject)this);
        }
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
        MoIterator iter = this.getChildren();
        while (iter.hasMoreElements()) {
            ManagedObject child = iter.nextMo();
            if (child instanceof AuxDeviceSetMo) {
                AuxDeviceSetMo auxDevSetMo = (AuxDeviceSetMo)child;
                MessageLog.trace(1, this.getClass(), "deleting (AuxDeviceSet) child : " + child.getFullDistinguishedName());
                auxDevSetMo.sysDelete(context);
                continue;
            }
            if (child instanceof DeviceSetMo) {
                DeviceSetMo devSetMo = (DeviceSetMo)child;
                MessageLog.trace(1, this.getClass(), "deleting (DeviceSet) child : " + child.getFullDistinguishedName());
                devSetMo.sysDelete(context);
                continue;
            }
            MessageLog.trace(1, this.getClass(), "deleting child : " + child.getFullDistinguishedName());
            child.delete(context);
        }
        this.eqcDeviceGroupProxy.deleteGroup(this.getTxIdTransactional(context), 0L, this.getAuxGroupFroId(context));
        this.removeObservers(context);
        super.delete(context);
    }

    public String getIdentity(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getIdentity()");
        return this.getNamingAttributeValue();
    }

    public String getUserLabel(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getUserLabel() ");
        return this.bcmGetStringAttribute(USER_LABEL_NAME, context);
    }

    public void setUserLabel(String value, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setUserLabel() ");
        this.bcmSetStringAttribute(USER_LABEL_NAME, value, 0, 128, this.getType(), context);
        this.sendAVC(USER_LABEL_NAME, value, context);
    }

    public int getUsageState(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getUsageState()");
        EqcGetGroupParametersRspS rspSig = this.eqcDeviceGroupProxy.getGroupParameters(this.getTxIdNonTransactional(context), 0L, this.getAuxGroupFroId(context));
        return rspSig.usageState;
    }

    public int getOperationalState(Coordinator context) throws MoAccessException, TransactionRequiredException, ResourceLockedException {
        MessageLog.traceEnter(this.getClass(), "getOperationalState()");
        EqcGetGroupParametersRspS rspSig = this.eqcDeviceGroupProxy.getGroupParameters(this.getTxIdNonTransactional(context), 0L, this.getAuxGroupFroId(context));
        return rspSig.opState;
    }

    public int getAvailabilityStatus(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getAvailabilityStatus()");
        EqcGetGroupParametersRspS rspSig = this.eqcDeviceGroupProxy.getGroupParameters(this.getTxIdNonTransactional(context), 0L, this.getAuxGroupFroId(context));
        return AvailabilityStatusIntToEnum.convGetAvailStatIntToEnum(rspSig.availStatus);
    }

    public int getAuxPiuFroId(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getAuxPiuFroId()");
        return ((AuxPlugInUnitMo)this.getParent()).getAuxPlugInUnitFroId(context);
    }

    public int getAuxGroupFroId(Coordinator context) {
        MessageLog.traceEnter(this.getClass(), "getAuxGroupFroId()");
        IntegerAttribute attribute = (IntegerAttribute)this.myData.getAttribute(AUX_GROUP_FRO_ID);
        return attribute.getValue(context);
    }

    public int getFroId(Coordinator context) {
        MessageLog.traceEnter(this.getClass(), "getFroId()");
        return this.getAuxGroupFroId(context);
    }

    public MoData getMyMoData() {
        MessageLog.traceEnter(this.getClass(), "getMyMoData()");
        return this.myData;
    }

    public boolean isMyMoDataPersistent() {
        MessageLog.traceEnter(this.getClass(), "isMyMoDataPersistent()");
        return true;
    }

    public void actionStartHwTest(String testId, Coordinator context) throws MoAccessException, AlreadyInitiatedException, MoNotLockedException, OperationFailedException, FunctionNotSupportedException, TestBoardDependencyException {
        MessageLog.traceEnter(this.getClass(), "actionStartHwTest()");
        ValidateAttributes.stringValueRangeCheck("actionStartHwTest::testId", testId, 31, this.getType());
        int auxGroupFroId = this.getAuxGroupFroId(context);
        this.boardDependencyCheckUc1Fs6(context);
        try {
            this.eqcDeviceGroupProxy.startDeviceGroupHwTest(0L, auxGroupFroId, testId);
        }
        catch (FroRequestFailedException e) {
            if (e.getOrgErrorCode() == 9) {
                throw new MoNotLockedException();
            }
            if (e.getOrgErrorCode() == 13) {
                this.updateHwTestResult(2);
                throw new AlreadyInitiatedException();
            }
            if (e.getOrgErrorCode() == 39) {
                this.updateHwTestResult(3);
                throw new TestBoardDependencyException();
            }
            if (e.getOrgErrorCode() == 25) {
                throw new FunctionNotSupportedException();
            }
            this.updateHwTestResult(3);
            throw new OperationFailedException();
        }
        this.updateHwTestResult(2);
    }

    public void eventRaised(InSignal eventInd) {
        MessageLog.traceEnter(this.getClass(), "eventRaised()");
        String objectClass = this.getType();
        String managedObjectInstance = this.getFullDistinguishedName();
        String eventType = "0";
        String eventTime = USER_LABEL_DEF_VAL;
        int auxGroupFroId = this.getAuxGroupFroId(null);
        if (eventInd instanceof EqcGroupEventIndS) {
            MessageLog.trace(6, this.getClass(), "EqcGroupEventIndS received");
            EqcGroupEventIndS recSig = (EqcGroupEventIndS)eventInd;
            String specificEvent = USER_LABEL_DEF_VAL;
            int eventIs = recSig.groupEventType;
            if (eventIs == 49153) {
                specificEvent = this.getType() + "_SuccessfulRecoveryActionPerformedBoardRestart";
                MessageLog.trace(6, this.getClass(), " " + specificEvent);
            } else if (eventIs == 49154) {
                specificEvent = this.getType() + "_SuccessfulRecoveryActionPerformedWarmReset";
                MessageLog.trace(6, this.getClass(), " " + specificEvent);
            } else if (eventIs == 49157) {
                specificEvent = this.getType() + "_SuccessfulRecoveryActionPerformedSwitchedClockSource";
                MessageLog.trace(6, this.getClass(), " " + specificEvent);
            } else if (eventIs == 49156) {
                specificEvent = this.getType() + "_SuccessfulRecoveryActionPerformedReestablishLink";
                MessageLog.trace(6, this.getClass(), " " + specificEvent);
            } else if (eventIs == 49158) {
                specificEvent = this.getType() + "_PreloadFailed";
                MessageLog.trace(6, this.getClass(), " " + specificEvent);
            } else {
                specificEvent = this.checkSpecificEvent(eventIs);
                if (null == specificEvent) {
                    MessageLog.traceError(this.getClass(), "Unknown event received");
                    return;
                }
                MessageLog.trace(6, this.getClass(), " " + specificEvent);
            }
            String additionalText = this.bcmGetMEUserLabel();
            new Event(objectClass, managedObjectInstance, eventType, eventTime, specificEvent, additionalText, null);
            MessageLog.trace(6, this.getClass(), "Event raised MO = " + objectClass + " " + "eventType = " + eventType + " " + "specificEvent = " + specificEvent);
        } else if (eventInd instanceof EqcTestGroupEndIndS) {
            MessageLog.trace(6, this.getClass(), "EqcTestGroupEndIndS received");
            EqcTestGroupEndIndS recSig = (EqcTestGroupEndIndS)eventInd;
            if ((long)auxGroupFroId == recSig.groupFroId) {
                try {
                    String specificEvent = this.getType() + "_HardwareTestEndIndication";
                    String additionalText = recSig.testId.name;
                    AdditionalInfo[] InfoList = new AdditionalInfo[4];
                    this.updateTestResult(InfoList, recSig);
                    new Event(objectClass, managedObjectInstance, eventType, eventTime, specificEvent, additionalText, InfoList);
                    this.updateHwTestResult(recSig.testResult);
                }
                catch (MoAccessException e) {
                    MessageLog.trace(6, this.getClass(), "Can not update HW Test Result.");
                }
            }
        } else if (eventInd instanceof EqcGroupStartedIndS) {
            try {
                if ((long)this.getFroId(null) == ((EqcGroupStartedIndS)eventInd).groupFroId) {
                    this.updateHwLogSiteConfig();
                }
            }
            catch (MoAccessException e) {
                MessageLog.trace(6, this.getClass(), "Update HW Log rejected");
            }
        } else if (eventInd instanceof EqcGroupHwLogConfigIndS) {
            try {
                if ((long)this.getFroId(null) == ((EqcGroupHwLogConfigIndS)eventInd).groupFroId) {
                    MoHelper.updateHwLogConfig(this.getFroId(null), 0, (ManagedObject)this);
                }
            }
            catch (MoAccessException e) {
                MessageLog.trace(6, this.getClass(), "Update HW Log rejected");
            }
        }
    }

    private void updateHwLogSiteConfig() throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "updateHwLogSiteConfig()");
        long logId = 0L;
        AuxPlugInUnitMo piuMo = (AuxPlugInUnitMo)this.getParent();
        ManagedObject mo = piuMo.getParent();
        ManagedElementMo rootmo = (ManagedElementMo)MibMgr.instance().getMib().getRootMo();
        String rbstype = rootmo.getProductName(null);
        String logName = rootmo.getLogicalName(null);
        String freeText = rbstype + ";" + "Site " + logName + ";" + "subrack " + piuMo.getSubrackId(null) + ";";
        freeText = mo instanceof RbsSlotMo ? freeText + "slot " + ((RbsSlotMo)mo).getSlotPosition(null) : freeText + "slot N/A";
        this.eqcDeviceGroupProxy.updateGroupHwLog(0L, this.getFroId(null), 0L, freeText);
    }

    private void checkRfifStateNonDuvBased(Coordinator context) throws MoAccessException {
        if ("TrxDeviceGroup".equalsIgnoreCase(this.getType())) {
            ManagedElementMo me = (ManagedElementMo)MibMgr.instance().getMib().getRootMo();
            String rbsType = me.getProductName(context);
            SlotMo slotMo = (SlotMo)AuxDeviceGroupMoImpl.getAncestor((ManagedObject)this, "Slot");
            SlotMo slotMoNr2 = null;
            SlotMo slotMoNr3 = null;
            ManagedObject rfifMo = null;
            SubrackMo srMo = (SubrackMo)AuxDeviceGroupMoImpl.getAncestor((ManagedObject)slotMo, "Subrack");
            MoIterator moIter = BoamHelper.findMOs("Slot", (ManagedObject)srMo, 1);
            while (moIter.hasMoreElements() && slotMoNr2 == null && slotMoNr3 == null) {
                SlotMo element = (SlotMo)moIter.nextMo();
                if (2 == element.getSlotNumber(context)) {
                    slotMoNr2 = element;
                    continue;
                }
                if (3 != element.getSlotNumber(context)) continue;
                slotMoNr3 = element;
            }
            int trxSlotNo = slotMo.getSlotNumber(context);
            if ("3101".equalsIgnoreCase(rbsType) || "3202".equalsIgnoreCase(rbsType)) {
                if (trxSlotNo == 4 || trxSlotNo == 7 || trxSlotNo == 10) {
                    rfifMo = BoamHelper.getFirstMatchingMo(slotMoNr2, "RfifDeviceGroup");
                } else if (trxSlotNo == 5 || trxSlotNo == 8 || trxSlotNo == 11) {
                    rfifMo = BoamHelper.getFirstMatchingMo((ManagedObject)slotMoNr3, "RfifDeviceGroup");
                }
            } else if ("3103".equalsIgnoreCase(rbsType) || "3104".equalsIgnoreCase(rbsType)) {
                rfifMo = BoamHelper.getFirstMatchingMo("RfifDeviceGroup");
            }
            if (rfifMo != null && !this.checkRefState(rfifMo, context)) {
                MessageLog.trace(2, this.getClass(), "startHwTest refused: The Rfif must be unlocked and enabled !!rfifMo:" + rfifMo.getLocalDistinguishedName());
                throw new TestBoardDependencyException("startHwTest refused: The Rfif must be unlocked and enabled !!rfifMo:" + rfifMo.getLocalDistinguishedName());
            }
        }
    }

    private void boardDependencyCheckUc1Fs6(Coordinator context) throws MoAccessException, TestBoardDependencyException {
        RbsSynchronizationMo rbsSync;
        MessageLog.trace(2, this.getClass(), "boardDependencyCheckUc1Fs6DuvBased(),Start precondition 1");
        if (this.getHwTestResult(context) == 2) {
            MessageLog.trace(2, this.getClass(), "startHwTest refused: The test is already initiated!!");
            throw new AlreadyInitiatedException();
        }
        MessageLog.trace(2, this.getClass(), "boardDependencyCheckUc1Fs6DuvBased(),Start precondition 2");
        AuxPlugInUnitMo parent = (AuxPlugInUnitMo)this.getParent();
        boolean dependCheckPassed = false;
        ManagedObject mo1 = parent.getPlugInUnitRef1(context);
        ManagedObject mo2 = parent.getPlugInUnitRef2(context);
        dependCheckPassed = this.checkRefState(mo1, context);
        if (mo2 != null && !dependCheckPassed) {
            dependCheckPassed = this.checkRefState(mo2, context);
        }
        if (!dependCheckPassed) {
            MessageLog.trace(2, this.getClass(), "startHwTest refused: precondition on referred PIUs (piuRef1/piuRef2) not met. At least one of the PIUs with the ATF must be unlocked/enabled!!");
            throw new TestBoardDependencyException("startHwTest refused: precondition on referred PIUs (piuRef1/piuRef2) not met. At least one of the PIUs with the ATF must be unlocked/enabled!!");
        }
        MessageLog.trace(2, this.getClass(), "boardDependencyCheckUc1Fs6DuvBased(),Start precondition 3");
        String typeName = this.getType();
        if (("TxDeviceGroup".equalsIgnoreCase(typeName) || "RaxDeviceGroup".equalsIgnoreCase(typeName) || "RfifDeviceGroup".equalsIgnoreCase(typeName) || "TrxDeviceGroup".equalsIgnoreCase(typeName) || "AiuDeviceGroup".equalsIgnoreCase(typeName) || "RuDeviceGroup".equalsIgnoreCase(typeName) || "RruDeviceGroup".equalsIgnoreCase(typeName) || "ObifDeviceGroup".equalsIgnoreCase(typeName)) && !(rbsSync = (RbsSynchronizationMo)BoamHelper.getFirstMatchingMo("RbsSynchronization")).getNodeIsSynchronized(context) && !rbsSync.getNodeIsStable(context)) {
            MessageLog.trace(2, this.getClass(), "startHwTest refused: The base band clock must be distributed. Attribute NodeIsSynchronized or NodeIsStable on the RbsSynchronizationMo must be true! !!");
            throw new TestBoardDependencyException("startHwTest refused: The base band clock must be distributed. Attribute NodeIsSynchronized or NodeIsStable on the RbsSynchronizationMo must be true! !!");
        }
        MessageLog.trace(2, this.getClass(), "boardDependencyCheckUc1Fs6DuvBased(),Start precondition 5");
        this.checkRfifStateNonDuvBased(context);
        MessageLog.trace(2, this.getClass(), "boardDependencyCheckUc1Fs6DuvBased(),Start precondition 6");
        if ("AscDeviceGroup".equalsIgnoreCase(typeName) || "RetuDeviceGroup".equalsIgnoreCase(typeName)) {
            if (!MoHelper.checkMosOpState("SaiuDeviceGroup", context)) {
                MessageLog.trace(2, this.getClass(), "startHwTest refused: The sAIU of all instances must be enabled !!");
                throw new TestBoardDependencyException("startHwTest refused: The sAIU of all instances must be enabled !!");
            }
            if (!MoHelper.checkMosOpState("AiuDeviceGroup", context)) {
                MessageLog.trace(2, this.getClass(), "startHwTest refused: The AIU of all instances must be enabled !!");
                throw new TestBoardDependencyException("startHwTest refused: The AIU of all instances must be enabled !!");
            }
            if (!MoHelper.checkMosOpState("RuDeviceGroup", context)) {
                MessageLog.trace(2, this.getClass(), "startHwTest refused: The RU of all instances must be enabled !!");
                throw new TestBoardDependencyException("startHwTest refused: The RU of all instances must be enabled !!");
            }
            if (!MoHelper.checkMosOpState("FuDeviceGroup", context)) {
                MessageLog.trace(2, this.getClass(), "startHwTest refused: The FU of all instances must be enabled !!");
                throw new TestBoardDependencyException("startHwTest refused: The FU of all instances must be enabled !!");
            }
        }
    }

    private boolean checkRefState(ManagedObject moRef, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "checkRefState()");
        if (moRef instanceof PlugInUnitMo) {
            PlugInUnitMo piu = (PlugInUnitMo)moRef;
            MessageLog.trace(2, this.getClass(), "Instance of PlugInUnitMo" + moRef + " with OperationalState: " + piu.getOperationalState(context) + " and administrativeState " + piu.getAdministrativeState(context));
            if (piu.getOperationalState(context) == 1 && piu.getAdministrativeState(context) == 1) {
                return true;
            }
        } else if (moRef instanceof AuxPlugInUnitMo) {
            AuxPlugInUnitMo auxPiu = (AuxPlugInUnitMo)moRef;
            MessageLog.trace(2, this.getClass(), "Instance of AuxPlugInUnitMo" + moRef + " with OperationalState: " + auxPiu.getOperationalState(context) + " and administrativeState " + auxPiu.getAdministrativeState(context));
            if (auxPiu.getOperationalState(context) == 1 && auxPiu.getAdministrativeState(context) == 1) {
                return true;
            }
        }
        return false;
    }

    public void startupAuxDevGr(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "startupAuxDevGr()");
        this.eqcDeviceGroupProxy.startupGroup(0L, this.getAuxGroupFroId(context));
        MessageLog.trace(4, this.getClass(), "startupAuxDevGr executed ");
    }

    public void updateHwTestResult(int newResult) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "updateHwTestResult()");
        IntegerAttribute intAttribute = (IntegerAttribute)this.myData.getAttribute("hwTestResult");
        intAttribute.setValue(newResult);
        String[] attrArr = new String[]{"hwTestResult"};
        Object[] valArr = new Object[]{new Integer(newResult)};
        NotificationSender.instance().pushAVC((ManagedObject)this, attrArr, valArr);
    }

    protected void updateTestResult(AdditionalInfo[] infoList, EqcTestGroupEndIndS recSig) throws MoAccessException {
        if (recSig.testResult == 2) {
            recSig.testResult = 3;
        }
        switch (recSig.testResult) {
            case 0: {
                infoList[0] = new AdditionalInfo("Result", "Passed");
                break;
            }
            case 1: {
                infoList[0] = new AdditionalInfo("Result", "Failed");
                break;
            }
            case 3: {
                infoList[0] = new AdditionalInfo("Result", "Undetermined");
                break;
            }
            case 2: {
                infoList[0] = new AdditionalInfo("Result", "Pending");
                break;
            }
            default: {
                infoList[0] = new AdditionalInfo("Result", "Unknown");
            }
        }
        infoList[1] = new AdditionalInfo("Test Time", Integer.toString(recSig.testTime == 0 ? 1 : recSig.testTime) + " sec");
        infoList[2] = new AdditionalInfo("Start Test Time", recSig.startTestTime);
        infoList[3] = new AdditionalInfo("Stop Test Time", recSig.stopTestTime);
    }

    public int getHwTestResult(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getHwTestResult()");
        this.myData.handleTransaction(context, MoData.READ_ACCESS);
        IntegerAttribute attribute = (IntegerAttribute)this.myData.getAttribute("hwTestResult");
        int result2 = attribute.getValue(context);
        return result2;
    }

    protected void addObservers(int froType, Coordinator context) throws MoAccessException {
        this.myMoAlarms = new MoAlarms((ManagedObject)this, this.eqcBdhIndProxy, froType, this.getFroId(context), context);
        this.myMoEvents = new MoEvents(this, this.eqcBdhIndProxy, this.getFroId(context), context);
        this.myPnP = new PlugAndPlay((ManagedObject)this, this.eqcBdhIndProxy, this.getFroId(context), context);
    }

    protected void removeObservers(Coordinator context) throws MoAccessException {
        this.myMoAlarms.delete(context);
        this.myMoEvents.delete(context);
        this.myPnP.delete(context);
    }

    public String checkSpecificEvent(int eventType) {
        return null;
    }

    public EcSetGrpPiuPositionRspS setGrpPiuPositionReq(String positionRef, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(AuxDeviceGroupMoImpl.class, "setGrpPiuPositionReq()");
        AuxDeviceGroupMoImpl.checkTransaction(context);
        EcSetGrpPiuPositionRspS rsp = null;
        int groupFroId = this.getFroId(context);
        rsp = this.eqcDeviceGroupProxy.setGrpPiuPositionReq(this.getTxIdTransactional(context), 0L, groupFroId, positionRef);
        return rsp;
    }
}

