/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.mao.dmo.auxdevice;

import se.ericsson.cello.commandlog.logcontentcontrol.InspectorMgr;
import se.ericsson.cello.commandlog.logcontentcontrol.LogContentInspector;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoCanNotBeCreatedException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoFactory;
import se.ericsson.cello.moframework.MoFactoryMgr;
import se.ericsson.cello.moframework.MoFilter;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.MoRepository;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.RbsDeviceFroInfoT;
import se.ericsson.wcdma.rbs.boam.mao.bcm.BoamManagedObjectWithAlarms;
import se.ericsson.wcdma.rbs.boam.mao.dmo.alarm.AlmDeviceMoImpl;
import se.ericsson.wcdma.rbs.boam.mao.dmo.auxdevice.AuxDeviceMoFilter;
import se.ericsson.wcdma.rbs.boam.mao.dmo.auxdevice.AuxDeviceMoImpl;
import se.ericsson.wcdma.rbs.boam.mao.dmo.auxdevice.AuxDeviceSetMoFilter;
import se.ericsson.wcdma.rbs.boam.mao.dmo.auxdevice.AuxDeviceSetMoImpl;
import se.ericsson.wcdma.rbs.boam.mao.dmo.auxdevice.OutDeviceMoImpl;
import se.ericsson.wcdma.rbs.boam.mao.dmo.climate.ClDeviceMoImpl;
import se.ericsson.wcdma.rbs.boam.mao.dmo.power.AcDeviceMoImpl;
import se.ericsson.wcdma.rbs.boam.mao.dmo.power.BfDeviceMoImpl;
import se.ericsson.wcdma.rbs.boam.mao.dmo.power.PdDeviceMoImpl;
import se.ericsson.wcdma.rbs.boam.mao.dmo.power.PsDeviceMoImpl;
import se.ericsson.wcdma.rbs.boam.mao.dmo.tr.AiDeviceMoImpl;
import se.ericsson.wcdma.rbs.boam.mao.dmo.tr.RetDeviceMoImpl;
import se.ericsson.wcdma.rbs.boam.mao.dmo.tr.TmaDeviceMoImpl;
import se.ericsson.wcdma.rbs.boam.mao.dmo.tr.TpaDeviceMoImpl;

public class AuxDeviceMoFactory
implements MoFactory,
LogContentInspector {
    private static final Class SELF = AuxDeviceMoFactory.class;
    private static AuxDeviceMoFactory tpaInstance;
    private static AuxDeviceMoFactory bfInstance;
    private static AuxDeviceMoFactory acInstance;
    private static AuxDeviceMoFactory clInstance;
    private static AuxDeviceMoFactory tmaInstance;
    private static AuxDeviceMoFactory psInstance;
    private static AuxDeviceMoFactory pdInstance;
    private static AuxDeviceMoFactory xalmInstance;
    private static AuxDeviceMoFactory outInstance;
    private static AuxDeviceMoFactory retInstance;
    private static AuxDeviceMoFactory aiInstance;
    private static final int MAX_DEPTH = 10;
    private int eqcDeviceType = 0;

    private AuxDeviceMoFactory(int deviceType) {
        MessageLog.traceEnter(SELF, "auxDeviceMoFactory normal constructor, deviceType = " + deviceType);
        this.eqcDeviceType = deviceType;
        MoFactoryMgr.instance().register((MoFactory)this, this.getMoTypeName());
        InspectorMgr.instance().register((LogContentInspector)this, this.getMoTypeName());
    }

    public static synchronized AuxDeviceMoFactory instance(int deviceType) {
        AuxDeviceMoFactory instance;
        switch (deviceType) {
            case 8: {
                if (tpaInstance == null) {
                    tpaInstance = new AuxDeviceMoFactory(deviceType);
                }
                instance = tpaInstance;
                break;
            }
            case 10: {
                if (bfInstance == null) {
                    bfInstance = new AuxDeviceMoFactory(deviceType);
                }
                instance = bfInstance;
                break;
            }
            case 11: {
                if (acInstance == null) {
                    acInstance = new AuxDeviceMoFactory(deviceType);
                }
                instance = acInstance;
                break;
            }
            case 12: {
                if (clInstance == null) {
                    clInstance = new AuxDeviceMoFactory(deviceType);
                }
                instance = clInstance;
                break;
            }
            case 14: {
                if (tmaInstance == null) {
                    tmaInstance = new AuxDeviceMoFactory(deviceType);
                }
                instance = tmaInstance;
                break;
            }
            case 9: {
                if (psInstance == null) {
                    psInstance = new AuxDeviceMoFactory(deviceType);
                }
                instance = psInstance;
                break;
            }
            case 13: {
                if (pdInstance == null) {
                    pdInstance = new AuxDeviceMoFactory(deviceType);
                }
                instance = pdInstance;
                break;
            }
            case 15: {
                if (xalmInstance == null) {
                    xalmInstance = new AuxDeviceMoFactory(deviceType);
                }
                instance = xalmInstance;
                break;
            }
            case 16: {
                if (outInstance == null) {
                    outInstance = new AuxDeviceMoFactory(deviceType);
                }
                instance = outInstance;
                break;
            }
            case 17: {
                if (retInstance == null) {
                    retInstance = new AuxDeviceMoFactory(deviceType);
                }
                instance = retInstance;
                break;
            }
            case 7: {
                if (aiInstance == null) {
                    aiInstance = new AuxDeviceMoFactory(deviceType);
                }
                instance = aiInstance;
                break;
            }
            default: {
                instance = null;
            }
        }
        return instance;
    }

    public void createDeviceMo(ManagedObject parentDevSetMo, RbsDeviceFroInfoT deviceFroInfo, String identity, String userLabel, Coordinator context) throws MoAccessException {
        MessageLog.trace(1, SELF, "Creating DeviceMo with identity = " + identity);
        MessageLog.trace(1, SELF, "Creating DeviceMo with deviceFroId = " + deviceFroInfo.deviceFroId);
        this.createTheMo(parentDevSetMo, (int)deviceFroInfo.deviceFroId, identity, userLabel, context);
    }

    public ManagedObject createMo(ManagedObject parent, AttrList attributes, String identity, ManagedObject source, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(SELF, "createMo()");
        String msg = "Device MOs cannot be created over Mub";
        throw new MoCanNotBeCreatedException(msg);
    }

    public ManagedObject createTheMo(ManagedObject parent, int deviceFroId, String identity, String userLabel, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(SELF, "createTheMo()");
        BoamManagedObjectWithAlarms mo = null;
        switch (this.eqcDeviceType) {
            case 8: {
                MessageLog.trace(1, SELF, "Device Set MO  To be Created eqcDeviceType = " + this.eqcDeviceType);
                MessageLog.trace(1, SELF, "Device Set MO  To be Created RbsTypes.RBS_TPA_DEV = 8");
                mo = new TpaDeviceMoImpl(parent, this.getMoTypeName(), deviceFroId, identity, userLabel, context);
                MessageLog.trace(1, SELF, "Device MO Created");
                break;
            }
            case 10: {
                MessageLog.trace(1, SELF, "Device Set MO  To be Created eqcDeviceType = " + this.eqcDeviceType);
                MessageLog.trace(1, SELF, "Device Set MO  To be Created RbsTypes.RBS_BF_DEV = 10");
                mo = new BfDeviceMoImpl(parent, this.getMoTypeName(), deviceFroId, identity, userLabel, context);
                MessageLog.trace(1, SELF, "Device MO Created");
                break;
            }
            case 11: {
                MessageLog.trace(1, SELF, "Device Set MO  To be Created eqcDeviceType = " + this.eqcDeviceType);
                MessageLog.trace(1, SELF, "Device Set MO  To be Created RbsTypes.RBS_AC_DEV = 11");
                mo = new AcDeviceMoImpl(parent, this.getMoTypeName(), deviceFroId, identity, userLabel, context);
                MessageLog.trace(1, SELF, "Device MO Created");
                break;
            }
            case 12: {
                MessageLog.trace(1, SELF, "Device Set MO  To be Created eqcDeviceType = " + this.eqcDeviceType);
                MessageLog.trace(1, SELF, "Device Set MO  To be Created RbsTypes.RBS_CL_DEV = 12");
                mo = new ClDeviceMoImpl(parent, this.getMoTypeName(), deviceFroId, identity, userLabel, context);
                MessageLog.trace(1, SELF, "Device MO Created");
                break;
            }
            case 14: {
                MessageLog.trace(1, SELF, "Device Set MO  To be Created eqcDeviceType = " + this.eqcDeviceType);
                MessageLog.trace(1, SELF, "Device Set MO  To be Created RbsTypes.RBS_TMA_DEV = 14");
                mo = new TmaDeviceMoImpl(parent, this.getMoTypeName(), deviceFroId, identity, userLabel, context);
                MessageLog.trace(1, SELF, "Device MO Created");
                break;
            }
            case 9: {
                MessageLog.trace(1, SELF, "Device Set MO  To be Created eqcDeviceType = " + this.eqcDeviceType);
                MessageLog.trace(1, SELF, "Device Set MO  To be Created RbsTypes.RBS_PS_DEV = 9");
                mo = new PsDeviceMoImpl(parent, this.getMoTypeName(), deviceFroId, identity, userLabel, context);
                MessageLog.trace(1, SELF, "Device MO Created");
                break;
            }
            case 13: {
                MessageLog.trace(1, SELF, "Device Set MO  To be Created eqcDeviceType = " + this.eqcDeviceType);
                MessageLog.trace(1, SELF, "Device Set MO  To be Created RbsTypes.RBS_PD_DEV = 13");
                mo = new PdDeviceMoImpl(parent, this.getMoTypeName(), deviceFroId, identity, userLabel, context);
                MessageLog.trace(1, SELF, "Device MO Created");
                break;
            }
            case 15: {
                MessageLog.trace(1, SELF, "Device Set MO  To be Created eqcDeviceType = " + this.eqcDeviceType);
                MessageLog.trace(1, SELF, "Device Set MO  To be Created RbsTypes.RBS_ALM_DEV = 15");
                mo = new AlmDeviceMoImpl(parent, this.getMoTypeName(), deviceFroId, identity, userLabel, context);
                MessageLog.trace(1, SELF, "Device MO Created");
                break;
            }
            case 16: {
                MessageLog.trace(1, SELF, "Device Set MO  To be Created eqcDeviceType = " + this.eqcDeviceType);
                MessageLog.trace(1, SELF, "Device Set MO  To be Created RbsTypes.RBS_OUT_DEV = 16");
                mo = new OutDeviceMoImpl(parent, this.getMoTypeName(), deviceFroId, identity, userLabel, context);
                MessageLog.trace(1, SELF, "Device MO Created");
                break;
            }
            case 17: {
                MessageLog.trace(1, SELF, "Device Set MO  To be Created eqcDeviceType = " + this.eqcDeviceType);
                MessageLog.trace(1, SELF, "Device Set MO  To be Created RbsTypes.RBS_RET_DEV = 17");
                mo = new RetDeviceMoImpl(parent, this.getMoTypeName(), deviceFroId, identity, userLabel, context);
                MessageLog.trace(1, SELF, "Device MO Created");
                break;
            }
            case 7: {
                MessageLog.trace(1, SELF, "Device Set MO  To be Created eqcDeviceType = " + this.eqcDeviceType);
                MessageLog.trace(1, SELF, "Device Set MO  To be Created RbsTypes.RBS_AI_DEV = 7");
                mo = new AiDeviceMoImpl(parent, this.getMoTypeName(), deviceFroId, identity, userLabel, context);
                MessageLog.trace(1, SELF, "Device MO Created");
                break;
            }
            default: {
                MessageLog.traceError(SELF, "Software Error in BOAM, illegal device type");
            }
        }
        MessageLog.trace(1, SELF, "createTheMo() return");
        return mo;
    }

    public ManagedObject recoverMo(MoData recoveredData) throws MoNameAlreadyTakenException {
        MessageLog.traceEnter(SELF, "recoverMo for auxiliary device type : " + this.eqcDeviceType);
        BoamManagedObjectWithAlarms mo = null;
        switch (this.eqcDeviceType) {
            case 8: {
                mo = new TpaDeviceMoImpl(recoveredData);
                break;
            }
            case 10: {
                mo = new BfDeviceMoImpl(recoveredData);
                break;
            }
            case 11: {
                mo = new AcDeviceMoImpl(recoveredData);
                break;
            }
            case 12: {
                mo = new ClDeviceMoImpl(recoveredData);
                break;
            }
            case 14: {
                mo = new TmaDeviceMoImpl(recoveredData);
                break;
            }
            case 9: {
                mo = new PsDeviceMoImpl(recoveredData);
                break;
            }
            case 13: {
                mo = new PdDeviceMoImpl(recoveredData);
                break;
            }
            case 15: {
                mo = new AlmDeviceMoImpl(recoveredData);
                break;
            }
            case 16: {
                mo = new OutDeviceMoImpl(recoveredData);
                break;
            }
            case 17: {
                mo = new RetDeviceMoImpl(recoveredData);
                break;
            }
            case 7: {
                mo = new AiDeviceMoImpl(recoveredData);
                break;
            }
            default: {
                MessageLog.traceError(SELF, "Software Error in BOAM, illegal device type");
            }
        }
        return mo;
    }

    public String getMoTypeName() {
        String name = "";
        switch (this.eqcDeviceType) {
            case 8: {
                name = "TpaDevice";
                break;
            }
            case 10: {
                name = "BfDevice";
                break;
            }
            case 11: {
                name = "AcDevice";
                break;
            }
            case 12: {
                name = "ClDevice";
                break;
            }
            case 14: {
                name = "TmaDevice";
                break;
            }
            case 9: {
                name = "PsDevice";
                break;
            }
            case 13: {
                name = "PdDevice";
                break;
            }
            case 15: {
                name = "AlmDevice";
                break;
            }
            case 16: {
                name = "OutDevice";
                break;
            }
            case 17: {
                name = "RetDevice";
                break;
            }
            case 7: {
                name = "AiDevice";
                break;
            }
            default: {
                MessageLog.traceError(SELF, "Software Error in BOAM, illegal device type");
                name = "UnknownDevice";
            }
        }
        return name;
    }

    public AuxDeviceSetMoImpl findDeviceSetMo(AuxDeviceSetMoFilter filter, ManagedObject root) {
        MoIterator moIter = MoRepository.instance().select(root, 10, (MoFilter)filter);
        if (moIter.hasMoreElements()) {
            return (AuxDeviceSetMoImpl)moIter.nextMo();
        }
        return null;
    }

    public AuxDeviceMoImpl findDeviceMo(AuxDeviceMoFilter filter, ManagedObject root) {
        MoIterator moIter = MoRepository.instance().select(root, 10, (MoFilter)filter);
        if (moIter.hasMoreElements()) {
            return (AuxDeviceMoImpl)moIter.nextMo();
        }
        return null;
    }

    public Object[] hideHazardousActionParameters(String paramString, Object[] paramArrayOfObject) {
        try {
            if (!paramString.equalsIgnoreCase("sendAntennaConfigurationFile")) {
                return null;
            }
            int i = 3;
            try {
                paramArrayOfObject[i] = "*****";
            }
            catch (Exception localException) {
                MessageLog.info(super.getClass(), "In hideHazardousActionParameters, not able to hide hazardous parameters" + localException);
                return null;
            }
            return paramArrayOfObject;
        }
        catch (RuntimeException localRuntimeException) {
            MessageLog.info(super.getClass(), "In hideHazardousActionParameters, not able to hide hazardous parameters" + localRuntimeException);
            return null;
        }
    }

    public Object[] hideHazardousAttributeValues(AttrList arg0) {
        return null;
    }
}

