/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.mao.dmo.auxdevice;

import se.ericsson.cello.moframework.IllegalParentException;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.UndeletableMoException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.common.AvailabilityStatusIntToEnum;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.proxies.EqcBdhIndProxy;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.proxies.EqcDeviceProxy;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EqcCreateDeviceRspS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EqcGetDeviceParametersRspS;
import se.ericsson.wcdma.rbs.boam.fpx.proxies.FroProxy;
import se.ericsson.wcdma.rbs.boam.fpx.scmi.proxies.ScRfAccessProxy;
import se.ericsson.wcdma.rbs.boam.mao.alarm.MoAlarms;
import se.ericsson.wcdma.rbs.boam.mao.bcm.BoamManagedObject;
import se.ericsson.wcdma.rbs.boam.mao.bcm.BoamManagedObjectWithAlarms;
import se.ericsson.wcdma.rbs.boam.mao.common.MaoHasFro;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.AuxDeviceMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.AuxDeviceSetMo;

public abstract class AuxDeviceMoImpl
extends BoamManagedObjectWithAlarms
implements AuxDeviceMo,
MaoHasFro {
    private static final String USER_LABEL = "userLabel";
    public static final String USER_LABEL_DEFAULT = "";
    private static final int USER_LABEL_MAX_LENGTH = 128;
    private static final int USER_LABEL_MIN_LENGTH = 0;
    private static final String IDENTITY = "identity";
    public static final String AUX_DEVICE_FRO_ID = "auxDeviceFroId";
    private static final int CLIENT_ID = 0;
    protected static final EqcDeviceProxy eqcDeviceProxy = EqcDeviceProxy.instance();
    protected static final EqcBdhIndProxy eqcBdhIndProxy = EqcBdhIndProxy.instance();
    protected static final ScRfAccessProxy scRfAccessProxy = ScRfAccessProxy.instance();

    public AuxDeviceMoImpl(ManagedObject parent, String thisMoName, int devType, int deviceFroId, String identity, Coordinator context, String userlabel) throws MoAccessException {
        super(parent, thisMoName, identity, context);
        int thisDeviceFroId;
        int deviceId;
        MessageLog.traceEnter(this.getClass(), "Normal constructor");
        this.myData = new MoData(this.getLocalDistinguishedName(), this.getType(), true, context);
        if (parent == null) {
            throw new IllegalParentException(thisMoName);
        }
        MessageLog.trace(1, this.getClass(), "Creating AuxDeviceMoImpl, MO named " + thisMoName);
        if (devType == 11 || devType == 12) {
            deviceId = 1;
        } else if (devType == 10) {
            deviceId = 1;
        } else if (devType == 9) {
            int slotPos;
            deviceId = slotPos = Integer.parseInt(identity);
            MessageLog.trace(1, this.getClass(), "deviceId = " + deviceId);
        } else {
            deviceId = 0;
        }
        AuxDeviceSetMo auxDevSet = (AuxDeviceSetMo)parent;
        if (!auxDevSet.shallCreateDevSetFro()) {
            thisDeviceFroId = deviceFroId;
        } else {
            MessageLog.trace(1, this.getClass(), "Creating Device FRO, devType=" + devType);
            EqcCreateDeviceRspS resp = eqcDeviceProxy.createDevice(context.getTransactionID(), 0L, devType, auxDevSet.getAuxDevSetFroId(context), deviceId);
            thisDeviceFroId = (int)resp.deviceFroId;
        }
        this.bcmStoreAndRegisterStringAttribute(USER_LABEL, userlabel);
        this.bcmStoreAndRegisterStringAttribute(IDENTITY, identity);
        this.bcmStoreAndRegisterIntAttribute(AUX_DEVICE_FRO_ID, thisDeviceFroId);
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
    }

    public AuxDeviceMoImpl(MoData recoveredData) throws MoNameAlreadyTakenException {
        super(recoveredData);
        MessageLog.traceEnter(this.getClass(), "Recovery constructor");
        this.myData = recoveredData;
    }

    public void delete(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "delete()<---");
        throw new UndeletableMoException((ManagedObject)this);
    }

    public void sysDelete(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "sysDelete()");
        if (this.isReserved(context)) {
            throw new UndeletableMoException((ManagedObject)this);
        }
        this.removeObservers(context);
        super.delete(context);
    }

    public void npuDelete(Coordinator context, int deviceType) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "npuDelete() ");
        if (this.isReserved(context)) {
            throw new UndeletableMoException((ManagedObject)this);
        }
        eqcDeviceProxy.deleteDevice(context.getTransactionID(), 0L, this.getFroId(context));
        this.removeObservers(context);
        super.delete(context);
    }

    public String getUserLabel(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getUserLabel() ");
        this.myData.handleTransaction(context, MoData.READ_ACCESS);
        return this.bcmGetStringAttribute(USER_LABEL, context);
    }

    public void setUserLabel(String value, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setUserLabel() ");
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
        this.bcmSetStringAttribute(USER_LABEL, value, 0, 128, this.getType(), context);
        this.sendAVC(USER_LABEL, value, context);
    }

    public String getIdentity(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getIdentity()");
        return this.getNamingAttributeValue();
    }

    public int getOperationalState(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getOperationalState()");
        EqcGetDeviceParametersRspS rspSig = eqcDeviceProxy.getDeviceParameters(this.getTxIdNonTransactional(context), 0L, this.getAuxDeviceFroId(context));
        return rspSig.opState;
    }

    public int getAvailabilityStatus(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getAvailabilityStatus()");
        EqcGetDeviceParametersRspS rspSig = eqcDeviceProxy.getDeviceParameters(this.getTxIdNonTransactional(context), 0L, this.getAuxDeviceFroId(context));
        return AvailabilityStatusIntToEnum.convGetAvailStatIntToEnum(rspSig.availStatus);
    }

    public int getUsageState(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getUsageState()");
        EqcGetDeviceParametersRspS rspSig = eqcDeviceProxy.getDeviceParameters(this.getTxIdNonTransactional(context), 0L, this.getAuxDeviceFroId(context));
        return rspSig.usageState;
    }

    public int getAuxDeviceFroId(Coordinator context) {
        MessageLog.traceEnter(this.getClass(), "getAuxDeviceFroId()");
        IntegerAttribute attribute = (IntegerAttribute)this.myData.getAttribute(AUX_DEVICE_FRO_ID);
        if (attribute == null) {
            MessageLog.traceError(this.getClass(), "Recovered attribute auxDeviceFroId is null");
        }
        return attribute.getValue(context);
    }

    public int getFroId(Coordinator context) {
        MessageLog.traceEnter(this.getClass(), "getFroId()");
        return this.getAuxDeviceFroId(context);
    }

    public MoData getMyMoData() {
        MessageLog.traceEnter(this.getClass(), "getMyMoData()");
        return this.myData;
    }

    public boolean isMyMoDataPersistent() {
        MessageLog.traceEnter(this.getClass(), "isMyMoDataPersistent()");
        return true;
    }

    public ManagedObject searchForCorrespNpu(ManagedObject moRef, String moType) {
        MessageLog.traceEnter(this.getClass(), "searchForCorrespNpu()");
        ManagedObject result2 = null;
        try {
            ManagedObject[] mos = ((BoamManagedObject)moRef).getReservedBy(null);
            for (int i = 0; i < mos.length; ++i) {
                if (!moType.equals(mos[i].getType())) continue;
                result2 = mos[i];
            }
        }
        catch (MoAccessException e) {
            MessageLog.trace(2, this.getClass(), "Could not access the reservedByList to get Npu info");
        }
        return result2;
    }

    protected void addObservers(int froType, Coordinator context) throws MoAccessException {
        this.addObservers(eqcBdhIndProxy, froType, context);
    }

    protected void addObservers(FroProxy proxy, int froType, Coordinator context) throws MoAccessException {
        this.myMoAlarms = new MoAlarms((ManagedObject)this, proxy, froType, this.getFroId(context), context);
    }

    protected void removeObservers(Coordinator context) throws MoAccessException {
        if (this.myMoAlarms != null) {
            this.myMoAlarms.delete(context);
        }
    }
}

