/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.mao.dmo.auxdevice;

import enea.ose.system.InSignal;
import java.util.Locale;
import se.ericsson.cello.faultmanagement.Event;
import se.ericsson.cello.moframework.IllegalParentException;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.ResourceLockedException;
import se.ericsson.cello.moframework.TransactionRequiredException;
import se.ericsson.cello.moframework.UndeletableMoException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.common.AvailabilityStatusIntToEnum;
import se.ericsson.wcdma.rbs.boam.common.MoEventable;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.proxies.EqcBdhIndProxy;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.proxies.EqcDeviceSetProxy;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EqcCreateDevSetRspS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EqcDevSetEventIndS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EqcGetDevSetParametersRspS;
import se.ericsson.wcdma.rbs.boam.mao.alarm.MoAlarms;
import se.ericsson.wcdma.rbs.boam.mao.bcm.BoamManagedObjectWithAlarms;
import se.ericsson.wcdma.rbs.boam.mao.common.MaoHasFro;
import se.ericsson.wcdma.rbs.boam.mao.event.MoEvents;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.AuxDeviceGroupMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.AuxDeviceMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.AuxDeviceSetMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.DeviceGroupMo;

public abstract class AuxDeviceSetMoImpl
extends BoamManagedObjectWithAlarms
implements AuxDeviceSetMo,
MoEventable,
MaoHasFro {
    private static final String IDENTITY = "identity";
    public static final String AUX_DEVICE_SET_FRO_ID = "auxDevSetFroId";
    private static final String USER_LABEL = "userLabel";
    public static final String USER_LABEL_DEFAULT = "";
    public static final int USER_LABEL_MIN_LENGTH = 0;
    public static final int USER_LABEL_MAX_LENGTH = 128;
    protected static final int CLIENT_IDENTITY = 0;
    protected MoEvents myMoEvents = null;
    protected EqcDeviceSetProxy eqcDeviceSetProxy = EqcDeviceSetProxy.instance();
    protected EqcBdhIndProxy eqcBdhIndProxy = EqcBdhIndProxy.instance();

    public AuxDeviceSetMoImpl(ManagedObject parent, String thisMoName, int devType, int devSetFroId, String identity, Coordinator context, String userlabel) throws MoAccessException {
        super(parent, thisMoName, identity, context);
        MessageLog.traceEnter(this.getClass(), "Normal constructor");
        this.myData = new MoData(this.getLocalDistinguishedName(), this.getType(), true, context);
        if (parent == null) {
            throw new IllegalParentException(thisMoName);
        }
        MessageLog.trace(1, this.getClass(), "Creating DeviceSetMoImpl ");
        if (this.shallCreateDevSetFro(parent)) {
            AuxDeviceGroupMo auxDevGr = (AuxDeviceGroupMo)parent;
            int auxDevGrFroId = auxDevGr.getAuxGroupFroId(context);
            MessageLog.trace(1, this.getClass(), "Creating Set/Device FRO, setType=" + devType);
            EqcCreateDevSetRspS resp = this.eqcDeviceSetProxy.createDevSet(context.getTransactionID(), 0L, devType, auxDevGrFroId);
            devSetFroId = (int)resp.devSetFroId;
        }
        this.bcmStoreAndRegisterStringAttribute(IDENTITY, identity);
        this.bcmStoreAndRegisterStringAttribute(USER_LABEL, userlabel);
        if (devSetFroId != -1) {
            this.bcmStoreAndRegisterIntAttribute(AUX_DEVICE_SET_FRO_ID, devSetFroId);
        }
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
    }

    public AuxDeviceSetMoImpl(MoData recoveredData) throws MoNameAlreadyTakenException {
        super(recoveredData);
        MessageLog.traceEnter(this.getClass(), "Recovery constructor");
        this.myData = recoveredData;
    }

    public boolean shallCreateDevSetFro() {
        MessageLog.traceEnter(this.getClass(), "shallCreateDevSetFro()");
        return this.shallCreateDevSetFro(this.getParent());
    }

    private boolean shallCreateDevSetFro(ManagedObject parent) {
        String thisMoName = this.getType();
        String parentMoName = parent.getType();
        if (parentMoName.compareTo("PcuDeviceGroup") == 0 || parent instanceof DeviceGroupMo) {
            String strId;
            if (parent instanceof DeviceGroupMo && (strId = parent.getNamingAttributeValue().toUpperCase(Locale.ENGLISH)).compareTo("PCU") != 0) {
                return false;
            }
            if (thisMoName.compareTo("AcDeviceSet") == 0) {
                return true;
            }
            if (thisMoName.compareTo("BfDeviceSet") == 0) {
                return true;
            }
            if (thisMoName.compareTo("ClDeviceSet") == 0) {
                return true;
            }
            if (thisMoName.compareTo("PsDeviceSet") == 0) {
                return true;
            }
        }
        return false;
    }

    public void delete(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "delete()<---");
        throw new UndeletableMoException((ManagedObject)this);
    }

    public void sysDelete(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "sysDelete()");
        if (this.isReserved(context)) {
            throw new UndeletableMoException((ManagedObject)this);
        }
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
        MoIterator iter = this.getChildren();
        MessageLog.trace(1, this.getClass(), "delete devices");
        while (iter.hasMoreElements()) {
            Object child = iter.nextElement();
            AuxDeviceMo auxDevMo = (AuxDeviceMo)child;
            auxDevMo.sysDelete(context);
        }
        this.removeObservers(context);
        this.myData.delete(context);
        super.delete(context);
    }

    public String getIdentity(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getIdentity()");
        return this.getNamingAttributeValue();
    }

    public String getUserLabel(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getUserLabel() ");
        this.myData.handleTransaction(context, MoData.READ_ACCESS);
        return this.bcmGetStringAttribute(USER_LABEL, context);
    }

    public void setUserLabel(String value, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setUserLabel() ");
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
        this.bcmSetStringAttribute(USER_LABEL, value, 0, 128, this.getType(), context);
        this.sendAVC(USER_LABEL, value, context);
    }

    public int getOperationalState(Coordinator context) throws MoAccessException, TransactionRequiredException, ResourceLockedException {
        MessageLog.traceEnter(this.getClass(), "getOperationalState()");
        EqcGetDevSetParametersRspS rspSig = this.eqcDeviceSetProxy.getDevSetParameters(this.getTxIdNonTransactional(context), 0L, this.getAuxDevSetFroId(context));
        return rspSig.opState;
    }

    public int getAvailabilityStatus(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getAvailabilityStatus()");
        EqcGetDevSetParametersRspS rspSig = this.eqcDeviceSetProxy.getDevSetParameters(this.getTxIdNonTransactional(context), 0L, this.getAuxDevSetFroId(context));
        return AvailabilityStatusIntToEnum.convGetAvailStatIntToEnum(rspSig.availStatus);
    }

    public int getAuxDevSetFroId(Coordinator context) {
        MessageLog.traceEnter(this.getClass(), "getAuxDevSetFroId()");
        IntegerAttribute attribute = (IntegerAttribute)this.myData.getAttribute(AUX_DEVICE_SET_FRO_ID);
        return attribute.getValue(context);
    }

    public int getFroId(Coordinator context) {
        MessageLog.traceEnter(this.getClass(), "getFroId()");
        return this.getAuxDevSetFroId(context);
    }

    public MoData getMyMoData() {
        MessageLog.traceEnter(this.getClass(), "getMyMoData()");
        return this.myData;
    }

    public boolean isMyMoDataPersistent() {
        MessageLog.traceEnter(this.getClass(), "isMyMoDataPersistent()");
        return true;
    }

    public void eventRaised(InSignal eventInd) {
        MessageLog.traceEnter(this.getClass(), "eventRaised()");
        String objectClass = this.getType();
        String managedObjectInstance = this.getFullDistinguishedName();
        String eventType = "0";
        String eventTime = USER_LABEL_DEFAULT;
        if (eventInd instanceof EqcDevSetEventIndS) {
            MessageLog.trace(6, this.getClass(), "EqcDevSetEventIndS received");
            EqcDevSetEventIndS recSig = (EqcDevSetEventIndS)eventInd;
            String specificEvent = USER_LABEL_DEFAULT;
            int eventIs = recSig.devSetEventType;
            if (eventIs == 49153) {
                specificEvent = this.getType() + "_SuccessfulRecoveryActionPerformedBoardRestart";
                MessageLog.trace(6, this.getClass(), "MO = " + objectClass + " specificEvent = _SuccessfulRecoveryActionPerformedBoardRestart");
            } else if (eventIs == 49154) {
                specificEvent = this.getType() + "_SuccessfulRecoveryActionPerformedWarmReset";
                MessageLog.trace(6, this.getClass(), "MO = " + objectClass + " specificEvent = _SuccessfulRecoveryActionPerformedWarmReset");
            } else if (eventIs == 49157) {
                specificEvent = this.getType() + "_SuccessfulRecoveryActionPerformedSwitchedClockSource";
                MessageLog.trace(6, this.getClass(), "MO = " + objectClass + " specificEvent = _SuccessfulRecoveryActionPerformedSwitchedClockSource");
            } else if (eventIs == 49156) {
                specificEvent = this.getType() + "_SuccessfulRecoveryActionPerformedReestablishLink";
                MessageLog.trace(6, this.getClass(), "MO = " + objectClass + " specificEvent = _SuccessfulRecoveryActionPerformedReestablishLink");
            } else {
                MessageLog.traceError(this.getClass(), "Unknown event received");
                return;
            }
            String additionalText = this.bcmGetMEUserLabel();
            new Event(objectClass, managedObjectInstance, eventType, eventTime, specificEvent, additionalText, null);
            MessageLog.trace(6, this.getClass(), "Event raised MO = " + objectClass + " " + "eventType = " + eventType + " " + "specificEvent = " + specificEvent);
        }
    }

    protected void addObservers(int froType, Coordinator context) throws MoAccessException {
        this.myMoAlarms = new MoAlarms((ManagedObject)this, this.eqcBdhIndProxy, froType, this.getFroId(context), context);
        this.myMoEvents = new MoEvents(this, this.eqcBdhIndProxy, this.getFroId(context), context);
    }

    protected void removeObservers(Coordinator context) throws MoAccessException {
        this.myMoAlarms.delete(context);
        this.myMoEvents.delete(context);
    }
}

