/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.mao.dmo.auxdevice;

import enea.ose.system.InSignal;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Enumeration;
import se.ericsson.cello.equipment.SubrackMo;
import se.ericsson.cello.faultmanagement.Event;
import se.ericsson.cello.managedelement.ManagedElementDataMo;
import se.ericsson.cello.mao.AttrListImpl;
import se.ericsson.cello.mao.Reservable;
import se.ericsson.cello.moframework.AccessControlHelper;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.AttrMissingAtCreateException;
import se.ericsson.cello.moframework.AttrNotSettableException;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MibMgr;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoCanNotBeCreatedException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoFactory;
import se.ericsson.cello.moframework.MoFactoryMgr;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.MoNotFoundException;
import se.ericsson.cello.moframework.MoRemovedException;
import se.ericsson.cello.moframework.MoRepository;
import se.ericsson.cello.moframework.NoSuchFieldException;
import se.ericsson.cello.moframework.NotHandledAttributeTypeException;
import se.ericsson.cello.moframework.ReferenceAttribute;
import se.ericsson.cello.moframework.SequenceAttribute;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.moframework.StructAttribute;
import se.ericsson.cello.moframework.StructImpl;
import se.ericsson.cello.moframework.TransactionRequiredException;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.moframework.WrongAttributeTypeException;
import se.ericsson.cello.productinventory.HardwareProductData;
import se.ericsson.cello.productinventory.ProductRepository;
import se.ericsson.cello.swmanagement.PiuTypeMo;
import se.ericsson.cello.swmanagement.SwAllocationMo;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.common.AvailabilityStatusIntToEnum;
import se.ericsson.wcdma.rbs.boam.common.EnumConverter;
import se.ericsson.wcdma.rbs.boam.common.FroRequestFailedException;
import se.ericsson.wcdma.rbs.boam.common.Strings;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.fpx.common.ErrorCodeMapper;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.proxies.EqcAuxPiuProxy;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.proxies.EqcBdhIndProxy;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.proxies.EqcDeviceGroupProxy;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EqcAuxPiuEventIndS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EqcAuxPiuPrimFaultCeaseIndS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EqcAuxPiuPrimFaultIndS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EqcGetGroupHwLogInfoRspS;
import se.ericsson.wcdma.rbs.boam.mao.alarm.MoAlarms;
import se.ericsson.wcdma.rbs.boam.mao.bcm.BoamHelper;
import se.ericsson.wcdma.rbs.boam.mao.bcm.BoamManagedObjectWithAlarms;
import se.ericsson.wcdma.rbs.boam.mao.common.ConfigNotSupportedException;
import se.ericsson.wcdma.rbs.boam.mao.common.MaoHasFro;
import se.ericsson.wcdma.rbs.boam.mao.common.ValidateAttributes;
import se.ericsson.wcdma.rbs.boam.mao.dmo.auxdevice.auxpiu.AuxPiuHwUpgradeHandler;
import se.ericsson.wcdma.rbs.boam.mao.dmo.auxdevice.auxpiu.AuxPiuSwUpgradeHandler;
import se.ericsson.wcdma.rbs.boam.mao.dmo.auxdevice.auxpiu.AuxPlugInUnitAttributesChecker;
import se.ericsson.wcdma.rbs.boam.mao.dmo.auxdevice.auxpiu.AuxPlugInUnitFroMao;
import se.ericsson.wcdma.rbs.boam.mao.dmo.auxdevice.auxpiu.AuxPlugInUnitUpgradeHelper;
import se.ericsson.wcdma.rbs.boam.mao.dmo.common.MoHelper;
import se.ericsson.wcdma.rbs.boam.mao.dmo.device.DeviceGroupMoImpl;
import se.ericsson.wcdma.rbs.boam.mao.emo.cable.OptoCommCableMoImpl;
import se.ericsson.wcdma.rbs.boam.mao.event.MoEvents;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.enumer.AuxPlugInUnitHubPosition;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.excep.FunctionNotSupportedException;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.excep.HwPresentException;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.excep.NoAccessToHwLogException;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.excep.NotAllowedWhenTechnicianPresentException;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.excep.NotSupportedException;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.excep.RepairDeliveryNoteAlreadyExistsException;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.excep.RepairDeliveryNoteDoesNotExistException;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.struct.OperFaultEntryStruct;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.struct.SpecialIndicatorStruct;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.AuxDeviceGroupMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.AuxPlugInUnitMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.CuSubrackMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.DeviceGroupMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.ExternalAntennaMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.McpaSubrackMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.OptoCommCableMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.PowerSupplySubrackMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.RbsSlotMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.RbsSubrackMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.SectorAntennaMo;
import se.ericsson.wcdma.rbs.boam.mao.rmo.node.NodeBFunctionMoImpl;

public class AuxPlugInUnitMoImpl
extends BoamManagedObjectWithAlarms
implements AuxPlugInUnitMo {
    private static final String AUX_PIU_FRO_ID = "auxPiuFroId";
    public static final int MO_DATA_REVISION = 6050401;
    private static final EqcAuxPiuProxy eqcAuxPiuProxy = EqcAuxPiuProxy.instance();
    private static final EqcBdhIndProxy eqcBdhIndProxy = EqcBdhIndProxy.instance();
    private static final int RBS_EVENT_NEW_AUXILIARY_UNIT_DETECTED_MATCHES_THE_DEF_CONFIG = 98;
    private static final int RBS_EVENT_NEW_AUXILIARY_UNIT_DETECTED_NO_PREDEF_CONFIG_EXISTS = 99;
    private static final int CLIENT_ID = 0;
    private static final String SHELF_TYPE_NAME = "Shelf";
    private EqcDeviceGroupProxy eqcDeviceGroupProxy = EqcDeviceGroupProxy.instance();
    private final AuxPiuSwUpgradeHandler auxPiuSwUpgradeHandler;
    private final AuxPiuHwUpgradeHandler auxPiuHwUpgradeHandler;
    private final AuxPlugInUnitFroMao auxPlugInUnitFroMao;
    private int internalAlarmStatus;
    private PiuTypeMo failingPiuType;
    private MoEvents myMoEvents = null;
    private static final String CELLO_RESERVED_BY = "reservedBy";

    public AuxPlugInUnitMoImpl(MoData recoveredData) throws MoNameAlreadyTakenException {
        super(recoveredData);
        MessageLog.traceEnter(this.getClass(), "AuxPlugInUnitMoImpl()<---");
        this.myData = recoveredData;
        this.auxPiuSwUpgradeHandler = new AuxPiuSwUpgradeHandler(this);
        this.auxPiuHwUpgradeHandler = new AuxPiuHwUpgradeHandler(this);
        this.auxPlugInUnitFroMao = new AuxPlugInUnitFroMao(this);
        ProductRepository.instance().registerHw((HardwareProductData)this);
        try {
            this.addObservers(49152, null);
        }
        catch (MoAccessException e) {
            MessageLog.traceError(this.getClass(), "Couldn't init the Observers!!");
        }
        MessageLog.trace(1, this.getClass(), "Mo recovered");
    }

    private AuxPlugInUnitMoImpl(ManagedObject parent, String thisMoName, ManagedObject source, String identity, String userLabel, int adminState, boolean isSharedWithExternalMe, int operState, int availStatus, int shutDownTimer, int auType, ManagedObject piuType, ManagedObject plugInUnitRef1, ManagedObject plugInUnitRef2, int alarmStatus, int hubPosition, String uniqueHwId, int position, String positionInformation, ManagedObject positionRef, Struct positionCoordinates, ManagedObject[] supportUnitRef, AttrList attributes, Coordinator context) throws MoAccessException {
        super(parent, thisMoName, identity, context);
        boolean bAutoConfigAllowed;
        MessageLog.traceEnter(this.getClass(), "AuxPlugInUnitMoImpl()<---");
        this.auxPiuSwUpgradeHandler = new AuxPiuSwUpgradeHandler(this);
        this.auxPiuHwUpgradeHandler = new AuxPiuHwUpgradeHandler(this);
        this.auxPlugInUnitFroMao = new AuxPlugInUnitFroMao(this);
        this.initMoData(parent, source, identity, userLabel, adminState, isSharedWithExternalMe, operState, availStatus, shutDownTimer, auType, piuType, plugInUnitRef1, plugInUnitRef2, alarmStatus, hubPosition, uniqueHwId, position, positionInformation, positionRef, positionCoordinates, supportUnitRef, attributes, context);
        if (plugInUnitRef1 != null) {
            ((Reservable)plugInUnitRef1).reserve((ManagedObject)this, context);
        }
        if (plugInUnitRef2 != null) {
            ((Reservable)plugInUnitRef2).reserve((ManagedObject)this, context);
        }
        if (positionRef != null) {
            ((Reservable)positionRef).reserve((ManagedObject)this, context);
        }
        if (supportUnitRef != null) {
            for (int i = 0; i < supportUnitRef.length; ++i) {
                ((Reservable)supportUnitRef[i]).reserve((ManagedObject)this, context);
            }
        }
        if (AuxPlugInUnitAttributesChecker.auType2FroObjectType(auType) == 49156) {
            this.createOptoCommCable(identity, context);
        }
        this.addObservers(49152, context);
        ManagedObject managedElementData = AuxPlugInUnitUpgradeHelper.findManagedElementDataMO();
        if (managedElementData != null && (bAutoConfigAllowed = ((ManagedElementDataMo)managedElementData).getAutoConfigurationAllowed(context))) {
            this.autoConfigureMe(context);
        }
        MessageLog.trace(1, this.getClass(), "AuxPlugInUnit MO is Created ");
    }

    private void autoConfigureMe(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "autoconfigureMe");
        this.autoCreateSubordinates(context);
    }

    public static synchronized ManagedObject create(ManagedObject parent, AttrList attributes, String identity, ManagedObject source, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(AuxPlugInUnitMoImpl.class, "create()<---");
        ValidateAttributes.checkTransaction(context);
        boolean checkedIsSharedWithExternalMe = ValidateAttributes.checkAndGetBooleanAttribute(attributes, "isSharedWithExternalMe", "optional", false, false, true, "AuxPlugInUnit");
        String checkedUserLabel = ValidateAttributes.checkAndGetStringAttribute(attributes, "userLabel", "optional", "", 0, 128, "AuxPlugInUnit");
        String checkedUniqueHwId = ValidateAttributes.checkAndGetStringAttribute(attributes, "uniqueHwId", "optional", "", 0, 19, "AuxPlugInUnit");
        int checkedAdminState = ValidateAttributes.checkAndGetIntAttribute(attributes, "administrativeState", "optional", 1, 0, 2, "AuxPlugInUnit");
        int checkedOperState = ValidateAttributes.checkAndGetIntAttribute(attributes, "operationalState", "optional", 0, 0, 1, "AuxPlugInUnit");
        int checkedAvailStatus = ValidateAttributes.checkAndGetIntAttribute(attributes, "availabilityStatus", "optional", 0, 0, 1056, "AuxPlugInUnit");
        int checkedShutDownTimer = ValidateAttributes.checkAndGetIntAttribute(attributes, "shutDownTimer", "optional", 10, 0, 100, "AuxPlugInUnit");
        int checkedAuType = ValidateAttributes.checkAndGetIntAttribute(attributes, "auType", "mandatory", 1, 1, 29, "AuxPlugInUnit");
        AuxPlugInUnitAttributesChecker.checkAuTypeUnicityWithinSector(parent, checkedAuType, context);
        int checkedAlarmStatus = ValidateAttributes.checkAndGetIntAttribute(attributes, "alarmStatus", "optional", 0, ALARM_STATUS_MIN_VALUES, ALARM_STATUS_MAX_VALUES, "AuxPlugInUnit");
        ManagedObject checkedPiuType = ValidateAttributes.checkAndGetReferenceAttribute("piuType", attributes, "mandatory", new String[]{"PiuType"}, "AuxPlugInUnit");
        AuxPlugInUnitAttributesChecker.checkMoRefType(checkedPiuType, "PiuType", "piuType", "AuxPlugInUnit");
        ManagedObject checkedPlugInUnitRef1 = AuxPlugInUnitAttributesChecker.checkAndGetPlugInUnitRef(attributes, "plugInUnitRef1", "mandatory", checkedAuType, context);
        ManagedObject checkedPlugInUnitRef2 = AuxPlugInUnitAttributesChecker.checkAndGetPlugInUnitRef(attributes, "plugInUnitRef2", "optional", checkedAuType, context);
        int checkedHubPosition = AuxPlugInUnitMoImpl.checkAttributeHubPosition(attributes);
        AuxPlugInUnitAttributesChecker.checkParentCompatibilityWithAuType(parent, checkedAuType);
        int checkedPosition = ValidateAttributes.checkAndGetIntAttribute(attributes, "position", "optional", 0, POSITION_MIN_VALUES, POSITION_MAX_VALUES, "AuxPlugInUnit");
        String checkedPositionInformation = ValidateAttributes.checkAndGetStringAttribute(attributes, "positionInformation", "optional", "", 0, 255, "AuxPlugInUnit");
        ManagedObject checkedPositionRef = ValidateAttributes.checkAndGetReferenceAttribute("positionRef", attributes, "optional", new String[]{"Cabinet", SHELF_TYPE_NAME}, "AuxPlugInUnit");
        Struct checkedPositionCoordinates = ValidateAttributes.checkAndGetStructAttribute(attributes, "positionCoordinates", "optional", "AuxPlugInUnit");
        AuxPlugInUnitMoImpl.validatePosition(checkedPositionCoordinates);
        ManagedObject[] checkedSupportUnitRef = ValidateAttributes.checkandGetRefSeqAttribute(attributes, "supportUnitRef", "optional", new String[]{"SupportUnit"}, Integer.MAX_VALUE, "AuxPlugInUnit");
        ValidateAttributes.checkOtherAttributes(attributes, "AuxPlugInUnit");
        return new AuxPlugInUnitMoImpl(parent, "AuxPlugInUnit", source, identity, checkedUserLabel, checkedAdminState, checkedIsSharedWithExternalMe, checkedOperState, checkedAvailStatus, checkedShutDownTimer, checkedAuType, checkedPiuType, checkedPlugInUnitRef1, checkedPlugInUnitRef2, checkedAlarmStatus, checkedHubPosition, checkedUniqueHwId, checkedPosition, checkedPositionInformation, checkedPositionRef, checkedPositionCoordinates, checkedSupportUnitRef, attributes, context);
    }

    public void delete(Coordinator context) throws MoAccessException {
        ManagedObject[] supportUnitRef;
        ManagedObject positionRef;
        MessageLog.traceEnter(this.getClass(), "delete()");
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
        SwAllocationMo swAll = (SwAllocationMo)this.getSwAllocation(context);
        if (swAll != null) {
            swAll.actionDeleteSlot((ManagedObject)this, context);
        }
        this.deleteSubordinates(this, context);
        this.auxPlugInUnitFroMao.deleteAuxPlugInUnit(this.getTxIdTransactional(context), 0, this.getAuxPlugInUnitFroId(context));
        ManagedObject plugInUnitRef1 = this.getPlugInUnitRef1(context);
        ManagedObject plugInUnitRef2 = this.getPlugInUnitRef2(context);
        if (plugInUnitRef1 != null) {
            ((Reservable)plugInUnitRef1).release((ManagedObject)this, context);
        }
        if (plugInUnitRef2 != null) {
            ((Reservable)plugInUnitRef2).release((ManagedObject)this, context);
        }
        if ((positionRef = this.getPositionRef(context)) != null) {
            ((Reservable)positionRef).release((ManagedObject)this, context);
        }
        if ((supportUnitRef = this.getSupportUnitRef(context)) != null) {
            for (int i = 0; i < supportUnitRef.length; ++i) {
                ((Reservable)supportUnitRef[i]).release((ManagedObject)this, context);
            }
        }
        this.removeObservers(context);
        super.delete(context);
        ProductRepository.instance().deregisterHw((HardwareProductData)this);
        if (AuxPlugInUnitAttributesChecker.auType2FroObjectType(this.getAuType(context)) == 49156) {
            this.deleteOptoCommCable(context);
        }
        MessageLog.trace(1, this.getClass(), "AuxPlugInUnit is Deleted");
    }

    public void deleteSubordinates(ManagedObject targetMo, Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "deleteSubordinates()<---");
        ManagedObject mo = null;
        try {
            MoIterator iter = targetMo.getChildren();
            if (iter != null) {
                while (iter.hasMoreElements()) {
                    mo = iter.nextMo();
                    MessageLog.trace(1, this.getClass(), "deleting: " + mo.getFullDistinguishedName());
                    mo.delete(c);
                }
            }
        }
        catch (MoAccessException e) {
            MessageLog.trace(1, this.getClass(), mo.getType() + ", Mo could not be deleted. Mo: " + mo.getFullDistinguishedName() + "\nException :" + (Object)((Object)e));
            throw e;
        }
    }

    public void autoCreateSubordinates(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "autoCreateSubordinates");
        Struct[] moConfigList = this.getMoConfiguration(c);
        if (moConfigList.length > 0) {
            MessageLog.trace(1, this.getClass(), "dependant MO configuration exist, processing");
            this.autoCreateAccordingToMoConfigList(c, moConfigList);
        } else {
            MessageLog.trace(1, this.getClass(), "No MO configuration defined for this PIU type.");
        }
    }

    private Struct[] getMoConfiguration(Coordinator c) throws MoAccessException {
        ArrayList<Struct> structList = new ArrayList<Struct>();
        try {
            PiuTypeMo piuType = (PiuTypeMo)this.getPiuType(c);
            if (piuType == null) {
                throw new MoCanNotBeCreatedException("AuxPlugInUnit because piuType is mandatory when autoconfiguration==true, but is missing");
            }
            int elementNrStruct = piuType.actionNumberOfMoConfigurations(c);
            for (int i = 0; i < elementNrStruct; ++i) {
                structList.add(piuType.actionGetMoConfiguration(i, c));
            }
        }
        catch (MoAccessException ex) {
            MessageLog.traceError(this.getClass(), "failed to get Mo Configuration for PiuType", ex);
            throw new MoCanNotBeCreatedException("AuxPlugInUnit because of error in getMoConfiguration method " + ex.toString());
        }
        return structList.toArray(new Struct[structList.size()]);
    }

    private static int checkAttributeHubPosition(AttrList attribute) throws MoAccessException {
        int checkedHubPosition = ValidateAttributes.checkAndGetIntAttribute(attribute, "hubPosition", "optional", 99, 0, 99, "AuxPlugInUnit");
        ValidateAttributes.intValueInEnumerationCheck("hubPosition", checkedHubPosition, AuxPlugInUnitHubPosition.class, "AuxPlugInUnit");
        return checkedHubPosition;
    }

    private void autoCreateAccordingToMoConfigList(Coordinator c, Struct[] moConfigList) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "autoCreateAccordingToMoConfigList");
        for (int moc = 0; moc < moConfigList.length; ++moc) {
            String spSubParentLDN = (String)moConfigList[moc].getValue("spSubParentLDN");
            String moType = (String)moConfigList[moc].getValue("moTypeNamea");
            String identity = (String)moConfigList[moc].getValue("identity");
            String parentLDN = "".equals(spSubParentLDN) ? this.getLocalDistinguishedName() : this.getLocalDistinguishedName() + "," + spSubParentLDN;
            ManagedObject parent = MoRepository.instance().lookup(parentLDN);
            if (parent == null) {
                MessageLog.trace(1, this.getClass(), "WARNING: MO Parent defined in PiuType not found under PIU, parent ##" + parentLDN + "## (## = delimiter generated " + "in this message)");
                continue;
            }
            MessageLog.trace(1, this.getClass(), "creating MO of type: " + moType);
            MoFactory moFactory = MoFactoryMgr.instance().lookup(moType);
            if (moFactory == null) {
                MessageLog.traceError(this.getClass(), "!!! No factory found for type '" + moType + "'");
                continue;
            }
            AttrListImpl attrList = new AttrListImpl(0);
            moFactory.createMo(parent, (AttrList)attrList, identity, null, c);
        }
    }

    public void deleteSubordinates(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "deleteSubordinates()");
        MoIterator iter = this.getChildren();
        if (iter != null) {
            while (iter.hasMoreElements()) {
                ManagedObject mo = iter.nextMo();
                mo.delete(c);
            }
        }
    }

    public void setInternalAlarmStatus(int status) {
        MessageLog.traceEnter(this.getClass(), "setInternalAlarmStatus()<---");
        this.internalAlarmStatus = status;
    }

    public int getInternalAlarmStatus() {
        MessageLog.traceEnter(this.getClass(), "getInternalAlarmStatus()<---");
        return this.internalAlarmStatus;
    }

    public PiuTypeMo getFailingPiuType() {
        return this.failingPiuType;
    }

    public AuxPiuHwUpgradeHandler getAuxPiuHwUpgradeHandler() {
        return this.auxPiuHwUpgradeHandler;
    }

    public void generateInternalAlarm(PiuTypeMo failingPiuType) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "generateInternalAlarm()<---");
        this.setInternalAlarmStatus(1);
        this.failingPiuType = failingPiuType;
        if (this.getAdministrativeState(null) == 1) {
            MessageLog.trace(5, this.getClass(), "AdminState UNLOCKED the alarm will be sent");
            this.generateExternalAlarm();
        } else {
            MessageLog.trace(5, this.getClass(), "AdminState LOCKED the alarm will be raised when the operator will set the admin state to UNLOCKED");
        }
    }

    private void generateExternalAlarm() throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "generateExternalAlarm()<---");
        EqcAuxPiuPrimFaultIndS eqcAuxPrimFault = new EqcAuxPiuPrimFaultIndS(0L, this.getAuxPlugInUnitFroId(null), 49187, 0L, "");
        this.myMoAlarms.alarmRaised(eqcAuxPrimFault, eqcAuxPiuProxy.getClass().getName());
        MessageLog.trace(5, this.getClass(), "generateExternalAlarm executed ");
    }

    public void ceaseInternalAlarm(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "ceaseInternalAlarm()<---");
        this.failingPiuType = null;
        if (this.getInternalAlarmStatus() != 0) {
            this.setInternalAlarmStatus(0);
            if (this.getAdministrativeState(null) == 1) {
                MessageLog.info(this.getClass(), "The admState is Unlocked : The alarm will be ceased");
                this.ceaseExternalAlarm(c);
            } else {
                MessageLog.info(this.getClass(), "The admState is Locked, the internal Alarm can't be ceased!!");
            }
        }
    }

    private void ceaseExternalAlarm(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "ceaseExternalAlarm()<---");
        EqcAuxPiuPrimFaultCeaseIndS eqcAuxPrimFaultCease = new EqcAuxPiuPrimFaultCeaseIndS(0L, this.getAuxPlugInUnitFroId(c), 49187, 0L);
        this.myMoAlarms.alarmCeased(eqcAuxPrimFaultCease, eqcAuxPiuProxy.getClass().getName());
    }

    public void generateEvent1(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "generateEvent1()<---");
        EqcAuxPiuEventIndS eqcAuxPiuEvent = new EqcAuxPiuEventIndS(0L, this.getAuxPlugInUnitFroId(c), 98);
        this.eventRaised((InSignal)eqcAuxPiuEvent);
    }

    public void generateEvent2(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "generateEvent2()<---");
        EqcAuxPiuEventIndS eqcAuxPiuEvent = new EqcAuxPiuEventIndS(0L, this.getAuxPlugInUnitFroId(c), 99);
        this.eventRaised((InSignal)eqcAuxPiuEvent);
    }

    public void eventRaised(InSignal eventInd) {
        MessageLog.traceEnter(this.getClass(), "eventRaised()<--");
        if (eventInd instanceof EqcAuxPiuEventIndS) {
            MessageLog.trace(6, this.getClass(), "EqcAuxPiuEventIndS received");
            String specificEvent = this.getType();
            switch (((EqcAuxPiuEventIndS)eventInd).auxPiuEventType) {
                case 49155: {
                    specificEvent = specificEvent + "_SuccessfulRecoveryActionPerformedSwitchedAuPath";
                    MessageLog.trace(6, this.getClass(), specificEvent);
                    break;
                }
                case 49156: {
                    specificEvent = specificEvent + "_SuccessfulRecoveryActionPerformedReestablishLink";
                    MessageLog.trace(6, this.getClass(), specificEvent);
                    break;
                }
                case 98: {
                    specificEvent = specificEvent + "_NewAuxiliaryUnitDetectedMatchesTheDefinedConfiguration";
                    MessageLog.trace(6, this.getClass(), specificEvent);
                    break;
                }
                case 99: {
                    specificEvent = specificEvent + "_NewAuxiliaryUnitDetectedNoPredefinedConfigurationExists";
                    MessageLog.trace(6, this.getClass(), specificEvent);
                    break;
                }
                default: {
                    MessageLog.traceError(this.getClass(), "Unknown event received");
                    return;
                }
            }
            new Event(this.getType(), this.getFullDistinguishedName(), "0", "", specificEvent, this.bcmGetMEUserLabel(), null);
        } else {
            MessageLog.traceError(this.getClass(), "Unknown event received");
        }
    }

    public String getUserLabel(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getUserLabel()");
        return this.bcmGetStringAttribute("userLabel", context);
    }

    public void setUserLabel(String value, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setUserLabel()");
        this.bcmSetStringAttribute("userLabel", value, 0, 128, "AuxPlugInUnit", context);
        this.sendAVC("userLabel", value, context);
    }

    public ManagedObject getPlugInUnitRef1(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getPlugInUnitRef1()");
        return this.bcmGetReferenceAttribute("plugInUnitRef1", context);
    }

    public ManagedObject getPlugInUnitRef2(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getPlugInUnitRef2()");
        return this.bcmGetReferenceAttribute("plugInUnitRef2", context);
    }

    public void setPlugInUnitRef2(ManagedObject value, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setPlugInUnitRef2()");
        ValidateAttributes.checkTransaction(context);
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
        int auType = this.getAuType(context);
        if (auType == 7 || auType == 5) {
            throw new AttrNotSettableException((ManagedObject)this, "plugInUnitRef2 Operation not allowed for this Aux Unit type.");
        }
        int plugInUnit2FroId = -1;
        ManagedObject oldRef = this.getPlugInUnitRef2(context);
        if (value != null && oldRef != null && value.getLocalDistinguishedName().equals(oldRef.getLocalDistinguishedName())) {
            MessageLog.trace(2, this.getClass(), "setPlugInUnitRef2() : the old value  and the new vlaue is the same, nothing to change!! mo:" + this.getFullDistinguishedName());
            return;
        }
        if (value != null) {
            plugInUnit2FroId = BoamHelper.getPlugInUnitFroId(AuxPlugInUnitMoImpl.mapPiu2PiuDeviceIfDui(value, context), context);
        } else {
            MessageLog.trace(2, this.getClass(), "setPlugInUnitRef2 : null value for plugInUnitRef2");
        }
        this.auxPlugInUnitFroMao.setAuxPlugInUnitParameter(this.getTxIdTransactional(context), 0, this.getAuxPlugInUnitFroId(context), plugInUnit2FroId);
        if (oldRef != null) {
            ((Reservable)oldRef).release((ManagedObject)this, context);
        }
        if (value != null) {
            ((Reservable)value).reserve((ManagedObject)this, context);
        }
        this.bcmSetReferenceAttribute("plugInUnitRef2", value, "", context);
        this.sendAVC("plugInUnitRef2", value, context);
    }

    public int getShutDownTimer(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getShutDownTimer()");
        return this.bcmGetIntAttribute("shutDownTimer", context);
    }

    public void setShutDownTimer(int newValue, Coordinator context) throws MoAccessException, ValueOutOfRangeException {
        MessageLog.traceEnter(this.getClass(), "setShutDownTimer()");
        this.bcmSetIntAttribute("shutDownTimer", newValue, 0, 100, "AuxPlugInUnit", context);
    }

    public ManagedObject getPiuType(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getPiuType()");
        return this.bcmGetReferenceAttribute("piuType", c);
    }

    public void setPiuType(ManagedObject value, Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setPiuType() ");
        AuxPlugInUnitMoImpl.checkTransaction(c);
        this.myData.handleTransaction(c, MoData.WRITE_ACCESS);
        if (value == null || !(value instanceof PiuTypeMo)) {
            throw new ValueOutOfRangeException("piuType", "AuxPlugInUnitThe new reference is null or is not an instance of PiuTypeMoImpl");
        }
        ManagedObject piuTypeOrg = this.getPiuType(c);
        if (piuTypeOrg != null) {
            String newPiuType;
            String currentPiuType = this.getPiuType(c).getNamingAttributeValue();
            if (currentPiuType.equals(newPiuType = value.getNamingAttributeValue())) {
                MessageLog.trace(2, this.getClass(), "NewPiuType is same as current piu type");
                return;
            }
            MessageLog.trace(2, this.getClass(), "initMoData(): newPiuType is new, auxPiuHelper.reconfigureProgramPrepare(c) invoked");
            this.auxPiuSwUpgradeHandler.reconfigureProgramPrepare(c);
            MessageLog.trace(2, this.getClass(), "initMoData(): newPiuType is new, auxPiuHelper.removeDisabledPrograms(c) invoked");
            this.auxPiuSwUpgradeHandler.removeDisabledPrograms(c);
        }
        ReferenceAttribute refAttr = (ReferenceAttribute)this.myData.getAttribute("piuType");
        refAttr.setValue(value);
        this.sendAVC("piuType", value, c);
    }

    public ManagedObject getSwAllocation(Coordinator context) throws MoAccessException {
        ManagedObject swa;
        block5: {
            MessageLog.traceEnter(this.getClass(), "getSwAllocation() ");
            swa = null;
            try {
                ManagedObject[] mo = this.getReservedBy(context);
                if (mo == null) break block5;
                for (int i = 0; i < mo.length; ++i) {
                    if (mo[i] instanceof SwAllocationMo) {
                        swa = mo[i];
                        break;
                    }
                    MessageLog.trace(2, this.getClass(), "Yes mo[i] " + i + "  " + mo[i].getFullDistinguishedName());
                }
            }
            catch (MoRemovedException e1) {
            }
            catch (TransactionRequiredException transactionRequiredException) {
                // empty catch block
            }
        }
        return swa;
    }

    public int getAuType(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getAuType() ");
        return this.bcmGetIntAttribute("auType", c);
    }

    public void actionRestartAuxUnit(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "actionRestartAuxUnit()<---");
        this.myData.handleTransaction(context, MoData.READ_ACCESS);
        this.auxPlugInUnitFroMao.actionRestartAuxUnitFroMao(this.getTxIdNonTransactional(context), 0, this.getAuxPlugInUnitFroId(context));
        MessageLog.trace(2, this.getClass(), "actionRestartAuxUnit() successfully executed");
    }

    public String getType() {
        return "AuxPlugInUnit";
    }

    public int getFroId(Coordinator context) {
        MessageLog.traceEnter(this.getClass(), "getFroId()");
        return this.getAuxPlugInUnitFroId(context);
    }

    public int getAuxPlugInUnitFroId(Coordinator c) {
        MessageLog.traceEnter(this.getClass(), "getAuxPlugInUnitFroId()");
        int auxPlugInUnitFroId = 0;
        try {
            auxPlugInUnitFroId = this.bcmGetIntAttribute(AUX_PIU_FRO_ID, c);
        }
        catch (Exception e) {
            MessageLog.trace(2, this.getClass(), "auxGroupFroId could not be fetched ");
        }
        return auxPlugInUnitFroId;
    }

    public int getResourceId(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getResourceId()");
        return this.getAuxPlugInUnitFroId(c);
    }

    public int getAdministrativeState(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getAdministrativeState()<---");
        return this.auxPlugInUnitFroMao.getAdministrativeStateFroMao(this.getTxIdNonTransactional(context), 0, this.getAuxPlugInUnitFroId(context));
    }

    public void setAdministrativeState(int newAdmState, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setAdministrativeState()<---");
        ValidateAttributes.checkTransaction(context);
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
        if (newAdmState != 0 && newAdmState != 1) {
            throw new ValueOutOfRangeException("The new administrative state is out of range ", this.getType());
        }
        NodeBFunctionMoImpl nodeBFunctionMoImplInstance = NodeBFunctionMoImpl.getTheOneAndOnly();
        if (nodeBFunctionMoImplInstance != null) {
            boolean technicianPresent = nodeBFunctionMoImplInstance.getTechnicianPresent(context);
            if (technicianPresent) {
                throw new NotAllowedWhenTechnicianPresentException("Operation is not allowed when a technician is present at the site.");
            }
        } else {
            MessageLog.trace(9, this.getClass(), "NodeBFunctionMoImpl instance is not ready.");
        }
        this.auxPlugInUnitFroMao.setAdministrativeStateFroMao(this.getTxIdTransactional(context), 0, this.getAuxPlugInUnitFroId(context), newAdmState);
        switch (newAdmState) {
            case 0: {
                if (this.getInternalAlarmStatus() != 1) break;
                this.ceaseExternalAlarm(context);
                break;
            }
            case 1: {
                if (this.getInternalAlarmStatus() != 1) break;
                this.generateExternalAlarm();
                break;
            }
        }
        this.sendAVC("administrativeState", newAdmState, context);
    }

    public int getOperationalState(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getOperationalState()<---");
        return this.auxPlugInUnitFroMao.getOperationalStateFroMao(this.getTxIdNonTransactional(context), 0, this.getAuxPlugInUnitFroId(context));
    }

    public int getAvailabilityStatus(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getAvailabilityStatus()");
        int availibility = this.auxPlugInUnitFroMao.getAvailibilityStatusFroMao(this.getTxIdNonTransactional(context), 0, this.getAuxPlugInUnitFroId(context));
        return AvailabilityStatusIntToEnum.convGetAvailStatIntToEnum(availibility);
    }

    public void setAdministrativeStateSwitch(int admState, int switchAtLock, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setAdministrativeStateSwitch()<---");
        this.setAdministrativeState(admState, context);
    }

    public int getGreenLed(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getGreenLed()<---");
        if (!this.isSupportSystemAvailable(c)) {
            return this.auxPlugInUnitFroMao.getGreenLedStatusFroMao(this.getTxIdNonTransactional(c), 0, this.getAuxPlugInUnitFroId(c));
        }
        return 0;
    }

    public int getRedLed(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getRedLed()<----");
        if (!this.isSupportSystemAvailable(c)) {
            return this.auxPlugInUnitFroMao.getRedLedStatusFroMao(this.getTxIdNonTransactional(c), 0, this.getAuxPlugInUnitFroId(c));
        }
        return 0;
    }

    public int getYellowLed(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getYellowLed()<---");
        if (!this.isSupportSystemAvailable(c)) {
            return this.auxPlugInUnitFroMao.getYellowLedStatusFroMao(this.getTxIdNonTransactional(c), 0, this.getAuxPlugInUnitFroId(c));
        }
        return 0;
    }

    public String getProductNumber(Coordinator context) {
        MessageLog.traceEnter(this.getClass(), "getProductNumber()<---");
        try {
            if (AuxPlugInUnitAttributesChecker.moHasChildren(this)) {
                return Strings.removeNonPrintableAscii(this.auxPlugInUnitFroMao.getProductNumberFroMao(this.getTxIdNonTransactional(context), 0, this.getAuxPlugInUnitFroId(context)));
            }
        }
        catch (MoAccessException moAccessException) {
            // empty catch block
        }
        return "";
    }

    public String getProductName(Coordinator context) {
        MessageLog.traceEnter(this.getClass(), "getProductName()<---");
        try {
            if (AuxPlugInUnitAttributesChecker.moHasChildren(this)) {
                return Strings.removeNonPrintableAscii(this.auxPlugInUnitFroMao.getProductNameFroMao(this.getTxIdNonTransactional(context), 0, this.getAuxPlugInUnitFroId(context)));
            }
        }
        catch (MoAccessException moAccessException) {
            // empty catch block
        }
        return "";
    }

    public String getProductType(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getProductType()<---");
        try {
            if (AuxPlugInUnitAttributesChecker.moHasChildren(this)) {
                return Strings.removeNonPrintableAscii(this.auxPlugInUnitFroMao.getProductTypeFroMao(this.getTxIdNonTransactional(context), 0, this.getAuxPlugInUnitFroId(context)));
            }
        }
        catch (MoAccessException moAccessException) {
            // empty catch block
        }
        return "";
    }

    public String getSerialNumber(Coordinator context) {
        MessageLog.traceEnter(this.getClass(), "getSerialNumber()<---");
        try {
            if (AuxPlugInUnitAttributesChecker.moHasChildren(this)) {
                return Strings.removeNonPrintableAscii(this.auxPlugInUnitFroMao.getSerialNumberFroMao(this.getTxIdNonTransactional(context), 0, this.getAuxPlugInUnitFroId(context)));
            }
        }
        catch (MoAccessException moAccessException) {
            // empty catch block
        }
        return "";
    }

    public String getRState(Coordinator context) {
        MessageLog.traceEnter(this.getClass(), "getRState()<---");
        try {
            if (AuxPlugInUnitAttributesChecker.moHasChildren(this)) {
                return Strings.removeNonPrintableAscii(this.auxPlugInUnitFroMao.getRStateFroMao(this.getTxIdNonTransactional(context), 0, this.getAuxPlugInUnitFroId(context)));
            }
        }
        catch (MoAccessException moAccessException) {
            // empty catch block
        }
        return "";
    }

    public String getProductRevision(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getProductRevision()<---");
        return this.getRState(c);
    }

    public String getProductionDate(Coordinator context) {
        MessageLog.traceEnter(this.getClass(), "getProductionDate()<---");
        if (AuxPlugInUnitAttributesChecker.moHasChildren(this)) {
            try {
                return this.auxPlugInUnitFroMao.getProductionDateFroMao(this.getTxIdNonTransactional(context), 0, this.getAuxPlugInUnitFroId(context));
            }
            catch (MoAccessException e) {
                return "00000000";
            }
        }
        return "00000000";
    }

    public int getSlotPosition(Coordinator context) {
        MessageLog.traceEnter(this.getClass(), "getSlotPosition()<---");
        try {
            ManagedObject mo = this.getParent();
            if (mo instanceof RbsSlotMo) {
                return ((RbsSlotMo)mo).getSlotPosition(context);
            }
            return 0;
        }
        catch (MoAccessException e) {
            return 0;
        }
    }

    public String getSubrackId(Coordinator context) {
        MessageLog.traceEnter(this.getClass(), "getSubrackId()<---");
        try {
            ManagedObject mo = this.getParent();
            if (mo.getType().equals("RbsSlot")) {
                if ((mo = mo.getParent()).getType().equals("McpaSubrack")) {
                    return ((McpaSubrackMo)mo).getSubrackPosition(context);
                }
                if (mo.getType().equals("PowerSupplySubrack")) {
                    return ((PowerSupplySubrackMo)mo).getSubrackPosition(context);
                }
                if (mo.getType().equals("RbsSubrack")) {
                    return ((RbsSubrackMo)mo).getSubrackPosition(context);
                }
            } else {
                if (mo.getType().equals("Subrack")) {
                    return ((SubrackMo)mo).getSubrackPosition(context);
                }
                if (mo.getType().equals("CuSubrack")) {
                    return ((CuSubrackMo)mo).getSubrackPosition(context);
                }
                if (mo.getType().equals("McpaSubrack")) {
                    return ((McpaSubrackMo)mo).getSubrackPosition(context);
                }
                if (mo.getType().equals("PowerSupplySubrack")) {
                    return ((PowerSupplySubrackMo)mo).getSubrackPosition(context);
                }
            }
            return "";
        }
        catch (MoAccessException e) {
            return "";
        }
    }

    public MoData getMyMoData() {
        MessageLog.traceEnter(this.getClass(), "getMyMoData()");
        return this.myData;
    }

    public boolean isMyMoDataPersistent() {
        MessageLog.traceEnter(this.getClass(), "isMyMoDataPersistent()");
        return true;
    }

    public void actionRemoveDisabledPrograms(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "actionRemoveDisabledPrograms()");
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
        MoIterator moIter = this.getChildren();
        while (moIter.hasMoreElements()) {
            ManagedObject mo = moIter.nextMo();
            if (mo.getType().equals("RetuDeviceGroup") || DeviceGroupMoImpl.checkIfMoIsGenericDeviceGroupOfType(mo, "RETU")) {
                MessageLog.trace(2, this.getClass(), "aux units(Retu) without loadable software shall not be upgradable");
                return;
            }
            MessageLog.trace(2, this.getClass(), "aux units with loadable software shall be upgradable");
            this.auxPiuSwUpgradeHandler.removeDisabledPrograms(context);
        }
    }

    public void actionRestart(int restartCause, int restartRank, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "actionRestart()");
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
        this.actionRestartAuxUnit(context);
    }

    public void hwMismatchCeaseReceived() throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "hwMismatchCeaseReceived()");
        this.generateEvent1(null);
        this.ceaseInternalAlarm(null);
        this.auxPiuHwUpgradeHandler.hwMismatchCeaseReceived();
    }

    public void reconfigureProgAfterHwUpgradeRetry(String hwProductNumber, String hwProductRevision, String hwProductName, String preInstalledSwProdNum, String preInstalledSwProdRev, int noOfTry) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "reconfigureProgAfterHwUpgradeRetry()<---");
        this.auxPiuHwUpgradeHandler.reconfigureProgAfterHwUpgradeRetry(hwProductNumber, hwProductRevision, hwProductName, preInstalledSwProdNum, preInstalledSwProdRev, noOfTry);
    }

    public void actionReconfigureProgramPrepare(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "actionReconfigureProgramPrepare()<---");
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
        if (AuxPlugInUnitAttributesChecker.isUpgradeablePlugInUnit(this, context)) {
            if (!AuxPlugInUnitUpgradeHelper.hasSwAllocation(this, context)) {
                MessageLog.info(this.getClass(), "incomplete configuration found: loadable AuxPlugInUnit has no SwAllocation: " + this.toString());
                if (this.getAdministrativeState(context) == 0) {
                    MessageLog.info(this.getClass(), "admin state is LOCKED and there is no SwAllocation, do not attempt to load software for: " + this.toString());
                    return;
                }
            }
            this.auxPiuSwUpgradeHandler.reconfigureProgramPrepare(context);
        }
    }

    public void setPiuTypeForSwUpgrade(ManagedObject piuType, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setPiuTypeForSwUpgrade()");
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
        ReferenceAttribute refAttr = (ReferenceAttribute)this.myData.getAttribute("piuType");
        refAttr.setValue(piuType);
        if (piuType != null) {
            MessageLog.trace(2, this.getClass(), "piuType != null, sending AVC");
            this.sendAVC("piuType", piuType.getLocalDistinguishedName(), context);
        } else {
            MessageLog.trace(2, this.getClass(), "Warning, piuType = null, sending AVC");
            this.sendAVC("piuType", "PiuType = null", context);
        }
    }

    private void createOptoCommCable(String identity, Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "createOptoCommCable()<---");
        ManagedObject equipmentMO = this.getEquipmentMo();
        OptoCommCableMoImpl.create(equipmentMO, (AttrList)new AttrListImpl(), identity, c);
    }

    private void deleteOptoCommCable(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "deleteOptoCommCable()<---");
        ManagedObject equipmentMO = this.getEquipmentMo();
        if (equipmentMO != null) {
            MoIterator iter = equipmentMO.getChildren();
            while (iter.hasMoreElements()) {
                ManagedObject aMo = iter.nextMo();
                if (aMo == null || !aMo.getType().equals("OptoCommCable")) continue;
                ((OptoCommCableMo)aMo).deleteOptoCommCable(c);
                break;
            }
        }
    }

    private ManagedObject getEquipmentMo() {
        ManagedObject rootMo = MibMgr.instance().getMib().getRootMo();
        MoIterator iter = rootMo.getChildren();
        while (iter.hasMoreElements()) {
            ManagedObject aMo = iter.nextMo();
            if (aMo == null || !aMo.getType().equals("Equipment")) continue;
            return aMo;
        }
        return null;
    }

    private void initMoData(ManagedObject parent, ManagedObject source, String identity, String userLabel, int adminState, boolean isSharedWithExternalMe, int operState, int availStatus, int shutDownTimer, int auType, ManagedObject piuType, ManagedObject plugInUnitRef1, ManagedObject plugInUnitRef2, int alarmStatus, int hubPosition, String uniqueHwId, int position, String positionInformation, ManagedObject positionRef, Struct positionCoordinates, ManagedObject[] supportUnitRef, AttrList attributes, Coordinator context) throws MoAccessException, TransactionRequiredException, AttrMissingAtCreateException, WrongAttributeTypeException, NotHandledAttributeTypeException, ValueOutOfRangeException {
        MessageLog.trace(1, this.getClass(), "initMoData()");
        this.myData = new MoData(this.getLocalDistinguishedName(), "AuxPlugInUnit", true, context);
        int piuFroId1 = 0;
        int piuFroId2 = -1;
        if (plugInUnitRef1 != null) {
            ManagedObject moRef = plugInUnitRef1;
            switch (auType) {
                case 5: 
                case 7: 
                case 10: 
                case 11: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 24: 
                case 25: 
                case 26: 
                case 27: {
                    moRef = AuxPlugInUnitMoImpl.mapPiu2PiuDeviceIfDui(plugInUnitRef1, context);
                    break;
                }
            }
            piuFroId1 = BoamHelper.getPlugInUnitFroId(moRef, context);
        }
        if (plugInUnitRef2 != null) {
            piuFroId2 = BoamHelper.getPlugInUnitFroId(AuxPlugInUnitMoImpl.mapPiu2PiuDeviceIfDui(plugInUnitRef2, context), context);
        }
        int additionalDeviceInfo = 0;
        if (uniqueHwId.equalsIgnoreCase("-")) {
            additionalDeviceInfo = 1;
        }
        int auxPiuFroId = this.auxPlugInUnitFroMao.createAuxPlugInUnit(this.getTxIdTransactional(context), 0, AuxPlugInUnitAttributesChecker.auType2FroObjectType(auType), new int[]{piuFroId1, piuFroId2}, hubPosition, uniqueHwId, AuxPlugInUnitAttributesChecker.checkExternalAntenna(parent, context), AuxPlugInUnitAttributesChecker.getAdditionalInfo(parent, identity, auType, context), auType, this.getSectorAntennaFroId(context), additionalDeviceInfo, EnumConverter.rbsBooleanTConverter(isSharedWithExternalMe));
        this.bcmStoreAndRegisterIntAttribute(AUX_PIU_FRO_ID, auxPiuFroId);
        this.bcmStoreAndRegisterStringAttribute("userLabel", userLabel);
        this.bcmStoreAndRegisterIntAttribute("shutDownTimer", shutDownTimer);
        this.bcmStoreAndRegisterIntAttribute("auType", auType);
        this.bcmStoreAndRegisterReferenceAttribute("piuType", piuType);
        this.bcmStoreAndRegisterReferenceAttribute("plugInUnitRef1", plugInUnitRef1);
        this.bcmStoreAndRegisterReferenceAttribute("plugInUnitRef2", plugInUnitRef2);
        this.bcmStoreAndRegisterIntAttribute("position", position);
        this.bcmStoreAndRegisterStringAttribute("positionInformation", positionInformation);
        this.bcmStoreAndRegisterReferenceAttribute("positionRef", positionRef);
        this.bcmStoreAndRegisterStructAttribute("positionCoordinates", positionCoordinates);
        this.bcmStoreAndRegisterSequenceRefAttribute("supportUnitRef", supportUnitRef);
        ProductRepository.instance().registerHw((HardwareProductData)this);
        this.myData.setRevision(6050401);
        this.initAlarmStatus(alarmStatus, context);
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
    }

    private void bcmStoreAndRegisterStructAttribute(String attrName, Struct positionCoordinates) throws NotHandledAttributeTypeException, NoSuchFieldException, MoNotFoundException {
        int longitude = 0;
        int latitude = 0;
        int altitude = 0;
        String geoDatum = "WGS84";
        StructAttribute positionCoordinateAttr = new StructAttribute(attrName, true);
        if (positionCoordinates.size() > 0) {
            longitude = (Integer)positionCoordinates.getValue("longitude");
            latitude = (Integer)positionCoordinates.getValue("latitude");
            altitude = (Integer)positionCoordinates.getValue("altitude");
            geoDatum = positionCoordinates.getValue("geoDatum").toString();
        }
        positionCoordinateAttr.addElement((Attribute)new IntegerAttribute("altitude", true, altitude));
        positionCoordinateAttr.addElement((Attribute)new StringAttribute("geoDatum", true, geoDatum));
        positionCoordinateAttr.addElement((Attribute)new IntegerAttribute("latitude", true, latitude));
        positionCoordinateAttr.addElement((Attribute)new IntegerAttribute("longitude", true, longitude));
        this.myData.registerPersistentAttr((Attribute)positionCoordinateAttr);
    }

    private void addObservers(int froType, Coordinator context) throws MoAccessException {
        this.myMoAlarms = new MoAlarms((ManagedObject)this, eqcBdhIndProxy, froType, this.getAuxPlugInUnitFroId(context), context);
        this.myMoEvents = new MoEvents(this, eqcBdhIndProxy, this.getAuxPlugInUnitFroId(context), context);
    }

    private void removeObservers(Coordinator context) throws MoAccessException {
        this.myMoAlarms.delete(context);
        this.myMoEvents.delete(context);
    }

    public int getHubPosition(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getHubPosition()<---");
        String hubPosName = this.auxPlugInUnitFroMao.getHubPositionFroMao(this.getTxIdNonTransactional(context), 0, this.getAuxPlugInUnitFroId(context));
        int hubPos = this.convHubPositionNameToInt(hubPosName, context);
        return hubPos;
    }

    private int convHubPositionNameToInt(String hubPosName, Coordinator context) throws MoAccessException {
        Field[] hubPosConsts = AuxPlugInUnitHubPosition.class.getFields();
        for (int f = 0; f < hubPosConsts.length; ++f) {
            String constName = hubPosConsts[f].getName();
            if (!constName.equals(hubPosName)) continue;
            try {
                return hubPosConsts[f].getInt(AuxPlugInUnitHubPosition.class);
            }
            catch (IllegalAccessException iae) {
                return 99;
            }
        }
        return 99;
    }

    public String getUnitType(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getUnitType()<---");
        PiuTypeMo piuType = (PiuTypeMo)this.getPiuType(c);
        Struct prodDataStruct = piuType.getProductData(c);
        return (String)prodDataStruct.getValue("productName");
    }

    public Struct actionReadRepairDelivNote(Coordinator c) throws MoAccessException, RepairDeliveryNoteDoesNotExistException, NoAccessToHwLogException, FunctionNotSupportedException {
        MessageLog.traceEnter(this.getClass(), "actionReadRepairDelivNote()");
        if (!MoHelper.isHwLogActionsAllowed(this, c)) {
            String msg = "The action readRepairDelivNote is not supported for AuxPlugInUnit with auType=" + this.getAuTypeAsString(c);
            throw new FunctionNotSupportedException(msg);
        }
        ManagedObject child = this.getChildren().nextMo();
        if (child instanceof AuxDeviceGroupMo || child instanceof DeviceGroupMo) {
            OperFaultEntryStruct struct = this.readRepairDelivNote(((MaoHasFro)child).getFroId(c), c);
            if (struct == null) {
                return new StructImpl(new String[0], (Object[])new String[0]);
            }
            return struct;
        }
        throw new FunctionNotSupportedException("The action readRepairDelivNote is not supported for " + child.getType());
    }

    public void actionWriteRepairDelivNote(String preparedBy, String countryCode, String stateCode, String descriptionOfFault, String trNumber, String reference, Coordinator c) throws MoAccessException, RepairDeliveryNoteAlreadyExistsException, NoAccessToHwLogException, FunctionNotSupportedException {
        MessageLog.traceEnter(this.getClass(), "actionWriteRepairDelivNote()");
        AccessControlHelper.performAccessControl();
        if (!MoHelper.isHwLogActionsAllowed(this, c)) {
            String msg = "The action writeRepairDelivNote is not supported for AuxPlugInUnit with auType=" + this.getAuTypeAsString(c);
            throw new FunctionNotSupportedException(msg);
        }
        this.checkHwLogString(1, 15, preparedBy, "preparedBy");
        this.checkHwLogString(2, 2, countryCode, "countryCode");
        this.checkHwLogString(1, 1, stateCode, "stateCode");
        this.checkHwLogString(1, 64, descriptionOfFault, "descriptionOfFault");
        this.checkHwLogString(0, 10, trNumber, "trNumber");
        this.checkHwLogString(0, 8, reference, "reference");
        ManagedObject child = this.getChildren().nextMo();
        if (!(child instanceof AuxDeviceGroupMo) && !(child instanceof DeviceGroupMo)) {
            throw new FunctionNotSupportedException("The action writeRepairDelivNote is not supported for " + child.getType());
        }
        int froId = ((MaoHasFro)child).getFroId(c);
        this.writeRepairDelivNote(preparedBy, countryCode, stateCode, descriptionOfFault, trNumber, reference, froId, child, c);
    }

    public static ManagedObject mapPiu2PiuDeviceIfDui(ManagedObject piuMo, Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(AuxPlugInUnitMoImpl.class, "mapPiu2PiuDeviceIfDui()");
        MoIterator iter = BoamHelper.findMOs("DeviceGroup", "DUI", piuMo, 2);
        if (iter.hasMoreElements()) {
            return iter.nextMo().getParent();
        }
        return piuMo;
    }

    private OperFaultEntryStruct readRepairDelivNote(long froId, Coordinator c) throws MoAccessException {
        this.myData.handleTransaction(c, MoData.READ_ACCESS);
        try {
            EqcGetGroupHwLogInfoRspS rspSig = this.eqcDeviceGroupProxy.getGroupHwLogInfo(0L, froId);
            String text = rspSig.freeText;
            StringBuffer freeTextBuf = new StringBuffer(text);
            if (Strings.countNrOfOccurrences(text, ';') > 4) {
                String preparedBy = Strings.extractFirstToken(freeTextBuf, ';');
                String countryCode = Strings.extractFirstToken(freeTextBuf, ';');
                String stateCode = Strings.extractFirstToken(freeTextBuf, ';');
                String descriptionOfFault = Strings.extractFirstToken(freeTextBuf, ';');
                String trNumber = Strings.extractFirstToken(freeTextBuf, ';');
                String reference = Strings.extractFirstToken(freeTextBuf, ';');
                String dateTime = rspSig.dateTime;
                return new OperFaultEntryStruct(countryCode, descriptionOfFault, preparedBy, reference, stateCode, dateTime, trNumber);
            }
            MessageLog.trace(2, this.getClass(), "freeText In getGroupHwLogInfo is not correct");
        }
        catch (FroRequestFailedException e) {
            if (e.getOrgErrorCode() == 22) {
                throw new RepairDeliveryNoteDoesNotExistException();
            }
            if (e.getOrgErrorCode() == 24) {
                throw new NoAccessToHwLogException();
            }
            if (e.getOrgErrorCode() == 25) {
                throw new FunctionNotSupportedException();
            }
            throw e;
        }
        return null;
    }

    private void writeRepairDelivNote(String checkedPreparedBy, String checkedCountryCode, String checkedStateCode, String checkedDescriptionOfFault, String checkedTrNumber, String checkedReference, long froId, ManagedObject deviceGroupMo, Coordinator c) throws MoAccessException, RepairDeliveryNoteAlreadyExistsException, NoAccessToHwLogException {
        this.myData.handleTransaction(c, MoData.READ_ACCESS);
        long logId = 1L;
        String freeText = checkedPreparedBy + ";" + checkedCountryCode + ";" + checkedStateCode + ";" + checkedDescriptionOfFault + ";" + checkedTrNumber + ";" + checkedReference;
        try {
            this.eqcDeviceGroupProxy.updateGroupHwLog(0L, froId, 1L, freeText);
        }
        catch (FroRequestFailedException e) {
            if (e.getOrgErrorCode() == 23) {
                throw new RepairDeliveryNoteAlreadyExistsException();
            }
            if (e.getOrgErrorCode() == 24) {
                throw new NoAccessToHwLogException();
            }
            if (e.getOrgErrorCode() == 25) {
                throw new FunctionNotSupportedException();
            }
            throw e;
        }
        MoHelper.updateHwLogConfig(froId, 0, deviceGroupMo);
    }

    private String getAuTypeAsString(Coordinator c) throws MoAccessException {
        switch (this.getAuType(c)) {
            case 18: {
                return "ARETU";
            }
            case 5: {
                return "ASC";
            }
            case 17: {
                return "ATMAU";
            }
            case 15: {
                return "BFU";
            }
            case 16: {
                return "CLU";
            }
            case 2: {
                return "CU";
            }
            case 3: {
                return "FAN";
            }
            case 13: {
                return "FCU";
            }
            case 27: {
                return "IRU";
            }
            case 28: {
                return "RD";
            }
            case 12: {
                return "FU";
            }
            case 1: {
                return "MCPA";
            }
            case 8: {
                return "PAU";
            }
            case 4: {
                return "PCU";
            }
            case 14: {
                return "PSU";
            }
            case 7: {
                return "RETU";
            }
            case 10: {
                return "RRU";
            }
            case 20: {
                return "RRUW";
            }
            case 11: {
                return "RU";
            }
            case 19: {
                return "RUW";
            }
            case 9: {
                return "SAIU";
            }
            case 6: {
                return "XALM";
            }
            case 24: {
                return "XCU";
            }
            case 25: {
                return "TMF";
            }
        }
        return "(AuType not found)";
    }

    private void checkHwLogString(int minValue, int maxValue, String value, String attrName) throws ValueOutOfRangeException {
        int length = value.length();
        if (length < minValue || length > maxValue) {
            MessageLog.trace(2, this.getClass(), attrName + ":" + value + " is not in range, minValue: " + minValue + ", maxValue: " + maxValue);
            throw new ValueOutOfRangeException(attrName, "AuxPlugInUnit");
        }
        if (Strings.countNrOfOccurrences(value, ';') != 0) {
            MessageLog.trace(2, this.getClass(), attrName + ":" + value + " must not " + "contain the character ';'");
            throw new ValueOutOfRangeException(attrName, "AuxPlugInUnit");
        }
    }

    public String getUniqueHwId(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getUniqueHwId()<---");
        String uniqueHwId = this.auxPlugInUnitFroMao.getUniqueHwId(this.getTxIdNonTransactional(c), 0, this.getAuxPlugInUnitFroId(c));
        return Strings.removeNonPrintableAscii(uniqueHwId);
    }

    public void setUniqueHwId(String value, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setUniqueHwId()");
        if (this.getAuType(context) != 26) {
            throw new AttrNotSettableException((ManagedObject)this, "uniqueHwId");
        }
        AuxPlugInUnitMoImpl.checkTransaction(context);
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
        int externalAntenna = AuxPlugInUnitAttributesChecker.checkExternalAntenna(this, context);
        int aFroId = this.getFroId(context);
        this.auxPlugInUnitFroMao.setUniqueHwId(this.getTxIdTransactional(context), 0, aFroId, externalAntenna, value);
    }

    public int getPosition(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getPosition()");
        return this.bcmGetIntAttribute("position", c);
    }

    public void setPosition(int value, Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setPosition()");
        this.bcmSetIntAttribute("position", value, POSITION_MIN_VALUES, POSITION_MAX_VALUES, "AuxPlugInUnit", c);
        this.sendAVC("position", value, c);
    }

    public String getPositionInformation(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getPositionInformation()");
        return this.bcmGetStringAttribute("positionInformation", c);
    }

    public void setPositionInformation(String value, Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setPrositionInformation()");
        this.bcmSetStringAttribute("positionInformation", value, 0, 255, "AuxPlugInUnit", c);
        this.sendAVC("positionInformation", value, c);
    }

    public ManagedObject getPositionRef(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getPositionRef()");
        return this.bcmGetReferenceAttribute("positionRef", c);
    }

    public void setPositionRef(ManagedObject value, Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setPositionRef()");
        MoIterator iter = this.getChildren();
        ManagedObject child = null;
        String positionRef = "";
        ManagedObject oldRef = this.getPositionRef(c);
        if (value != null) {
            positionRef = value.getLocalDistinguishedName();
        }
        if (iter != null) {
            while (iter.hasMoreElements()) {
                child = iter.nextMo();
                if (child instanceof DeviceGroupMo) {
                    DeviceGroupMo deviceGroup = (DeviceGroupMo)child;
                    deviceGroup.setGrpPiuPositionReq(positionRef, c);
                    continue;
                }
                if (!(child instanceof AuxDeviceGroupMo)) continue;
                AuxDeviceGroupMo auxDeviceGroup = (AuxDeviceGroupMo)child;
                auxDeviceGroup.setGrpPiuPositionReq(positionRef, c);
            }
        }
        if (value != null && oldRef != null && value.getLocalDistinguishedName().equals(oldRef.getLocalDistinguishedName())) {
            MessageLog.trace(2, this.getClass(), "setPositionRef : the old value  and the new vlaue is the same, nothing to change!! mo:" + this.getFullDistinguishedName());
            return;
        }
        if (oldRef != null) {
            ((Reservable)oldRef).release((ManagedObject)this, c);
        }
        if (value != null) {
            ((Reservable)value).reserve((ManagedObject)this, c);
        }
        this.bcmSetReferenceAttribute("positionRef", value, "AuxPlugInUnit", c);
        this.sendAVC("positionRef", value, c);
    }

    public int getFaultIndicator(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getFaultIndicator()");
        if (this.isSupportSystemAvailable(c)) {
            return this.auxPlugInUnitFroMao.getFaultIndicatorFroMao(this.getTxIdNonTransactional(c), 0, this.getAuxPlugInUnitFroId(c));
        }
        return 0;
    }

    public int getMaintenanceIndicator(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getMaintenanceIndicator()");
        if (this.isSupportSystemAvailable(c)) {
            return this.auxPlugInUnitFroMao.getMaintenanceIndicatorFroMao(this.getTxIdNonTransactional(c), 0, this.getAuxPlugInUnitFroId(c));
        }
        return 0;
    }

    public int getOperationalIndicator(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getOperationalIndicator()");
        if (this.isSupportSystemAvailable(c)) {
            return this.auxPlugInUnitFroMao.getOperationalIndicatorFroMao(this.getTxIdNonTransactional(c), 0, this.getAuxPlugInUnitFroId(c));
        }
        return 0;
    }

    private boolean isSupportSystemAvailable(Coordinator c) throws MoAccessException {
        NodeBFunctionMoImpl nodeBFunction = (NodeBFunctionMoImpl)BoamHelper.getFirstMatchingMo("NodeBFunction");
        if (nodeBFunction == null) {
            throw new MoNotFoundException("NodeBFunction");
        }
        return nodeBFunction.getSupportSystemAvailable(c);
    }

    private int getSectorAntennaFroId(Coordinator context) throws MoAccessException {
        int sectorAntennaFroId = -1;
        if (this.getParent() instanceof SectorAntennaMo) {
            sectorAntennaFroId = ((SectorAntennaMo)this.getParent()).getFroId(context);
        } else if (this.getParent() instanceof ExternalAntennaMo) {
            SectorAntennaMo sa = (SectorAntennaMo)((ExternalAntennaMo)this.getParent()).getSectorAntennaRef(context);
            if (sa != null) {
                sectorAntennaFroId = sa.getFroId(context);
            } else {
                String msg = "Could not find SectorAntenna for cascaded ARET";
                MessageLog.traceError(this.getClass(), msg);
                throw new ConfigNotSupportedException(msg);
            }
        }
        return sectorAntennaFroId;
    }

    public Struct[] getSpecialIndicator(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getSpecialIndicator()<----");
        if (this.isSupportSystemAvailable(c)) {
            return this.auxPlugInUnitFroMao.getSpecialIndicatorFroMao(this.getTxIdNonTransactional(c), 0, this.getAuxPlugInUnitFroId(c));
        }
        return new SpecialIndicatorStruct[0];
    }

    public Struct getPositionCoordinates(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getPositionCoordinates()");
        return this.bcmGetStructAttribute("positionCoordinates", c);
    }

    public void setPositionCoordinates(Struct value, Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setPositionCoordinates()");
        ValidateAttributes.checkTransaction(c);
        AuxPlugInUnitMoImpl.validatePosition(value);
        this.bcmSetStructAttribute("positionCoordinates", value, c);
        this.sendAVC("positionCoordinates", value, c);
    }

    private static void validatePosition(Struct value) throws NotHandledAttributeTypeException, NoSuchFieldException, MoNotFoundException, ValueOutOfRangeException {
        if (value.size() > 0) {
            int longitude = (Integer)value.getValue("longitude");
            int latitude = (Integer)value.getValue("latitude");
            int altitude = (Integer)value.getValue("altitude");
            String geoDatum = value.getValue("geoDatum").toString();
            ValidateAttributes.intValueRangeCheck("longitude", longitude, POSITION_COORDINATES__LONGITUDE_MIN_VALUES, POSITION_COORDINATES__LONGITUDE_MAX_VALUES, "AuxPlugInUnit");
            ValidateAttributes.intValueRangeCheck("latitude", latitude, POSITION_COORDINATES__LATITUDE_MIN_VALUES, POSITION_COORDINATES__LATITUDE_MAX_VALUES, "AuxPlugInUnit");
            ValidateAttributes.intValueRangeCheck("altitude", altitude, POSITION_COORDINATES__ALTITUDE_MIN_VALUES, POSITION_COORDINATES__ALTITUDE_MAX_VALUES, "AuxPlugInUnit");
            ValidateAttributes.stringValueRangeCheck("geoDatum", geoDatum, 5, "AuxPlugInUnit");
        }
    }

    public int getFroType() {
        return 49178;
    }

    public void actionResetUnitInstallation(Coordinator c) throws MoAccessException, HwPresentException, NotSupportedException {
        MessageLog.traceEnter(this.getClass(), "actionResetUnitInstallation()");
        AccessControlHelper.performAccessControl();
        if (28 != this.getAuType(c)) {
            throw new NotSupportedException("The action resetUnitInstallation only support Radio Dot.");
        }
        try {
            eqcAuxPiuProxy.resetUnitInstallation(0L, this.getAuxPlugInUnitFroId(c));
        }
        catch (FroRequestFailedException e) {
            int errorCode = e.getOrgErrorCode();
            String exceptionCauseTag = ErrorCodeMapper.getExceptionTag_RbsErrorCodeT(errorCode);
            String errorInfo = "The action resetUnitInstallation failed due to the error " + exceptionCauseTag + "[errorCode=" + errorCode + "].";
            switch (errorCode) {
                case 25: {
                    throw new NotSupportedException(errorInfo);
                }
                case 11: {
                    throw new HwPresentException(errorInfo);
                }
            }
            throw e;
        }
    }

    public ManagedObject[] getSupportUnitRef(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getSupportUnitRef() ");
        this.myData.handleTransaction(c, MoData.READ_ACCESS);
        return this.bcmGetMoRefSequenceAttribute("supportUnitRef", c);
    }

    public ManagedObject[] getReservedBy(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getReservedBy()");
        ManagedObject[] reservedBy = super.getReservedBy(context);
        if (reservedBy.length == 0 && this.isReserved(context)) {
            this.myData.handleTransaction(context, MoData.READ_ACCESS);
            SequenceAttribute celloReservers = (SequenceAttribute)this.myData.getAttribute(CELLO_RESERVED_BY);
            ArrayList<ManagedObject> result2 = new ArrayList<ManagedObject>();
            if (celloReservers != null) {
                Enumeration pe = celloReservers.elements();
                while (pe != null && pe.hasMoreElements()) {
                    ReferenceAttribute aRefAttribute = (ReferenceAttribute)pe.nextElement();
                    if (aRefAttribute == null) continue;
                    result2.add(aRefAttribute.getValue(context));
                }
            }
            return result2.toArray(new ManagedObject[result2.size()]);
        }
        return reservedBy;
    }

    public boolean isReserved(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "isReserved()");
        boolean isReserved = super.isReserved(context);
        if (!isReserved) {
            Attribute[] attrList;
            this.myData.handleTransaction(context, MoData.READ_ACCESS);
            SequenceAttribute celloReservers = (SequenceAttribute)this.myData.getAttribute(CELLO_RESERVED_BY);
            if (celloReservers != null && (attrList = celloReservers.getValue(context)) != null) {
                for (int i = 0; i < attrList.length; ++i) {
                    ReferenceAttribute pra = (ReferenceAttribute)attrList[i];
                    if (pra == null) continue;
                    MessageLog.trace(1, this.getClass(), "This MO is reserved by " + pra.getReferenceAsLDN());
                }
            }
            return celloReservers != null && celloReservers.size() != 0;
        }
        return isReserved;
    }

    public synchronized void release(ManagedObject aUser, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "release() " + this.getFullDistinguishedName() + "  " + (aUser == null ? null : aUser.getFullDistinguishedName()));
        super.release(aUser, context);
        if (context != null) {
            this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
            SequenceAttribute celloReservers = (SequenceAttribute)this.myData.getAttribute(CELLO_RESERVED_BY);
            if (celloReservers != null && !celloReservers.isEmpty()) {
                Enumeration e = celloReservers.elements();
                while (e != null && e.hasMoreElements()) {
                    ReferenceAttribute aRefAttribute = (ReferenceAttribute)e.nextElement();
                    if (aRefAttribute == null || !aRefAttribute.getValue(context).equals(aUser)) continue;
                    celloReservers.removeElement((Attribute)aRefAttribute);
                    MessageLog.traceEnter(this.getClass(), "Mo is removed from persistent reservers list");
                    break;
                }
            }
        }
    }

    public boolean getIsSharedWithExternalMe(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getIsSharedWithExternalMe()<---");
        return this.auxPlugInUnitFroMao.getIsSharedWithExternalMeFroMao(this.getTxIdNonTransactional(context), 0, this.getAuxPlugInUnitFroId(context));
    }

    public void setIsSharedWithExternalMe(boolean isSharedWithExternalMe, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setIsSharedWithExternalMe()<---");
        ValidateAttributes.checkTransaction(context);
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
        this.auxPlugInUnitFroMao.setIsSharedWithExternalMeFroMao(this.getTxIdTransactional(context), 0, this.getAuxPlugInUnitFroId(context), isSharedWithExternalMe);
        this.sendAVC("isSharedWithExternalMe", isSharedWithExternalMe, context);
    }
}

