/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.mao.dmo.power;

import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MibMgr;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoFilter;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.MoRepository;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.mao.common.MoTypeFilter;
import se.ericsson.wcdma.rbs.boam.mao.dmo.auxdevice.AuxDeviceMoImpl;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.PowerSupplySystemMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.PsDeviceMo;

public class PsDeviceMoImpl
extends AuxDeviceMoImpl
implements PsDeviceMo {
    public static final int MO_DATA_REVISION = 3020001;

    public PsDeviceMoImpl(ManagedObject parent, String thisMoName, int deviceFroId, String identity, String userLabel, Coordinator context) throws MoAccessException {
        super(parent, thisMoName, 9, deviceFroId, identity, context, userLabel);
        MessageLog.traceEnter(this.getClass(), "Normal constructor");
        int devFroId = this.getAuxDeviceFroId(context);
        ManagedObject elementRef = MibMgr.instance().getMib().getRootMo();
        MoIterator iter = MoRepository.instance().select(elementRef, 2, (MoFilter)new MoTypeFilter("PowerSupplySystem"));
        while (iter.hasMoreElements()) {
            PowerSupplySystemMo poss = (PowerSupplySystemMo)iter.nextMo();
            poss.allocPossDevice(this, devFroId, 9, context);
        }
        int checkedAlarmStatus = 0;
        this.initAlarmStatus(checkedAlarmStatus, context);
        this.myData.setRevision(3020001);
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
        this.addObservers(9, context);
    }

    public PsDeviceMoImpl(MoData recoveredData) throws MoNameAlreadyTakenException {
        super(recoveredData);
        MessageLog.traceEnter(this.getClass(), "Recovery constructor");
        this.myData = recoveredData;
        try {
            this.addObservers(9, null);
        }
        catch (MoAccessException e) {
            MessageLog.traceError(this.getClass(), "Couldn't init the Observers!!");
        }
        MessageLog.trace(1, this.getClass(), "Mo recovered");
    }

    public void npuDelete(Coordinator context, int deviceType) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "npuDelete() ");
        this.deAllocPoss(context);
        super.npuDelete(context, deviceType);
    }

    public void sysDelete(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "sysDelete()");
        this.deAllocPoss(context);
        super.sysDelete(context);
    }

    private void deAllocPoss(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "deAllocPoss()");
        int devFroId = this.getAuxDeviceFroId(context);
        ManagedObject elementRef = MibMgr.instance().getMib().getRootMo();
        MoIterator iter = MoRepository.instance().select(elementRef, 2, (MoFilter)new MoTypeFilter("PowerSupplySystem"));
        while (iter.hasMoreElements()) {
            PowerSupplySystemMo poss = (PowerSupplySystemMo)iter.nextMo();
            poss.deallocPossDevice(this, devFroId, 9, context);
        }
    }

    public String getPsDeviceId(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getPsDeviceId()");
        return this.getIdentity(context);
    }

    public String getType() {
        return "PsDevice";
    }
}

