/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.mao.dmo.tr;

import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.IllegalParentException;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EqcCreateGroupRspS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.RbsGroupFroInfoT;
import se.ericsson.wcdma.rbs.boam.mao.common.ErrorMgr;
import se.ericsson.wcdma.rbs.boam.mao.common.ValidateAttributes;
import se.ericsson.wcdma.rbs.boam.mao.dmo.auxdevice.AuxDeviceGroupMoFactory;
import se.ericsson.wcdma.rbs.boam.mao.dmo.auxdevice.AuxDeviceGroupMoImpl;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.excep.FunctionNotSupportedException;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.AuxPlugInUnitMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.SaiuDeviceGroupMo;

public class SaiuDeviceGroupMoImpl
extends AuxDeviceGroupMoImpl
implements SaiuDeviceGroupMo {
    public static final int MAX_NO_OF_CHILDREN = 1;
    public static final int MO_DATA_REVISION = 2031001;

    public SaiuDeviceGroupMoImpl(MoData recoveredData) throws MoNameAlreadyTakenException {
        super(recoveredData);
        MessageLog.traceEnter(this.getClass(), "SaiuDeviceGroupMoImpl () Recovery constructor <---");
        StringAttribute userLabel = (StringAttribute)recoveredData.getAttribute("userLabel");
        IntegerAttribute froId = (IntegerAttribute)recoveredData.getAttribute("auxGroupFroId");
        IntegerAttribute alarmStatus = (IntegerAttribute)recoveredData.getAttribute("alarmStatus");
        ErrorMgr.shotDownIfNull(userLabel, "userLabel");
        ErrorMgr.shotDownIfNull(froId, "auxGroupFroId");
        ErrorMgr.shotDownIfNull(alarmStatus, "alarmStatus");
        try {
            this.addObservers(49561, null);
        }
        catch (MoAccessException e) {
            MessageLog.traceError(this.getClass(), "Couldn't init the Observers!!");
        }
        MessageLog.trace(1, this.getClass(), "Mo recovered");
    }

    private SaiuDeviceGroupMoImpl(ManagedObject parent, int checkedAlarmStatus, String userLabel, String identity, Coordinator context) throws MoAccessException {
        super(parent, "SaiuDeviceGroup", identity, context, 1);
        MessageLog.traceEnter(this.getClass(), "SaiuDeviceGroupMoImpl() <---");
        EqcCreateGroupRspS rsp = this.createAuxDeviceGroupResource(parent, 49561, context);
        RbsGroupFroInfoT groupFroInfo = rsp.groupFroInfo;
        int auxGroupFroId = (int)rsp.groupFroInfo.groupFroId;
        this.initMoData(userLabel, auxGroupFroId, context);
        this.initAlarmStatus(checkedAlarmStatus, context);
        AuxDeviceGroupMoFactory.instance(49561).createDeviceGroupMoTree((ManagedObject)this, groupFroInfo, "", context);
        this.addObservers(49561, context);
    }

    public static synchronized ManagedObject create(ManagedObject parent, AttrList attributes, String identity, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(SaiuDeviceGroupMoImpl.class, "create()");
        ValidateAttributes.checkTransaction(context);
        ValidateAttributes.checkParent(parent, "AuxPlugInUnit");
        if (((AuxPlugInUnitMo)parent).getAuType(null) != 9) {
            throw new IllegalParentException("SaiuDeviceGroup");
        }
        int checkedAlarmStatus = SaiuDeviceGroupMoImpl.checkAndGetAlarmStatus(attributes, 0, "SaiuDeviceGroup", context);
        String checkedUserLabel = ValidateAttributes.checkAndGetStringAttribute(attributes, "userLabel", "optional", "", 0, 128, "SaiuDeviceGroup");
        ValidateAttributes.checkOtherAttributes(attributes, "SaiuDeviceGroup");
        return new SaiuDeviceGroupMoImpl(parent, checkedAlarmStatus, checkedUserLabel, identity, context);
    }

    public void actionStartHwTest(String testId, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "actionStartHwTest()");
        throw new FunctionNotSupportedException();
    }

    public String getType() {
        return "SaiuDeviceGroup";
    }

    private void initMoData(String userLabel, int auxGroupFroId, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "initMoData()");
        this.getMyMoData().handleTransaction(context, MoData.WRITE_ACCESS);
        this.bcmStoreAndRegisterStringAttribute("userLabel", userLabel);
        this.bcmStoreAndRegisterIntAttribute("auxGroupFroId", auxGroupFroId);
        this.getMyMoData().setRevision(2031001);
    }
}

