/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.mao.emo.cable;

import se.ericsson.cello.equipment.EquipmentMo;
import se.ericsson.cello.equipment.PlugInUnitMaoi;
import se.ericsson.cello.equipment.PlugInUnitMo;
import se.ericsson.cello.mao.Reservable;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.AttrMissingAtCreateException;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.IllegalParentException;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.MoRemovedException;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.moframework.NotHandledAttributeTypeException;
import se.ericsson.cello.moframework.ReferenceAttribute;
import se.ericsson.cello.moframework.ResourceLockedException;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.moframework.TransactionRequiredException;
import se.ericsson.cello.moframework.UndeletableMoException;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.moframework.WrongAttributeTypeException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.common.FroNotAccessibleException;
import se.ericsson.wcdma.rbs.boam.common.FroRequestFailedException;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.proxies.EqcCableProxy;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.proxies.EqcRrhIndProxy;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EqcCreateCableRspS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EqcGetLoPowTxCableParamRspS;
import se.ericsson.wcdma.rbs.boam.mao.alarm.MoAlarms;
import se.ericsson.wcdma.rbs.boam.mao.bcm.BoamManagedObjectWithAlarms;
import se.ericsson.wcdma.rbs.boam.mao.common.ValidateAttributes;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.AuxPlugInUnitMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.LoPowTxCableMo;

public class LoPowTxCableMoImpl
extends BoamManagedObjectWithAlarms
implements LoPowTxCableMo {
    public static final String LO_POW_TX_CABLE_ID = "LoPowTxCableId";
    public static final String LO_POW_TX_CABLE_FRO_ID = "LoPowTxCableFroId";
    public static final String AIU_PIU_INSTANCE_ID = "aiuPiuInstanceId";
    public static final String MCPA_PIU_FRO_ID = "mcpaPiuFroId";
    public static final int MO_DATA_REVISION = 3010001;
    private EqcCableProxy eqcCableProxy = EqcCableProxy.instance();
    private EqcRrhIndProxy eqcRrhIndProxy = EqcRrhIndProxy.instance();
    private int loPowTxCableFroId;
    private ManagedObject aiuPluginUnitRef;
    private ManagedObject mcpaAuxPluginUnitRef;
    private int mcpaConnector;
    private int aiuConnector;
    private int aiuPiuInstanceId;
    private int mcpaPiuFroId;
    private int dlAttenuation;
    private int electricalDlDelay;
    private String userLabel;
    private IntegerAttribute loPowTxCableFroIdAttr;
    private StringAttribute loPowTxCableIdAttr;
    private ReferenceAttribute aiuPluginUnitRefAttr;
    private ReferenceAttribute mcpaAuxPluginUnitRefAttr;
    private IntegerAttribute dlAttenuationAttr;
    private IntegerAttribute mcpaConnectorAttr;
    private IntegerAttribute aiuConnectorAttr;
    private IntegerAttribute aiuPiuInstanceIdAttr;
    private IntegerAttribute mcpaPiuFroIdAttr;
    private IntegerAttribute electricalDlDelayAttr;
    private StringAttribute userLabelAttr;

    public LoPowTxCableMoImpl(ManagedObject parent, AttrList attributes, String identity, ManagedObject source, Coordinator context) throws MoAccessException {
        super(parent, "LoPowTxCable", identity, context);
        MessageLog.traceEnter(this.getClass(), "LoPowTxCableMoImpl Normal constructor");
        if (!(parent instanceof EquipmentMo)) {
            MessageLog.trace(1, this.getClass(), "Illegal parent");
            throw new IllegalParentException("Expecting EquipmentMo, received:" + parent.getClass().getName());
        }
        this.initMoData(identity, attributes, context);
        this.createRo(context);
        this.addObservers(50153, context);
    }

    public LoPowTxCableMoImpl(MoData recoveredData) throws MoNameAlreadyTakenException {
        super(recoveredData);
        MessageLog.traceEnter(this.getClass(), "LoPowTxCableMoImpl Recovery constructor");
        this.myData = recoveredData;
        this.loPowTxCableFroIdAttr = new IntegerAttribute(LO_POW_TX_CABLE_FRO_ID, false);
        this.loPowTxCableIdAttr = new StringAttribute(LO_POW_TX_CABLE_ID, false);
        this.aiuPluginUnitRefAttr = new ReferenceAttribute("aiuPlugInUnitRef", false);
        this.mcpaAuxPluginUnitRefAttr = new ReferenceAttribute("mcpaAuxPlugInUnitRef", false);
        this.aiuPiuInstanceIdAttr = new IntegerAttribute(AIU_PIU_INSTANCE_ID, false);
        this.mcpaPiuFroIdAttr = new IntegerAttribute(MCPA_PIU_FRO_ID, false);
        this.dlAttenuationAttr = new IntegerAttribute("dlAttenuation", false);
        this.electricalDlDelayAttr = new IntegerAttribute("electricalDlDelay", false);
        this.loPowTxCableFroIdAttr = (IntegerAttribute)recoveredData.getAttribute(LO_POW_TX_CABLE_FRO_ID);
        this.loPowTxCableIdAttr = (StringAttribute)recoveredData.getAttribute(LO_POW_TX_CABLE_ID);
        this.aiuPluginUnitRefAttr = (ReferenceAttribute)recoveredData.getAttribute("aiuPlugInUnitRef");
        this.aiuPiuInstanceIdAttr = (IntegerAttribute)recoveredData.getAttribute(AIU_PIU_INSTANCE_ID);
        this.mcpaAuxPluginUnitRefAttr = (ReferenceAttribute)recoveredData.getAttribute("mcpaAuxPlugInUnitRef");
        this.mcpaPiuFroIdAttr = (IntegerAttribute)recoveredData.getAttribute(MCPA_PIU_FRO_ID);
        this.dlAttenuationAttr = (IntegerAttribute)recoveredData.getAttribute("dlAttenuation");
        this.electricalDlDelayAttr = (IntegerAttribute)recoveredData.getAttribute("electricalDlDelay");
        try {
            this.addObservers(50153, null);
        }
        catch (MoAccessException e) {
            MessageLog.traceError(this.getClass(), "Couldn't init the Observers!!");
        }
        MessageLog.trace(1, this.getClass(), "Mo recovered");
    }

    public static synchronized ManagedObject create(ManagedObject parent, AttrList attributes, String identity, ManagedObject source, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(LoPowTxCableMoImpl.class, "create() ");
        LoPowTxCableMoImpl.checkTransaction(context);
        LoPowTxCableMoImpl createdMo = new LoPowTxCableMoImpl(parent, attributes, identity, source, context);
        return createdMo;
    }

    public void delete(Coordinator context) throws MoAccessException, MoRemovedException, UndeletableMoException {
        MessageLog.traceEnter(this.getClass(), "delete()");
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
        this.loPowTxCableFroIdAttr = (IntegerAttribute)this.myData.getAttribute(LO_POW_TX_CABLE_FRO_ID);
        int loPowTxCableFroId = this.loPowTxCableFroIdAttr.getValue(context);
        this.eqcCableProxy.deleteCable(this.getTxIdTransactional(context), 0, loPowTxCableFroId, 50153);
        this.releaseReservations(context);
        this.removeObservers(context);
        super.delete(context);
        MessageLog.trace(1, this.getClass(), "Mo is Deleted");
    }

    public String getLoPowTxCableId(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getLoPowTxCableId()");
        return super.bcmGetIdentity(this.getLocalDistinguishedName(), context);
    }

    public String getType() {
        return "LoPowTxCable";
    }

    public MoData getMyMoData() {
        MessageLog.traceEnter(this.getClass(), "getMyMoData()");
        return this.myData;
    }

    public boolean isMyMoDataPersistent() {
        MessageLog.traceEnter(this.getClass(), "isMyMoDataPersistent()");
        return true;
    }

    public int getLoPowTxCableFroId(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getLoPowTxCableFroId()");
        this.myData.handleTransaction(context, MoData.READ_ACCESS);
        this.loPowTxCableFroIdAttr = (IntegerAttribute)this.myData.getAttribute(LO_POW_TX_CABLE_FRO_ID);
        this.loPowTxCableFroId = this.loPowTxCableFroIdAttr.getValue(context);
        return this.loPowTxCableFroId;
    }

    public String getUserLabel(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getUserLabel()");
        this.myData.handleTransaction(context, MoData.READ_ACCESS);
        this.userLabelAttr = (StringAttribute)this.myData.getAttribute("userLabel");
        return this.userLabelAttr.getValue(context);
    }

    public void setUserLabel(String value, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setUserLabel() ");
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
        this.bcmSetStringAttribute("userLabel", value, 0, 128, this.getType(), context);
        this.sendAVC("userLabel", value, context);
    }

    public void createRo(Coordinator context) throws MoAccessException, TransactionRequiredException, ResourceLockedException, FroRequestFailedException, FroNotAccessibleException {
        MessageLog.traceEnter(this.getClass(), "createRo()");
        EqcCreateCableRspS rspSig = this.eqcCableProxy.createCable(this.getTxIdTransactional(context), 0L, 50153, 0L, this.aiuPiuInstanceId, this.aiuConnector, this.mcpaPiuFroId, this.mcpaConnector);
        this.loPowTxCableFroId = (int)rspSig.cableFroId;
        this.loPowTxCableFroIdAttr = (IntegerAttribute)this.myData.getAttribute(LO_POW_TX_CABLE_FRO_ID);
        this.loPowTxCableFroIdAttr.setValue(this.loPowTxCableFroId);
        this.setDlAttenuation(this.dlAttenuation, context);
        this.setElectricalDlDelay(this.electricalDlDelay, context);
        MessageLog.trace(1, this.getClass(), " RO is created ");
    }

    public ManagedObject getAiuPlugInUnitRef(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getAiuPlugInUnitRef()");
        this.myData.handleTransaction(context, MoData.READ_ACCESS);
        this.aiuPluginUnitRefAttr = (ReferenceAttribute)this.myData.getAttribute("aiuPlugInUnitRef");
        if (this.aiuPluginUnitRefAttr == null) {
            return null;
        }
        this.aiuPluginUnitRef = this.aiuPluginUnitRefAttr.getValue(context);
        return this.aiuPluginUnitRef;
    }

    public ManagedObject getMcpaAuxPlugInUnitRef(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getMcpaAuxPlugInUnitRef()");
        this.myData.handleTransaction(context, MoData.READ_ACCESS);
        this.mcpaAuxPluginUnitRefAttr = (ReferenceAttribute)this.myData.getAttribute("mcpaAuxPlugInUnitRef");
        if (this.mcpaAuxPluginUnitRefAttr == null) {
            return null;
        }
        this.mcpaAuxPluginUnitRef = this.mcpaAuxPluginUnitRefAttr.getValue(context);
        return this.mcpaAuxPluginUnitRef;
    }

    public int getAiuConnector(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getAiuConnector()");
        this.aiuConnector = this.getAttribute(context, "aiuConnector");
        if (this.aiuConnector == 10) {
            this.aiuConnector = 1;
        } else if (this.aiuConnector == 11) {
            this.aiuConnector = 2;
        }
        return this.aiuConnector;
    }

    public int getAiuPiuInstanceId(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getAiuPiuInstanceId()");
        this.aiuPiuInstanceId = this.getAttribute(context, AIU_PIU_INSTANCE_ID);
        return this.aiuPiuInstanceId;
    }

    public int getMcpaConnector(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getMcpaConnector()");
        this.mcpaConnector = this.getAttribute(context, "mcpaConnector");
        if (this.mcpaConnector == 31) {
            this.mcpaConnector = 1;
        }
        return this.mcpaConnector;
    }

    public int getDlAttenuation(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getDlAttenuation()");
        this.dlAttenuation = this.getAttribute(context, "dlAttenuation");
        return this.dlAttenuation;
    }

    public int getElectricalDlDelay(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getElectricalDlDelay()");
        this.electricalDlDelay = this.getAttribute(context, "electricalDlDelay");
        return this.electricalDlDelay;
    }

    public void setElectricalDlDelay(int value, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setElectricalDlDelay()");
        ValidateAttributes.checkTransaction(context);
        this.getMyMoData().handleTransaction(context, MoData.WRITE_ACCESS);
        ValidateAttributes.intValueRangeCheck("electricalDlDelay", value, ELECTRICAL_DL_DELAY_MIN_VALUES, ELECTRICAL_DL_DELAY_MAX_VALUES, this.getType());
        this.loPowTxCableFroId = this.getLoPowTxCableFroId(context);
        this.eqcCableProxy.setLoPowTxCableParameters(this.getTxIdTransactional(context), 0, this.loPowTxCableFroId, 2, 0, value);
    }

    public void setDlAttenuation(int value, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setDlAttenuation()");
        ValidateAttributes.checkTransaction(context);
        this.getMyMoData().handleTransaction(context, MoData.WRITE_ACCESS);
        ValidateAttributes.intValueRangeCheck("dlAttenuation", value, DL_ATTENUATION_MIN_VALUES, DL_ATTENUATION_MAX_VALUES, this.getType());
        this.loPowTxCableFroId = this.getLoPowTxCableFroId(context);
        this.eqcCableProxy.setLoPowTxCableParameters(this.getTxIdTransactional(context), 0, this.loPowTxCableFroId, 1, value, 0);
    }

    public int getFroId(Coordinator context) {
        MessageLog.traceEnter(this.getClass(), "getFroId()");
        int result2 = 0;
        try {
            this.myData.handleTransaction(context, MoData.READ_ACCESS);
            IntegerAttribute froId = (IntegerAttribute)this.myData.getAttribute(LO_POW_TX_CABLE_FRO_ID);
            result2 = froId == null ? 0 : froId.getValue(context);
        }
        catch (MoAccessException e) {
            MessageLog.info(this.getClass(), "FroId could not be retrieved");
        }
        return result2;
    }

    private void initMoData(String identity, AttrList attributes, Coordinator context) throws MoAccessException, TransactionRequiredException, AttrMissingAtCreateException, WrongAttributeTypeException, NotHandledAttributeTypeException, ValueOutOfRangeException {
        MessageLog.traceEnter(this.getClass(), "initMoData() ");
        this.myData = new MoData(super.getLocalDistinguishedName(), this.getType(), true, context);
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
        this.checkAndSaveLoPowTxCableId(identity);
        this.checkAndSaveAiuPlugInUnitRef(attributes, context);
        this.checkAndSaveAiuPiuInstanceId(attributes, context);
        this.checkAndSaveMcpaAuxPlugInUnitRef(attributes, context);
        this.checkAndSaveMcpaPiuFroId(attributes, context);
        this.checkAndSaveAiuConnector(attributes, context);
        this.checkAndSaveMcpaConnector(attributes, context);
        this.checkAndSaveDlAttenuation(attributes, context);
        this.checkAndSaveElectricalDlDelay(attributes, context);
        this.checkAndSaveUserLabel(attributes, context);
        this.loPowTxCableFroIdAttr = new IntegerAttribute(LO_POW_TX_CABLE_FRO_ID, false);
        this.myData.registerPersistentAttr((Attribute)this.loPowTxCableFroIdAttr);
        int checkedAlarmStatus = ValidateAttributes.checkAndGetIntAttribute(attributes, "alarmStatus", "optional", 0, LoPowTxCableMo.ALARM_STATUS_MIN_VALUES, LoPowTxCableMo.ALARM_STATUS_MAX_VALUES, "LoPowTxCable");
        this.initAlarmStatus(checkedAlarmStatus, context);
        ValidateAttributes.checkOtherAttributes(attributes, "LoPowTxCable");
        this.myData.setRevision(3010001);
    }

    private int getAttribute(Coordinator context, String attributeName) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getAttribute()");
        this.myData.handleTransaction(context, MoData.READ_ACCESS);
        this.loPowTxCableFroId = this.getLoPowTxCableFroId(context);
        EqcGetLoPowTxCableParamRspS rspSig = this.eqcCableProxy.getLoPowTxCableParameters(this.getTxIdNonTransactional(context), 0, this.loPowTxCableFroId);
        if (attributeName.equals("aiuConnector")) {
            return rspSig.aiuConnectorId;
        }
        if (attributeName.equals("mcpaConnector")) {
            return rspSig.mcpaConnectorId;
        }
        if (attributeName.equals(AIU_PIU_INSTANCE_ID)) {
            return (int)rspSig.aiuPiuInstanceId;
        }
        if (attributeName.equals(MCPA_PIU_FRO_ID)) {
            return (int)rspSig.mcpaPiuFroId;
        }
        if (attributeName.equals("dlAttenuation")) {
            return rspSig.dlAttenuation;
        }
        if (attributeName.equals("electricalDlDelay")) {
            return rspSig.electricalDlDelay;
        }
        String msg = "Attribute EqcGetLoPowTxCableParametersRspS." + attributeName + " no such attribute";
        MessageLog.trace(2, this.getClass(), msg);
        throw new NoSuchAttributeException(msg, this.getType());
    }

    private void releaseReservations(Coordinator context) throws MoAccessException, MoRemovedException, UndeletableMoException {
        MessageLog.traceEnter(this.getClass(), "releaseReservations()");
        if (this.getAiuPlugInUnitRef(context) != null) {
            ((Reservable)this.getAiuPlugInUnitRef(context)).release((ManagedObject)this, context);
        }
        if (this.getMcpaAuxPlugInUnitRef(context) != null) {
            ((Reservable)this.getMcpaAuxPlugInUnitRef(context)).release((ManagedObject)this, context);
        }
    }

    private void checkAndSaveLoPowTxCableId(String identity) throws MoAccessException {
        this.loPowTxCableIdAttr = new StringAttribute(LO_POW_TX_CABLE_ID, false);
        this.loPowTxCableIdAttr.setValue(identity);
        this.myData.registerPersistentAttr((Attribute)this.loPowTxCableIdAttr);
    }

    private void checkAndSaveAiuPlugInUnitRef(AttrList attributes, Coordinator context) throws MoAccessException {
        int aiuPluginUnitRefAttrIndex = attributes.indexOf("aiuPlugInUnitRef");
        if (aiuPluginUnitRefAttrIndex == -1) {
            MessageLog.trace(1, this.getClass(), "aiuPluginUnitRef is not included in the attribute list");
            throw new AttrMissingAtCreateException("aiuPlugInUnitRef", this.getType());
        }
        if (!(attributes.getValue(aiuPluginUnitRefAttrIndex) instanceof PlugInUnitMo)) {
            MessageLog.trace(1, this.getClass(), "aiuPluginUnitRef has wrong type");
            throw new WrongAttributeTypeException("aiuPlugInUnitRef", this.getType());
        }
        this.aiuPluginUnitRefAttr = new ReferenceAttribute("aiuPlugInUnitRef", false);
        this.myData.registerPersistentAttr((Attribute)this.aiuPluginUnitRefAttr);
        this.aiuPluginUnitRef = (ManagedObject)attributes.getValue(aiuPluginUnitRefAttrIndex);
        this.aiuPluginUnitRefAttr.setValue(this.aiuPluginUnitRef);
        attributes.removeElementAt(aiuPluginUnitRefAttrIndex);
        ((Reservable)this.aiuPluginUnitRef).reserve((ManagedObject)this, context);
    }

    private void checkAndSaveMcpaAuxPlugInUnitRef(AttrList attributes, Coordinator context) throws MoAccessException {
        int mcpaAuxPluginUnitRefAttrIndex = attributes.indexOf("mcpaAuxPlugInUnitRef");
        if (mcpaAuxPluginUnitRefAttrIndex == -1) {
            MessageLog.trace(1, this.getClass(), "aiuPluginUnitRef is not included in the attribute list");
            throw new AttrMissingAtCreateException("mcpaAuxPlugInUnitRef", this.getType());
        }
        if (!(attributes.getValue(mcpaAuxPluginUnitRefAttrIndex) instanceof AuxPlugInUnitMo)) {
            MessageLog.trace(1, this.getClass(), "mcpaAuxPluginUnitRef has wrong type");
            throw new WrongAttributeTypeException("mcpaAuxPlugInUnitRef", this.getType());
        }
        this.mcpaAuxPluginUnitRefAttr = new ReferenceAttribute("mcpaAuxPlugInUnitRef", false);
        this.myData.registerPersistentAttr((Attribute)this.mcpaAuxPluginUnitRefAttr);
        this.mcpaAuxPluginUnitRef = (ManagedObject)attributes.getValue(mcpaAuxPluginUnitRefAttrIndex);
        this.mcpaAuxPluginUnitRefAttr.setValue(this.mcpaAuxPluginUnitRef);
        attributes.removeElementAt(mcpaAuxPluginUnitRefAttrIndex);
        ((Reservable)this.mcpaAuxPluginUnitRef).reserve((ManagedObject)this, context);
    }

    private void checkAndSaveDlAttenuation(AttrList attributes, Coordinator context) throws MoAccessException {
        int dlAttenuationAttrIndex = attributes.indexOf("dlAttenuation");
        if (dlAttenuationAttrIndex == -1) {
            MessageLog.trace(1, this.getClass(), "dlAttenuation is not included in the attribute list");
            throw new AttrMissingAtCreateException("dlAttenuation", this.getType());
        }
        if (!(attributes.getValue(dlAttenuationAttrIndex) instanceof Integer)) {
            MessageLog.trace(1, this.getClass(), "dlAttenuation has wrong type");
            throw new WrongAttributeTypeException("dlAttenuation", this.getType());
        }
        this.dlAttenuation = (Integer)attributes.getValue(dlAttenuationAttrIndex);
        ValidateAttributes.intValueRangeCheck("dlAttenuation", this.dlAttenuation, DL_ATTENUATION_MIN_VALUES, DL_ATTENUATION_MAX_VALUES, this.getType());
        this.dlAttenuationAttr = new IntegerAttribute("dlAttenuation", false);
        this.myData.registerPersistentAttr((Attribute)this.dlAttenuationAttr);
        this.dlAttenuationAttr.setValue(this.dlAttenuation);
        attributes.removeElementAt(dlAttenuationAttrIndex);
    }

    private void checkAndSaveAiuPiuInstanceId(AttrList attributes, Coordinator context) throws MoAccessException {
        this.aiuPiuInstanceId = ((PlugInUnitMaoi)this.getAiuPlugInUnitRef(context)).getFroId(context);
        this.aiuPiuInstanceIdAttr = new IntegerAttribute(AIU_PIU_INSTANCE_ID, false);
        this.myData.registerPersistentAttr((Attribute)this.aiuPiuInstanceIdAttr);
        this.aiuPiuInstanceIdAttr.setValue(this.aiuPiuInstanceId);
    }

    private void checkAndSaveMcpaPiuFroId(AttrList attributes, Coordinator context) throws MoAccessException {
        this.mcpaPiuFroId = ((AuxPlugInUnitMo)this.getMcpaAuxPlugInUnitRef(context)).getAuxPlugInUnitFroId(context);
        this.mcpaPiuFroIdAttr = new IntegerAttribute(MCPA_PIU_FRO_ID, false);
        this.myData.registerPersistentAttr((Attribute)this.mcpaPiuFroIdAttr);
        this.mcpaPiuFroIdAttr.setValue(this.mcpaPiuFroId);
    }

    private void checkAndSaveElectricalDlDelay(AttrList attributes, Coordinator context) throws MoAccessException {
        int dlDelayAttrIndex = attributes.indexOf("electricalDlDelay");
        if (dlDelayAttrIndex == -1) {
            MessageLog.trace(1, this.getClass(), "dlDelay is not included in the attribute list");
            throw new AttrMissingAtCreateException("electricalDlDelay", this.getType());
        }
        if (!(attributes.getValue(dlDelayAttrIndex) instanceof Integer)) {
            MessageLog.trace(1, this.getClass(), "dlDelay has wrong type");
            throw new WrongAttributeTypeException("electricalDlDelay", this.getType());
        }
        this.electricalDlDelay = (Integer)attributes.getValue(dlDelayAttrIndex);
        ValidateAttributes.intValueRangeCheck("electricalDlDelay", this.electricalDlDelay, ELECTRICAL_DL_DELAY_MIN_VALUES, ELECTRICAL_DL_DELAY_MAX_VALUES, this.getType());
        this.electricalDlDelayAttr = new IntegerAttribute("electricalDlDelay", false);
        this.myData.registerPersistentAttr((Attribute)this.electricalDlDelayAttr);
        this.electricalDlDelayAttr.setValue(this.electricalDlDelay);
        attributes.removeElementAt(dlDelayAttrIndex);
    }

    private void checkAndSaveMcpaConnector(AttrList attributes, Coordinator context) throws MoAccessException {
        int mcpaConnectorAttrIndex = attributes.indexOf("mcpaConnector");
        if (mcpaConnectorAttrIndex == -1) {
            MessageLog.trace(1, this.getClass(), "mcpaConnector is not included in the attribute list");
            throw new AttrMissingAtCreateException("mcpaConnector", this.getType());
        }
        if (!(attributes.getValue(mcpaConnectorAttrIndex) instanceof Integer)) {
            MessageLog.trace(1, this.getClass(), "mcpaConnector has wrong type");
            throw new WrongAttributeTypeException("mcpaConnector", this.getType());
        }
        this.mcpaConnector = (Integer)attributes.getValue(mcpaConnectorAttrIndex);
        if (this.mcpaConnector != 1) {
            String msg = "The attribute mcpaConnector is Out of range" + this.mcpaConnector;
            MessageLog.trace(1, this.getClass(), msg);
            throw new ValueOutOfRangeException(msg, this.getType());
        }
        this.mcpaConnector = 31;
        this.mcpaConnectorAttr = new IntegerAttribute("mcpaConnector", false);
        this.myData.registerPersistentAttr((Attribute)this.mcpaConnectorAttr);
        this.mcpaConnectorAttr.setValue(this.mcpaConnector);
        attributes.removeElementAt(mcpaConnectorAttrIndex);
    }

    private void checkAndSaveAiuConnector(AttrList attributes, Coordinator context) throws MoAccessException {
        int aiuConnectorAttrIndex = attributes.indexOf("aiuConnector");
        if (aiuConnectorAttrIndex == -1) {
            MessageLog.trace(1, this.getClass(), "aiuConnector is not included in the attribute list");
            throw new AttrMissingAtCreateException("aiuConnector", this.getType());
        }
        if (!(attributes.getValue(aiuConnectorAttrIndex) instanceof Integer)) {
            MessageLog.trace(1, this.getClass(), "mcpaConnector has wrong type");
            throw new WrongAttributeTypeException("aiuConnector", this.getType());
        }
        this.aiuConnector = (Integer)attributes.getValue(aiuConnectorAttrIndex);
        if (this.aiuConnector < 1 || this.aiuConnector > 2) {
            String msg = "The attribute aiuConnector is Out of range" + this.aiuConnector;
            MessageLog.trace(1, this.getClass(), msg);
            throw new ValueOutOfRangeException(msg, this.getType());
        }
        if (this.aiuConnector == 1) {
            this.aiuConnector = 10;
        } else if (this.aiuConnector == 2) {
            this.aiuConnector = 11;
        } else {
            String msg = "The attribute aiuConnector is Out of range" + this.aiuConnector;
            MessageLog.trace(1, this.getClass(), msg);
            throw new ValueOutOfRangeException(msg, this.getType());
        }
        this.aiuConnectorAttr = new IntegerAttribute("aiuConnector", false);
        this.myData.registerPersistentAttr((Attribute)this.aiuConnectorAttr);
        this.aiuConnectorAttr.setValue(this.aiuConnector);
        attributes.removeElementAt(aiuConnectorAttrIndex);
    }

    private void checkAndSaveUserLabel(AttrList attributes, Coordinator context) throws MoAccessException {
        int userLabelAttrIndex = attributes.indexOf("userLabel");
        if (userLabelAttrIndex == -1) {
            this.userLabel = "";
        } else {
            this.userLabel = (String)attributes.getValue(userLabelAttrIndex);
            if (this.userLabel.length() > 128) {
                String errMsg = "userLabel has WRONG size ! Expected :128 ; received :" + this.userLabel.length();
                MessageLog.trace(1, this.getClass(), errMsg);
                throw new ValueOutOfRangeException(errMsg, this.getType());
            }
            attributes.removeElementAt(userLabelAttrIndex);
        }
        this.userLabelAttr = new StringAttribute("userLabel", false);
        this.myData.registerPersistentAttr((Attribute)this.userLabelAttr);
        this.userLabelAttr.setValue(this.userLabel);
    }

    private void addObservers(int froType, Coordinator context) throws MoAccessException {
        this.myMoAlarms = new MoAlarms((ManagedObject)this, this.eqcRrhIndProxy, froType, this.getFroId(context), context);
    }

    private void removeObservers(Coordinator context) throws MoAccessException {
        this.myMoAlarms.delete(context);
    }
}

