/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.mao.emo.intf;

import enea.ose.system.InSignal;
import se.ericsson.cello.equipment.PlugInUnitMaoi;
import se.ericsson.cello.equipment.PlugInUnitMo;
import se.ericsson.cello.equipment.SlotMaoi;
import se.ericsson.cello.equipment.SlotMo;
import se.ericsson.cello.equipment.SubrackMaoi;
import se.ericsson.cello.equipment.SubrackMo;
import se.ericsson.cello.faultmanagement.Event;
import se.ericsson.cello.mao.Reservable;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.AttrMissingAtCreateException;
import se.ericsson.cello.moframework.IllegalParentException;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoCanNotBeCreatedException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoFilter;
import se.ericsson.cello.moframework.MoHasChildrenException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.MoRepository;
import se.ericsson.cello.moframework.UndeletableMoException;
import se.ericsson.cello.moframework.WrongAttributeTypeException;
import se.ericsson.cello.productinventory.HardwareProductData;
import se.ericsson.cello.productinventory.ProductRepository;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.common.ServiceNotPublishedException;
import se.ericsson.wcdma.rbs.boam.common.Strings;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.proxies.EqcBbifProxy;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.proxies.EqcBdhIndProxy;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EqcBbifEventIndS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EqcCreateBbifRspS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EqcGetBbifBHwPidRspS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EqcGetBbifParamRspS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.RbsBasicHwPidT;
import se.ericsson.wcdma.rbs.boam.mao.alarm.MoAlarms;
import se.ericsson.wcdma.rbs.boam.mao.bcm.BoamHelper;
import se.ericsson.wcdma.rbs.boam.mao.bcm.BoamManagedObjectWithAlarms;
import se.ericsson.wcdma.rbs.boam.mao.common.AttrListImpl;
import se.ericsson.wcdma.rbs.boam.mao.common.MoTypeFilter;
import se.ericsson.wcdma.rbs.boam.mao.common.ProductDataUtil;
import se.ericsson.wcdma.rbs.boam.mao.common.ValidateAttributes;
import se.ericsson.wcdma.rbs.boam.mao.emo.bb.DownlinkBaseBandPoolMoFactory;
import se.ericsson.wcdma.rbs.boam.mao.emo.bb.DownlinkBaseBandPoolMoImpl;
import se.ericsson.wcdma.rbs.boam.mao.emo.bb.UplinkBaseBandPoolMoFactory;
import se.ericsson.wcdma.rbs.boam.mao.emo.bb.UplinkBaseBandPoolMoImpl;
import se.ericsson.wcdma.rbs.boam.mao.event.MoEvents;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.excep.OperationNotAllowedException;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.BbifBoardMo;

public class BbifBoardMoImpl
extends BoamManagedObjectWithAlarms
implements BbifBoardMo {
    private static final EqcBbifProxy eqcBbifProxy = EqcBbifProxy.instance();
    private static final EqcBdhIndProxy eqcBdhIndProxy = EqcBdhIndProxy.instance();
    private static final String RFIF_DEVICE_GROUP_REF = "rfifDeviceGroupRef";
    private static final String BBIF_FRO_ID = "bbifFroId";
    private static final int BBIF_MAX_NO_OF_CHILDREN = 1;
    public static final int MO_DATA_REVISION = 1020001;
    private MoEvents myMoEvents;

    public BbifBoardMoImpl(ManagedObject parent, String motypeName, String identity, Coordinator context, String checkedUserLabel, ManagedObject checkedRfifPlugInUnitRef, int checkedDlTrafficDelay, int checkedUlTrafficDelay, int checkedDlClockDelay, int checkedUlClockDelay, int checkedAlarmStatus) throws MoAccessException {
        super(parent, motypeName, identity, context, 1);
        MessageLog.traceEnter(this.getClass(), " BbifBoard Normal constructor");
        ManagedObject rfifDeviceGroupRef = null;
        rfifDeviceGroupRef = this.checkPreconditionsGetRfifDeviceGroupRef(checkedRfifPlugInUnitRef, context);
        long piuFroId = ((PlugInUnitMaoi)checkedRfifPlugInUnitRef).getFroId(context);
        SubrackMaoi subrack = (SubrackMaoi)parent.getParent();
        int subrackFroId = subrack.getResourceId(context);
        int slotPosition = ((SlotMo)parent).getSlotNumber(context);
        EqcCreateBbifRspS rspSig = eqcBbifProxy.createBbif(this.getTxIdTransactional(context), 0L, subrackFroId, slotPosition, piuFroId, checkedDlTrafficDelay, checkedUlTrafficDelay, checkedDlClockDelay, checkedUlClockDelay);
        int bbifFroId = (int)rspSig.bbifFroId;
        int poolId = rspSig.bbPoolId;
        this.initMoData(checkedUserLabel, checkedRfifPlugInUnitRef, rfifDeviceGroupRef, bbifFroId, checkedAlarmStatus, context);
        this.addObservers(50352, context);
        if (poolId == 1 || poolId == 2) {
            this.createSystemMos(poolId, 50352, context);
        }
    }

    public BbifBoardMoImpl(MoData recoveredData) throws MoNameAlreadyTakenException {
        super(recoveredData);
        MessageLog.traceEnter(this.getClass(), " BbifBoard Recovery constructor");
        this.myData = recoveredData;
        try {
            this.addObservers(50352, null);
        }
        catch (MoAccessException e) {
            MessageLog.traceError(this.getClass(), "Couldn't init the Observers!!");
        }
        ProductRepository.instance().registerHw((HardwareProductData)this);
        MessageLog.trace(1, this.getClass(), "BbifBoard MO is Restored ");
    }

    public static synchronized ManagedObject create(ManagedObject parent, AttrList attributes, String identity, ManagedObject source, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(BbifBoardMoImpl.class, "create()");
        BbifBoardMoImpl.checkTransaction(context);
        BbifBoardMoImpl.checkParent(parent);
        String checkedUserLabel = ValidateAttributes.checkAndGetStringAttribute(attributes, "userLabel", "optional", "", 0, 128, "BbifBoard");
        ManagedObject checkedRfifPlugInUnitRef = BbifBoardMoImpl.checkAndGetRfifPlugInUnitRef(attributes, context);
        int checkedDlTrafficDelay = ValidateAttributes.checkAndGetIntAttribute(attributes, "dlTrafficDelay", "mandatory", 0, DL_TRAFFIC_DELAY_MIN_VALUES, DL_TRAFFIC_DELAY_MAX_VALUES, "BbifBoard");
        int checkedUlTrafficDelay = ValidateAttributes.checkAndGetIntAttribute(attributes, "ulTrafficDelay", "mandatory", 0, UL_TRAFFIC_DELAY_MIN_VALUES, UL_TRAFFIC_DELAY_MAX_VALUES, "BbifBoard");
        int checkedDlClockDelay = ValidateAttributes.checkAndGetIntAttribute(attributes, "dlClockDelay", "mandatory", 0, DL_CLOCK_DELAY_MIN_VALUES, DL_CLOCK_DELAY_MAX_VALUES, "BbifBoard");
        int checkedUlClockDelay = ValidateAttributes.checkAndGetIntAttribute(attributes, "ulClockDelay", "mandatory", 0, UL_CLOCK_DELAY_MIN_VALUES, UL_CLOCK_DELAY_MAX_VALUES, "BbifBoard");
        int checkedAlarmStatus = ValidateAttributes.checkAndGetIntAttribute(attributes, "alarmStatus", "optional", 0, ALARM_STATUS_MIN_VALUES, ALARM_STATUS_MAX_VALUES, "BbifBoard");
        ValidateAttributes.checkOtherAttributes(attributes, "BbifBoard");
        BbifBoardMoImpl createdMo = new BbifBoardMoImpl(parent, "BbifBoard", identity, context, checkedUserLabel, checkedRfifPlugInUnitRef, checkedDlTrafficDelay, checkedUlTrafficDelay, checkedDlClockDelay, checkedUlClockDelay, checkedAlarmStatus);
        return createdMo;
    }

    public void createSystemMos(int poolId, int rbsGroupType, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "createSystemMos() ");
        ManagedObject parent = null;
        switch (rbsGroupType) {
            case 50352: {
                ManagedObject subrackMo;
                ManagedObject SlotMo2 = this.getParent();
                parent = subrackMo = SlotMo2.getParent();
                AttrListImpl attrList = new AttrListImpl();
                DownlinkBaseBandPoolMoFactory.instance().createSystemMo(parent, attrList, poolId, this, null, context);
                UplinkBaseBandPoolMoFactory.instance().createSystemMo(parent, attrList, poolId, this, null, context);
                break;
            }
            default: {
                MessageLog.traceError(this.getClass(), "Invalid Create attempt, this is a System Created MO : ");
                throw new OperationNotAllowedException();
            }
        }
    }

    public void delete(Coordinator context) throws MoAccessException, MoHasChildrenException {
        MessageLog.traceEnter(this.getClass(), "delete() ");
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
        this.releasePoolReference(context);
        if (super.isReserved(context)) {
            throw new UndeletableMoException((ManagedObject)this);
        }
        eqcBbifProxy.deleteBbif(this.getTxIdTransactional(context), 0L, this.getBbifFroId(context));
        this.releaseReservation("rfifPlugInUnitRef", this.bcmGetReferenceAttribute("rfifPlugInUnitRef", context), context);
        this.removeObservers(context);
        super.delete(context);
        ProductRepository.instance().deregisterHw((HardwareProductData)this);
        MessageLog.trace(1, this.getClass(), "BbifBoard Mo is Deleted ");
    }

    public String getType() {
        return "BbifBoard";
    }

    public void proxiesAvailable() throws ServiceNotPublishedException {
        MessageLog.traceEnter(this.getClass(), "proxiesAvailable()");
    }

    public MoData getMyMoData() {
        MessageLog.traceEnter(this.getClass(), "getMyMoData()");
        return this.myData;
    }

    public boolean isMyMoDataPersistent() {
        MessageLog.traceEnter(this.getClass(), "isMyMoDataPersistent()");
        return true;
    }

    public void eventRaised(InSignal receiveSig) {
        MessageLog.traceEnter(this.getClass(), "eventRaised()");
        if (receiveSig instanceof EqcBbifEventIndS) {
            MessageLog.trace(6, this.getClass(), " EqcBbifEventIndS received ");
            String objectClass = this.getType();
            String managedObjectInstance = this.getFullDistinguishedName();
            String eventType = "0";
            String eventTime = "";
            String additionalText = this.bcmGetMEUserLabel();
            EqcBbifEventIndS recSig = (EqcBbifEventIndS)receiveSig;
            String specificEvent = "";
            if (recSig.bbifEventType != 49156) {
                MessageLog.traceError(this.getClass(), "Unknown event received");
                return;
            }
            specificEvent = this.getType() + "_SuccessfulRecoveryActionPerformedReestablishLink";
            MessageLog.trace(6, this.getClass(), "MO = " + objectClass + " specificEvent = _SuccessfulRecoveryActionPerformedReestablishLink");
            new Event(objectClass, managedObjectInstance, eventType, eventTime, specificEvent, additionalText, null);
        }
    }

    public String getBbifBoardId(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getBbifBoardId()");
        return super.bcmGetIdentity(this.getLocalDistinguishedName(), context);
    }

    public int getBbifFroId(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getBbifFroId()");
        return this.bcmGetIntAttribute(BBIF_FRO_ID, context);
    }

    public int getFroId(Coordinator context) {
        MessageLog.traceEnter(this.getClass(), "getFroId()");
        int froId = 0;
        try {
            froId = this.getBbifFroId(context);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return froId;
    }

    public String getUserLabel(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getUserLabel() ");
        return this.bcmGetStringAttribute("userLabel", context);
    }

    public void setUserLabel(String value, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setUserLabel() ");
        this.bcmSetStringAttribute("userLabel", value, 0, 128, this.getType(), context);
        this.sendAVC("userLabel", value, context);
    }

    public ManagedObject getRfifPlugInUnitRef(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getRfifPlugInUnitRef() ");
        return this.bcmGetReferenceAttribute("rfifPlugInUnitRef", context);
    }

    public int getDlTrafficDelay(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getDlTrafficDelay() ");
        return this.getRoValue("dlTrafficDelay", DL_TRAFFIC_DELAY_MIN_VALUES, DL_TRAFFIC_DELAY_MAX_VALUES, context);
    }

    public int getUlTrafficDelay(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getUlTrafficDelay() ");
        return this.getRoValue("ulTrafficDelay", UL_TRAFFIC_DELAY_MIN_VALUES, UL_TRAFFIC_DELAY_MAX_VALUES, context);
    }

    public int getDlClockDelay(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getDlClockDelay() ");
        return this.getRoValue("dlClockDelay", DL_CLOCK_DELAY_MIN_VALUES, DL_CLOCK_DELAY_MAX_VALUES, context);
    }

    public int getUlClockDelay(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getUlClockDelay() ");
        return this.getRoValue("ulClockDelay", UL_CLOCK_DELAY_MIN_VALUES, UL_CLOCK_DELAY_MAX_VALUES, context);
    }

    private RbsBasicHwPidT getRbsBasicHwPidT(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getRbsBasicHwPidT()");
        this.myData.handleTransaction(context, MoData.READ_ACCESS);
        RbsBasicHwPidT rbsBasicHwPidT = null;
        int bbifFroId = this.getBbifFroId(context);
        EqcGetBbifBHwPidRspS rspSig = eqcBbifProxy.getBbifBHwPid(0L, bbifFroId);
        if (rspSig != null && rspSig.result == 0) {
            rbsBasicHwPidT = rspSig.basicHwPid;
        }
        return rbsBasicHwPidT;
    }

    public String getProductNumber(Coordinator context) {
        MessageLog.traceEnter(this.getClass(), "getProductNumber()");
        String productNumber = "";
        try {
            RbsBasicHwPidT rbsBasicHwPidT = this.getRbsBasicHwPidT(context);
            if (rbsBasicHwPidT != null) {
                productNumber = Strings.removeNonPrintableAscii(rbsBasicHwPidT.hwProductNumber);
            }
        }
        catch (MoAccessException moAccessException) {
            // empty catch block
        }
        return productNumber;
    }

    public String getProductRevision(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getProductRevision()");
        String productRevision = "";
        try {
            RbsBasicHwPidT rbsBasicHwPidT = this.getRbsBasicHwPidT(context);
            if (rbsBasicHwPidT != null) {
                productRevision = Strings.removeNonPrintableAscii(rbsBasicHwPidT.hwProductRevision);
            }
        }
        catch (MoAccessException moAccessException) {
            // empty catch block
        }
        return productRevision;
    }

    public String getProductName(Coordinator context) {
        MessageLog.traceEnter(this.getClass(), "getProductName()");
        String productName = "";
        try {
            RbsBasicHwPidT rbsBasicHwPidT = this.getRbsBasicHwPidT(context);
            if (rbsBasicHwPidT != null) {
                productName = Strings.removeNonPrintableAscii(rbsBasicHwPidT.hwProductName);
            }
        }
        catch (MoAccessException moAccessException) {
            // empty catch block
        }
        return productName;
    }

    public String getProductType(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getProductType()");
        String productType = "HW";
        try {
            RbsBasicHwPidT rbsBasicHwPidT = this.getRbsBasicHwPidT(context);
            if (rbsBasicHwPidT != null) {
                productType = Strings.removeNonPrintableAscii(rbsBasicHwPidT.hwProductType);
            }
        }
        catch (MoAccessException moAccessException) {
            // empty catch block
        }
        return productType;
    }

    public String getProductionDate(Coordinator context) {
        MessageLog.traceEnter(this.getClass(), "getProductionDate()");
        String productionDate = "00000000";
        try {
            RbsBasicHwPidT rbsBasicHwPidT = this.getRbsBasicHwPidT(context);
            if (rbsBasicHwPidT != null) {
                productionDate = ProductDataUtil.verifyDateFormat(rbsBasicHwPidT);
            }
        }
        catch (MoAccessException moAccessException) {
            // empty catch block
        }
        return productionDate;
    }

    public String getSerialNumber(Coordinator context) {
        MessageLog.traceEnter(this.getClass(), "getSerialNumber()");
        String serialNumber = "";
        try {
            RbsBasicHwPidT rbsBasicHwPidT = this.getRbsBasicHwPidT(context);
            if (rbsBasicHwPidT != null) {
                serialNumber = Strings.removeNonPrintableAscii(rbsBasicHwPidT.hwSerialNumber);
            }
        }
        catch (MoAccessException moAccessException) {
            // empty catch block
        }
        return serialNumber;
    }

    public String getRState(Coordinator context) {
        MessageLog.traceEnter(this.getClass(), "getRState()");
        String rState = "";
        try {
            RbsBasicHwPidT rbsBasicHwPidT = this.getRbsBasicHwPidT(context);
            if (rbsBasicHwPidT != null) {
                rState = Strings.removeNonPrintableAscii(rbsBasicHwPidT.hwProductRevision);
            }
        }
        catch (MoAccessException moAccessException) {
            // empty catch block
        }
        return rState;
    }

    public int getSlotPosition(Coordinator context) {
        MessageLog.traceEnter(this.getClass(), "getSlotPosition()");
        try {
            this.myData.handleTransaction(context, MoData.READ_ACCESS);
            ManagedObject mo = this.getParent();
            if (mo instanceof SlotMo) {
                SlotMaoi celloSlot = (SlotMaoi)mo;
                return celloSlot.getSlotPosition(context);
            }
            return 0;
        }
        catch (MoAccessException e) {
            return 0;
        }
    }

    public String getSubrackId(Coordinator context) {
        MessageLog.traceEnter(this.getClass(), "getSubrackId()");
        try {
            ManagedObject parParMo;
            this.myData.handleTransaction(context, MoData.READ_ACCESS);
            ManagedObject parMo = this.getParent();
            if (parMo instanceof SlotMo && (parParMo = parMo.getParent()) instanceof SubrackMo) {
                SubrackMo subrackMo = (SubrackMo)parParMo;
                return subrackMo.getSubrackPosition(context);
            }
            return "";
        }
        catch (MoAccessException e) {
            return "";
        }
    }

    private void releasePoolReference(Coordinator context) throws MoAccessException {
        ManagedObject existingMo;
        MessageLog.trace(1, this.getClass(), "releasePoolReference()");
        MoIterator MoTypeExistsItr = MoRepository.instance().lookupType("DownlinkBaseBandPool");
        if (MoTypeExistsItr != null) {
            while (MoTypeExistsItr.hasMoreElements()) {
                existingMo = MoTypeExistsItr.nextMo();
                ((DownlinkBaseBandPoolMoImpl)existingMo).sysDelete(this, context);
            }
        }
        if ((MoTypeExistsItr = MoRepository.instance().lookupType("UplinkBaseBandPool")) != null) {
            while (MoTypeExistsItr.hasMoreElements()) {
                existingMo = MoTypeExistsItr.nextMo();
                ((UplinkBaseBandPoolMoImpl)existingMo).sysDelete(this, context);
            }
        }
    }

    private static void checkParent(ManagedObject parent) throws IllegalParentException {
        if (parent == null || !(parent instanceof SlotMo)) {
            String msg = " Illegal parent, Expecting SlotMo, received for mo: BbifBoard";
            throw new IllegalParentException(msg);
        }
    }

    private static ManagedObject checkAndGetRfifPlugInUnitRef(AttrList attributes, Coordinator context) throws MoAccessException {
        int index = attributes.indexOf("rfifPlugInUnitRef");
        if (index == -1) {
            throw new AttrMissingAtCreateException("rfifPlugInUnitRef", "BbifBoardMoImpl");
        }
        if (!(attributes.getValue(index) instanceof PlugInUnitMo)) {
            throw new WrongAttributeTypeException("rfifPlugInUnitRef", "BbifBoardMoImpl");
        }
        ManagedObject ref = (ManagedObject)attributes.getValue(index);
        attributes.removeElementAt(index);
        return ref;
    }

    private ManagedObject checkPreconditionsGetRfifDeviceGroupRef(ManagedObject rfifPlugInUnitRef, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "checkPreconditionsGetRfifDeviceGroupRef()");
        ManagedObject iterMoRef = null;
        MoIterator iter = MoRepository.instance().select(rfifPlugInUnitRef, 1, (MoFilter)new MoTypeFilter("RfifDeviceGroup"));
        if (iter.size() == 0) {
            iter = BoamHelper.findMOs("DeviceGroup", "RFIF", rfifPlugInUnitRef, 1);
        }
        if (iter.size() == 0) {
            String msg = "RfifDeviceGroupMo does not exist ) ";
            throw new MoCanNotBeCreatedException(msg);
        }
        while (iter.hasMoreElements()) {
            iterMoRef = iter.nextMo();
        }
        return iterMoRef;
    }

    private void initMoData(String checkedUserLabel, ManagedObject checkedRfifPlugInUnitRef, ManagedObject rfifDeviceGroupRef, int bbifFroId, int checkedAlarmStatus, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "initMoData() ");
        this.myData = new MoData(this.getLocalDistinguishedName(), this.getType(), true, context);
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
        this.bcmStoreAndRegisterStringAttribute("userLabel", checkedUserLabel);
        this.bcmStoreAndRegisterReferenceAttribute("rfifPlugInUnitRef", checkedRfifPlugInUnitRef);
        this.bcmStoreAndRegisterReferenceAttribute(RFIF_DEVICE_GROUP_REF, rfifDeviceGroupRef);
        this.bcmStoreAndRegisterIntAttribute(BBIF_FRO_ID, bbifFroId);
        this.setReservation("rfifPlugInUnitRef", checkedRfifPlugInUnitRef, context);
        this.initAlarmStatus(checkedAlarmStatus, context);
        ProductRepository.instance().registerHw((HardwareProductData)this);
        this.myData.setRevision(1020001);
    }

    private int getRoValue(String type, int[] min, int[] max, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getRoValue() " + type);
        EqcGetBbifParamRspS rspSig = eqcBbifProxy.getBbifParam(this.getTxIdNonTransactional(context), 0L, this.getBbifFroId(context));
        int value = 0;
        if (type.equals("dlTrafficDelay")) {
            value = rspSig.tBbifDl;
        } else if (type.equals("ulTrafficDelay")) {
            value = rspSig.tBbifUl;
        } else if (type.equals("dlClockDelay")) {
            value = rspSig.tcBbifDl;
        } else if (type.equals("ulClockDelay")) {
            value = rspSig.tcBbifUl;
        } else {
            MessageLog.trace(2, this.getClass(), " Fault, should never happen ");
        }
        ValidateAttributes.intValueRangeCheck(type, value, min, max, "BbifBoard");
        return value;
    }

    private void setReservation(String refName, ManagedObject moRef, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setReservation() ");
        if (moRef != null) {
            ((Reservable)moRef).reserve((ManagedObject)this, context);
        } else {
            String msg = refName + " MO to be reserved is missing ";
            MessageLog.traceError(this.getClass(), msg);
        }
    }

    private void releaseReservation(String refName, ManagedObject moRef, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "releaseReservation() ");
        if (moRef != null) {
            ((Reservable)moRef).release((ManagedObject)this, context);
        } else {
            String msg = refName + " MO to be released is missing ";
            MessageLog.traceError(this.getClass(), msg);
        }
    }

    private void addObservers(int froType, Coordinator context) throws MoAccessException {
        this.myMoAlarms = new MoAlarms((ManagedObject)this, eqcBdhIndProxy, froType, this.getBbifFroId(context), context);
        this.myMoEvents = new MoEvents(this, eqcBdhIndProxy, this.getBbifFroId(context), context);
    }

    private void removeObservers(Coordinator context) throws MoAccessException {
        this.myMoAlarms.delete(context);
        this.myMoEvents.delete(context);
    }
}

