/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.mao.emo.power;

import se.ericsson.cello.equipment.EquipmentMo;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.IllegalParentException;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoHasChildrenException;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.UndeletableMoException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.common.ServiceNotPublishedException;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.mao.bcm.BoamManagedObject;
import se.ericsson.wcdma.rbs.boam.mao.common.ValidateAttributes;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.AccuSubrackMo;

public class AccuSubrackMoImpl
extends BoamManagedObject
implements AccuSubrackMo {
    public static final int MO_DATA_REVISION = 1020001;
    private MoData myData;

    public AccuSubrackMoImpl(ManagedObject parent, String motypeName, String identity, Coordinator context, String checkedUserLabel, String checkedSubrackPosition, String checkedCabinetPosition, ManagedObject source) throws MoAccessException {
        super(parent, motypeName, identity, context);
        MessageLog.traceEnter(this.getClass(), " AccuSubrack Normal constructor");
        this.initMoData(checkedUserLabel, checkedSubrackPosition, checkedCabinetPosition, context);
    }

    public AccuSubrackMoImpl(MoData recoveredData) throws MoNameAlreadyTakenException {
        super(recoveredData.getLocalDistinguishedName());
        MessageLog.traceEnter(this.getClass(), " AccuSubrack recovery constructor");
        this.myData = recoveredData;
        MessageLog.trace(1, this.getClass(), "MO is Restored, version Attribute in MoData = " + this.myData.getRevision());
    }

    public static synchronized ManagedObject create(ManagedObject parent, AttrList attributes, String identity, ManagedObject source, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(AccuSubrackMoImpl.class, "create()");
        AccuSubrackMoImpl.checkTransaction(context);
        AccuSubrackMoImpl.checkParent(parent);
        String checkedUserLabel = ValidateAttributes.checkAndGetStringAttribute(attributes, "userLabel", "optional", "", 0, 128, "AccuSubrack");
        String checkedSubrackPosition = ValidateAttributes.checkAndGetStringAttribute(attributes, "subrackPosition", "mandatory", "", Integer.MIN_VALUE, Integer.MAX_VALUE, "AccuSubrack");
        String checkedCabinetPosition = ValidateAttributes.checkAndGetStringAttribute(attributes, "cabinetPosition", "optional", "", 0, 2, "AccuSubrack");
        ValidateAttributes.checkOtherAttributes(attributes, "AccuSubrack");
        AccuSubrackMoImpl createdMo = new AccuSubrackMoImpl(parent, "AccuSubrack", identity, context, checkedUserLabel, checkedSubrackPosition, checkedCabinetPosition, source);
        return createdMo;
    }

    public void delete(Coordinator c) throws MoAccessException, MoHasChildrenException {
        MessageLog.traceEnter(this.getClass(), "delete() ");
        this.myData.handleTransaction(c, MoData.WRITE_ACCESS);
        if (super.isReserved(c)) {
            throw new UndeletableMoException((ManagedObject)this);
        }
        this.myData.delete(c);
        super.delete(c);
        MessageLog.trace(1, this.getClass(), "AccuSubrack Mo is Deleted ");
    }

    public String getType() {
        return "AccuSubrack";
    }

    public void proxiesUnavailable() {
        MessageLog.traceEnter(this.getClass(), "proxiesUnavailable()");
    }

    public void proxiesAvailable() throws ServiceNotPublishedException {
        MessageLog.traceEnter(this.getClass(), "proxiesAvailable()");
    }

    public MoData getMyMoData() {
        MessageLog.traceEnter(this.getClass(), "getMyMoData()");
        return this.myData;
    }

    public boolean isMyMoDataPersistent() {
        MessageLog.traceEnter(this.getClass(), "isMyMoDataPersistent()");
        return true;
    }

    public String getAccuSubrackId(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getAccuSubrackId()");
        return super.bcmGetIdentity(this.getLocalDistinguishedName(), context);
    }

    public String getUserLabel(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getUserLabel() ");
        return this.bcmGetStringAttribute("userLabel", context);
    }

    public void setUserLabel(String value, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setUserLabel() ");
        this.bcmSetStringAttribute("userLabel", value, 0, 128, "AccuSubrack", context);
        this.sendAVC("userLabel", value, context);
    }

    public void setSubrackPosition(String value, Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setSubrackPosition() ");
        this.bcmSetStringAttribute("subrackPosition", value, Integer.MIN_VALUE, Integer.MAX_VALUE, "AccuSubrack", c);
        this.sendAVC("subrackPosition", value, c);
    }

    public String getSubrackPosition(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getSubrackPosition() ");
        return this.bcmGetStringAttribute("subrackPosition", context);
    }

    public void setCabinetPosition(String value, Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setCabinetPosition() ");
        this.bcmSetStringAttribute("cabinetPosition", value, 0, 2, "AccuSubrack", c);
        this.sendAVC("cabinetPosition", value, c);
    }

    public String getCabinetPosition(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getCabinetPosition() ");
        return this.bcmGetStringAttribute("cabinetPosition", context);
    }

    private static void checkParent(ManagedObject parent) throws IllegalParentException {
        if (parent == null || !(parent instanceof EquipmentMo)) {
            String msg = " Illegal parent, Expecting EquipmentMo, received: ";
            throw new IllegalParentException(msg);
        }
    }

    private void initMoData(String checkedUserLabel, String checkedSubrackPosition, String checkedCabinetPosition, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), " initMoData() ");
        this.myData = new MoData(this.getLocalDistinguishedName(), this.getType(), true, context);
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
        this.myData.setRevision(1020001);
        this.bcmStoreAndRegisterStringAttribute("userLabel", checkedUserLabel);
        this.bcmStoreAndRegisterStringAttribute("subrackPosition", checkedSubrackPosition);
        this.bcmStoreAndRegisterStringAttribute("cabinetPosition", checkedCabinetPosition);
    }
}

