/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.mao.emo.power;

import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.IllegalParentException;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoFilter;
import se.ericsson.cello.moframework.MoHasChildrenException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.MoRepository;
import se.ericsson.cello.moframework.MoTypeFilter;
import se.ericsson.cello.moframework.UndeletableMoException;
import se.ericsson.cello.productinventory.HardwareProductData;
import se.ericsson.cello.productinventory.ProductRepository;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.common.MoTypeCheckMoTypeAndIdFilter;
import se.ericsson.wcdma.rbs.boam.common.Strings;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.fpx.common.DefaultFaultDevFroId;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.proxies.EqcBdhIndProxy;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.proxies.EqcDeviceProxy;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EqcGetDeviceBHwPidRspS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.RbsBasicHwPidT;
import se.ericsson.wcdma.rbs.boam.mao.alarm.MoAlarms;
import se.ericsson.wcdma.rbs.boam.mao.bcm.BoamHelper;
import se.ericsson.wcdma.rbs.boam.mao.bcm.BoamManagedObject;
import se.ericsson.wcdma.rbs.boam.mao.bcm.BoamManagedObjectWithAlarms;
import se.ericsson.wcdma.rbs.boam.mao.common.ProductDataUtil;
import se.ericsson.wcdma.rbs.boam.mao.common.ValidateAttributes;
import se.ericsson.wcdma.rbs.boam.mao.dmo.auxdevice.AuxDeviceMoFactory;
import se.ericsson.wcdma.rbs.boam.mao.dmo.auxdevice.AuxDeviceSetMoFactory;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.gmo.GenRbsSlotMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.DeviceGroupMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.PcuDeviceGroupMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.PowerSupplySubrackMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.PsDeviceMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.PsDeviceSetMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.PsuMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.RbsSlotMo;

public class PsuMoImpl
extends BoamManagedObjectWithAlarms
implements PsuMo {
    private static final EqcDeviceProxy eqcDeviceProxy = EqcDeviceProxy.instance();
    private static final EqcBdhIndProxy eqcBdhIndProxy = EqcBdhIndProxy.instance();
    public static final int MO_DATA_REVISION = 274433;
    private static final int CLIENT_ID = 0;
    private ManagedObject pcuDevGrMo = null;
    private ManagedObject psDevSetMo = null;
    private int pcuDevGrFroId = 0;
    private int myFroId = 0;

    public PsuMoImpl(ManagedObject parent, String motypeName, String identity, Coordinator context, String checkedUserLabel, ManagedObject checkedDeviceRef, int checkedAlarmStatus, ManagedObject source) throws MoAccessException {
        super(parent, motypeName, identity, context);
        String slotPositionStr;
        Integer I;
        int slotPos;
        MessageLog.traceEnter(this.getClass(), " Clu Normal constructor");
        ManagedObject pcuDevGr = null;
        ManagedObject psDevSet = null;
        ManagedObject psDevice = null;
        pcuDevGr = this.checkPcuDevGroupExistence(parent, context);
        if (pcuDevGr == null) {
            throw new IllegalParentException(this.getType() + "MaoNotAllocated");
        }
        int deviceFroId = 0;
        int devSetFroId = 0;
        psDevSet = this.checkPsDevSetExistence(pcuDevGr, context);
        if (psDevSet == null) {
            psDevSet = AuxDeviceSetMoFactory.instance(49761).createTheMo(pcuDevGr, devSetFroId, "1", "", context);
        }
        if ((slotPos = (I = new Integer(slotPositionStr = ((RbsSlotMo)parent).getRbsSlotId(context))).intValue()) == 1 && ((PowerSupplySubrackMo)parent.getParent()).getNoOfSlots(null) != 1) {
            String msg = "The first RbsSlot is reserved for PcuDeviceGroup. PSU should be created on RbsSlot 2-7";
            throw new IllegalParentException(msg);
        }
        int psDeviceId = ((PowerSupplySubrackMo)parent.getParent()).getNoOfSlots(null) != 1 ? slotPos - 1 : 3;
        String psDevIdStr = Integer.toString(psDeviceId);
        ManagedObject psDeviceRef = psDevice = AuxDeviceMoFactory.instance(9).createTheMo(psDevSet, deviceFroId, psDevIdStr, "", context);
        this.initMoData(checkedUserLabel, psDeviceRef, checkedAlarmStatus, context);
        ((PsDeviceMo)psDeviceRef).reserve(this, context);
        this.addObservers(49166, context);
        MessageLog.trace(1, this.getClass(), "Psu Mo is Created ");
    }

    public PsuMoImpl(MoData recoveredData) throws MoNameAlreadyTakenException {
        super(recoveredData);
        MessageLog.traceEnter(this.getClass(), " Clu recovery constructor");
        this.myData = recoveredData;
        ProductRepository.instance().registerHw((HardwareProductData)this);
        try {
            this.addObservers(49166, null);
        }
        catch (MoAccessException e) {
            MessageLog.traceError(this.getClass(), "Couldn't init the Observers!!");
        }
        MessageLog.trace(1, this.getClass(), "Psu MO is Restored ");
    }

    public static synchronized ManagedObject create(ManagedObject parent, AttrList attributes, String identity, ManagedObject source, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(PsuMoImpl.class, "create()");
        PsuMoImpl.checkTransaction(context);
        PsuMoImpl.checkParent(parent);
        String checkedUserLabel = ValidateAttributes.checkAndGetStringAttribute(attributes, "userLabel", "optional", "", 0, 128, "Psu");
        ManagedObject psDeviceMoImpl = null;
        int checkedAlarmStatus = ValidateAttributes.checkAndGetIntAttribute(attributes, "alarmStatus", "optional", 0, ALARM_STATUS_MIN_VALUES, ALARM_STATUS_MAX_VALUES, "Psu");
        int nextSlot = PsuMoImpl.nextAvailableSlot(parent, context);
        if (nextSlot != ((RbsSlotMo)parent).getSlotPosition(context)) {
            throw new IllegalParentException("Wrong slot Id");
        }
        ValidateAttributes.checkOtherAttributes(attributes, "Psu");
        PsuMoImpl createdMo = new PsuMoImpl(parent, "Psu", identity, context, checkedUserLabel, psDeviceMoImpl, checkedAlarmStatus, source);
        return createdMo;
    }

    public void delete(Coordinator context) throws MoAccessException, MoHasChildrenException, UndeletableMoException {
        MessageLog.traceEnter(this.getClass(), "delete() ");
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
        ManagedObject parent = this.getParent();
        RbsSlotMo rbsSlot = (RbsSlotMo)parent;
        int slotPosition = rbsSlot.getSlotPosition(context);
        int deleteLastUsedSlot = this.getLastUsedSlot(parent, context);
        if (slotPosition != deleteLastUsedSlot) {
            MessageLog.trace(1, this.getClass(), "The PSU with the higest slot number must be deleted first");
            throw new UndeletableMoException((ManagedObject)this);
        }
        if (GenRbsSlotMo.SLOT_POSITION_MIN_VALUES.length > 1) {
            String msg = "SLOT_POSITION_{MIN|MAX}_VALUES are assumed to be of size 1, but are " + GenRbsSlotMo.SLOT_POSITION_MIN_VALUES.length;
            MessageLog.traceError(this.getClass(), msg);
        }
        if (deleteLastUsedSlot < GenRbsSlotMo.SLOT_POSITION_MIN_VALUES[0] || deleteLastUsedSlot > GenRbsSlotMo.SLOT_POSITION_MAX_VALUES[0]) {
            MessageLog.trace(1, this.getClass(), "The Last used Rbs Slot shoud be between " + GenRbsSlotMo.SLOT_POSITION_MIN_VALUES[0] + " and " + GenRbsSlotMo.SLOT_POSITION_MAX_VALUES[0]);
            throw new UndeletableMoException((ManagedObject)this);
        }
        PsDeviceMo psDeviceRef = (PsDeviceMo)this.getDeviceRef(context);
        PsDeviceSetMo psDevSetRef = (PsDeviceSetMo)psDeviceRef.getParent();
        ((BoamManagedObject)((Object)psDeviceRef)).release(this, context);
        psDeviceRef.npuDelete(context, 9);
        if (BoamHelper.findMOs("Psu").size() == 1) {
            MessageLog.trace(1, this.getClass(), "The Last used Rbs Slot : we must release and delete the corresp. PsDevSet and PsDev ");
            ((BoamManagedObject)((Object)psDevSetRef)).release(this, context);
            psDevSetRef.sysDelete(context);
        }
        this.removeObservers(context);
        this.myData.delete(context);
        super.delete(context);
        ProductRepository.instance().deregisterHw((HardwareProductData)this);
        MessageLog.trace(1, this.getClass(), "Psu Mo is Deleted ");
    }

    public String getType() {
        return "Psu";
    }

    public MoData getMyMoData() {
        MessageLog.traceEnter(this.getClass(), "getMyMoData()");
        return this.myData;
    }

    public boolean isMyMoDataPersistent() {
        MessageLog.traceEnter(this.getClass(), "isMyMoDataPersistent()");
        return true;
    }

    public String getPsuId(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getPsuId()");
        return super.bcmGetIdentity(this.getLocalDistinguishedName(), context);
    }

    public String getUserLabel(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getUserLabel() ");
        return this.bcmGetStringAttribute("userLabel", context);
    }

    public void setUserLabel(String value, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setUserLabel() ");
        this.bcmSetStringAttribute("userLabel", value, 0, 128, "Psu", context);
        this.sendAVC("userLabel", value, context);
    }

    public ManagedObject getDeviceRef(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getDeviceRef()");
        return this.bcmGetReferenceAttribute("deviceRef", context);
    }

    private RbsBasicHwPidT getRbsBasicHwPidT(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getRbsBasicHwPidT()");
        this.myData.handleTransaction(context, MoData.READ_ACCESS);
        RbsBasicHwPidT rbsBasicHwPidT = null;
        EqcGetDeviceBHwPidRspS rspSig = eqcDeviceProxy.getRbsBasicHwPidT(0L, ((PsDeviceMo)this.getDeviceRef(context)).getAuxDeviceFroId(context));
        if (rspSig != null && rspSig.result == 0) {
            rbsBasicHwPidT = rspSig.basicHwPid;
        }
        return rbsBasicHwPidT;
    }

    public String getProductNumber(Coordinator context) {
        MessageLog.traceEnter(this.getClass(), "getProductNumber()");
        String productNumber = "";
        try {
            RbsBasicHwPidT rbsBasicHwPidT = this.getRbsBasicHwPidT(context);
            if (rbsBasicHwPidT != null) {
                productNumber = Strings.removeNonPrintableAscii(rbsBasicHwPidT.hwProductNumber);
            }
        }
        catch (MoAccessException moAccessException) {
            // empty catch block
        }
        return productNumber;
    }

    public String getProductRevision(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getProductRevision()");
        String productRevision = "";
        try {
            RbsBasicHwPidT rbsBasicHwPidT = this.getRbsBasicHwPidT(context);
            if (rbsBasicHwPidT != null) {
                productRevision = Strings.removeNonPrintableAscii(rbsBasicHwPidT.hwProductRevision);
            }
        }
        catch (MoAccessException moAccessException) {
            // empty catch block
        }
        return productRevision;
    }

    public String getProductName(Coordinator context) {
        MessageLog.traceEnter(this.getClass(), "getProductName()");
        String productName = "";
        try {
            RbsBasicHwPidT rbsBasicHwPidT = this.getRbsBasicHwPidT(context);
            if (rbsBasicHwPidT != null) {
                productName = Strings.removeNonPrintableAscii(rbsBasicHwPidT.hwProductName);
            }
        }
        catch (MoAccessException moAccessException) {
            // empty catch block
        }
        return productName;
    }

    public String getProductType(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getProductType()");
        String productType = "HW";
        try {
            RbsBasicHwPidT rbsBasicHwPidT = this.getRbsBasicHwPidT(context);
            if (rbsBasicHwPidT != null) {
                productType = Strings.removeNonPrintableAscii(rbsBasicHwPidT.hwProductType);
            }
        }
        catch (MoAccessException moAccessException) {
            // empty catch block
        }
        return productType;
    }

    public String getProductionDate(Coordinator context) {
        MessageLog.traceEnter(this.getClass(), "getProductionDate()");
        String productionDate = "00000000";
        try {
            RbsBasicHwPidT rbsBasicHwPidT = this.getRbsBasicHwPidT(context);
            if (rbsBasicHwPidT != null) {
                productionDate = ProductDataUtil.verifyDateFormat(rbsBasicHwPidT);
            }
        }
        catch (MoAccessException moAccessException) {
            // empty catch block
        }
        return productionDate;
    }

    public String getSerialNumber(Coordinator context) {
        MessageLog.traceEnter(this.getClass(), "getSerialNumber()");
        String serialNumber = "";
        try {
            RbsBasicHwPidT rbsBasicHwPidT = this.getRbsBasicHwPidT(context);
            if (rbsBasicHwPidT != null) {
                serialNumber = Strings.removeNonPrintableAscii(rbsBasicHwPidT.hwSerialNumber);
            }
        }
        catch (MoAccessException moAccessException) {
            // empty catch block
        }
        return serialNumber;
    }

    public String getRState(Coordinator context) {
        MessageLog.traceEnter(this.getClass(), "getRState()");
        String rState = "";
        try {
            RbsBasicHwPidT rbsBasicHwPidT = this.getRbsBasicHwPidT(context);
            if (rbsBasicHwPidT != null) {
                rState = Strings.removeNonPrintableAscii(rbsBasicHwPidT.hwProductRevision);
            }
        }
        catch (MoAccessException moAccessException) {
            // empty catch block
        }
        return rState;
    }

    public int getSlotPosition(Coordinator context) {
        MessageLog.traceEnter(this.getClass(), "getSlotPosition()");
        try {
            this.myData.handleTransaction(context, MoData.READ_ACCESS);
            ManagedObject mo = this.getParent();
            if (mo instanceof RbsSlotMo) {
                RbsSlotMo rbsSlot = (RbsSlotMo)mo;
                return rbsSlot.getSlotPosition(context);
            }
            return 0;
        }
        catch (MoAccessException e) {
            return 0;
        }
    }

    public String getSubrackId(Coordinator context) {
        MessageLog.traceEnter(this.getClass(), "getSubrackId()");
        try {
            ManagedObject parParMo;
            this.myData.handleTransaction(context, MoData.READ_ACCESS);
            ManagedObject parMo = this.getParent();
            if (parMo instanceof RbsSlotMo && (parParMo = parMo.getParent()) instanceof PowerSupplySubrackMo) {
                PowerSupplySubrackMo psMo = (PowerSupplySubrackMo)parParMo;
                return psMo.getSubrackPosition(context);
            }
            return "";
        }
        catch (MoAccessException e) {
            return "";
        }
    }

    public int getGreenLed(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getGreenLed()");
        return 1;
    }

    public int getRedLed(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getRedLed()");
        return 1;
    }

    public int getYellowLed(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getYellowLed()");
        return 1;
    }

    private static void checkParent(ManagedObject parent) throws IllegalParentException {
        String msg = "";
        if (parent == null) {
            throw new IllegalParentException(msg);
        }
        if (!(parent instanceof RbsSlotMo)) {
            msg = " Illegal parent, Expecting RbsSlotMo, received: " + parent.getClass().getName();
            throw new IllegalParentException(msg);
        }
    }

    private ManagedObject checkPcuDevGroupExistence(ManagedObject parent, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "checkPcuDevGroupExistence()");
        ManagedObject mo = null;
        MoIterator moIter = MoRepository.instance().select(parent.getParent().getParent(), 4, (MoFilter)new MoTypeFilter("PcuDeviceGroup"));
        if (moIter.size() == 0) {
            moIter = MoRepository.instance().select(parent.getParent().getParent(), 5, (MoFilter)new MoTypeCheckMoTypeAndIdFilter("DeviceGroup", "PCU"));
        }
        while (moIter.hasMoreElements()) {
            mo = moIter.nextMo();
            if (mo instanceof PcuDeviceGroupMo) {
                this.pcuDevGrMo = mo;
                this.pcuDevGrFroId = ((PcuDeviceGroupMo)this.pcuDevGrMo).getAuxGroupFroId(context);
                MessageLog.trace(1, this.getClass(), "Psu checkPcuDevGroupExistence() executed pcuDevGrFroId :" + this.pcuDevGrFroId);
            }
            if (!(mo instanceof DeviceGroupMo)) continue;
            this.pcuDevGrMo = mo;
            this.pcuDevGrFroId = ((DeviceGroupMo)this.pcuDevGrMo).getAuxGroupFroId(context);
            MessageLog.trace(1, this.getClass(), "Psu checkPcuDevGroupExistence() executed pcuDevGrFroId :" + this.pcuDevGrFroId);
        }
        return mo;
    }

    private ManagedObject checkPsDevSetExistence(ManagedObject parent, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "checkPsDevSetExistence()");
        MoIterator moIter = MoRepository.instance().select(parent, 1, (MoFilter)new MoTypeFilter("PsDeviceSet"));
        MessageLog.traceEnter(this.getClass(), "checkPsDevSetExistence()" + moIter.size());
        while (moIter.hasMoreElements()) {
            ManagedObject iterMoRef = moIter.nextMo();
            if (!(iterMoRef instanceof PsDeviceSetMo)) continue;
            this.psDevSetMo = iterMoRef;
            MessageLog.trace(1, this.getClass(), "PsDeviceSet MO Is already created . : OK we do not need to create it.");
        }
        return this.psDevSetMo;
    }

    private void initMoData(String checkedUserLabel, ManagedObject psDeviceRef, int checkedAlarmStatus, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "initMoData() ");
        this.myData = new MoData(this.getLocalDistinguishedName(), this.getType(), true, context);
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
        this.bcmStoreAndRegisterStringAttribute("userLabel", checkedUserLabel);
        this.bcmStoreAndRegisterReferenceAttribute("deviceRef", psDeviceRef);
        this.initAlarmStatus(checkedAlarmStatus, context);
        ProductRepository.instance().registerHw((HardwareProductData)this);
        this.myData.setRevision(274433);
    }

    private static int nextAvailableSlot(ManagedObject parent, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(PsuMoImpl.class, "nextAvailableSlot() ");
        int result2 = -1;
        int nrOfSlots = ((PowerSupplySubrackMo)parent.getParent()).getNoOfSlots(context);
        boolean[] slots = new boolean[nrOfSlots];
        MoIterator moIter = BoamHelper.findMOs("Psu", parent.getParent(), 2);
        if (moIter != null) {
            while (moIter.hasMoreElements()) {
                ManagedObject mo = moIter.nextMo();
                int slotPos = ((RbsSlotMo)mo.getParent()).getSlotPosition(context);
                slots[slotPos - 1] = true;
            }
        }
        if (((PowerSupplySubrackMo)parent.getParent()).getNoOfSlots(context) == 1) {
            result2 = 1;
        } else {
            for (int i = 1; i < nrOfSlots; ++i) {
                if (slots[i]) continue;
                result2 = i + 1;
                break;
            }
        }
        MessageLog.trace(1, PsuMoImpl.class, "nextAvailableSlot returned: " + result2);
        return result2;
    }

    private int getLastUsedSlot(ManagedObject parent, Coordinator context) {
        MessageLog.traceEnter(this.getClass(), "getLastUsedSlot() " + parent + " " + context);
        int lastSlot = -1;
        ManagedObject mo = null;
        MoIterator moIter = MoRepository.instance().select(parent.getParent(), 2, (MoFilter)new MoTypeFilter("Psu"));
        while (moIter.hasMoreElements()) {
            mo = moIter.nextMo();
            if (!(mo instanceof PsuMo)) continue;
            int newSlot = 0;
            try {
                newSlot = ((RbsSlotMo)mo.getParent()).getSlotPosition(context);
            }
            catch (MoAccessException e) {
                MessageLog.traceError(this.getClass(), e.toString());
            }
            if (newSlot <= lastSlot) continue;
            lastSlot = newSlot;
        }
        MessageLog.trace(1, this.getClass(), "getLastUsedSlot: " + lastSlot);
        return lastSlot;
    }

    protected void addObservers(int froType, Coordinator context) throws MoAccessException {
        this.myFroId = DefaultFaultDevFroId.getNextNpuFroId();
        this.myMoAlarms = new MoAlarms((ManagedObject)this, eqcBdhIndProxy, froType, this.myFroId, context);
    }

    protected void removeObservers(Coordinator context) throws MoAccessException {
        this.myMoAlarms.delete(context);
    }

    public int getFroId(Coordinator c) {
        MessageLog.traceEnter(this.getClass(), "getFroId()");
        return this.myFroId;
    }
}

