/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.mao.rmo.antenna;

import se.ericsson.cello.mao.IllegalAttributeValueException;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.IllegalParentException;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoHasChildrenException;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.moframework.TransactionRequiredException;
import se.ericsson.cello.moframework.UndeletableMoException;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.common.FroNotAccessibleException;
import se.ericsson.wcdma.rbs.boam.common.FroRequestFailedException;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.proxies.EqcExtTmaProxy;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.proxies.EqcRrhIndProxy;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EqcCreateExtTmaRspS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EqcGetExtTmaParamRspS;
import se.ericsson.wcdma.rbs.boam.mao.alarm.MoAlarms;
import se.ericsson.wcdma.rbs.boam.mao.bcm.BoamManagedObjectWithAlarms;
import se.ericsson.wcdma.rbs.boam.mao.common.MaoHasFro;
import se.ericsson.wcdma.rbs.boam.mao.common.ValidateAttributes;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.excep.ConfigurationNotSupportedException;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.ExternalTmaMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.SectorAntennaMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.SectorMo;

public class ExternalTmaMoImpl
extends BoamManagedObjectWithAlarms
implements ExternalTmaMo {
    private static final String EXT_TMA_FRO_ID = "extTmaFroId";
    private static final int EXT_TMA_MAX_NO_OF_CHILDREN = 1;
    private static final int VALUE_12V = 12;
    private static final int VALUE_30V = 30;
    private static final int VALUE_17V = 17;
    private static final int DUMMY_VALUE = -1;
    private static final int NO_CHANGE_OF_OPTIONAL_PARAMETER = 0;
    private static final int OPTIONAL_PARAMETER_CURRENT_LOW_LIM_A = 1;
    private static final int OPTIONAL_PARAMETER_CURRENT_LOW_LIM_B = 2;
    private static final int OPTIONAL_PARAMETER_CURRENT_HIGH_LIM_A = 3;
    private static final int OPTIONAL_PARAMETER_CURRENT_HIGH_LIM_B = 4;
    private static final int OPTIONAL_PARAMETER_TMA_DEGRADED_SUPPORTED = 5;
    private static final int OPTIONAL_PARAMETER_SUPERVISION_TYPE = 6;
    public static final int MO_DATA_REVISION = 2031001;
    private final EqcRrhIndProxy eqcRrhIndProxy = EqcRrhIndProxy.instance();
    private final EqcExtTmaProxy extTmaProxy = EqcExtTmaProxy.instance();

    public ExternalTmaMoImpl(ManagedObject parent, String motypeName, String identity, Coordinator context, String checkedUserLabel, int checkedInternalPower, int checkedDcVoltage, int checkedDlAttenuation, int checkedUlGain, int checkedDlTrafficDelayA, int checkedDlTrafficDelayB, int checkedUlTrafficDelayA, int checkedUlTrafficDelayB, int checkedAlarmStatus, ManagedObject source) throws MoAccessException {
        super(parent, motypeName, identity, context, 1);
        MessageLog.traceEnter(this.getClass(), " Normal constructor ");
        int sectorFroId = this.getSectorMoRef(context).getSectorFroId(context);
        int sectorAntennaFroId = ((MaoHasFro)parent).getFroId(context);
        this.initMoData(checkedUserLabel, checkedInternalPower, checkedDcVoltage, checkedDlAttenuation, checkedUlGain, checkedDlTrafficDelayA, checkedDlTrafficDelayB, checkedUlTrafficDelayA, checkedUlTrafficDelayB, checkedAlarmStatus, sectorFroId, sectorAntennaFroId, context);
        this.addObservers(47, context);
        MessageLog.trace(1, this.getClass(), " MAO is Created ");
    }

    public ExternalTmaMoImpl(MoData recoveredData) throws MoNameAlreadyTakenException {
        super(recoveredData);
        MessageLog.traceEnter(this.getClass(), " ExternalTmaMoImpl()");
        this.myData = recoveredData;
        try {
            this.addObservers(47, null);
        }
        catch (MoAccessException e) {
            MessageLog.traceError(this.getClass(), "Couldn't init the Observers!!");
        }
        MessageLog.trace(1, this.getClass(), "Mo recovered");
    }

    private SectorMo getSectorMoRef(Coordinator context) throws MoAccessException {
        return (SectorMo)((SectorAntennaMo)this.getParent()).getReservedBy(context)[0];
    }

    private int getBandOfSector(Coordinator context) throws MoAccessException {
        SectorMo sectorMo = this.getSectorMoRef(context);
        if (sectorMo == null) {
            return 0;
        }
        return sectorMo.getBand(context);
    }

    private void checkDeletionPrecondition(Coordinator context) throws MoAccessException {
        if (this.getSectorMoRef(context).isSectorInitialized(context)) {
            MessageLog.trace(1, this.getClass(), "WARNING : Sector is initiated, cannot delete ExternalTma");
            throw new UndeletableMoException((ManagedObject)this);
        }
    }

    public static synchronized ManagedObject create(ManagedObject parent, AttrList attributes, String identity, ManagedObject source, Coordinator context) throws MoAccessException, ConfigurationNotSupportedException {
        MessageLog.traceEnter(ExternalTmaMoImpl.class, " create() ");
        ExternalTmaMoImpl.checkTransaction(context);
        ExternalTmaMoImpl.checkParent(parent);
        String checkedUserLabel = ValidateAttributes.checkAndGetStringAttribute(attributes, "userLabel", "optional", "", 0, 128, "ExternalTma");
        int checkedInternalPower = ValidateAttributes.checkAndGetIntAttribute(attributes, "internalPower", "mandatory", 0, 0, 1, "ExternalTma");
        if (((SectorAntennaMo)parent).hasAtmauDevice() && checkedInternalPower != 1) {
            throw new IllegalAttributeValueException("Dual TMA configuration requires value 1", "internalPower", "ExternalTma");
        }
        int checkedDlAttenuation = ValidateAttributes.checkAndGetIntAttribute(attributes, "dlAttenuation", "mandatory", 0, DL_ATTENUATION_MIN_VALUES, DL_ATTENUATION_MAX_VALUES, "ExternalTma");
        int checkedUlGain = ValidateAttributes.checkAndGetIntAttribute(attributes, "ulGain", "mandatory", 0, UL_GAIN_MIN_VALUES, UL_GAIN_MAX_VALUES, "ExternalTma");
        int checkedDlTrafficDelayA = ValidateAttributes.checkAndGetIntAttribute(attributes, "dlTrafficDelayA", "mandatory", 0, DL_TRAFFIC_DELAY_A_MIN_VALUES, DL_TRAFFIC_DELAY_A_MAX_VALUES, "ExternalTma");
        int checkedDlTrafficDelayB = ValidateAttributes.checkAndGetIntAttribute(attributes, "dlTrafficDelayB", "mandatory", 0, DL_TRAFFIC_DELAY_B_MIN_VALUES, DL_TRAFFIC_DELAY_B_MAX_VALUES, "ExternalTma");
        int checkedUlTrafficDelayA = ValidateAttributes.checkAndGetIntAttribute(attributes, "ulTrafficDelayA", "mandatory", 0, UL_TRAFFIC_DELAY_A_MIN_VALUES, UL_TRAFFIC_DELAY_A_MAX_VALUES, "ExternalTma");
        int checkedUlTrafficDelayB = ValidateAttributes.checkAndGetIntAttribute(attributes, "ulTrafficDelayB", "mandatory", 0, UL_TRAFFIC_DELAY_B_MIN_VALUES, UL_TRAFFIC_DELAY_B_MAX_VALUES, "ExternalTma");
        int checkedAlarmStatus = ValidateAttributes.checkAndGetIntAttribute(attributes, "alarmStatus", "optional", 0, ALARM_STATUS_MIN_VALUES, ALARM_STATUS_MAX_VALUES, "ExternalTma");
        int checkedCurrentLowLimA = ValidateAttributes.checkAndGetIntAttribute(attributes, "currentLowLimA", "optional", 50, CURRENT_LOW_LIM_A_MIN_VALUES, CURRENT_LOW_LIM_A_MAX_VALUES, "ExternalTma");
        int checkedCurrentLowLimB = ValidateAttributes.checkAndGetIntAttribute(attributes, "currentLowLimB", "optional", 50, CURRENT_LOW_LIM_B_MIN_VALUES, CURRENT_LOW_LIM_B_MAX_VALUES, "ExternalTma");
        int checkedCurrentHighLimA = ValidateAttributes.checkAndGetIntAttribute(attributes, "currentHighLimA", "optional", 180, CURRENT_HIGH_LIM_A_MIN_VALUES, CURRENT_HIGH_LIM_A_MAX_VALUES, "ExternalTma");
        int checkedCurrentHighLimB = ValidateAttributes.checkAndGetIntAttribute(attributes, "currentHighLimB", "optional", 180, CURRENT_HIGH_LIM_B_MIN_VALUES, CURRENT_HIGH_LIM_B_MAX_VALUES, "ExternalTma");
        int checkedTmaDegradedSupported = ValidateAttributes.checkAndGetIntAttribute(attributes, "tmaDegradedSupported", "optional", 0, 0, 1, "ExternalTma");
        if (((SectorAntennaMo)parent).hasAtmauDevice() && checkedTmaDegradedSupported != 0) {
            throw new IllegalAttributeValueException("Dual TMA configuration requires value 0", "tmaDegradedSupported", "ExternalTma");
        }
        int checkedSupervisionType = ValidateAttributes.checkAndGetIntAttribute(attributes, "supervisionType", "optional", 0, 0, 1, "ExternalTma");
        int checkedDcVoltage = ValidateAttributes.checkAndGetIntAttribute(attributes, "dcVoltage", "optional", 0, 0, 1, "ExternalTma");
        int valueDcvoltageToEc = 0;
        if (checkedDcVoltage == 1) {
            valueDcvoltageToEc = 12;
        } else if (checkedDcVoltage == 0) {
            valueDcvoltageToEc = 0;
        }
        ValidateAttributes.checkOtherAttributes(attributes, "ExternalTma");
        ExternalTmaMoImpl createdMo = new ExternalTmaMoImpl(parent, "ExternalTma", identity, context, checkedUserLabel, checkedInternalPower, valueDcvoltageToEc, checkedDlAttenuation, checkedUlGain, checkedDlTrafficDelayA, checkedDlTrafficDelayB, checkedUlTrafficDelayA, checkedUlTrafficDelayB, checkedAlarmStatus, source);
        ((ExternalTmaMo)createdMo).setCurrentLowLimA(checkedCurrentLowLimA, context);
        ((ExternalTmaMo)createdMo).setCurrentLowLimB(checkedCurrentLowLimB, context);
        ((ExternalTmaMo)createdMo).setCurrentHighLimA(checkedCurrentHighLimA, context);
        ((ExternalTmaMo)createdMo).setCurrentHighLimB(checkedCurrentHighLimB, context);
        ((ExternalTmaMo)createdMo).setTmaDegradedSupported(checkedTmaDegradedSupported, context);
        ((ExternalTmaMo)createdMo).setSupervisionType(checkedSupervisionType, context);
        MessageLog.trace(1, ExternalTmaMoImpl.class, " MO is Created ");
        return createdMo;
    }

    private static void checkParent(ManagedObject parent) throws IllegalParentException {
        MessageLog.traceEnter(ExternalTmaMoImpl.class, " checkParent() ");
        if (parent == null || !(parent instanceof SectorAntennaMo)) {
            throw new IllegalParentException(" Illegal parent, Expecting SectorAntenna, received!!");
        }
    }

    private void initMoData(String checkedUserLabel, int checkedInternalPower, int checkedDcVoltage, int checkedDlAttenuation, int checkedUlGain, int checkedDlTrafficDelayA, int checkedDlTrafficDelayB, int checkedUlTrafficDelayA, int checkedUlTrafficDelayB, int checkedAlarmStatus, int sectorFroId, int sectorAntennaFroId, Coordinator context) throws MoAccessException, FroRequestFailedException, FroNotAccessibleException {
        MessageLog.traceEnter(this.getClass(), " initMoData() ");
        this.myData = new MoData(super.getLocalDistinguishedName(), this.getType(), true, context);
        this.bcmStoreAndRegisterStringAttribute("userLabel", checkedUserLabel);
        if (this.myData == null) {
            MessageLog.trace(1, this.getClass(), "myData == null  myData == null  myData == null  myData == null  myData == null  myData == null");
        }
        this.initAlarmStatus(checkedAlarmStatus, context);
        int extTmaFroId = this.createRo(context, sectorFroId, sectorAntennaFroId, checkedInternalPower, checkedDcVoltage, checkedDlAttenuation, checkedUlGain, checkedDlTrafficDelayA, checkedDlTrafficDelayB, checkedUlTrafficDelayA, checkedUlTrafficDelayB);
        this.bcmStoreAndRegisterIntAttribute(EXT_TMA_FRO_ID, extTmaFroId);
        this.myData.setRevision(2031001);
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
    }

    private int createRo(Coordinator context, int sectorFroId, int sectorAntennaFroId, int internalPower, int dcVoltage, int dlAttenuation, int ulGain, int dlTrafficDelayA, int dlTrafficDelayB, int ulTrafficDelayA, int ulTrafficDelayB) throws MoAccessException, FroRequestFailedException, FroNotAccessibleException {
        EqcCreateExtTmaRspS cfmSig;
        MessageLog.traceEnter(this.getClass(), " createRo() ");
        try {
            cfmSig = this.extTmaProxy.createExtTma(this.getTxIdTransactional(context), 0, sectorFroId, sectorAntennaFroId, internalPower, dcVoltage, dlAttenuation, ulGain, dlTrafficDelayA, dlTrafficDelayB, ulTrafficDelayA, ulTrafficDelayB);
        }
        catch (FroNotAccessibleException e) {
            super.delete(context);
            throw e;
        }
        catch (FroRequestFailedException e) {
            super.delete(context);
            throw e;
        }
        catch (TransactionRequiredException e) {
            super.delete(context);
            throw e;
        }
        return (int)cfmSig.extTmaFroId;
    }

    public void delete(Coordinator c) throws MoAccessException, MoHasChildrenException {
        MessageLog.traceEnter(this.getClass(), " delete() ");
        this.myData.handleTransaction(c, MoData.WRITE_ACCESS);
        if (super.isReserved(c)) {
            throw new UndeletableMoException((ManagedObject)this);
        }
        this.checkDeletionPrecondition(c);
        this.deleteRo(c);
        this.removeObservers(c);
        this.myData.delete(c);
        super.delete(c);
        MessageLog.trace(1, this.getClass(), " MAO is Deleted ");
    }

    private void deleteRo(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), " deleteRo() ");
        this.extTmaProxy.deleteExtTma(this.getTxIdTransactional(context), 0, this.getExtTmaFroId(context));
    }

    public String getType() {
        return "ExternalTma";
    }

    public String getUserLabel(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), " getUserLabel() ");
        return this.getStringAttribute(context, "userLabel");
    }

    public void setUserLabel(String value, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), " setUserLabel() ");
        this.setStringAttribute(value, context, "userLabel", 128, this.getType());
    }

    public int getInternalPower(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), " getInternalPower() ");
        return this.getRoValue(context, "internalPower");
    }

    public void setInternalPower(int value, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), " setInternalPower() ");
        int transactionId = this.getTxIdNonTransactional(context);
        int extTmaFroId = this.getExtTmaFroId(context);
        ValidateAttributes.intValueRangeCheck("internalPower", value, 0, 1, this.getType());
        if (((SectorAntennaMo)this.getParent()).hasAtmauDevice() && value != 1) {
            throw new IllegalAttributeValueException("Dual TMA configuration requires value 1", "internalPower", "ExternalTma");
        }
        EqcGetExtTmaParamRspS rspSig = this.extTmaProxy.getExtTmaParam(transactionId, 0, extTmaFroId);
        this.extTmaProxy.setExtTmaParam(transactionId, 0, extTmaFroId, value, rspSig.dcVoltage, rspSig.dlAttenuation, rspSig.ulGain, rspSig.dlTrafficDelayA, rspSig.dlTrafficDelayB, rspSig.ulTrafficDelayA, rspSig.ulTrafficDelayB, 0, -1);
        this.sendAVC("internalPower", value, context);
    }

    public int getDlAttenuation(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), " getDlAttenuation() ");
        return this.getRoValue(context, "dlAttenuation");
    }

    public void setDlAttenuation(int value, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), " setDlAttenuation() ");
        int transactionId = this.getTxIdNonTransactional(context);
        int extTmaFroId = this.getExtTmaFroId(context);
        ValidateAttributes.intValueRangeCheck("dlAttenuation", value, DL_ATTENUATION_MIN_VALUES, DL_ATTENUATION_MAX_VALUES, this.getType());
        EqcGetExtTmaParamRspS rspSig = this.extTmaProxy.getExtTmaParam(transactionId, 0, extTmaFroId);
        this.extTmaProxy.setExtTmaParam(transactionId, 0, extTmaFroId, rspSig.internalPower, rspSig.dcVoltage, value, rspSig.ulGain, rspSig.dlTrafficDelayA, rspSig.dlTrafficDelayB, rspSig.ulTrafficDelayA, rspSig.ulTrafficDelayB, 0, -1);
        this.sendAVC("dlAttenuation", value, context);
    }

    public int getUlGain(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), " getUlGain() ");
        return this.getRoValue(context, "ulGain");
    }

    public void setUlGain(int value, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), " setUlGain() ");
        int transactionId = this.getTxIdNonTransactional(context);
        int extTmaFroId = this.getExtTmaFroId(context);
        ValidateAttributes.intValueRangeCheck("ulGain", value, UL_GAIN_MIN_VALUES, UL_GAIN_MAX_VALUES, this.getType());
        EqcGetExtTmaParamRspS rspSig = this.extTmaProxy.getExtTmaParam(transactionId, 0, extTmaFroId);
        this.extTmaProxy.setExtTmaParam(transactionId, 0, extTmaFroId, rspSig.internalPower, rspSig.dcVoltage, rspSig.dlAttenuation, value, rspSig.dlTrafficDelayA, rspSig.dlTrafficDelayB, rspSig.ulTrafficDelayA, rspSig.ulTrafficDelayB, 0, -1);
        this.sendAVC("ulGain", value, context);
    }

    public int getDlTrafficDelayA(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), " getDlTrafficDelayA() ");
        return this.getRoValue(context, "dlTrafficDelayA");
    }

    public void setDlTrafficDelayA(int value, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), " setDlTrafficDelayA() ");
        int transactionId = this.getTxIdNonTransactional(context);
        int extTmaFroId = this.getExtTmaFroId(context);
        ValidateAttributes.intValueRangeCheck("dlTrafficDelayA", value, DL_TRAFFIC_DELAY_A_MIN_VALUES, DL_TRAFFIC_DELAY_A_MAX_VALUES, this.getType());
        EqcGetExtTmaParamRspS rspSig = this.extTmaProxy.getExtTmaParam(transactionId, 0, extTmaFroId);
        this.extTmaProxy.setExtTmaParam(transactionId, 0, extTmaFroId, rspSig.internalPower, rspSig.dcVoltage, rspSig.dlAttenuation, rspSig.ulGain, value, rspSig.dlTrafficDelayB, rspSig.ulTrafficDelayA, rspSig.ulTrafficDelayB, 0, -1);
        this.sendAVC("dlTrafficDelayA", value, context);
    }

    public int getDlTrafficDelayB(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), " getDlTrafficDelayB() ");
        return this.getRoValue(context, "dlTrafficDelayB");
    }

    public void setDlTrafficDelayB(int value, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), " setDlTrafficDelayB() ");
        int transactionId = this.getTxIdNonTransactional(context);
        int extTmaFroId = this.getExtTmaFroId(context);
        ValidateAttributes.intValueRangeCheck("dlTrafficDelayB", value, DL_TRAFFIC_DELAY_B_MIN_VALUES, DL_TRAFFIC_DELAY_B_MAX_VALUES, this.getType());
        EqcGetExtTmaParamRspS rspSig = this.extTmaProxy.getExtTmaParam(transactionId, 0, extTmaFroId);
        this.extTmaProxy.setExtTmaParam(transactionId, 0, extTmaFroId, rspSig.internalPower, rspSig.dcVoltage, rspSig.dlAttenuation, rspSig.ulGain, rspSig.dlTrafficDelayA, value, rspSig.ulTrafficDelayA, rspSig.ulTrafficDelayB, 0, -1);
        this.sendAVC("dlTrafficDelayB", value, context);
    }

    public int getUlTrafficDelayA(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), " getUlTrafficDelayA() ");
        return this.getRoValue(context, "ulTrafficDelayA");
    }

    public void setUlTrafficDelayA(int value, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), " setUlTrafficDelayA() ");
        int transactionId = this.getTxIdNonTransactional(context);
        int extTmaFroId = this.getExtTmaFroId(context);
        ValidateAttributes.intValueRangeCheck("ulTrafficDelayA", value, UL_TRAFFIC_DELAY_A_MIN_VALUES, UL_TRAFFIC_DELAY_A_MAX_VALUES, this.getType());
        EqcGetExtTmaParamRspS rspSig = this.extTmaProxy.getExtTmaParam(transactionId, 0, extTmaFroId);
        this.extTmaProxy.setExtTmaParam(transactionId, 0, extTmaFroId, rspSig.internalPower, rspSig.dcVoltage, rspSig.dlAttenuation, rspSig.ulGain, rspSig.dlTrafficDelayA, rspSig.dlTrafficDelayB, value, rspSig.ulTrafficDelayB, 0, -1);
        this.sendAVC("ulTrafficDelayA", value, context);
    }

    public int getUlTrafficDelayB(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), " getUlTrafficDelayB() ");
        return this.getRoValue(context, "ulTrafficDelayB");
    }

    public void setUlTrafficDelayB(int value, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), " setUlTrafficDelayB() ");
        int transactionId = this.getTxIdNonTransactional(context);
        int extTmaFroId = this.getExtTmaFroId(context);
        ValidateAttributes.intValueRangeCheck("ulTrafficDelayB", value, UL_TRAFFIC_DELAY_B_MIN_VALUES, UL_TRAFFIC_DELAY_B_MAX_VALUES, this.getType());
        EqcGetExtTmaParamRspS rspSig = this.extTmaProxy.getExtTmaParam(transactionId, 0, extTmaFroId);
        this.extTmaProxy.setExtTmaParam(transactionId, 0, extTmaFroId, rspSig.internalPower, rspSig.dcVoltage, rspSig.dlAttenuation, rspSig.ulGain, rspSig.dlTrafficDelayA, rspSig.dlTrafficDelayB, rspSig.ulTrafficDelayA, value, 0, -1);
        this.sendAVC("ulTrafficDelayB", value, context);
    }

    public int getDcVoltage(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getDcVoltage() ");
        int voltageRealValueFromEc = 0;
        voltageRealValueFromEc = this.getRealDcVoltageFromEc(c);
        if (voltageRealValueFromEc == 0 || voltageRealValueFromEc == 17 || voltageRealValueFromEc == 30) {
            return 0;
        }
        return 1;
    }

    public int getRealDcVoltageFromEc(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getRealDcVoltageFromEc() ");
        int voltageRealValueFromEc = 0;
        voltageRealValueFromEc = this.getRoValue(c, "dcVoltage");
        return voltageRealValueFromEc;
    }

    public void setDcVoltage(int value, Coordinator c) throws MoAccessException, ConfigurationNotSupportedException {
        this.setRealDcVoltageToEc(value, c, true);
    }

    public void setRealDcVoltageToEc(int value, Coordinator c, boolean avcFlag) throws MoAccessException, ConfigurationNotSupportedException {
        MessageLog.traceEnter(this.getClass(), " setDcVoltage() ");
        ValidateAttributes.intValueRangeCheck("dcVoltage", value, 0, 1, this.getType());
        int transactionId = this.getTxIdTransactional(c);
        int extTmaFroId = this.getExtTmaFroId(c);
        EqcGetExtTmaParamRspS rspSig = this.extTmaProxy.getExtTmaParam(transactionId, 0, extTmaFroId);
        int voltageValueSendToEc = 0;
        int bandValue = 0;
        bandValue = this.getBandOfSector(c);
        voltageValueSendToEc = value == 1 ? 12 : (bandValue == 0 ? 0 : (bandValue == 1 || bandValue == 4 ? 30 : 17));
        MessageLog.trace(2, this.getClass(), "Send dcvoltage msg to ec proxy. ");
        this.extTmaProxy.setExtTmaParam(transactionId, 0, extTmaFroId, rspSig.internalPower, voltageValueSendToEc, rspSig.dlAttenuation, rspSig.ulGain, rspSig.dlTrafficDelayA, rspSig.dlTrafficDelayB, rspSig.ulTrafficDelayA, rspSig.ulTrafficDelayB, 0, -1);
        if (avcFlag) {
            this.sendAVC("dcVoltage", value, c);
        }
    }

    public int getFroId(Coordinator context) {
        MessageLog.traceEnter(this.getClass(), "getFroId()");
        int froId = 0;
        try {
            froId = this.getExtTmaFroId(context);
        }
        catch (MoAccessException e) {
            MessageLog.trace(2, this.getClass(), "ExtTmaFroId could not be fetched ");
        }
        return froId;
    }

    public MoData getMyMoData() {
        MessageLog.traceEnter(this.getClass(), " getMyMoData() ");
        return this.myData;
    }

    public boolean isMyMoDataPersistent() {
        MessageLog.traceEnter(this.getClass(), " isMyMoDataPersistent() ");
        return true;
    }

    private int getRoValue(Coordinator context, String valueType) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), " getRoValue() " + valueType);
        EqcGetExtTmaParamRspS cfmSig = this.extTmaProxy.getExtTmaParam(this.getTxIdNonTransactional(context), 0, this.getExtTmaFroId(context));
        int receivedValue = 0;
        if (valueType.equals("internalPower")) {
            receivedValue = cfmSig.internalPower;
        } else if (valueType.equals("dlAttenuation")) {
            receivedValue = cfmSig.dlAttenuation;
        } else if (valueType.equals("ulGain")) {
            receivedValue = cfmSig.ulGain;
        } else if (valueType.equals("dlTrafficDelayA")) {
            receivedValue = cfmSig.dlTrafficDelayA;
        } else if (valueType.equals("dlTrafficDelayB")) {
            receivedValue = cfmSig.dlTrafficDelayB;
        } else if (valueType.equals("ulTrafficDelayA")) {
            receivedValue = cfmSig.ulTrafficDelayA;
        } else if (valueType.equals("ulTrafficDelayB")) {
            receivedValue = cfmSig.ulTrafficDelayB;
        } else if (valueType.equals("currentLowLimA")) {
            receivedValue = cfmSig.currentLowLimA;
        } else if (valueType.equals("currentLowLimB")) {
            receivedValue = cfmSig.currentLowLimB;
        } else if (valueType.equals("currentHighLimA")) {
            receivedValue = cfmSig.currentHighLimA;
        } else if (valueType.equals("currentHighLimB")) {
            receivedValue = cfmSig.currentHighLimB;
        } else if (valueType.equals("tmaDegradedSupported")) {
            receivedValue = cfmSig.tmaDegradedSupported;
        } else if (valueType.equals("supervisionType")) {
            receivedValue = cfmSig.supervisionType;
        } else if (valueType.equals("dcVoltage")) {
            receivedValue = cfmSig.dcVoltage;
        } else {
            MessageLog.traceError(this.getClass(), " coding fault, should never happen ");
        }
        return receivedValue;
    }

    private String getStringAttribute(Coordinator context, String attributeName) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), " getStringAttribute() " + attributeName);
        this.myData.handleTransaction(context, MoData.READ_ACCESS);
        StringAttribute attribute = (StringAttribute)this.myData.getAttribute(attributeName);
        return attribute.getValue(context);
    }

    private void setStringAttribute(String value, Coordinator context, String attributeName, int maxLengthRange, String thisTypeName) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), " setStringAttribute() " + attributeName);
        if (value.length() > maxLengthRange) {
            String msg = attributeName + "attribute has value out of range it should be less than = " + Integer.toString(maxLengthRange);
            throw new ValueOutOfRangeException(msg, thisTypeName);
        }
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
        StringAttribute attribute = (StringAttribute)this.myData.getAttribute(attributeName);
        attribute.setValue(value);
        this.sendAVC(attributeName, value, context);
    }

    public int getExtTmaFroId(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), " getExtTmaFroId() ");
        IntegerAttribute attribute = (IntegerAttribute)this.myData.getAttribute(EXT_TMA_FRO_ID);
        return attribute.getValue(context);
    }

    private void addObservers(int froType, Coordinator context) throws MoAccessException {
        this.myMoAlarms = new MoAlarms((ManagedObject)this, this.eqcRrhIndProxy, froType, this.getFroId(context), context);
    }

    private void removeObservers(Coordinator context) throws MoAccessException {
        this.myMoAlarms.delete(context);
    }

    public int getCurrentLowLimA(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), " getCurrentLowLimA() ");
        return this.getRoValue(context, "currentLowLimA");
    }

    public void setCurrentLowLimA(int value, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), " setCurrentLowLimA() ");
        ValidateAttributes.intValueRangeCheck("currentLowLimA", value, CURRENT_LOW_LIM_A_MIN_VALUES, CURRENT_LOW_LIM_A_MAX_VALUES, this.getType());
        this.setOptParamValue(1, value, context);
        this.sendAVC("currentLowLimA", value, context);
    }

    public int getCurrentLowLimB(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), " getCurrentLowLimB() ");
        return this.getRoValue(context, "currentLowLimB");
    }

    public void setCurrentLowLimB(int value, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), " setCurrentLowLimB() ");
        ValidateAttributes.intValueRangeCheck("currentLowLimB", value, CURRENT_LOW_LIM_B_MIN_VALUES, CURRENT_LOW_LIM_B_MAX_VALUES, this.getType());
        this.setOptParamValue(2, value, context);
        this.sendAVC("currentLowLimB", value, context);
    }

    public int getCurrentHighLimA(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), " getCurrentHighLimA() ");
        return this.getRoValue(context, "currentHighLimA");
    }

    public void setCurrentHighLimA(int value, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), " setCurrentHighLimA() ");
        ValidateAttributes.intValueRangeCheck("currentHighLimA", value, CURRENT_HIGH_LIM_A_MIN_VALUES, CURRENT_HIGH_LIM_A_MAX_VALUES, this.getType());
        this.setOptParamValue(3, value, context);
        this.sendAVC("currentHighLimA", value, context);
    }

    public int getCurrentHighLimB(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), " getCurrentHighLimB() ");
        return this.getRoValue(context, "currentHighLimB");
    }

    public void setCurrentHighLimB(int value, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), " setCurrentHighLimB() ");
        ValidateAttributes.intValueRangeCheck("currentHighLimB", value, CURRENT_HIGH_LIM_B_MIN_VALUES, CURRENT_HIGH_LIM_B_MAX_VALUES, this.getType());
        this.setOptParamValue(4, value, context);
        this.sendAVC("currentHighLimB", value, context);
    }

    public int getTmaDegradedSupported(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), " getTmaDegradedSupported() ");
        return this.getRoValue(context, "tmaDegradedSupported");
    }

    public void setTmaDegradedSupported(int value, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), " setTmaDegradedSupported() ");
        ValidateAttributes.intValueRangeCheck("tmaDegradedSupported", value, 0, 1, this.getType());
        if (((SectorAntennaMo)this.getParent()).hasAtmauDevice() && value != 0) {
            throw new IllegalAttributeValueException("Dual TMA configuration requires value 0", "tmaDegradedSupported", "ExternalTma");
        }
        this.setOptParamValue(5, value, context);
        this.sendAVC("tmaDegradedSupported", value, context);
    }

    public boolean isSuitedForDualTma(Coordinator context) throws MoAccessException {
        return this.getInternalPower(context) == 1 && this.getTmaDegradedSupported(context) == 0;
    }

    public int getSupervisionType(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), " getSupervisionType() ");
        return this.getRoValue(c, "supervisionType");
    }

    public void setSupervisionType(int value, Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), " setSupervisionType() ");
        ValidateAttributes.intValueRangeCheck("supervisionType", value, 0, 1, this.getType());
        this.setOptParamValue(6, value, c);
        this.sendAVC("supervisionType", value, c);
    }

    private void setOptParamValue(int validParameter, int value, Coordinator c) throws MoAccessException {
        int transactionId = this.getTxIdNonTransactional(c);
        int extTmaFroId = this.getExtTmaFroId(c);
        EqcGetExtTmaParamRspS rspSig = this.extTmaProxy.getExtTmaParam(transactionId, 0, extTmaFroId);
        this.extTmaProxy.setExtTmaParam(transactionId, 0, extTmaFroId, rspSig.internalPower, rspSig.dcVoltage, rspSig.dlAttenuation, rspSig.ulGain, rspSig.dlTrafficDelayA, rspSig.dlTrafficDelayB, rspSig.ulTrafficDelayA, rspSig.ulTrafficDelayB, validParameter, value);
    }
}

