/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.mao.rmo.antenna;

public class FqBandRanges {
    private static final int[][] fqBandEdges = new int[][]{{0, 0}, {21100, 21700}, {19300, 19900}, {18050, 18800}, {21100, 21550}, {8690, 8940}, {8750, 8850}, {26200, 26900}, {9250, 9600}, {18449, 18799}, {21100, 21700}, {14759, 14959}, {7280, 7460}, {7460, 7560}, {7580, 7680}, {8750, 8900}, {7910, 8210}, {14959, 15109}, {14520, 14960}};
    private static final FqBandRanges[] allRange = new FqBandRanges[]{new FqBandRanges(0, 32766, 0, 32766)};
    private final int minLowEdge;
    private final int maxLowEdge;
    private final int minHighEdge;
    private final int maxHighEdge;

    private FqBandRanges(int minLowEdge, int maxLowEdge, int minHighEdge, int maxHighEdge) {
        this.minLowEdge = minLowEdge;
        this.maxLowEdge = maxLowEdge;
        this.minHighEdge = minHighEdge;
        this.maxHighEdge = maxHighEdge;
    }

    public static FqBandRanges lookup(int lowEdge, int highEdge) {
        for (int i = 0; i < allRange.length; ++i) {
            if (!allRange[i].isInRange(lowEdge, highEdge)) continue;
            return allRange[i];
        }
        return null;
    }

    public static FqBandRanges lookupLowEdge(int value) {
        for (int i = 0; i < allRange.length; ++i) {
            if (!allRange[i].isLowEdgeInRange(value)) continue;
            return allRange[i];
        }
        return null;
    }

    public static FqBandRanges lookupHighEdge(int value) {
        for (int i = 0; i < allRange.length; ++i) {
            if (!allRange[i].isHighEdgeInRange(value)) continue;
            return allRange[i];
        }
        return null;
    }

    public boolean isLowEdgeInRange(int value) {
        return value >= this.minLowEdge && value <= this.maxLowEdge;
    }

    public boolean isHighEdgeInRange(int value) {
        return value >= this.minHighEdge && value <= this.maxHighEdge;
    }

    public boolean isInRange(int lowEdge, int highEdge) {
        return this.isHighEdgeInRange(highEdge) && this.isLowEdgeInRange(lowEdge);
    }

    public static int[] getFqBandEdges(int band) {
        if (1 <= band && band <= 14) {
            return fqBandEdges[band];
        }
        if (19 == band) {
            return fqBandEdges[15];
        }
        if (20 == band) {
            return fqBandEdges[16];
        }
        if (21 == band) {
            return fqBandEdges[17];
        }
        if (32 == band) {
            return fqBandEdges[18];
        }
        return fqBandEdges[0];
    }
}

