/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.mao.rmo.channel;

import se.ericsson.cello.mao.Reservable;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoNotFoundException;
import se.ericsson.cello.moframework.SoftwareErrorException;
import se.ericsson.wcdma.rbs.boam.mao.bcm.BoamHelper;
import se.ericsson.wcdma.rbs.boam.mao.bcm.BoamManagedObject;
import se.ericsson.wcdma.rbs.boam.mao.common.MoNotPossibleToReserveException;

public class ChannelHelper {
    public static ManagedObject resolveDeviceSetRefAndReserve(int deviceSetFroId, String deviceSetTypeName, ManagedObject reservingMo) throws MoAccessException {
        ManagedObject deviceSet = BoamHelper.getMoForFroId(deviceSetTypeName, deviceSetFroId);
        if (deviceSet == null) {
            throw new MoNotFoundException(deviceSetTypeName);
        }
        if (!(deviceSet instanceof Reservable)) {
            throw new MoNotPossibleToReserveException("device of type " + deviceSetTypeName + " with froId " + deviceSetFroId + " is not Reservable", deviceSetTypeName);
        }
        if (!(reservingMo instanceof BoamManagedObject)) {
            throw new SoftwareErrorException();
        }
        if (((BoamManagedObject)reservingMo).isMyMoDataPersistent()) {
            throw new SoftwareErrorException();
        }
        ((Reservable)deviceSet).reserve(reservingMo, null);
        return deviceSet;
    }
}

