/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.mao.rmo.channel;

import se.ericsson.cello.moframework.IllegalParentException;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.UndeletableMoException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.proxies.ChcEulProxy;
import se.ericsson.wcdma.rbs.boam.mao.bcm.BoamManagedObject;
import se.ericsson.wcdma.rbs.boam.mao.common.MaoHasFro;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.EDchResourcesCellMo;
import se.ericsson.wcdma.rbs.boam.mao.rmo.channel.EDchResourcesMoFactory;
import se.ericsson.wcdma.rbs.boam.pms.impl.MoScanner;
import se.ericsson.wcdma.rbs.boam.pms.impl.PmsException;

public class EDchResourcesCellMoImpl
extends BoamManagedObject
implements EDchResourcesCellMo {
    private static final Class SELF = EDchResourcesCellMoImpl.class;
    private static final ChcEulProxy relatedProxy = ChcEulProxy.instance();
    public static final int MO_DATA_REVISION = 1000;
    private final MoData myData;
    private MoScanner myScanner;

    private EDchResourcesCellMoImpl(ManagedObject checkedParent, String thisMoName, String identity, Coordinator context) throws MoAccessException, IllegalParentException {
        super(checkedParent, thisMoName, identity, context);
        MessageLog.traceEnter(SELF, "EDchResourcesCellMoImpl() <---");
        this.myData = this.initMoData(context);
        this.myScanner = this.createMoScanner(this, ((MaoHasFro)checkedParent).getFroId(context), context);
    }

    private MoData initMoData(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(SELF, "initMoData()<--");
        MoData moData = new MoData(this.getLocalDistinguishedName(), this.getType(), false, context);
        moData.setRevision(1000);
        return moData;
    }

    public boolean isMyMoDataPersistent() {
        MessageLog.traceEnter(SELF, "isMyMoDataPersistent()<--");
        return false;
    }

    public static synchronized ManagedObject createEDchResourcesCell(ManagedObject mo) throws MoAccessException {
        MessageLog.traceEnter(EDchResourcesCellMoImpl.class, "createEDchResourcesCell() <---");
        return new EDchResourcesCellMoImpl(mo, "EDchResourcesCell", "1", null);
    }

    public void delete(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(SELF, "delete() <---");
        throw new UndeletableMoException((ManagedObject)this);
    }

    public void sysDelete(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(SELF, "sysDelete() <---");
        this.myData.delete(c);
        super.delete(c);
        this.myScanner.delete(c);
        MessageLog.trace(1, SELF, "EDchResourcesCell was deleted");
    }

    public String getType() {
        return "EDchResourcesCell";
    }

    private MoScanner createMoScanner(ManagedObject mo, int cellFroId, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(SELF, "createMoScanner() ");
        int[] additionalInfo = new int[]{0};
        MessageLog.trace(3, SELF, "create MO scanner <---");
        return new MoScanner(mo, relatedProxy, cellFroId, 0, EDchResourcesMoFactory.instance().getSecondaryCounters(), additionalInfo, false, context);
    }

    public boolean isPmCounterStartable(String name, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "isPmCounterStartable(), counter name: " + name);
        return !name.equals("pmNoUsersCEdchEul");
    }

    public MoData getMyMoData() {
        MessageLog.traceEnter(SELF, "getMyMoData()");
        return this.myData;
    }

    public int[] getScannerValue(String counterName) throws MoAccessException {
        if (this.myScanner == null) {
            throw new PmsException("MoScanner not available");
        }
        if (counterName.equals("pmNoUsersCEdchEul")) {
            return new int[]{-1};
        }
        return this.myScanner.getValue(counterName);
    }
}

