/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.mao.rmo.channel;

import se.ericsson.cello.moframework.AttrNotReadableException;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.ResourceLockedException;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.moframework.StructImpl;
import se.ericsson.cello.moframework.TransactionRequiredException;
import se.ericsson.cello.moframework.UndeletableMoException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.common.AvailabilityStatusIntToEnum;
import se.ericsson.wcdma.rbs.boam.common.FroRequestFailedException;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.proxies.ChcSccpchProxy;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.LrsGetSccpchParamRspS;
import se.ericsson.wcdma.rbs.boam.mao.bcm.BoamManagedObject;
import se.ericsson.wcdma.rbs.boam.mao.common.ValidateAttributes;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.excep.AlreadyActiveException;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.excep.InternalErrorException;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.excep.MoDisabledException;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.excep.NotActiveException;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.FachMo;

public class FachMoImpl
extends BoamManagedObject
implements FachMo {
    private static final int CLIENT_ID = 0;
    private int sccpchFroId;
    private int fachFroId;
    private int noOfMo;
    private MoData myData;
    private ChcSccpchProxy chcSccpchProxy = ChcSccpchProxy.instance();

    private FachMoImpl(ManagedObject parent, int sccpchFroId, int fachFroId, String thisMoName, String identity, int noOfMo) throws MoAccessException {
        super(parent, thisMoName, identity, null);
        MessageLog.traceEnter(this.getClass(), "Normal constructor");
        this.myData = new MoData(this.getLocalDistinguishedName(), this.getType(), false, null);
        this.sccpchFroId = sccpchFroId;
        this.fachFroId = fachFroId;
        this.noOfMo = noOfMo;
        MessageLog.trace(1, this.getClass(), "MO Created");
    }

    public static synchronized ManagedObject create(ManagedObject parent, int sccpchFroId, int fachFroId, String thisMoName, String identity, int noOfMo) throws MoAccessException {
        MessageLog.traceEnter(FachMoImpl.class, "create()");
        return new FachMoImpl(parent, sccpchFroId, fachFroId, thisMoName, identity, noOfMo);
    }

    public void delete(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "delete()");
        throw new UndeletableMoException((ManagedObject)this);
    }

    public void deleteFach(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "deleteFach()");
        if (super.isReserved(context)) {
            MessageLog.trace(1, this.getClass(), " this Mo is reserved and can not be deleted ");
            throw new UndeletableMoException((ManagedObject)this);
        }
        super.delete(context);
    }

    public String getType() {
        return "Fach";
    }

    public int getOperationalState(Coordinator context) throws MoAccessException, TransactionRequiredException, ResourceLockedException {
        MessageLog.traceEnter(this.getClass(), "getOperationalState()");
        LrsGetSccpchParamRspS rspSig = this.chcSccpchProxy.getSccpchParam(0, this.sccpchFroId);
        return rspSig.fachData[this.noOfMo].fachOpState;
    }

    public int getAvailabilityStatus(Coordinator context) throws MoAccessException, TransactionRequiredException, ResourceLockedException {
        MessageLog.traceEnter(this.getClass(), "getAvailabilityStatus()");
        LrsGetSccpchParamRspS rspSig = this.chcSccpchProxy.getSccpchParam(0, this.sccpchFroId);
        return AvailabilityStatusIntToEnum.convGetAvailStatIntToEnum(rspSig.fachData[this.noOfMo].fachAvailStatus);
    }

    public int getPnIsActive(Coordinator context) throws MoAccessException, TransactionRequiredException, ResourceLockedException {
        MessageLog.traceEnter(this.getClass(), "getPnIsActive()");
        LrsGetSccpchParamRspS rspSig = this.chcSccpchProxy.getSccpchParam(0, this.sccpchFroId);
        return rspSig.fachData[this.noOfMo].pnGenStatus;
    }

    public int getPnTfi(Coordinator context) throws MoAccessException, TransactionRequiredException, ResourceLockedException {
        MessageLog.traceEnter(this.getClass(), "getPnTfi()");
        LrsGetSccpchParamRspS rspSig = this.chcSccpchProxy.getSccpchParam(0, this.sccpchFroId);
        return rspSig.fachData[this.noOfMo].pnTfi;
    }

    public Struct actionReadNbapData(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "actionReadNbapData()");
        this.myData.handleTransaction(context, MoData.READ_ACCESS);
        LrsGetSccpchParamRspS rspSig = this.chcSccpchProxy.getSccpchParam(0, this.sccpchFroId);
        return this.convertSigToStruct(rspSig);
    }

    private Struct convertSigToStruct(LrsGetSccpchParamRspS rspSig) throws MoAccessException {
        String[] names = new String[9];
        Object[] values = new Object[9];
        names[0] = "trChId";
        names[1] = "maxFachPower";
        names[2] = "toAws";
        names[3] = "toAwe";
        names[4] = "codingMode";
        names[5] = "transTimeInt";
        names[6] = "crcSize";
        names[7] = "rateMatchingAttr";
        names[8] = "broadcastReference";
        Integer transpChannelId = new Integer(rspSig.fachData[this.noOfMo].transpChannelId);
        Integer maxFachPower = new Integer(rspSig.fachData[this.noOfMo].maxFachPower);
        Integer fachToAWS = new Integer(rspSig.fachData[this.noOfMo].fachToAWS);
        Integer fachToAWE = new Integer(rspSig.fachData[this.noOfMo].fachToAWE);
        Integer fachCodingMode = new Integer(rspSig.fachData[this.noOfMo].fachCodingMode);
        Integer fachTti = new Integer(rspSig.fachData[this.noOfMo].fachTti);
        Integer fachCrcSize = new Integer(rspSig.fachData[this.noOfMo].fachCrcSize);
        Integer fachRateMatchingAttr = new Integer(rspSig.fachData[this.noOfMo].fachRateMatchingAttr);
        Integer broadcastReference = new Integer(rspSig.fachData[this.noOfMo].broadcastReference);
        values[0] = transpChannelId;
        values[1] = maxFachPower;
        values[2] = fachToAWS;
        values[3] = fachToAWE;
        values[4] = fachCodingMode;
        values[5] = fachTti;
        values[6] = fachCrcSize;
        values[7] = fachRateMatchingAttr;
        values[8] = broadcastReference;
        if (rspSig.nbapIsValid == 1) {
            StructImpl status = new StructImpl(names, values);
            return status;
        }
        MessageLog.trace(2, this.getClass(), " Nbap data is not valid ");
        throw new AttrNotReadableException((ManagedObject)this, this.getType() + "DataNotValid");
    }

    public int getSccpchFroId() {
        MessageLog.traceEnter(this.getClass(), "getSccpchFroId()");
        return this.sccpchFroId;
    }

    public void actionStartPn(int pnTfi, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "actionStartPn()");
        this.myData.handleTransaction(context, MoData.READ_ACCESS);
        ValidateAttributes.intValueRangeCheck("pnTfi", pnTfi, PN_TFI_MIN_VALUES, PN_TFI_MAX_VALUES, this.getClass().getName());
        try {
            this.chcSccpchProxy.startPnGenPchFach(0, this.sccpchFroId, this.fachFroId, 1, pnTfi);
        }
        catch (FroRequestFailedException e) {
            if (e.getOrgErrorCode() == 1) {
                throw new InternalErrorException();
            }
            if (e.getOrgErrorCode() == 4) {
                throw new AlreadyActiveException();
            }
            if (e.getOrgErrorCode() == 8) {
                throw new MoDisabledException();
            }
            throw e;
        }
    }

    public void actionStopPn(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "actionStopPn()");
        this.myData.handleTransaction(context, MoData.READ_ACCESS);
        try {
            this.chcSccpchProxy.stopPnGenPchFach(0, this.sccpchFroId, this.fachFroId, 1);
        }
        catch (FroRequestFailedException e) {
            if (e.getOrgErrorCode() == 1) {
                throw new InternalErrorException();
            }
            if (e.getOrgErrorCode() == 5) {
                throw new NotActiveException();
            }
            throw e;
        }
    }

    public MoData getMyMoData() {
        MessageLog.traceEnter(this.getClass(), "getMyMoData()");
        return this.myData;
    }

    public boolean isMyMoDataPersistent() {
        MessageLog.traceEnter(this.getClass(), "isMyMoDataPersistent()");
        return false;
    }

    public int getFroId(Coordinator c) {
        MessageLog.traceEnter(this.getClass(), "getFroId()");
        return this.fachFroId;
    }
}

