/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.mao.rmo.channel;

import se.ericsson.cello.mao.Reservable;
import se.ericsson.cello.moframework.AttrNotReadableException;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.moframework.UndeletableMoException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.common.AvailabilityStatusIntToEnum;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.proxies.ChcSccpchProxy;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.LrsGetSccpchParamRspS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.LrsSccpchCreatedIndS;
import se.ericsson.wcdma.rbs.boam.mao.bcm.BoamManagedObject;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.struct.MichReadNbapDataStruct;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.DbchDeviceSetMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.MichMo;
import se.ericsson.wcdma.rbs.boam.mao.rmo.channel.ChannelHelper;

public class MichMoImpl
extends BoamManagedObject
implements MichMo {
    public static final String IDENTITY = "1";
    private static int identity;
    private static final String MICH_FRO_ID = "michFroId";
    private static final String MICH_DEV_SET_FRO_ID = "michDevSetFroId";
    private int sccpchFroId;
    private MoData myData;
    private IntegerAttribute michFroIdAttr;
    private IntegerAttribute michDevSetFroId;
    private ManagedObject dbchDeviceSetRef;
    private ChcSccpchProxy michProxy = ChcSccpchProxy.instance();

    private MichMoImpl(ManagedObject parent, int sccpchFroId, int michDevSetFroId, int michFroId, String thisMoName, String id) throws MoAccessException {
        super(parent, thisMoName, id, null);
        MessageLog.traceEnter(this.getClass(), "Normal constructor");
        this.sccpchFroId = sccpchFroId;
        this.initMoData(michDevSetFroId, michFroId, null);
        this.dbchDeviceSetRef = (DbchDeviceSetMo)ChannelHelper.resolveDeviceSetRefAndReserve(michDevSetFroId, "DbchDeviceSet", this);
        MessageLog.trace(1, this.getClass(), "MO Created");
    }

    public static synchronized ManagedObject create(ManagedObject parent, LrsSccpchCreatedIndS indicationSig) throws MoAccessException {
        MessageLog.traceEnter(MichMoImpl.class, "create() ");
        String id = Integer.toString(identity += indicationSig.michFroId);
        return new MichMoImpl(parent, indicationSig.sccpchFroId, indicationSig.michDevSetFroId, indicationSig.michFroId, "Mich", id);
    }

    public void delete(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "delete()<---");
        throw new UndeletableMoException((ManagedObject)this);
    }

    public void deleteMich(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "deleteMich()<---");
        if (super.isReserved(context)) {
            MessageLog.trace(1, this.getClass(), " this Mo is reserved and can not be deleted ");
            throw new UndeletableMoException((ManagedObject)this);
        }
        ManagedObject dbchDevSetRef = this.getDbchDeviceSetRef(context);
        if (dbchDevSetRef != null) {
            ((Reservable)dbchDevSetRef).release((ManagedObject)this, context);
        }
        MessageLog.trace(1, this.getClass(), "dbchDeviceSet is released");
        super.delete(context);
    }

    public MoData getMyMoData() {
        MessageLog.traceEnter(this.getClass(), "getMyMoData()<---");
        return this.myData;
    }

    public boolean isMyMoDataPersistent() {
        MessageLog.traceEnter(this.getClass(), "isMyMoDataPersistent()<---");
        return false;
    }

    public String getType() {
        return "Mich";
    }

    public Struct actionReadNbapData(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "actionReadNbapData()");
        this.myData.handleTransaction(context, MoData.READ_ACCESS);
        LrsGetSccpchParamRspS rspSig = this.michProxy.getSccpchParam(0, this.sccpchFroId);
        return this.convertSigToStruct(context, rspSig);
    }

    private Struct convertSigToStruct(Coordinator context, LrsGetSccpchParamRspS rspSig) throws MoAccessException {
        if (rspSig.nbapIsValid == 1) {
            return new MichReadNbapDataStruct(rspSig.michDlChanCodeNo, rspSig.michPhysChId, rspSig.michPower, rspSig.michMode);
        }
        throw new AttrNotReadableException((ManagedObject)this, this.getType() + "DataNotValid");
    }

    public int getAvailabilityStatus(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getAvailabilityStatus()");
        LrsGetSccpchParamRspS rspSig = this.michProxy.getSccpchParam(0, this.sccpchFroId);
        return AvailabilityStatusIntToEnum.convGetAvailStatIntToEnum(rspSig.michAvailStatus);
    }

    public ManagedObject getDbchDeviceSetRef(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getDbchDeviceSetRef()<---");
        return this.dbchDeviceSetRef;
    }

    public int getOperationalState(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getOperationalState()");
        LrsGetSccpchParamRspS rspSig = this.michProxy.getSccpchParam(0, this.sccpchFroId);
        return rspSig.michOpState;
    }

    public int getFroId(Coordinator context) {
        MessageLog.traceEnter(this.getClass(), "getFroId()");
        return this.michFroIdAttr.getValue(context);
    }

    private void initMoData(int michDevSetFroId, int michFroId, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "initMoData()---");
        this.myData = new MoData(super.getLocalDistinguishedName(), this.getType(), false, context);
        this.michFroIdAttr = new IntegerAttribute(MICH_FRO_ID, false, michFroId);
        this.myData.registerTransientAttr((Attribute)this.michFroIdAttr);
        this.michDevSetFroId = new IntegerAttribute(MICH_DEV_SET_FRO_ID, false, michDevSetFroId);
        this.myData.registerTransientAttr((Attribute)this.michDevSetFroId);
    }
}

