/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.mao.rmo.iub;

import se.ericsson.cello.mao.Reservable;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.AttrMissingAtCreateException;
import se.ericsson.cello.moframework.IllegalParentException;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.MoNotFoundException;
import se.ericsson.cello.moframework.NotHandledAttributeTypeException;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.moframework.TransactionRequiredException;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.moframework.WrongAttributeTypeException;
import se.ericsson.cello.sctp.SctpMaoi;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.usaal.UniSaalTpMaoi;
import se.ericsson.cello.usaal.UniSaalTpMo;
import se.ericsson.wcdma.rbs.boam.common.AvailabilityStatusIntToEnum;
import se.ericsson.wcdma.rbs.boam.common.FroNotAccessibleException;
import se.ericsson.wcdma.rbs.boam.common.FroRequestFailedException;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.fpx.ncmi.proxies.NcControlLinkProxy;
import se.ericsson.wcdma.rbs.boam.fpx.ncmi.proxies.NcNbapProxy;
import se.ericsson.wcdma.rbs.boam.fpx.ncmi.proxies.NcNphL3SupMgrProxy;
import se.ericsson.wcdma.rbs.boam.fpx.ncmi.sigs.BcGetNbapL3SupParamRspS;
import se.ericsson.wcdma.rbs.boam.fpx.ncmi.sigs.LrsGetNodebCpParamRspS;
import se.ericsson.wcdma.rbs.boam.fpx.proxies.FroProxy;
import se.ericsson.wcdma.rbs.boam.mao.alarm.MoAlarms;
import se.ericsson.wcdma.rbs.boam.mao.bcm.BoamHelper;
import se.ericsson.wcdma.rbs.boam.mao.bcm.BoamManagedObjectWithAlarms;
import se.ericsson.wcdma.rbs.boam.mao.common.ValidateAttributes;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.IubMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.NbapCommonMo;

public class NbapCommonMoImpl
extends BoamManagedObjectWithAlarms
implements NbapCommonMo {
    public static final int MO_DATA_REVISION = 6020101;
    private static final int NOT_DEFINED = -1;
    private NcNbapProxy ncNbapProxy = NcNbapProxy.instance();
    private NcControlLinkProxy lrsContLinkProxy = NcControlLinkProxy.instance();
    private NcNphL3SupMgrProxy ncNphL3SupMgrProxy = NcNphL3SupMgrProxy.instance();

    public NbapCommonMoImpl(ManagedObject parent, String motypeName, String identity, Coordinator context, AttrList attributes, ManagedObject source) throws MoAccessException {
        super(parent, "NbapCommon", identity, context);
        MessageLog.traceEnter(this.getClass(), "Normal constructor");
        NbapCommonMoImpl.checkTransaction(context);
        this.checkParent(parent);
        this.initMoData(attributes, parent, context);
        this.addObservers(62, context);
        MessageLog.trace(1, this.getClass(), "The Managed Object NbapCommon is Created ");
    }

    public NbapCommonMoImpl(MoData recoveredData) throws MoNameAlreadyTakenException, MoAccessException {
        super(recoveredData);
        MessageLog.traceEnter(this.getClass(), "Recovery constructor");
        this.myData = recoveredData;
        try {
            this.addObservers(62, null);
        }
        catch (MoAccessException e) {
            MessageLog.traceError(this.getClass(), "Couldn't init the Observers!!");
        }
        MessageLog.trace(1, this.getClass(), "Mo recovered");
    }

    public static synchronized ManagedObject create(ManagedObject parent, String thisMoName, String identity, Coordinator context, AttrList attributes, ManagedObject source) throws MoAccessException {
        MessageLog.traceEnter(NbapCommonMoImpl.class, "create()");
        NbapCommonMoImpl createdMo = new NbapCommonMoImpl(parent, thisMoName, identity, context, attributes, source);
        return createdMo;
    }

    public String getType() {
        return "NbapCommon";
    }

    private void initMoData(AttrList attributes, ManagedObject parent, Coordinator context) throws MoAccessException, TransactionRequiredException, AttrMissingAtCreateException, WrongAttributeTypeException, NotHandledAttributeTypeException, ValueOutOfRangeException {
        MessageLog.traceEnter(this.getClass(), "initMoData()");
        this.myData = new MoData(this.getLocalDistinguishedName(), this.getType(), true, context);
        int checkedAlarmStatus = ValidateAttributes.checkAndGetIntAttribute(attributes, "alarmStatus", "optional", 0, ALARM_STATUS_MIN_VALUES, ALARM_STATUS_MAX_VALUES, "NbapCommon");
        this.initAlarmStatus(checkedAlarmStatus, context);
        String checkedUserLabel = ValidateAttributes.checkAndGetStringAttribute(attributes, "userLabel", "optional", "", 0, 128, "NbapCommon");
        int checkedL2EstablishReqRetryT = ValidateAttributes.checkAndGetIntAttribute(attributes, "l2EstablishReqRetryT", "optional", 1, L2_ESTABLISH_REQ_RETRY_T_MIN_VALUES, L2_ESTABLISH_REQ_RETRY_T_MAX_VALUES, "NbapCommon");
        int checkedL2EstablishSupervisionT = ValidateAttributes.checkAndGetIntAttribute(attributes, "l2EstablishSupervisionT", "optional", 30, L2_ESTABLISH_SUPERVISION_T_MIN_VALUES, L2_ESTABLISH_SUPERVISION_T_MAX_VALUES, "NbapCommon");
        int checkedL3EstablishSupervisionT = ValidateAttributes.checkAndGetIntAttribute(attributes, "l3EstablishSupervisionT", "optional", 30, L3_ESTABLISH_SUPERVISION_T_MIN_VALUES, L3_ESTABLISH_SUPERVISION_T_MAX_VALUES, "NbapCommon");
        int checkedAuditRetransmissionT = ValidateAttributes.checkAndGetIntAttribute(attributes, "auditRetransmissionT", "optional", 5, AUDIT_RETRANSMISSION_T_MIN_VALUES, AUDIT_RETRANSMISSION_T_MAX_VALUES, "NbapCommon");
        ValidateAttributes.checkAndGetIntAttribute(attributes, "alarmStatus", "optional", 0, ALARM_STATUS_MIN_VALUES, ALARM_STATUS_MAX_VALUES, "NbapCommon");
        ManagedObject checkedSctpRef = ValidateAttributes.checkAndGetReferenceAttribute("sctpRef", attributes, "optional", new String[]{"Sctp"}, "NbapCommon");
        ManagedObject uniSaalTpRef1 = this.checkAndSaveUniSaalTpRef1(attributes, parent, context);
        int unisaalCepFroId1 = -1;
        if (uniSaalTpRef1 != null) {
            ((Reservable)uniSaalTpRef1).reserve((ManagedObject)this, context);
            unisaalCepFroId1 = ((UniSaalTpMaoi)uniSaalTpRef1).getUsaalCepFroId(context);
        }
        ManagedObject uniSaalTpRef2 = this.checkAndSaveUniSaalTpRef2(attributes, context);
        int unisaalCepFroId2 = -1;
        if (uniSaalTpRef2 != null) {
            ((Reservable)uniSaalTpRef2).reserve((ManagedObject)this, context);
            unisaalCepFroId2 = ((UniSaalTpMaoi)uniSaalTpRef2).getUsaalCepFroId(context);
        }
        ValidateAttributes.checkOtherAttributes(attributes, "NbapCommon");
        if (checkedSctpRef != null) {
            ((Reservable)checkedSctpRef).reserve((ManagedObject)this, context);
        }
        this.bcmStoreAndRegisterStringAttribute("userLabel", checkedUserLabel);
        this.bcmStoreAndRegisterReferenceAttribute("sctpRef", checkedSctpRef);
        this.bcmStoreAndRegisterReferenceAttribute("uniSaalTpRef1", uniSaalTpRef1);
        this.bcmStoreAndRegisterReferenceAttribute("uniSaalTpRef2", uniSaalTpRef2);
        this.lrsCreateNodeBcp(context, 0, checkedL2EstablishReqRetryT, checkedL2EstablishSupervisionT);
        this.addSbToNodeBcp(context, unisaalCepFroId1, unisaalCepFroId2);
        this.bcAddNodeBcpToNbap(context);
        this.setAuditRetransmissionT(checkedAuditRetransmissionT, context);
        this.setL3EstablishSupervisionT(checkedL3EstablishSupervisionT, context);
        this.myData.setRevision(6020101);
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
    }

    private void lrsCreateNodeBcp(Coordinator context, int clientId, int establishTimeout, int nbapEstSupervisionT) throws MoAccessException, FroNotAccessibleException, FroRequestFailedException {
        MessageLog.traceEnter(this.getClass(), "lrsCreateNodeBcp()");
        this.lrsContLinkProxy.createNodebCp(this.getTxIdTransactional(context), clientId, establishTimeout, nbapEstSupervisionT);
    }

    private static boolean getControlPlaneTransportOptionAttributeValue(ManagedObject parent, String attributeName, Coordinator c) throws MoAccessException {
        Struct st = ((IubMo)parent).getControlPlaneTransportOption(c);
        return st != null && st.getNames().length != 0 ? (Boolean)st.getValue(attributeName) : false;
    }

    private void addSbToNodeBcp(Coordinator context, int unisaalCepFroId1, int unisaalCepFroId2) throws MoAccessException, FroNotAccessibleException, FroRequestFailedException {
        MessageLog.traceEnter(this.getClass(), "addSbToNodeBcp()");
        boolean atm = NbapCommonMoImpl.getControlPlaneTransportOptionAttributeValue(this.getParent(), "atm", context);
        boolean ipv4 = NbapCommonMoImpl.getControlPlaneTransportOptionAttributeValue(this.getParent(), "ipV4", context);
        int sctpFroId = -1;
        if (atm && !ipv4) {
            sctpFroId = -1;
            this.releaseSctpRef(context);
        } else if (ipv4 && !atm) {
            unisaalCepFroId1 = -1;
            unisaalCepFroId2 = -1;
            ManagedObject sctpMo = this.getSctpRef(context);
            if (sctpMo == null) {
                MoIterator sctpMos = BoamHelper.findMOs("Sctp");
                if (sctpMos.hasMoreElements()) {
                    sctpMo = (ManagedObject)sctpMos.nextElement();
                }
                if (sctpMo == null) {
                    MessageLog.traceError(this.getClass(), " For IP node: Couldn't finde Motype:Sctp");
                    throw new MoNotFoundException("For IP node: Couldn't finde Motype:Sctp");
                }
                this.setSctpRef(sctpMo, context);
            }
            sctpFroId = ((SctpMaoi)sctpMo).getFroId(context);
        } else {
            unisaalCepFroId1 = -1;
            unisaalCepFroId2 = -1;
            sctpFroId = -1;
        }
        this.lrsContLinkProxy.setNodebSbRef(this.getTxIdTransactional(context), 0, unisaalCepFroId1, unisaalCepFroId2, sctpFroId);
    }

    private void bcAddNodeBcpToNbap(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "bcAddNodeBcpToNbap()");
        this.ncNbapProxy.addNodebCpToNbap(this.getTxIdTransactional(context), 0);
    }

    public void delete(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "delete()");
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
        this.ncNbapProxy.delNodebCpFromNbap(this.getTxIdTransactional(context), 0);
        this.lrsContLinkProxy.delNodebCp(this.getTxIdTransactional(context), 0);
        this.releaseSctpRef(context);
        this.releaseUniSaalTpRef1(context);
        this.releaseUniSaalTpRef2(context);
        this.removeObservers(context);
        super.delete(context);
        MessageLog.trace(1, this.getClass(), "NbapCommon is Deleted");
    }

    private void releaseSctpRef(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "releaseSctpRef()");
        ManagedObject sctpMo = this.getSctpRef(context);
        if (sctpMo != null) {
            ((Reservable)sctpMo).release((ManagedObject)this, context);
            MessageLog.trace(2, this.getClass(), "SctpRef released");
        }
        this.setSctpRef(null, context);
    }

    private void releaseUniSaalTpRef1(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "releaseUniSaalTpRef1()");
        ManagedObject uniSaalTpRef1 = this.getUniSaalTpRef1(context);
        if (uniSaalTpRef1 != null) {
            ((Reservable)uniSaalTpRef1).release((ManagedObject)this, context);
            MessageLog.trace(2, this.getClass(), "uniSaalTpRef1 released");
        }
    }

    private void releaseUniSaalTpRef2(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "releaseUniSaalTpRef2()");
        ManagedObject uniSaalTpRef2 = this.getUniSaalTpRef2(context);
        if (uniSaalTpRef2 != null) {
            ((Reservable)uniSaalTpRef2).release((ManagedObject)this, context);
            MessageLog.trace(2, this.getClass(), "uniSaalTpRef2 released");
        }
    }

    public void controlPlaneTransportOptionUpdated(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "update()");
        ValidateAttributes.checkTransaction(context);
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
        int unisaalCepFroId1 = -1;
        int unisaalCepFroId2 = -1;
        ManagedObject uniRef1 = this.getUniSaalTpRef1(context);
        ManagedObject uniRef2 = this.getUniSaalTpRef2(context);
        if (uniRef1 != null) {
            unisaalCepFroId1 = ((UniSaalTpMaoi)uniRef1).getUsaalCepFroId(context);
        }
        if (uniRef2 != null) {
            unisaalCepFroId2 = ((UniSaalTpMaoi)uniRef2).getUsaalCepFroId(context);
        }
        this.addSbToNodeBcp(context, unisaalCepFroId1, unisaalCepFroId2);
    }

    public String getUserLabel(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getUserLabel() ");
        return this.bcmGetStringAttribute("userLabel", context);
    }

    public void setUserLabel(String value, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setUserLabel() ");
        this.bcmSetStringAttribute("userLabel", value, 0, 128, this.getType(), context);
        this.sendAVC("userLabel", value, context);
    }

    public int getNbOfSB(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getNbOfSB()");
        LrsGetNodebCpParamRspS cfmSig = this.lrsContLinkProxy.getNodebCpParam(0, this.getTxIdNonTransactional(context));
        return cfmSig.numberOfSb;
    }

    public int getOperationalState(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), " getOperationalState()");
        BcGetNbapL3SupParamRspS cfmSig = this.ncNbapProxy.getNbapL3SupParam(0, this.getTxIdNonTransactional(context));
        return cfmSig.operationalState;
    }

    public void setL2EstablishReqRetryT(int l2EstablishReqRetryT, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setL2EstablishReqRetryT()");
        ValidateAttributes.checkTransaction(context);
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
        ValidateAttributes.intValueRangeCheck("l2EstablishReqRetryT", l2EstablishReqRetryT, L2_ESTABLISH_REQ_RETRY_T_MIN_VALUES, L2_ESTABLISH_REQ_RETRY_T_MAX_VALUES, "NbapCommon");
        this.lrsContLinkProxy.setNodebEstRetry(this.getTxIdTransactional(context), 0, l2EstablishReqRetryT);
        this.sendAVC("l2EstablishReqRetryT", l2EstablishReqRetryT, context);
    }

    public void setL2EstablishSupervisionT(int l2EstablishSupervisionT, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setL2EstablishSupervisionT()");
        ValidateAttributes.checkTransaction(context);
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
        ValidateAttributes.intValueRangeCheck("l2EstablishSupervisionT", l2EstablishSupervisionT, L2_ESTABLISH_SUPERVISION_T_MIN_VALUES, L2_ESTABLISH_SUPERVISION_T_MAX_VALUES, "NbapCommon");
        this.lrsContLinkProxy.setNodebNbapSuperv(this.getTxIdTransactional(context), 0, l2EstablishSupervisionT);
        this.sendAVC("l2EstablishSupervisionT", l2EstablishSupervisionT, context);
    }

    public void setAuditRetransmissionT(int auditRetransmissionT, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setAuditRetransmissionT()");
        ValidateAttributes.checkTransaction(context);
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
        ValidateAttributes.intValueRangeCheck("auditRetransmissionT", auditRetransmissionT, AUDIT_RETRANSMISSION_T_MIN_VALUES, AUDIT_RETRANSMISSION_T_MAX_VALUES, "NbapCommon");
        this.ncNphL3SupMgrProxy.setNbapL3SupRetransmissionTmo(this.getTxIdTransactional(context), 0, auditRetransmissionT);
        this.sendAVC("auditRetransmissionT", auditRetransmissionT, context);
    }

    public void setL3EstablishSupervisionT(int l3EstablishSupervisionT, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setL3EstablishSupervisionT()");
        ValidateAttributes.checkTransaction(context);
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
        ValidateAttributes.intValueRangeCheck("l3EstablishSupervisionT", l3EstablishSupervisionT, L3_ESTABLISH_SUPERVISION_T_MIN_VALUES, L3_ESTABLISH_SUPERVISION_T_MAX_VALUES, "NbapCommon");
        this.ncNphL3SupMgrProxy.setNbapL3SupEstSupervisionTmo(this.getTxIdTransactional(context), 0, l3EstablishSupervisionT);
        this.sendAVC("l3EstablishSupervisionT", l3EstablishSupervisionT, context);
    }

    public int getAvailabilityStatus(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getAvailabilityStatus()");
        LrsGetNodebCpParamRspS cfmSig = this.lrsContLinkProxy.getNodebCpParam(0, this.getTxIdNonTransactional(context));
        return AvailabilityStatusIntToEnum.convGetAvailStatIntToEnum(cfmSig.availStatus);
    }

    public int getActiveBearer(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getActiveBearer()");
        LrsGetNodebCpParamRspS cfmSig = this.lrsContLinkProxy.getNodebCpParam(0, this.getTxIdNonTransactional(context));
        return cfmSig.activeSb;
    }

    public ManagedObject getUniSaalTpRef1(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getUniSaalTpRef1()");
        return this.bcmGetReferenceAttribute("uniSaalTpRef1", context);
    }

    public ManagedObject getUniSaalTpRef2(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getUniSaalTpRef2()");
        return this.bcmGetReferenceAttribute("uniSaalTpRef2", context);
    }

    public int getL2EstablishReqRetryT(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getL2EstablishReqRetryT()");
        LrsGetNodebCpParamRspS cfmSig = this.lrsContLinkProxy.getNodebCpParam(0, this.getTxIdNonTransactional(context));
        return cfmSig.estRetryT;
    }

    public int getL2EstablishSupervisionT(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getL2EstablishSupervisionT()");
        LrsGetNodebCpParamRspS cfmSig = this.lrsContLinkProxy.getNodebCpParam(0, this.getTxIdNonTransactional(context));
        return cfmSig.nbapEstSupervisionT;
    }

    public int getAuditRetransmissionT(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getAuditRetransmissionT()");
        BcGetNbapL3SupParamRspS cfmSig = this.ncNbapProxy.getNbapL3SupParam(0, this.getTxIdNonTransactional(context));
        return cfmSig.auditRetransmissionT;
    }

    public int getL3EstablishSupervisionT(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getL3EstablishSupervisionT()");
        BcGetNbapL3SupParamRspS cfmSig = this.ncNbapProxy.getNbapL3SupParam(0, this.getTxIdNonTransactional(context));
        return cfmSig.l3EstSupervisionT;
    }

    public MoData getMyMoData() {
        MessageLog.traceEnter(this.getClass(), "getMyMoData()");
        return this.myData;
    }

    public boolean isMyMoDataPersistent() {
        MessageLog.traceEnter(this.getClass(), "isMyMoDataPersistent()");
        return true;
    }

    private void checkParent(ManagedObject parent) throws MoAccessException {
        if (!(parent instanceof IubMo)) {
            throw new IllegalParentException("Expecting Iub, received:" + parent.getClass().getName());
        }
    }

    private ManagedObject checkAndSaveUniSaalTpRef1(AttrList attributes, ManagedObject parent, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "checkAndSaveUniSaalTpRef1");
        ManagedObject uniSaalTpRef1 = null;
        int moUnSaTpRef1AttrIndex = attributes.indexOf("uniSaalTpRef1");
        if (moUnSaTpRef1AttrIndex == -1) {
            MessageLog.trace(1, this.getClass(), "uniSaalTpRef1 is not included in the attribute list");
            if ("optional".equalsIgnoreCase("mandatory") && NbapCommonMoImpl.getControlPlaneTransportOptionAttributeValue(parent, "atm", context)) {
                throw new AttrMissingAtCreateException("uniSaalTpRef1", this.getType());
            }
            return uniSaalTpRef1;
        }
        if (!(attributes.getValue(moUnSaTpRef1AttrIndex) instanceof UniSaalTpMo)) {
            MessageLog.trace(1, this.getClass(), "uniSaalTpRef1 has wrong type");
            throw new WrongAttributeTypeException("uniSaalTpRef1", this.getType());
        }
        uniSaalTpRef1 = (ManagedObject)attributes.getValue(moUnSaTpRef1AttrIndex);
        if (((UniSaalTpMo)uniSaalTpRef1).getReservedBy(context) != null) {
            MessageLog.trace(1, this.getClass(), "uniSaalTpRef1 already reserved by another MO");
            throw new WrongAttributeTypeException("uniSaalTpRef1", this.getType());
        }
        attributes.removeElementAt(moUnSaTpRef1AttrIndex);
        return uniSaalTpRef1;
    }

    private ManagedObject checkAndSaveUniSaalTpRef2(AttrList attributes, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "checkAndSaveUniSaalTpRef2");
        ManagedObject uniSaalTpRef2 = null;
        int moUnSaTpRef2AttrIndex = attributes.indexOf("uniSaalTpRef2");
        if (moUnSaTpRef2AttrIndex == -1) {
            MessageLog.trace(1, this.getClass(), " uniSaalTpRef2 is not included in the attribute list ");
            if ("optional".equalsIgnoreCase("mandatory")) {
                throw new AttrMissingAtCreateException("uniSaalTpRef1", this.getType());
            }
            return uniSaalTpRef2;
        }
        if (!(attributes.getValue(moUnSaTpRef2AttrIndex) instanceof UniSaalTpMo)) {
            MessageLog.trace(1, this.getClass(), " uniSaalTpRef2 has wrong type ");
            throw new WrongAttributeTypeException("uniSaalTpRef2", this.getType());
        }
        uniSaalTpRef2 = (ManagedObject)attributes.getValue(moUnSaTpRef2AttrIndex);
        attributes.removeElementAt(moUnSaTpRef2AttrIndex);
        if (((UniSaalTpMo)uniSaalTpRef2).getReservedBy(context) != null) {
            MessageLog.trace(1, this.getClass(), "uniSaalTpRef2 already reserved by another MO");
            throw new WrongAttributeTypeException("uniSaalTpRef2", this.getType());
        }
        return uniSaalTpRef2;
    }

    protected void addObservers(int froType, Coordinator context) throws MoAccessException {
        this.myMoAlarms = new MoAlarms((ManagedObject)this, new FroProxy[]{this.ncNphL3SupMgrProxy, this.lrsContLinkProxy}, froType, -4, context);
    }

    protected void removeObservers(Coordinator context) throws MoAccessException {
        this.myMoAlarms.delete(context);
    }

    public int getFroId(Coordinator c) {
        MessageLog.traceEnter(this.getClass(), "getFroId()");
        return -4;
    }

    public ManagedObject getSctpRef(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getSctpRef()");
        return this.bcmGetReferenceAttribute("sctpRef", c);
    }

    private void setSctpRef(ManagedObject sctpRef, Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setSctpRef()");
        this.myData.handleTransaction(c, MoData.WRITE_ACCESS);
        if (sctpRef != null) {
            ((Reservable)sctpRef).reserve((ManagedObject)this, c);
        }
        this.bcmSetReferenceAttribute("sctpRef", sctpRef, this.getType(), c);
    }

    public void setUniSaalTpRef2(ManagedObject uniSaalTpRef2, Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setUniSaalTpRef2()");
        NbapCommonMoImpl.checkTransaction(c);
        this.myData.handleTransaction(c, MoData.WRITE_ACCESS);
        if (!this.checkSetUniSaalTpRef("uniSaalTpRef2", uniSaalTpRef2, this.getUniSaalTpRef2(c), this.getUniSaalTpRef1(c), c)) {
            return;
        }
        this.releaseUniSaalTpRef2(c);
        if (uniSaalTpRef2 != null) {
            ((Reservable)uniSaalTpRef2).reserve((ManagedObject)this, c);
        }
        this.bcmSetReferenceAttribute("uniSaalTpRef2", uniSaalTpRef2, this.getType(), c);
        this.updateSB(c);
        this.sendAVC("uniSaalTpRef2", uniSaalTpRef2, c);
    }

    public void setUniSaalTpRef1(ManagedObject uniSaalTpRef1, Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setUniSaalTpRef1()");
        NbapCommonMoImpl.checkTransaction(c);
        this.myData.handleTransaction(c, MoData.WRITE_ACCESS);
        if (!this.checkSetUniSaalTpRef("uniSaalTpRef1", uniSaalTpRef1, this.getUniSaalTpRef1(c), this.getUniSaalTpRef2(c), c)) {
            return;
        }
        this.releaseUniSaalTpRef1(c);
        if (uniSaalTpRef1 != null) {
            ((Reservable)uniSaalTpRef1).reserve((ManagedObject)this, c);
        }
        this.bcmSetReferenceAttribute("uniSaalTpRef1", uniSaalTpRef1, this.getType(), c);
        this.updateSB(c);
        this.sendAVC("uniSaalTpRef1", uniSaalTpRef1, c);
    }

    private boolean checkSetUniSaalTpRef(String attrName, ManagedObject newUniSaalTpRef, ManagedObject uniSaalTpRef2Change, ManagedObject nextUniSaalTpRef, Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "checkSetUniSaalTpRef() attrName:" + attrName);
        boolean atm = NbapCommonMoImpl.getControlPlaneTransportOptionAttributeValue(this.getParent(), "atm", c);
        boolean ipv4 = NbapCommonMoImpl.getControlPlaneTransportOptionAttributeValue(this.getParent(), "ipV4", c);
        if (atm && !ipv4 && newUniSaalTpRef == null && nextUniSaalTpRef == null) {
            MessageLog.trace(2, this.getClass(), attrName + " on the NbapCommon,  both uniSaalTpRef1 and uniSaalTpRef2 are not allowed as NULLs in ATM mode");
            throw new ValueOutOfRangeException(attrName, "NbapCommon", " both uniSaalTpRef1 and uniSaalTpRef2 are not allowed as NULLs in ATM mode");
        }
        if (newUniSaalTpRef != null) {
            if (!newUniSaalTpRef.getType().equalsIgnoreCase("UniSaalTp")) {
                MessageLog.trace(2, this.getClass(), attrName + " is of wrong type, expected UniSaalTpMo");
                throw new WrongAttributeTypeException(attrName, this.getType());
            }
            if (uniSaalTpRef2Change != null && uniSaalTpRef2Change.getLocalDistinguishedName().equalsIgnoreCase(newUniSaalTpRef.getFullDistinguishedName())) {
                MessageLog.trace(2, this.getClass(), attrName + " sets to the same value as before, ignoring!! OldRef=newRef= " + newUniSaalTpRef.getLocalDistinguishedName());
                return false;
            }
            ManagedObject reserver = ((UniSaalTpMo)newUniSaalTpRef).getReservedBy(c);
            if (reserver != null) {
                MessageLog.trace(2, this.getClass(), " uniSaalTpRef already reserved by another MO. The new " + attrName + newUniSaalTpRef.getLocalDistinguishedName() + " The reserver: " + reserver.getLocalDistinguishedName());
                throw new ValueOutOfRangeException(attrName, "NbapCommon", " uniSaalTpRef already reserved by another MO. The new " + attrName + newUniSaalTpRef.getLocalDistinguishedName() + " The reserver: " + reserver.getLocalDistinguishedName());
            }
        }
        return true;
    }

    private void updateSB(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "updateSB()");
        ManagedObject uniSaalTpRef1 = this.getUniSaalTpRef1(c);
        ManagedObject uniSaalTpRef2 = this.getUniSaalTpRef2(c);
        int unisaalCepFroId1 = -1;
        int unisaalCepFroId2 = -1;
        if (uniSaalTpRef1 != null) {
            unisaalCepFroId1 = ((UniSaalTpMaoi)uniSaalTpRef1).getUsaalCepFroId(c);
        }
        if (uniSaalTpRef2 != null) {
            unisaalCepFroId2 = ((UniSaalTpMaoi)uniSaalTpRef2).getUsaalCepFroId(c);
        }
        this.addSbToNodeBcp(c, unisaalCepFroId1, unisaalCepFroId2);
    }
}

