/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.mao.rmo.node;

import enea.ose.system.InSignal;
import se.ericsson.cello.equipment.PlugInUnitMaoi;
import se.ericsson.cello.equipment.PlugInUnitMo;
import se.ericsson.cello.faultmanagement.Event;
import se.ericsson.cello.mao.Reservable;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.AttrNotReadableException;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.IllegalParentException;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoCanNotBeCreatedException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.MoNotFoundException;
import se.ericsson.cello.moframework.ReferenceAttribute;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.moframework.TransactionRequiredException;
import se.ericsson.cello.moframework.UndeletableMoException;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.moframework.WrongAttributeTypeException;
import se.ericsson.cello.transaction.Control;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.cello.transaction.TransactionServiceImpl;
import se.ericsson.wcdma.rbs.boam.common.FroRequestFailedException;
import se.ericsson.wcdma.rbs.boam.common.PlugAndPlayObserver;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.proxies.EcTimingProxy;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EcSyncResAvcIndS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.LrsCreateSyncResRspS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.LrsGetSyncResParamRspS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.LrsSyncResEventIndS;
import se.ericsson.wcdma.rbs.boam.mao.alarm.MoAlarms;
import se.ericsson.wcdma.rbs.boam.mao.bcm.BoamHelper;
import se.ericsson.wcdma.rbs.boam.mao.bcm.BoamManagedObjectWithAlarms;
import se.ericsson.wcdma.rbs.boam.mao.common.ValidateAttributes;
import se.ericsson.wcdma.rbs.boam.mao.event.MoEvents;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.excep.FunctionNotSupportedException;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.excep.NoSlaveTuException;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.excep.SlaveTuNotStableException;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.RbsSynchronizationMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.TimDeviceMo;

public class RbsSynchronizationMoImpl
extends BoamManagedObjectWithAlarms
implements RbsSynchronizationMo,
PlugAndPlayObserver {
    public static final String RO_SYNC_RES_ID1 = "roSyncResId1";
    public static final String RO_SYNC_RES_ID2 = "roSyncResId2";
    public static final int FIRST = 1;
    public static final int SECOND = 2;
    public static final int UNDEFINED = -1;
    public static final int UNKNOWN = 3;
    private static final String TAG_LRS_SYNC_RES_NODE_SYNCHRONIZATION_REDUNDANCY_SWITCH_OVER = "_NodeSynchronizationRedundancySwitchOver";
    private static RbsSynchronizationMoImpl instance;
    private static Object singletonLock;
    public static final int MO_DATA_REVISION = 3020001;
    private ReferenceAttribute timDeviceRef1 = null;
    private ReferenceAttribute timDeviceRef2 = null;
    private ReferenceAttribute plugInUnitRef1 = null;
    private ReferenceAttribute plugInUnitRef2 = null;
    private IntegerAttribute roSyncResId1 = null;
    private IntegerAttribute roSyncResId2 = null;
    public EcTimingProxy ecTimingProxy = EcTimingProxy.instance();
    protected MoEvents myMoEvents;

    private RbsSynchronizationMoImpl(ManagedObject parent, String thisMoName, AttrList attributes, String identity, ManagedObject source, Coordinator context) throws MoAccessException, IllegalParentException {
        super(parent, thisMoName, identity, context);
        MessageLog.traceEnter(this.getClass(), "Normal constructor");
        if (!parent.getType().equals("NodeBFunction")) {
            MessageLog.traceEnter(this.getClass(), "Illegal parent");
            throw new IllegalParentException("Exepting NodeBFunction, received:" + parent);
        }
        this.initMoData(attributes, context);
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
        this.addObservers(95, context);
        MessageLog.trace(1, this.getClass(), "Created MoData");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RbsSynchronizationMoImpl(MoData recoveredData) throws MoNameAlreadyTakenException {
        super(recoveredData);
        MessageLog.traceEnter(this.getClass(), "Recovery constructor");
        Object object = singletonLock;
        synchronized (object) {
            instance = this;
            this.myData = recoveredData;
            this.timDeviceRef1 = (ReferenceAttribute)recoveredData.getAttribute("timDeviceRef1");
            this.timDeviceRef2 = (ReferenceAttribute)recoveredData.getAttribute("timDeviceRef2");
            this.plugInUnitRef1 = (ReferenceAttribute)recoveredData.getAttribute("plugInUnitRef1");
            this.plugInUnitRef2 = (ReferenceAttribute)recoveredData.getAttribute("plugInUnitRef2");
            this.roSyncResId1 = (IntegerAttribute)recoveredData.getAttribute(RO_SYNC_RES_ID1);
            this.roSyncResId2 = (IntegerAttribute)recoveredData.getAttribute(RO_SYNC_RES_ID2);
            if (this.timDeviceRef1 == null) {
                MessageLog.traceError(this.getClass(), "Recovered attribute timDeviceRef1 is null");
            }
            if (this.timDeviceRef2 == null) {
                MessageLog.traceError(this.getClass(), "Recovered attribute timDeviceRef2 is null");
            }
            if (this.plugInUnitRef1 == null) {
                MessageLog.traceError(this.getClass(), "Recovered attribute plugInUnitRef1 is null");
            }
            if (this.plugInUnitRef2 == null) {
                MessageLog.traceError(this.getClass(), "Recovered attribute plugInUnitRef2 is null");
            }
            if (this.roSyncResId1 == null) {
                MessageLog.traceError(this.getClass(), "Recovered attribute roSyncResId1 is null");
            }
            if (this.roSyncResId2 == null) {
                MessageLog.traceError(this.getClass(), "Recovered attribute roSyncResId2 is null");
            }
            try {
                this.addObservers(95, null);
            }
            catch (MoAccessException e) {
                MessageLog.traceError(this.getClass(), "Couldn't init the Observers!!");
            }
        }
        MessageLog.trace(1, this.getClass(), "MO is Recovered, version Attribute in MoData = " + this.myData.getRevision());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ManagedObject create(ManagedObject parent, String thisMoName, AttrList attributes, String identity, ManagedObject source, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(RbsSynchronizationMoImpl.class, "create");
        Object object = singletonLock;
        synchronized (object) {
            if (instance == null) {
                instance = new RbsSynchronizationMoImpl(parent, thisMoName, attributes, identity, source, context);
            }
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RbsSynchronizationMoImpl instance(ManagedObject parent, String thisMoName, AttrList attributes, int devType, String identity, ManagedObject source, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(RbsSynchronizationMoImpl.class, "instance()");
        Object object = singletonLock;
        synchronized (object) {
            if (instance != null) {
                throw new MoCanNotBeCreatedException(thisMoName);
            }
            instance = new RbsSynchronizationMoImpl(parent, thisMoName, attributes, identity, source, context);
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RbsSynchronizationMoImpl getInstance() {
        MessageLog.traceEnter(RbsSynchronizationMoImpl.class, "getInstance()");
        Object object = singletonLock;
        synchronized (object) {
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void _reset_onlyForTest() {
        MessageLog.traceEnter(RbsSynchronizationMoImpl.class, "_reset_onlyForTest");
        Object object = singletonLock;
        synchronized (object) {
            instance = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void _resetPaP_onlyForTest() {
        MessageLog.traceEnter(RbsSynchronizationMoImpl.class, "_resetPaP_onlyForTest");
        RbsSynchronizationMoImpl tmp = null;
        Object object = singletonLock;
        synchronized (object) {
            tmp = instance;
        }
        if (tmp != null) {
            tmp.ecTimingProxy.deRegisterForPlugAndPLayInd(null, -5L);
        }
    }

    private void initMoData(AttrList attributes, Coordinator context) throws MoAccessException, TransactionRequiredException, WrongAttributeTypeException {
        ManagedObject mo;
        MessageLog.traceEnter(this.getClass(), "initMoData()");
        this.myData = new MoData(this.getLocalDistinguishedName(), this.getType(), true, context);
        StringAttribute userLabel = new StringAttribute("userLabel", false);
        this.timDeviceRef1 = new ReferenceAttribute("timDeviceRef1", false);
        this.timDeviceRef2 = new ReferenceAttribute("timDeviceRef2", false);
        this.plugInUnitRef1 = new ReferenceAttribute("plugInUnitRef1", false);
        this.plugInUnitRef2 = new ReferenceAttribute("plugInUnitRef2", false);
        this.roSyncResId1 = new IntegerAttribute(RO_SYNC_RES_ID1, false);
        this.roSyncResId2 = new IntegerAttribute(RO_SYNC_RES_ID2, false);
        MessageLog.trace(1, this.getClass(), "All alarmxSeverity are registered");
        this.timDeviceRef1.setValue(null);
        this.timDeviceRef2.setValue(null);
        this.plugInUnitRef1.setValue(null);
        this.plugInUnitRef2.setValue(null);
        this.roSyncResId1.setValue(-1);
        this.roSyncResId2.setValue(-1);
        int attrIndex = attributes.indexOf("userLabel");
        if (attrIndex != -1) {
            String str = (String)attributes.getValue(attrIndex);
            userLabel.setValue(str);
        } else {
            userLabel.setValue("");
        }
        this.myData.registerPersistentAttr((Attribute)this.timDeviceRef1);
        this.myData.registerPersistentAttr((Attribute)this.timDeviceRef2);
        this.myData.registerPersistentAttr((Attribute)this.plugInUnitRef1);
        this.myData.registerPersistentAttr((Attribute)this.plugInUnitRef2);
        this.myData.registerPersistentAttr((Attribute)this.roSyncResId1);
        this.myData.registerPersistentAttr((Attribute)this.roSyncResId2);
        this.myData.registerPersistentAttr((Attribute)userLabel);
        this.initAlarmStatus(0, context);
        this.myData.setRevision(3020001);
        if (this.plugInUnitRef1 != null && (mo = this.plugInUnitRef1.getValue(context)) != null) {
            ((Reservable)mo).reserve((ManagedObject)this, context);
        }
        if (this.plugInUnitRef2 != null && (mo = this.plugInUnitRef2.getValue(context)) != null) {
            ((Reservable)mo).reserve((ManagedObject)this, context);
        }
    }

    public void bringTimIntoService(PlugInUnitMo moPlugInUnit, TimDeviceMo moTimDevice, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "bringTimIntoService()");
        if (moPlugInUnit == null) {
            String errMsg = " null ref: PlugInUnit of TIM.";
            MessageLog.traceError(this.getClass(), errMsg);
            throw new MoNotFoundException(errMsg);
        }
        if (moTimDevice == null) {
            String errMsg = " null ref: TimDevice.";
            MessageLog.traceError(this.getClass(), errMsg);
            throw new MoNotFoundException("null ref: TimDevice");
        }
        PlugInUnitMo moRefPiu1 = (PlugInUnitMo)this.getPlugInUnitRef1(context);
        PlugInUnitMo moRefPiu2 = (PlugInUnitMo)this.getPlugInUnitRef2(context);
        if (moPlugInUnit == moRefPiu1 || moPlugInUnit == moRefPiu2) {
            MessageLog.trace(2, this.getClass(), "PIU already has TIM in service.");
            throw new MoCanNotBeCreatedException("TimDeviceSet");
        }
        if (moRefPiu1 == null) {
            this.bringTimIntoService(1, moPlugInUnit, moTimDevice, context);
        } else if (moRefPiu2 == null) {
            this.bringTimIntoService(2, moPlugInUnit, moTimDevice, context);
        } else {
            MessageLog.trace(2, this.getClass(), "Both TIM already in service.");
            throw new MoCanNotBeCreatedException("TimDeviceSet");
        }
    }

    private void bringTimIntoService(int refNr, PlugInUnitMo moPlugInUnit, TimDeviceMo moTimDevice, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "bringTimIntoService()/4 called for TIM nr " + refNr + ".");
        int piuResId = moPlugInUnit.getFroId(context);
        LrsCreateSyncResRspS rspSig = this.ecTimingProxy.createSyncRes(this.getTxIdTransactional(context), 0, piuResId);
        if (refNr == 1) {
            this.setPlugInUnitRef1((ManagedObject)moPlugInUnit, context);
            this.setTimDeviceRef1(moTimDevice, context);
            this.setRoSyncResId1(rspSig.syncResId, context);
        } else {
            this.setPlugInUnitRef2((ManagedObject)moPlugInUnit, context);
            this.setTimDeviceRef2(moTimDevice, context);
            this.setRoSyncResId2(rspSig.syncResId, context);
        }
        moTimDevice.setSyncResId(rspSig.syncResId, context);
        moTimDevice.reserve(this, context);
        MessageLog.trace(2, this.getClass(), "TIM nr " + refNr + " was brought into service");
    }

    public void bringTimOutOfService(PlugInUnitMo moPlugInUnit, TimDeviceMo moTimDevice, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "bringTimOutOfService()");
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
        if (moPlugInUnit == null) {
            String errMsg = " null ref: PlugInUnit of TIM.";
            MessageLog.traceError(this.getClass(), errMsg);
            throw new MoNotFoundException(errMsg);
        }
        if (moTimDevice == null) {
            String errMsg = " null ref: TimDevice.";
            MessageLog.traceError(this.getClass(), errMsg);
            throw new MoNotFoundException("null ref: TimDevice");
        }
        ManagedObject mo1 = this.getPlugInUnitRef1(context);
        ManagedObject mo2 = this.getPlugInUnitRef2(context);
        PlugInUnitMo moRefPiu1 = null;
        PlugInUnitMo moRefPiu2 = null;
        if (mo1 != null && mo1 instanceof PlugInUnitMo) {
            moRefPiu1 = (PlugInUnitMo)this.getPlugInUnitRef1(context);
        } else if (mo1 != null) {
            MessageLog.traceEnter(this.getClass(), "bringTimOutOfService(), the motype for piu1:" + mo1.getType());
        } else {
            MessageLog.traceEnter(this.getClass(), "bringTimOutOfService(), the piu1 ref is null");
        }
        if (mo2 != null && mo2 instanceof PlugInUnitMo) {
            moRefPiu2 = (PlugInUnitMo)this.getPlugInUnitRef2(context);
        } else if (mo2 != null) {
            MessageLog.traceEnter(this.getClass(), "bringTimOutOfService(), the motype for piu2:" + mo2.getType());
        } else {
            MessageLog.traceEnter(this.getClass(), "bringTimOutOfService(), the piu2 ref is null");
        }
        if (moRefPiu1 == moPlugInUnit) {
            this.bringTimOutOfService(1, moPlugInUnit, moTimDevice, context);
        } else if (moRefPiu2 == moPlugInUnit) {
            this.bringTimOutOfService(2, moPlugInUnit, moTimDevice, context);
        } else {
            String errMsg = "PIU has no TIM in service.";
            MessageLog.trace(2, this.getClass(), errMsg);
            throw new MoNotFoundException("Ref not in use: PlugInUnit of TIM");
        }
    }

    private void bringTimOutOfService(int refNr, PlugInUnitMo moPlugInUnit, TimDeviceMo moTimDevice, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "bringTimOutOfService()/4 called for TIM nr " + refNr + ".");
        moTimDevice.getReservedBy(context);
        if (refNr == 1) {
            this.ecTimingProxy.deleteSyncRes(this.getTxIdTransactional(context), 0, this.getRoSyncResId1(context));
            this.setRoSyncResId1(-1, context);
            this.setPlugInUnitRef1(null, context);
            this.setTimDeviceRef1(null, context);
        } else {
            this.ecTimingProxy.deleteSyncRes(this.getTxIdTransactional(context), 0, this.getRoSyncResId2(context));
            this.setRoSyncResId2(-1, context);
            this.setPlugInUnitRef2(null, context);
            this.setTimDeviceRef2(null, context);
        }
        moTimDevice.clearSyncResId(context);
        moTimDevice.release(this, context);
        MessageLog.trace(2, this.getClass(), "TIM nr " + refNr + " was brought out of service");
    }

    public void actionSwitchMasterTu(Coordinator context) throws MoAccessException, NoSlaveTuException, SlaveTuNotStableException {
        MessageLog.traceEnter(this.getClass(), "actionSwitchMasterTu()");
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
        if (BoamHelper.findMOs("DeviceGroup", "DUI").hasMoreElements()) {
            throw new FunctionNotSupportedException();
        }
        try {
            this.ecTimingProxy.switchSyncRes(0);
        }
        catch (FroRequestFailedException e) {
            if (e.getOrgErrorCode() == 3) {
                throw new NoSlaveTuException();
            }
            if (e.getOrgErrorCode() == 4) {
                throw new SlaveTuNotStableException();
            }
            throw e;
        }
    }

    public boolean getNodeIsSynchronized(Coordinator context) throws MoAccessException {
        int nodeIsSynchronized = 0;
        MessageLog.traceEnter(this.getClass(), "getNodeIsSynchronized()");
        int roSyncResId = this.getRoSyncResId1(context);
        if (roSyncResId != -1) {
            nodeIsSynchronized = this.getSyncData((int)roSyncResId, (Coordinator)context).isNodeSynchronized;
        } else {
            roSyncResId = this.getRoSyncResId2(context);
            if (roSyncResId != -1) {
                nodeIsSynchronized = this.getSyncData((int)roSyncResId, (Coordinator)context).isNodeSynchronized;
            }
        }
        return nodeIsSynchronized == 1;
    }

    /*
     * WARNING - void declaration
     */
    public int getSyncResId(Coordinator context, ManagedObject moTimDeviceRef) throws MoAccessException, AttrNotReadableException {
        void var3_6;
        MessageLog.traceEnter(this.getClass(), "getSyncResId()");
        int attrIndex = this.selectAttribute(context, moTimDeviceRef);
        if (attrIndex == -1) {
            String msg = "Bring into service has not been performed.This is precondition for creation of Node Synch TP or Unknown moTimDevice reference";
            MessageLog.trace(2, this.getClass(), msg);
            throw new AttrNotReadableException((ManagedObject)this, msg);
        }
        switch (attrIndex) {
            case 1: {
                int roSyncResId = this.getRoSyncResId1(context);
                break;
            }
            case 2: {
                int roSyncResId = this.getRoSyncResId2(context);
                break;
            }
            default: {
                String msg = "Unknown moTimDevice reference";
                throw new AttrNotReadableException((ManagedObject)this, msg);
            }
        }
        return (int)var3_6;
    }

    private int selectAttribute(Coordinator context, ManagedObject moTimDeviceRef) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "selectAttribute()");
        ManagedObject timDev1 = this.getTimDeviceRef1(context);
        if (timDev1 != null && timDev1.getLocalDistinguishedName().equals(moTimDeviceRef.getLocalDistinguishedName())) {
            return 1;
        }
        if (timDev1 == null) {
            MessageLog.trace(2, this.getClass(), "The TimDeviceRef1 is  null");
        } else {
            MessageLog.trace(2, this.getClass(), "TimDeviceRef1: " + timDev1.getLocalDistinguishedName() + ", expected TimDeviceRef" + moTimDeviceRef.getLocalDistinguishedName());
        }
        ManagedObject timDev2 = this.getTimDeviceRef2(context);
        if (timDev2 != null && timDev2.getLocalDistinguishedName().equals(moTimDeviceRef.getLocalDistinguishedName())) {
            return 2;
        }
        if (timDev2 == null) {
            MessageLog.trace(2, this.getClass(), "The TimDeviceRef2 is  null");
        } else {
            MessageLog.trace(2, this.getClass(), ", TimDeviceRef2: " + timDev2.getLocalDistinguishedName() + ", expected TimDeviceRef" + moTimDeviceRef.getLocalDistinguishedName());
        }
        return 3;
    }

    public String getType() {
        return "RbsSynchronization";
    }

    public void delete(Coordinator context) throws UndeletableMoException {
        MessageLog.traceEnter(this.getClass(), "delete()");
        MessageLog.trace(1, this.getClass(), "MO is Undeleteable");
        throw new UndeletableMoException((ManagedObject)this);
    }

    public void setUserLabel(String str, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setUserLabel()");
        if (str.length() > 128) {
            String msg = "userLabel attribute has value out of range; string length should be =< 128";
            MessageLog.traceError(this.getClass(), msg);
            throw new ValueOutOfRangeException(msg, this.getType());
        }
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
        StringAttribute tmpStringAttr = (StringAttribute)this.myData.getAttribute("userLabel");
        tmpStringAttr.setValue(str);
        this.sendAVC("userLabel", str, context);
    }

    public String getUserLabel(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getUserLabel()");
        this.myData.handleTransaction(context, MoData.READ_ACCESS);
        StringAttribute tmpStringAttr = (StringAttribute)this.myData.getAttribute("userLabel");
        return tmpStringAttr.getValue(context);
    }

    public ManagedObject getTimDeviceRef1(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getTimDeviceRef1()");
        this.myData.handleTransaction(context, MoData.READ_ACCESS);
        ReferenceAttribute tmpRefAttr = (ReferenceAttribute)this.myData.getAttribute("timDeviceRef1");
        return tmpRefAttr.getValue(context);
    }

    public ManagedObject getTimDeviceRef2(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getTimDeviceRef2()");
        this.myData.handleTransaction(context, MoData.READ_ACCESS);
        ReferenceAttribute tmpRefAttr = (ReferenceAttribute)this.myData.getAttribute("timDeviceRef2");
        return tmpRefAttr.getValue(context);
    }

    public ManagedObject getPlugInUnitRef1(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getPlugInUnitRef1()");
        this.myData.handleTransaction(context, MoData.READ_ACCESS);
        ReferenceAttribute tmpRefAttr = (ReferenceAttribute)this.myData.getAttribute("plugInUnitRef1");
        return tmpRefAttr.getValue(context);
    }

    public ManagedObject getPlugInUnitRef2(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getPlugInUnitRef2()");
        this.myData.handleTransaction(context, MoData.READ_ACCESS);
        ReferenceAttribute tmpRefAttr = (ReferenceAttribute)this.myData.getAttribute("plugInUnitRef2");
        return tmpRefAttr.getValue(context);
    }

    private void setTimDeviceRef2(ManagedObject mo, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setTimDeviceRef2()");
        ValidateAttributes.checkTransaction(context);
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
        this.timDeviceRef2.setValue(mo);
    }

    private void setTimDeviceRef1(ManagedObject mo, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setTimDeviceRef1()");
        ValidateAttributes.checkTransaction(context);
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
        this.timDeviceRef1.setValue(mo);
    }

    private void setPlugInUnitRef1(ManagedObject mo, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setPlugInUnitRef1()");
        ValidateAttributes.checkTransaction(context);
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
        if (this.plugInUnitRef1 != null) {
            ManagedObject _mo = this.plugInUnitRef1.getValue(context);
            if (_mo != null) {
                ((Reservable)_mo).release((ManagedObject)this, context);
            }
            if (mo != null) {
                ((Reservable)mo).reserve((ManagedObject)this, context);
            }
            this.plugInUnitRef1.setValue(mo);
        }
    }

    private void setPlugInUnitRef2(ManagedObject mo, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setPlugInUnitRef2()");
        ValidateAttributes.checkTransaction(context);
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
        if (this.plugInUnitRef2 != null) {
            ManagedObject _mo = this.plugInUnitRef2.getValue(context);
            if (_mo != null) {
                ((Reservable)_mo).release((ManagedObject)this, context);
            }
            if (mo != null) {
                ((Reservable)mo).reserve((ManagedObject)this, context);
            }
            this.plugInUnitRef2.setValue(mo);
        }
    }

    private void setRoSyncResId1(int value, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setRoSyncResId1()");
        ValidateAttributes.checkTransaction(context);
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
        this.roSyncResId1.setValue(value);
    }

    private void setRoSyncResId2(int value, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setRoSyncResId2()");
        ValidateAttributes.checkTransaction(context);
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
        this.roSyncResId2.setValue(value);
    }

    private int getRoSyncResId1(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getRoSyncResId1()");
        this.myData.handleTransaction(context, MoData.READ_ACCESS);
        return this.roSyncResId1.getValue(context);
    }

    private int getRoSyncResId2(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getRoSyncResId2()");
        this.myData.handleTransaction(context, MoData.READ_ACCESS);
        return this.roSyncResId2.getValue(context);
    }

    public int getMasterTu(Coordinator context) throws MoAccessException {
        PlugInUnitMaoi moRefPiu;
        int piuResId;
        MessageLog.traceEnter(this.getClass(), "getMasterTu()");
        int roSyncResId = this.getRoSyncResId1(context);
        if (roSyncResId != -1 && this.getSyncData((int)roSyncResId, (Coordinator)context).masterTuId == (piuResId = (moRefPiu = (PlugInUnitMaoi)this.getPlugInUnitRef1(context)).getFroId(context))) {
            return 1;
        }
        roSyncResId = this.getRoSyncResId2(context);
        if (roSyncResId != -1 && this.getSyncData((int)roSyncResId, (Coordinator)context).masterTuId == (piuResId = (moRefPiu = (PlugInUnitMaoi)this.getPlugInUnitRef2(context)).getFroId(context))) {
            return 2;
        }
        return 0;
    }

    public boolean getNodeIsStable(Coordinator context) throws MoAccessException {
        int nodeIsStable = 0;
        MessageLog.traceEnter(this.getClass(), "getNodeIsStable()");
        this.myData.handleTransaction(context, MoData.READ_ACCESS);
        int roSyncResId = this.getRoSyncResId1(context);
        if (roSyncResId != -1) {
            nodeIsStable = this.getSyncData((int)roSyncResId, (Coordinator)context).nodeIsStable;
        } else {
            roSyncResId = this.getRoSyncResId2(context);
            if (roSyncResId != -1) {
                nodeIsStable = this.getSyncData((int)roSyncResId, (Coordinator)context).nodeIsStable;
            }
        }
        return nodeIsStable == 1;
    }

    public MoData getMyMoData() {
        MessageLog.traceEnter(this.getClass(), "getMyMoData()");
        return this.myData;
    }

    public boolean isMyMoDataPersistent() {
        MessageLog.traceEnter(this.getClass(), "isMyMoDataPersistent()");
        return true;
    }

    public void eventRaised(InSignal receiveSig) {
        MessageLog.traceEnter(this.getClass(), "eventRaised()");
        if (receiveSig instanceof LrsSyncResEventIndS) {
            MessageLog.trace(6, this.getClass(), " LrsSyncResEventIndS received ");
            String objectClass = this.getType();
            String managedObjectInstance = this.getFullDistinguishedName();
            String eventType = "0";
            String eventTime = "";
            String additionalText = this.bcmGetMEUserLabel();
            LrsSyncResEventIndS recSig = (LrsSyncResEventIndS)receiveSig;
            String specificEvent = "";
            if (recSig.eventType == 49352) {
                specificEvent = this.getType() + TAG_LRS_SYNC_RES_NODE_SYNCHRONIZATION_REDUNDANCY_SWITCH_OVER;
                MessageLog.trace(6, this.getClass(), "MO = " + objectClass + " specificEvent = _NodeSynchronizationRedundancySwitchOver");
                new Event(objectClass, managedObjectInstance, eventType, eventTime, specificEvent, additionalText, null);
            } else {
                MessageLog.traceError(this.getClass(), "Unknown event received");
            }
        }
    }

    private LrsGetSyncResParamRspS getSyncData(int roSyncResId, Coordinator context) throws MoAccessException {
        return this.ecTimingProxy.getSyncResParam(0, this.getTxIdNonTransactional(context), roSyncResId);
    }

    private void addObservers(int froType, Coordinator context) throws MoAccessException {
        this.myMoAlarms = new MoAlarms((ManagedObject)this, this.ecTimingProxy, froType, -5, context);
        this.myMoEvents = new MoEvents(this, this.ecTimingProxy, -5, context);
        this.ecTimingProxy.registerForPlugAndPLayInd(context, this, -5L);
    }

    public int getFroId(Coordinator c) {
        MessageLog.traceEnter(this.getClass(), "getFroId()");
        return -5;
    }

    public void plugAndPlayInd(InSignal pnpIndSig) {
        int timDeviceFroId = 0;
        int newValue = 0;
        TimDeviceMo timDeviceRef2 = null;
        MessageLog.traceEnter(this.getClass(), "plugAndPlayInd()");
        if (pnpIndSig == null) {
            MessageLog.traceError(this.getClass(), "The received signal is null!!");
            return;
        }
        if (pnpIndSig.getClass().getName().equals(EcSyncResAvcIndS.class.getName())) {
            Control tx = null;
            try {
                tx = TransactionServiceImpl.instance().getTransactionFactory().create(1000);
                Coordinator txCoordinator = tx.getCoordinator();
                timDeviceFroId = ((EcSyncResAvcIndS)pnpIndSig).masterTuId;
                TimDeviceMo timDeviceRef1 = (TimDeviceMo)this.getTimDeviceRef1(txCoordinator);
                timDeviceRef2 = (TimDeviceMo)this.getTimDeviceRef2(txCoordinator);
                if (timDeviceRef1 != null && timDeviceFroId == timDeviceRef1.getFroId(txCoordinator)) {
                    newValue = 1;
                } else if (timDeviceRef2 != null && timDeviceFroId == timDeviceRef2.getFroId(txCoordinator)) {
                    newValue = 2;
                }
                this.sendAVC("masterTu", newValue, txCoordinator);
                tx.getTerminator().commit();
            }
            catch (Exception e) {
                MessageLog.traceError(this.getClass(), "sendAVC for MasterTu is failed du to:" + e);
                try {
                    if (tx != null) {
                        tx.getTerminator().rollback();
                    }
                }
                catch (InactiveTransactionException e1) {}
            }
        } else {
            MessageLog.traceError(this.getClass(), "unexpected signal is received!! recSig:" + pnpIndSig.getClass().getName());
        }
    }

    public void _changeTimDevRef_4_test_only(ManagedObject timDevMo, boolean ref1, Coordinator c) throws MoAccessException {
        if (ref1) {
            this.setTimDeviceRef1(timDevMo, c);
        } else {
            this.setTimDeviceRef2(timDevMo, c);
        }
    }

    static {
        singletonLock = new Object();
    }
}

