/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.mao.rmo.node;

import java.util.ArrayList;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.ManagedObjectBase;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.UndeletableMoException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.common.FroRequestFailedException;
import se.ericsson.wcdma.rbs.boam.common.Strings;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.fpx.ncmi.proxies.NcSystemConstantsProxy;
import se.ericsson.wcdma.rbs.boam.fpx.ncmi.sigs.BcGetSysConstRspS;
import se.ericsson.wcdma.rbs.boam.mao.common.SystemConstant;
import se.ericsson.wcdma.rbs.boam.mao.common.ValidateAttributes;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.excep.InternalErrorException;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.excep.NotFoundException;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.excep.ParameterValueErrorException;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.excep.ResourceLockedException;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.excep.SysConstantsFullException;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.SystemConstantsMo;

public class SystemConstantsMoImpl
extends ManagedObjectBase
implements SystemConstantsMo {
    private static SystemConstantsMoImpl instance;
    private static final String SYSCONSTANT_SEPARATOR_COMMA = ",";
    private static final String SYSCONSTANT_SEPARATOR_COLON = ":";
    public static final int MO_DATA_REVISION = 20030300;
    private MoData myData;

    public SystemConstantsMoImpl(MoData recoveredData) throws MoNameAlreadyTakenException {
        super(recoveredData.getLocalDistinguishedName());
        MessageLog.traceEnter(this.getClass(), "recovered SystemConstantsMo() <---");
        instance = this;
        this.myData = recoveredData;
    }

    private SystemConstantsMoImpl(ManagedObject parent, String identity, Coordinator c) throws MoAccessException, MoNameAlreadyTakenException {
        super(parent, "SystemConstants", identity, c);
        this.myData = new MoData(this.getLocalDistinguishedName(), this.getType(), true, c);
        this.myData.handleTransaction(c, MoData.WRITE_ACCESS);
        this.myData.setRevision(20030300);
    }

    public static synchronized ManagedObject create(ManagedObject parent, AttrList attribute, String identity, ManagedObject source, Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(SystemConstantsMoImpl.class, "create() <---");
        ValidateAttributes.checkParent(parent, "NodeBFunction");
        if (instance == null) {
            instance = new SystemConstantsMoImpl(parent, identity, c);
        }
        return instance;
    }

    public static void _reset_onlyForTest() {
        MessageLog.traceEnter(SystemConstantsMoImpl.class, "_reset_onlyForTest()");
        instance = null;
    }

    public void delete(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "delete() <---");
        throw new UndeletableMoException((ManagedObject)this);
    }

    public String getType() {
        return "SystemConstants";
    }

    public String getSysConstants(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getSysConstants()<---");
        BcGetSysConstRspS rspSig = NcSystemConstantsProxy.instance().getSystemConstants(0, ValidateAttributes.getTxIdNonTransactional(c));
        return rspSig.sysConstants;
    }

    public void actionWriteConst(String name, String value, Coordinator c) throws MoAccessException, SysConstantsFullException, InternalErrorException, ResourceLockedException, ParameterValueErrorException {
        MessageLog.traceEnter(this.getClass(), "actionWriteConst(" + name + SYSCONSTANT_SEPARATOR_COMMA + value + ")<---");
        this.myData.handleTransaction(c, MoData.WRITE_ACCESS);
        try {
            NcSystemConstantsProxy.instance().writeSystemConstant(0, ValidateAttributes.getTxIdTransactional(c), name, value);
        }
        catch (FroRequestFailedException e) {
            if (e.getOrgErrorCode() == 5) {
                throw new SysConstantsFullException();
            }
            if (e.getOrgErrorCode() == 4) {
                throw new ParameterValueErrorException();
            }
            if (e.getOrgErrorCode() == 1) {
                throw new ResourceLockedException();
            }
            if (e.getOrgErrorCode() == 3) {
                throw new InternalErrorException();
            }
            throw e;
        }
    }

    public void actionDeleteConst(String name, Coordinator c) throws MoAccessException, NotFoundException, InternalErrorException, ResourceLockedException, ParameterValueErrorException {
        MessageLog.traceEnter(this.getClass(), "actionDeleteConst(" + name + ")<---");
        this.myData.handleTransaction(c, MoData.WRITE_ACCESS);
        try {
            NcSystemConstantsProxy.instance().deleteSystemConstant(0, ValidateAttributes.getTxIdTransactional(c), name);
        }
        catch (FroRequestFailedException e) {
            if (e.getOrgErrorCode() == 6) {
                throw new NotFoundException();
            }
            if (e.getOrgErrorCode() == 4) {
                throw new ParameterValueErrorException();
            }
            if (e.getOrgErrorCode() == 1) {
                throw new ResourceLockedException();
            }
            if (e.getOrgErrorCode() == 3) {
                throw new InternalErrorException();
            }
            throw e;
        }
    }

    public String getSysConstantValue(Coordinator c, String constantName) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getSysConstantValue()");
        String[] sysConst = this.getSysConstantValues(c, new String[]{constantName});
        if (sysConst != null && sysConst.length > 0) {
            return sysConst[0];
        }
        return null;
    }

    public String[] getSysConstantValues(Coordinator c, String[] constantNames) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getSysConstantValues()");
        SystemConstant[] systemConstants = this.getSystemConstants(c);
        String[] values = new String[constantNames.length];
        for (int i = 0; i < constantNames.length; ++i) {
            for (int j = 0; j < systemConstants.length; ++j) {
                if (!constantNames[i].equals(systemConstants[j].getName())) continue;
                values[i] = systemConstants[j].getValue();
                break;
            }
            if (values[i] != null) continue;
            MessageLog.trace(2, this.getClass(), "Did not find system constant " + constantNames[i]);
        }
        return values;
    }

    public SystemConstant[] getSystemConstants(Coordinator c) throws MoAccessException {
        String[] sysConstList;
        MessageLog.traceEnter(this.getClass(), "getSystemConstants()");
        String sysConstants = this.getSysConstants(c);
        ArrayList<SystemConstant> result2 = new ArrayList<SystemConstant>();
        if (sysConstants != null && sysConstants.trim().length() > 0 && (sysConstList = Strings.split(sysConstants, SYSCONSTANT_SEPARATOR_COMMA)) != null && sysConstList.length > 0) {
            for (int i = 0; i < sysConstList.length; ++i) {
                int colonIndex = sysConstList[i].indexOf(SYSCONSTANT_SEPARATOR_COLON);
                if (colonIndex <= 0 || sysConstList[i].length() <= colonIndex + 1) {
                    MessageLog.traceError(this.getClass(), "Unable to parse system constants string, colonIndex = " + colonIndex + ", value = " + sysConstList[i]);
                    return new SystemConstant[0];
                }
                String name = sysConstList[i].substring(0, colonIndex);
                String value = sysConstList[i].substring(colonIndex + 1);
                result2.add(new SystemConstant(name, value));
            }
        }
        return result2.toArray(new SystemConstant[result2.size()]);
    }
}

