/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.pmcommon;

import se.ericsson.crbs.cat.pmcommon.PmDeepCloneable;

public class PmCounterDefinition
implements Comparable,
PmDeepCloneable {
    public final int counterId;
    public final String counterName;
    public final int multiplicity;
    private boolean m_isActivated;
    private boolean m_isEnabled;
    private int m_numRefCount = 0;

    public PmCounterDefinition(int cid, String cname, int mlt) {
        this.counterId = cid;
        this.counterName = cname;
        this.multiplicity = mlt;
    }

    public int activateCounter() {
        ++this.m_numRefCount;
        this.m_isActivated = true;
        return this.m_numRefCount;
    }

    public int deactivateCounter() {
        --this.m_numRefCount;
        if (0 == this.m_numRefCount) {
            this.m_isActivated = false;
            this.m_isEnabled = false;
        }
        return this.m_numRefCount;
    }

    public boolean isCounterActivated() {
        return this.m_isActivated;
    }

    public void enableForReporting() {
        this.m_isEnabled = true;
    }

    public boolean isEnabledForReporting() {
        return this.m_isEnabled;
    }

    public int compareTo(Object other) {
        if (other instanceof PmCounterDefinition) {
            PmCounterDefinition o = (PmCounterDefinition)other;
            if (this.counterId < o.counterId) {
                return -1;
            }
            if (this.counterId > o.counterId) {
                return 1;
            }
            return 0;
        }
        return -1;
    }

    public PmDeepCloneable deepClone() {
        PmCounterDefinition copy = new PmCounterDefinition(this.counterId, this.counterName, this.multiplicity);
        copy.m_isActivated = this.m_isActivated;
        copy.m_isEnabled = this.m_isEnabled;
        copy.m_numRefCount = this.m_numRefCount;
        return copy;
    }
}

