/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.pmproxy;

import se.ericsson.crbs.cat.pmapplication.PmThreadSwitcherI;
import se.ericsson.crbs.cat.pmcommon.PmBaseState;
import se.ericsson.crbs.cat.pmcommon.PmBaseStateMachine;
import se.ericsson.crbs.cat.pmcommon.PmClassCounter;
import se.ericsson.crbs.cat.pmcommon.PmClassCounterDefinition;
import se.ericsson.crbs.cat.pmcommon.PmClassCounterDefinitions;
import se.ericsson.crbs.cat.pmcommon.PmClassGroup;
import se.ericsson.crbs.cat.pmcommon.PmClassGroups;
import se.ericsson.crbs.cat.pmcommon.PmClassInstance;
import se.ericsson.crbs.cat.pmcommon.PmClassInstances;
import se.ericsson.crbs.cat.pmcommon.PmCounterDefinition;
import se.ericsson.crbs.cat.pmcommon.PmInstance;
import se.ericsson.crbs.cat.pmcommon.PmInstanceGroup;
import se.ericsson.crbs.cat.pmcommon.PmLists;
import se.ericsson.crbs.cat.pmpms.PmMeasuredDataI;
import se.ericsson.crbs.cat.pmpms.PmMeasuredInstantData;
import se.ericsson.crbs.cat.pmproxy.PmProxyI;
import se.ericsson.crbs.cat.pmproxy.PmSessionHandler;
import se.ericsson.crbs.cat.pmproxy.signals.PmSignals;
import se.ericsson.crbs.omf.mao.commonmo.ResourceUnavailableException;

public class PmPmcciSession
extends PmBaseStateMachine {
    private final PmProxyI m_proxy;
    private final int m_pid;
    private final PmSessionHandler.Callback m_callback;
    private final PmThreadSwitcherI m_threadSwitcher;
    private final String m_serverInstanceName;
    private final PmClassCounterDefinitions m_classCounterDefs = new PmClassCounterDefinitions();
    private final PmClassInstances m_classInstances = new PmClassInstances();
    private long m_clientConnectionRef;
    private long m_serverConnectionRef;
    private long m_protocolRevision;
    private long m_procedureRef;
    private InstantCounterStateValues m_fetchInstantCountersState;
    private FrozenRDataStateValues m_fetchFrozenCountersRDataValues;

    public PmPmcciSession(PmProxyI proxy, int pid, PmSessionHandler.Callback callback, PmThreadSwitcherI threadSwitcher, String serverInstanceName) {
        super(State.Setup_Initial, State.Terminated_Fault);
        this.enter("PmPmcciSession");
        this.general("PmcciSession created. Pidno: " + pid);
        this.m_proxy = proxy;
        this.m_pid = pid;
        this.m_callback = callback;
        this.m_threadSwitcher = threadSwitcher;
        this.m_serverInstanceName = serverInstanceName;
    }

    public boolean onValidateState(PmBaseState currentState) {
        boolean result = true;
        result = currentState == State.Running_SendingFetchInstantRequest ? this.m_fetchInstantCountersState != null : (currentState == State.Running_AwaitingInstantCounterData ? this.m_fetchInstantCountersState != null : (currentState == State.Running_SendingFetchFrozenRequest ? this.m_fetchFrozenCountersRDataValues != null : (currentState == State.Running_AwaitingFrozenCounterData ? this.m_fetchFrozenCountersRDataValues != null : this.m_fetchFrozenCountersRDataValues == null && this.m_fetchInstantCountersState == null)));
        return result;
    }

    public boolean isUpdatingActive() {
        this.enter("isUpdatingActive");
        return this.isAtState(State.Running_SendingActiveCounters);
    }

    public boolean isFreezingCounters() {
        this.enter("isFreezingCounters");
        return this.isAtState(State.Running_SendingFreezeRequest);
    }

    public boolean isReportingCounters() {
        this.enter("isReportingCounters");
        return this.isAtState(State.Running_SendingFetchFrozenRequest) || this.isAtState(State.Running_AwaitingFrozenCounterData);
    }

    public boolean isReportingInstantCounters() {
        this.enter("isReportingInstantCounters");
        return this.isAtState(State.Running_SendingFetchInstantRequest) || this.isAtState(State.Running_AwaitingInstantCounterData);
    }

    public boolean isRunning() {
        this.enter("isRunning");
        return this.isBetweenStates(State.Running_Awaiting, State.Running_End);
    }

    public boolean terminateNonResponding() {
        boolean toBeTerminated;
        this.enter("terminateNonRespondingSessions");
        boolean bl = toBeTerminated = this.isAtState(State.Running_SendingActiveCounters) || this.isAtState(State.Running_SendingFreezeRequest) || this.isAtState(State.Running_SendingFetchFrozenRequest) || this.isAtState(State.Running_AwaitingFrozenCounterData) || this.isAtState(State.Running_SendingFetchInstantRequest) || this.isAtState(State.Running_AwaitingInstantCounterData);
        if (toBeTerminated) {
            this.error("Terminating session with: pid = " + this.m_pid + " serverConnectionRef: " + this.m_serverConnectionRef + " clientConnectionRef: " + this.m_clientConnectionRef);
            this.terminate();
        }
        return true;
    }

    public boolean hasRegisteredMoLdn(String moClassName, String moLDN) {
        this.enter("hasRegisteredMoLdn");
        PmClassCounterDefinition classCounterDef = this.m_classCounterDefs.findClassCounterDefinitionByName(moClassName);
        if (classCounterDef == null) {
            this.general("This session does not handle MoClassName: " + moClassName);
            return false;
        }
        PmClassInstance classInstance = this.m_classInstances.findClassInstanceById(classCounterDef.moClassId);
        if (classInstance == null) {
            this.error("Received unexpected call for MoClassName: " + moClassName + " with LDN: " + moLDN);
            return true;
        }
        PmInstance instance = classInstance.findInstanceByName(moLDN);
        if (instance == null) {
            this.info("No registered measurement object with LDN: " + moLDN + " found for MoClassName: " + moClassName);
            if (moClassName.equals("EnergyMeter")) {
                this.general("EnergyMeter -> don't set ResourceUnavailableException");
                return false;
            }
        }
        return true;
    }

    public void start(long clientConnectionRef) {
        this.enter("start");
        if (!this.validateState(State.Setup_Initial)) {
            return;
        }
        if (!this.updateState(State.Setup_Initial, State.Setup_ConnToServerRequest)) {
            return;
        }
        this.m_clientConnectionRef = clientConnectionRef;
        PmSignals.Send.PmcciConnToServerReq pmcciConnToServerReq = new PmSignals.Send.PmcciConnToServerReq();
        pmcciConnToServerReq.procedureRef = this.m_clientConnectionRef;
        pmcciConnToServerReq.connectionRef = this.m_clientConnectionRef;
        pmcciConnToServerReq.supportedProtocolRevisionsList = new long[]{3L};
        this.m_proxy.sendSignal(pmcciConnToServerReq, this.m_pid);
    }

    public void connToServerCfm(long procedureRef, long serverConnectionRef, long protocolRevision) {
        this.enter("connToServerCfm");
        if (!this.validateState(State.Setup_ConnToServerRequest)) {
            return;
        }
        this.m_serverConnectionRef = serverConnectionRef;
        this.m_protocolRevision = protocolRevision;
        this.debug("Used protocol revision: " + this.m_protocolRevision);
        if (!this.updateState(State.Setup_ConnToServerRequest, State.Setup_AwaitingCounters)) {
            return;
        }
    }

    public void connToServerRej(long procedureRef, long serverConnectionRef, long errorCode) {
        this.enter("connToServerRej");
        if (!this.validateState(State.Setup_ConnToServerRequest)) {
            return;
        }
        this.error("Received connToServerRej with error code: " + errorCode);
        this.terminate();
    }

    public void registerCounters(long procedureRef, boolean moreDataExists, PmSignals.PmcciMoClassItem[] moClassDefinitions) {
        this.enter("registerCounters");
        if (!this.validateState(State.Setup_AwaitingCounters)) {
            String errorMessage = "Signal received in wrong state!";
            this.sendPmcciRegisterCountersRrej(procedureRef, errorMessage);
            return;
        }
        if (!this.validateCounterDefinitions(moClassDefinitions)) {
            String errorMessage = "Rejected due to invalid or inconsistent indata!";
            this.sendPmcciRegisterCountersRrej(procedureRef, errorMessage);
            return;
        }
        if (this.m_callback.sessionHandler_registerCounters()) {
            for (int moClassIdx = 0; moClassIdx < moClassDefinitions.length; ++moClassIdx) {
                PmSignals.PmcciMoClassItem moClassDef = moClassDefinitions[moClassIdx];
                PmClassCounterDefinition ccdef = this.m_classCounterDefs.getClassCounterDefinition(moClassDef.moClassId, moClassDef.maxNumberOfMoInstances, moClassDef.moClassName);
                PmSignals.PmcciCounterRegistrationItem[] counterDefs = moClassDef.counterRegistrationItems;
                for (int counterIdx = 0; counterIdx < counterDefs.length; ++counterIdx) {
                    PmSignals.PmcciCounterRegistrationItem counterDef = counterDefs[counterIdx];
                    PmCounterDefinition cdef = new PmCounterDefinition(counterDef.counterId, counterDef.counterName, counterDef.multiplicity);
                    if (ccdef.addCounterDefinition(cdef)) continue;
                    this.error("Failed to add counter def, CounterId: " + cdef.counterId + " CounterName: " + cdef.counterName);
                }
            }
            PmSignals.Send.PmcciRegisterCountersRcfm pmcciRegisterCountersRcfm = new PmSignals.Send.PmcciRegisterCountersRcfm();
            pmcciRegisterCountersRcfm.procedureRef = procedureRef;
            pmcciRegisterCountersRcfm.connectionRef = this.m_serverConnectionRef;
            this.m_proxy.sendSignal(pmcciRegisterCountersRcfm, this.m_pid);
            if (!moreDataExists) {
                this.setActiveCounters(State.Setup_AwaitingCounters, State.Setup_SendingActiveCounters, new PmSignals.PmcciActivateCounterItem[0]);
            }
        } else {
            String errorMessage = "Internal error, failed to register counters!";
            this.sendPmcciRegisterCountersRrej(procedureRef, errorMessage);
            if (!this.updateState(State.Setup_AwaitingCounters, State.Terminated_Fault)) {
                this.error("Failed to update state to Terminated_Fault");
            }
        }
    }

    public void registerMeasurementObjects(long procedureRef, boolean usePmFwkMoInstanceIdService, PmSignals.PmcciMeasobjItem[] measurementObjects) {
        this.enter("registerMeasurementObjects");
        if (!this.validateStateRange(State.Running_Begin, State.Running_End)) {
            return;
        }
        String errorMessage = null;
        if (usePmFwkMoInstanceIdService) {
            errorMessage = "usePmFwkMoInstanceIdService must be false";
        } else if (measurementObjects.length <= 0) {
            this.general("Trying to register 0 measurement objects");
        }
        if (errorMessage != null) {
            this.sendPmcciRegisterMeasobjRrej(procedureRef, errorMessage);
            return;
        }
        errorMessage = this.validateMeasurementObjects(measurementObjects);
        if (errorMessage != null) {
            this.sendPmcciRegisterMeasobjRrej(procedureRef, errorMessage);
            return;
        }
        this.general("About to register # measurement objects: " + measurementObjects.length);
        for (int iter = 0; iter < measurementObjects.length; ++iter) {
            PmSignals.PmcciMeasobjItem measurementObject = measurementObjects[iter];
            PmClassInstance classInstance = this.m_classInstances.getClassInstance(measurementObject.moClassId);
            this.general("Registering measurement object, MoClassId: " + measurementObject.moClassId + " MoInstanceId: " + measurementObject.moInstanceId + " Ldn: " + measurementObject.measObjLdn);
            if (classInstance.addInstance(new PmInstance(measurementObject.moInstanceId, measurementObject.measObjLdn))) continue;
            this.error("Unable to add instance for MoClassId: " + measurementObject.moClassId + " MoInstanceId: " + measurementObject.moInstanceId + " Ldn: " + measurementObject.measObjLdn);
        }
        PmSignals.Send.PmcciRegisterMeasobjRcfm pmcciRegisterMeasobjRcfm = new PmSignals.Send.PmcciRegisterMeasobjRcfm();
        pmcciRegisterMeasobjRcfm.procedureRef = procedureRef;
        pmcciRegisterMeasobjRcfm.connectionRef = this.m_serverConnectionRef;
        PmSignals.PmcciMeasobjMappingItem[] measobjMappingItems = new PmSignals.PmcciMeasobjMappingItem[measurementObjects.length];
        for (int iter = 0; iter < measurementObjects.length; ++iter) {
            PmSignals.PmcciMeasobjItem measurementObject = measurementObjects[iter];
            PmSignals.PmcciMeasobjMappingItem measobjMappingItem = new PmSignals.PmcciMeasobjMappingItem();
            measobjMappingItem.moClassId = measurementObject.moClassId;
            measobjMappingItem.uniqueMoInstanceId = measurementObject.moInstanceId;
            measobjMappingItem.moInstanceId = measurementObject.moInstanceId;
            measobjMappingItems[iter] = measobjMappingItem;
        }
        pmcciRegisterMeasobjRcfm.measobjItems = measobjMappingItems;
        this.m_proxy.sendSignal(pmcciRegisterMeasobjRcfm, this.m_pid);
    }

    public void deregisterMeasurementObjects(long procedureRef, PmSignals.PmcciMeasobjItem[] measurementObjects) {
        this.enter("deregisterMeasurementObjects");
        if (!this.validateStateRange(State.Running_Begin, State.Running_End)) {
            return;
        }
        this.general("About to deregister # measurement objects: " + measurementObjects.length);
        for (int iter = 0; iter < measurementObjects.length; ++iter) {
            PmSignals.PmcciMeasobjItem measurementObject = measurementObjects[iter];
            PmClassCounterDefinition classCounterDef = this.m_classCounterDefs.findClassCounterDefinitionById(measurementObject.moClassId);
            if (classCounterDef == null) {
                this.error("Non-registered MoClassId " + measurementObject.moClassId + " MoInstanceId: " + measurementObject.moInstanceId + " MoLdn: " + measurementObject.measObjLdn);
                continue;
            }
            if (measurementObject.moInstanceId > classCounterDef.maxNumberOfMoInstances) {
                this.error("Too large moInstanceId: " + measurementObject.moInstanceId + " MoClassId: " + measurementObject.moClassId + " MoLdn: " + measurementObject.measObjLdn);
                continue;
            }
            PmClassInstance classInstance = this.m_classInstances.getClassInstance(measurementObject.moClassId);
            if (classInstance.findInstanceById(measurementObject.moInstanceId) == null) {
                this.general("Non-registered MoInstanceId: " + measurementObject.moInstanceId + " MoClassId: " + measurementObject.moClassId + " MoLdn: " + measurementObject.measObjLdn);
                continue;
            }
            this.general("Deregistering measurement object, MoClassId: " + measurementObject.moClassId + " MoInstanceId: " + measurementObject.moInstanceId + " Ldn: " + measurementObject.measObjLdn);
            if (classInstance.removeInstanceByName(measurementObject.measObjLdn)) continue;
            this.error("Unable to remove instance. for MoClassId: " + measurementObject.moClassId + " MoInstanceId: " + measurementObject.moInstanceId + " Ldn: " + measurementObject.measObjLdn);
        }
        this.sendPmcciDeregisterMeasobjRcfm(procedureRef);
    }

    public boolean activateCounters(PmClassCounter[] activatedClassCounters) {
        this.enter("activateCounters");
        if (!this.checkState(State.Running_Awaiting)) {
            return false;
        }
        ActivateCounters activateCounters = new ActivateCounters();
        PmSignals.PmcciActivateCounterItem[] activeCounterItems = activateCounters.getActiveCounterItems(activatedClassCounters);
        this.setActiveCounters(State.Running_Awaiting, State.Running_SendingActiveCounters, activeCounterItems);
        return true;
    }

    public boolean deactivateCounters(PmClassCounter[] deactivatedClassCounters) {
        this.enter("deactivateCounters");
        if (!this.checkState(State.Running_Awaiting)) {
            return false;
        }
        DeactivateCounters deactivateCounters = new DeactivateCounters();
        PmSignals.PmcciActivateCounterItem[] activeCounterItems = deactivateCounters.getActiveCounterItems(deactivatedClassCounters);
        this.setActiveCounters(State.Running_Awaiting, State.Running_SendingActiveCounters, activeCounterItems);
        return true;
    }

    private void setActiveCounters(State from, State to, PmSignals.PmcciActivateCounterItem[] activateCounterItems) {
        this.enter("setActiveCounters");
        this.general("About to set # of counters as active: " + activateCounterItems.length);
        if (!this.updateState(from, to)) {
            return;
        }
        PmSignals.Send.PmcciSetActiveCountersReq pmcciSetActiveCountersReq = new PmSignals.Send.PmcciSetActiveCountersReq();
        pmcciSetActiveCountersReq.procedureRef = ++this.m_procedureRef;
        pmcciSetActiveCountersReq.connectionRef = this.m_serverConnectionRef;
        pmcciSetActiveCountersReq.counterItems = activateCounterItems;
        this.m_proxy.sendSignal(pmcciSetActiveCountersReq, this.m_pid);
    }

    public boolean setActiveCountersCfm(long procedureRef) {
        this.enter("setActiveCountersCfm");
        if (!this.validateStates(new State[]{State.Setup_SendingActiveCounters, State.Running_SendingActiveCounters})) {
            return false;
        }
        if (this.getCurrentState() == State.Setup_SendingActiveCounters) {
            if (!this.updateState(State.Setup_SendingActiveCounters, State.Running_Awaiting)) {
                return false;
            }
            return false;
        }
        if (!this.updateState(State.Running_SendingActiveCounters, State.Running_Awaiting)) {
            return true;
        }
        return true;
    }

    public boolean setActiveCountersRej(long procedureRef, String errorMessage) {
        this.enter("setActiveCountersRej");
        if (!this.validateStates(new State[]{State.Setup_SendingActiveCounters, State.Running_SendingActiveCounters})) {
            return false;
        }
        this.error("Not expected: " + errorMessage);
        if (this.getCurrentState() == State.Setup_SendingActiveCounters) {
            if (!this.updateState(State.Setup_SendingActiveCounters, State.Running_Awaiting)) {
                return false;
            }
            return false;
        }
        if (!this.updateState(State.Running_SendingActiveCounters, State.Running_Awaiting)) {
            return true;
        }
        return true;
    }

    public void enableCountersForReporting(PmClassCounter[] enabledClassCounters) {
        this.enter("enableCountersForReporting");
        for (int outer = 0; outer < enabledClassCounters.length; ++outer) {
            PmClassCounter classCounter = enabledClassCounters[outer];
            PmClassCounterDefinition classCounterDef = this.m_classCounterDefs.findClassCounterDefinitionByName(classCounter.moClassName);
            if (classCounterDef == null) {
                this.debug("Unrecognized counter in activation req, MoClassName: " + classCounter.moClassName);
                continue;
            }
            PmClassCounter.PmCounter[] counters = classCounter.counters;
            for (int inner = 0; inner < counters.length; ++inner) {
                PmClassCounter.PmCounter counter = counters[inner];
                PmCounterDefinition counterDef = classCounterDef.findCounterDefinitionByName(counter.counterName);
                if (counterDef == null) {
                    this.debug("Unrecognized counter in activation req, MoClassName: " + classCounter.moClassName + " CounterName: " + counter.counterName);
                    continue;
                }
                counterDef.enableForReporting();
            }
        }
    }

    public boolean freezeCounters() {
        this.enter("freezeCounters");
        if (!this.checkState(State.Running_Awaiting)) {
            return false;
        }
        if (!this.updateState(State.Running_Awaiting, State.Running_SendingFreezeRequest)) {
            return false;
        }
        PmSignals.Send.PmcciFreezeCountersReq pmcciFreezeCountersReq = new PmSignals.Send.PmcciFreezeCountersReq();
        pmcciFreezeCountersReq.procedureRef = ++this.m_procedureRef;
        pmcciFreezeCountersReq.connectionRef = this.m_serverConnectionRef;
        this.m_proxy.sendSignal(pmcciFreezeCountersReq, this.m_pid);
        return true;
    }

    public void freezeCountersCfm(long procedureRef) {
        this.enter("freezeCountersCfm");
        if (!this.validateState(State.Running_SendingFreezeRequest)) {
            return;
        }
        if (!this.updateState(State.Running_SendingFreezeRequest, State.Running_Frozen)) {
            return;
        }
    }

    public boolean reportCounters() {
        this.enter("reportCounters");
        if (!this.checkState(State.Running_Frozen)) {
            return false;
        }
        if (!this.updateState(State.Running_Frozen, State.Running_SendingFetchFrozenRequest)) {
            return false;
        }
        this.m_fetchFrozenCountersRDataValues = new FrozenRDataStateValues();
        PmSignals.Send.PmcciFetchFrozenCountersReq pmcciFetchFrozenCountersReq = new PmSignals.Send.PmcciFetchFrozenCountersReq();
        pmcciFetchFrozenCountersReq.procedureRef = ++this.m_procedureRef;
        pmcciFetchFrozenCountersReq.connectionRef = this.m_serverConnectionRef;
        this.m_proxy.sendSignal(pmcciFetchFrozenCountersReq, this.m_pid);
        return true;
    }

    public boolean reportInstantCounters(final String moLDN, String[] counterNames) {
        this.enter("reportInstantCounters");
        if (!this.checkState(State.Running_Awaiting)) {
            return false;
        }
        this.m_fetchInstantCountersState = new InstantCounterStateValues(counterNames.length);
        boolean success = false;
        PmClassCounterDefinition[] classCounterDefinitions = this.m_classCounterDefs.getClassCounterDefs();
        for (int i = 0; i < classCounterDefinitions.length; ++i) {
            PmInstance instance;
            PmClassCounterDefinition classCounterDefinition = classCounterDefinitions[i];
            PmClassInstance classInstance = this.m_classInstances.findClassInstanceById(classCounterDefinition.moClassId);
            if (classInstance == null || (instance = classInstance.findInstanceByName(moLDN)) == null) continue;
            this.m_fetchInstantCountersState.m_moClassId = classCounterDefinition.moClassId;
            this.m_fetchInstantCountersState.m_moInstanceId = instance.moInstanceId;
            success = true;
            for (int j = 0; j < counterNames.length; ++j) {
                PmCounterDefinition counterDef = classCounterDefinition.findCounterDefinitionByName(counterNames[j]);
                if (counterDef == null) {
                    this.error("Failed to find counter id for counter " + counterNames[j] + " MO LDN: " + moLDN + " MO class id: " + this.m_fetchInstantCountersState.m_moClassId + " MO instance id: " + this.m_fetchInstantCountersState.m_moInstanceId);
                    success = false;
                    continue;
                }
                this.m_fetchInstantCountersState.m_counterIds[j] = counterDef.counterId;
            }
            break;
        }
        if (!success) {
            this.error("Failed to locate signal parameters for MO LDN: " + moLDN + " MO class id: " + this.m_fetchInstantCountersState.m_moClassId + " MO instance id: " + this.m_fetchInstantCountersState.m_moInstanceId);
            this.onFailure();
            this.m_fetchInstantCountersState = null;
            this.m_threadSwitcher.executeInMainThread(new Runnable(){

                public void run() {
                    PmPmcciSession.this.m_callback.sessionHandler_reportInstantCounterValues(new PmMeasuredInstantData(null, (Exception)new ResourceUnavailableException("PmPmcciSession", "Unknown MO LDN: " + moLDN)));
                }
            });
            return true;
        }
        if (!this.updateState(State.Running_Awaiting, State.Running_SendingFetchInstantRequest)) {
            return false;
        }
        PmSignals.Send.PmcciFetchInstantCountersReq pmcciFetchInstantCountersReq = new PmSignals.Send.PmcciFetchInstantCountersReq();
        pmcciFetchInstantCountersReq.procedureRef = ++this.m_procedureRef;
        pmcciFetchInstantCountersReq.connectionRef = this.m_serverConnectionRef;
        pmcciFetchInstantCountersReq.moClassId = this.m_fetchInstantCountersState.m_moClassId;
        pmcciFetchInstantCountersReq.moInstanceId = this.m_fetchInstantCountersState.m_moInstanceId;
        pmcciFetchInstantCountersReq.counterId = this.m_fetchInstantCountersState.m_counterIds;
        this.m_proxy.sendSignal(pmcciFetchInstantCountersReq, this.m_pid);
        return true;
    }

    public void fetchFrozenCountersCfm(long procedureRef) {
        this.enter("fetchFrozenCountersCfm");
        if (!this.validateState(State.Running_SendingFetchFrozenRequest)) {
            return;
        }
        if (!this.updateState(State.Running_SendingFetchFrozenRequest, State.Running_AwaitingFrozenCounterData)) {
            return;
        }
    }

    public void fetchInstantCountersCfm(long procedureRef, int moClassId, long moInstanceId) {
        this.enter("fetchInstantCountersCfm");
        if (!this.validateState(State.Running_SendingFetchInstantRequest)) {
            return;
        }
        if (this.m_fetchInstantCountersState.m_moClassId != moClassId || this.m_fetchInstantCountersState.m_moInstanceId != moInstanceId) {
            this.m_callback.sessionHandler_reportInstantCounterValues(new PmMeasuredInstantData(null, (Exception)new ResourceUnavailableException("PmPmcciSession", "Corrupt parameters in cfm. MO class id: " + moClassId + " , expected: " + this.m_fetchInstantCountersState.m_moClassId + " , MO Instance id: " + moInstanceId + " , expected: " + this.m_fetchInstantCountersState.m_moInstanceId)));
            this.m_fetchInstantCountersState = null;
            this.updateState(State.Running_SendingFetchInstantRequest, State.Running_Awaiting);
            return;
        }
        if (!this.updateState(State.Running_SendingFetchInstantRequest, State.Running_AwaitingInstantCounterData)) {
            return;
        }
    }

    public void fetchFrozenCountersRej(long procedureRef, String errorMessage) {
        this.enter("fetchFrozenCountersRej");
        if (!this.validateState(State.Running_SendingFetchFrozenRequest)) {
            return;
        }
        this.error("Not expected: " + errorMessage);
        this.m_fetchFrozenCountersRDataValues = null;
        if (!this.updateState(State.Running_SendingFetchFrozenRequest, State.Running_Awaiting)) {
            return;
        }
    }

    public void fetchInstantCountersRej(long procedureRef, int moClassId, long moInstanceId, String errorMessage) {
        this.enter("fetchInstantCountersRej");
        this.error("Not expected: " + errorMessage + " MO class id: " + moClassId + " MO instance id: " + moInstanceId);
        if (!this.validateState(State.Running_SendingFetchInstantRequest)) {
            return;
        }
        if (!this.updateState(State.Running_SendingFetchInstantRequest, State.Running_Awaiting)) {
            return;
        }
        this.m_fetchInstantCountersState = null;
        this.m_callback.sessionHandler_reportInstantCounterValues(new PmMeasuredInstantData(null, (Exception)new ResourceUnavailableException("PmPmcciSession", "Instant counter request rejected by PmCounterAggregator")));
    }

    public void fetchFrozenCountersRdata(long procedureRef, boolean moreDataExists, PmSignals.PmcciCounterCollectItem[] counterCollectItems) {
        this.enter("fetchFrozenCountersRdata");
        if (!this.isAtState(State.Running_AwaitingFrozenCounterData)) {
            PmSignals.Send.PmcciFetchFrozenCountersRack pmcciFetchFrozenCountersRack = new PmSignals.Send.PmcciFetchFrozenCountersRack();
            pmcciFetchFrozenCountersRack.procedureRef = procedureRef;
            pmcciFetchFrozenCountersRack.connectionRef = this.m_serverConnectionRef;
            pmcciFetchFrozenCountersRack.endTransfer = 1;
            this.m_proxy.sendSignal(pmcciFetchFrozenCountersRack, this.m_pid);
            return;
        }
        for (int i = 0; i < counterCollectItems.length; ++i) {
            this.m_fetchFrozenCountersRDataValues.m_frozenRDataValues.add(counterCollectItems[i]);
        }
        if (!moreDataExists) {
            if (!this.updateState(State.Running_AwaitingFrozenCounterData, State.Running_Awaiting)) {
                return;
            }
            PmMeasuredDataI[] measurements = this.createMeasuredData(this.m_fetchFrozenCountersRDataValues.m_frozenRDataValues.toArray());
            this.m_fetchFrozenCountersRDataValues = null;
            if (measurements != null) {
                this.m_callback.sessionHandler_reportCounterValues(measurements, true);
            } else {
                this.m_callback.sessionHandler_reportCounterValues(new PmMeasuredDataI[0], false);
            }
        }
        PmSignals.Send.PmcciFetchFrozenCountersRack pmcciFetchFrozenCountersRack = new PmSignals.Send.PmcciFetchFrozenCountersRack();
        pmcciFetchFrozenCountersRack.procedureRef = procedureRef;
        pmcciFetchFrozenCountersRack.connectionRef = this.m_serverConnectionRef;
        pmcciFetchFrozenCountersRack.endTransfer = 0;
        this.m_proxy.sendSignal(pmcciFetchFrozenCountersRack, this.m_pid);
    }

    public void fetchInstantCountersRdata(long procedureRef, boolean moreDataExists, int moClassId, long moInstanceId, PmSignals.PmcciInstantCounterCollectItem[] instantCounterCollectItems) {
        this.enter("fetchInstantCountersRdata");
        if (!this.isAtState(State.Running_AwaitingInstantCounterData)) {
            PmSignals.Send.PmcciFetchInstantCountersRack pmcciFetchInstantCountersRack = new PmSignals.Send.PmcciFetchInstantCountersRack();
            pmcciFetchInstantCountersRack.procedureRef = procedureRef;
            pmcciFetchInstantCountersRack.connectionRef = this.m_serverConnectionRef;
            pmcciFetchInstantCountersRack.moClassId = moClassId;
            pmcciFetchInstantCountersRack.moInstanceId = moInstanceId;
            this.m_proxy.sendSignal(pmcciFetchInstantCountersRack, this.m_pid);
            return;
        }
        for (int i = 0; i < instantCounterCollectItems.length; ++i) {
            this.m_fetchInstantCountersState.m_instantRDataValues.add(instantCounterCollectItems[i]);
        }
        if (!moreDataExists) {
            PmSignals.PmcciInstantCounterCollectItem[] completeInstantCounterCollectItems = this.m_fetchInstantCountersState.m_instantRDataValues.toArray();
            if (!this.updateState(State.Running_AwaitingInstantCounterData, State.Running_Awaiting)) {
                return;
            }
            if (moClassId != this.m_fetchInstantCountersState.m_moClassId || moInstanceId != this.m_fetchInstantCountersState.m_moInstanceId || !this.validateInstantCounterItems(completeInstantCounterCollectItems)) {
                this.m_fetchInstantCountersState = null;
                this.m_callback.sessionHandler_reportInstantCounterValues(new PmMeasuredInstantData(null, (Exception)new ResourceUnavailableException("PmPmcciSession", "Unexpected instant counter data received, check logs")));
                return;
            }
            long[][] measurements = this.createMeasuredInstantData(moClassId, completeInstantCounterCollectItems);
            if (measurements != null) {
                this.m_fetchInstantCountersState = null;
                this.m_callback.sessionHandler_reportInstantCounterValues(new PmMeasuredInstantData(measurements, null));
            } else {
                this.error("Failed to report instant counter values");
                this.m_fetchInstantCountersState = null;
                this.m_callback.sessionHandler_reportInstantCounterValues(new PmMeasuredInstantData(null, (Exception)new ResourceUnavailableException("PmPmcciSession", "Received instant counter data is not consistent with known counter definitions, check logs")));
            }
        }
        PmSignals.Send.PmcciFetchInstantCountersRack pmcciFetchInstantCountersRack = new PmSignals.Send.PmcciFetchInstantCountersRack();
        pmcciFetchInstantCountersRack.procedureRef = procedureRef;
        pmcciFetchInstantCountersRack.connectionRef = this.m_serverConnectionRef;
        pmcciFetchInstantCountersRack.moClassId = moClassId;
        pmcciFetchInstantCountersRack.moInstanceId = moInstanceId;
        this.m_proxy.sendSignal(pmcciFetchInstantCountersRack, this.m_pid);
    }

    public long[][] createMeasuredInstantData(int moClassId, PmSignals.PmcciInstantCounterCollectItem[] instantCounterCollectItems) {
        this.enter("createMeasuredInstantData");
        if (instantCounterCollectItems.length == 0) {
            this.error("instantCounterCollectItems was empty");
            return null;
        }
        PmClassCounterDefinition classCounterDef = this.m_classCounterDefs.findClassCounterDefinitionById(moClassId);
        if (classCounterDef == null) {
            this.error("Could not find the class counter definition using MO class id: " + moClassId);
            return null;
        }
        int outerLength = instantCounterCollectItems.length;
        for (int i = 0; i < instantCounterCollectItems.length; ++i) {
            PmSignals.PmcciInstantCounterCollectItem instantCounterCollectItem = instantCounterCollectItems[i];
            PmSignals.PmcciInstantCounterValueItem instantCounterValueItem = instantCounterCollectItem.valueItem;
            PmCounterDefinition counterDef = classCounterDef.findCounterDefinitionById(instantCounterValueItem.counterId);
            if (counterDef == null) {
                this.error("counterDef not found, counterId: " + instantCounterValueItem.counterId);
                continue;
            }
            int counterMultiplicity = counterDef.multiplicity;
            if (counterMultiplicity <= 1) continue;
            outerLength -= counterMultiplicity - 1;
            i += counterMultiplicity - 1;
        }
        long[][] measurements = new long[outerLength][];
        int collectItemIdx = 0;
        for (int i = 0; i < outerLength; ++i) {
            PmSignals.PmcciInstantCounterCollectItem instantCounterCollectItem = instantCounterCollectItems[collectItemIdx];
            PmSignals.PmcciInstantCounterValueItem instantCounterValueItem = instantCounterCollectItem.valueItem;
            PmCounterDefinition counterDef = classCounterDef.findCounterDefinitionById(instantCounterValueItem.counterId);
            if (counterDef == null) {
                this.error("counterDef not found, counterId: " + instantCounterValueItem.counterId);
                continue;
            }
            int counterMultiplicity = counterDef.multiplicity;
            String counterName = counterDef.counterName;
            if (counterMultiplicity < 1) {
                this.error("Wrong multiplicity for CounterName: " + counterName + " multiplicity: " + counterMultiplicity);
                continue;
            }
            measurements[i] = new long[counterMultiplicity];
            for (int j = 0; j < counterMultiplicity; ++j) {
                long counterValue;
                int counterIdx = collectItemIdx + j;
                instantCounterCollectItem = instantCounterCollectItems[counterIdx];
                instantCounterValueItem = instantCounterCollectItem.valueItem;
                long msValue = instantCounterValueItem.msValue;
                long lsValue = instantCounterValueItem.lsValue;
                measurements[i][j] = counterValue = (msValue << 32) + lsValue;
            }
            collectItemIdx += counterMultiplicity;
        }
        return measurements;
    }

    public PmMeasuredDataI[] createMeasuredData(PmSignals.PmcciCounterCollectItem[] counterCollectItems) {
        this.enter("createMeasuredData");
        int errorsDetected = 0;
        boolean dataToReport = false;
        PmClassGroup[] classGroups = this.groupCounterCollectItems(counterCollectItems);
        PmLists.MeasuredDataList measurements = new PmLists.MeasuredDataList();
        for (int classGroupIdx = 0; classGroupIdx < classGroups.length; ++classGroupIdx) {
            int previousErrorDetected = errorsDetected++;
            PmClassGroup classGroup = classGroups[classGroupIdx];
            PmClassCounterDefinition classCounterDef = this.m_classCounterDefs.findClassCounterDefinitionById(classGroup.moClassId);
            if (classCounterDef == null) {
                this.error("ClassCounterDef not found, MoClassId: " + classGroup.moClassId);
                continue;
            }
            PmClassInstance classInstance = this.m_classInstances.findClassInstanceById(classGroup.moClassId);
            if (classInstance == null) {
                ++errorsDetected;
                this.error("ClassInstance not found, MoClassId: " + classGroup.moClassId);
                continue;
            }
            PmLists.StringList scalarCounterNamesList = new PmLists.StringList();
            PmLists.StringList pdfCounterNamesList = new PmLists.StringList();
            PmCounterDefinition[] counterDefs = classCounterDef.getCounterDefs();
            boolean isEnabledForReporting = false;
            for (int counterIdx = 0; counterIdx < counterDefs.length; ++counterIdx) {
                PmCounterDefinition counterDef = counterDefs[counterIdx];
                if (!counterDef.isEnabledForReporting()) continue;
                dataToReport = true;
                isEnabledForReporting = true;
                if (counterDef.multiplicity == 1) {
                    scalarCounterNamesList.add(counterDef.counterName);
                    continue;
                }
                if (counterDef.multiplicity > 1) {
                    pdfCounterNamesList.add(counterDef.counterName);
                    continue;
                }
                ++errorsDetected;
                this.error("Wrong multiplicity for CounterName: " + counterDef.counterName + " multiplicity: " + counterDef.multiplicity);
            }
            if (errorsDetected > previousErrorDetected) {
                this.error("Skipping due to errors, MoClassId : " + classGroup.moClassId);
                continue;
            }
            if (!isEnabledForReporting) {
                this.general("MO-class has no counters to report, MoClassId: " + classGroup.moClassId);
                continue;
            }
            String[] scalarCounterNames = scalarCounterNamesList.toArray();
            String[] pdfCounterNames = pdfCounterNamesList.toArray();
            PmMeasuredDataI measurement = this.m_callback.sessionHandler_createMeasuredDataContainer(scalarCounterNames, pdfCounterNames);
            PmInstanceGroup[] instanceGroups = classGroup.getInstanceGroups();
            for (int instanceGroupIdx = 0; instanceGroupIdx < instanceGroups.length; ++instanceGroupIdx) {
                long counterValue;
                PmCounterDefinition counterDef;
                PmInstanceGroup instanceGroup = instanceGroups[instanceGroupIdx];
                PmInstance instance = classInstance.findInstanceById(instanceGroup.moInstanceId);
                if (instance == null) {
                    ++errorsDetected;
                    this.error("Instance not found for MoClassId: " + classGroup.moClassId + " MoInstanceId: " + instanceGroup.moInstanceId);
                    continue;
                }
                long[] scalarCounterValues = new long[scalarCounterNames.length];
                Object[] pdfCounterValues = new Object[pdfCounterNames.length];
                int idx = -1;
                int idy = -1;
                boolean isSuspect = true;
                for (int counterIndex = 0; counterIndex < counterDefs.length; ++counterIndex) {
                    counterDef = counterDefs[counterIndex];
                    if (!counterDef.isEnabledForReporting() || (counterValue = instanceGroup.getCounterValue(counterDef.counterId)) < 0L) continue;
                    this.debug("Valid counter found, CounterId: " + counterDef.counterId);
                    isSuspect = false;
                    break;
                }
                if (isSuspect) {
                    this.general("Instance is suspect marked, MoClassId: " + classGroup.moClassId + " MoInstanceId: " + instanceGroup.moInstanceId);
                }
                for (int counterIdx = 0; counterIdx < counterDefs.length; ++counterIdx) {
                    counterDef = counterDefs[counterIdx];
                    if (counterDef.isEnabledForReporting() && counterDef.multiplicity == 1) {
                        ++idx;
                        if (isSuspect) {
                            scalarCounterValues[idx] = -1L;
                            continue;
                        }
                        counterValue = instanceGroup.getCounterValue(counterDef.counterId);
                        if (-3L == counterValue) {
                            this.debug("Counter has unassigned value and is thus suspect marked, MoClassId: " + classGroup.moClassId + " MoInstanceId: " + instanceGroup.moInstanceId + " Counter: " + counterDef.counterName);
                            scalarCounterValues[idx] = -2L;
                            continue;
                        }
                        scalarCounterValues[idx] = counterValue;
                        continue;
                    }
                    if (!counterDef.isEnabledForReporting() || counterDef.multiplicity <= 1) continue;
                    ++idy;
                    long[] pdfValues = new long[counterDef.multiplicity];
                    for (int counterIdy = 0; counterIdy < counterDef.multiplicity; ++counterIdy) {
                        if (isSuspect) {
                            pdfValues[counterIdy] = -1L;
                            continue;
                        }
                        long counterValue2 = instanceGroup.getCounterValue(counterDef.counterId + counterIdy);
                        if (-3L == counterValue2) {
                            this.debug("Counter has unassigned value and is thus suspect marked, MoClassId: " + classGroup.moClassId + " MoInstanceId: " + instanceGroup.moInstanceId + " Counter: " + counterDef.counterName);
                            pdfValues[counterIdy] = -2L;
                            continue;
                        }
                        pdfValues[counterIdy] = counterValue2;
                    }
                    pdfCounterValues[idy] = pdfValues;
                }
                StringBuffer buffer = new StringBuffer();
                buffer.append("Reporting values for, Ldn: ");
                buffer.append(instance.moInstanceName);
                if (scalarCounterNames.length != 0) {
                    buffer.append("\n");
                    buffer.append("Reporting scalar counters:");
                    for (int iter = 0; iter < scalarCounterValues.length; ++iter) {
                        buffer.append("\n");
                        buffer.append(scalarCounterNames[iter]);
                        buffer.append(" (");
                        buffer.append(scalarCounterValues[iter]);
                        buffer.append(")");
                    }
                }
                if (pdfCounterNames.length != 0) {
                    buffer.append("\n");
                    buffer.append("Reporting PDF counters:");
                    for (int iter = 0; iter < pdfCounterNames.length; ++iter) {
                        buffer.append("\n");
                        buffer.append(pdfCounterNames[iter]);
                        buffer.append(" (");
                        long[] pdfValues = (long[])pdfCounterValues[iter];
                        for (int ix = 0; ix < pdfValues.length; ++ix) {
                            buffer.append(pdfValues[ix]);
                            if (ix + 1 != pdfValues.length) {
                                buffer.append(",");
                                continue;
                            }
                            buffer.append(")");
                        }
                    }
                }
                this.debug(buffer.toString());
                try {
                    measurement.addMeasuredValues(instance.moInstanceName, scalarCounterValues, pdfCounterValues, isSuspect);
                    continue;
                }
                catch (IllegalArgumentException e) {
                    ++errorsDetected;
                    this.error("Caught IllegalArgumentException: " + e.getMessage());
                }
            }
            measurements.add(measurement);
        }
        if (errorsDetected > 0) {
            this.error("Detected # errors during data collection: " + errorsDetected);
        }
        if (dataToReport) {
            return measurements.toArray();
        }
        return null;
    }

    public PmClassGroup[] groupCounterCollectItems(PmSignals.PmcciCounterCollectItem[] counterCollectItems) {
        this.enter("groupCounterCollectItems");
        PmClassGroups classGroups = new PmClassGroups();
        for (int iter = 0; iter < counterCollectItems.length; ++iter) {
            long counterValue;
            PmSignals.PmcciCounterCollectItem counterCollectItem = counterCollectItems[iter];
            PmClassGroup classGroup = classGroups.getClassGroup(counterCollectItem.moClassId);
            PmInstanceGroup instanceGroup = classGroup.getInstanceGroup(counterCollectItem.moInstanceId);
            if (instanceGroup.addCounterValue(counterCollectItem.counterId, counterValue = this.convertCounterValue(counterCollectItem.valueItem))) continue;
            this.error("Couldn't add counterValue, MoClassId: " + counterCollectItem.moClassId + " MoInstanceId: " + counterCollectItem.moInstanceId + " CounterId: " + counterCollectItem.counterId);
        }
        return classGroups.getClassGroups();
    }

    public boolean validateCounterDefinitions(PmSignals.PmcciMoClassItem[] moClassDefinitions) {
        this.enter("validateCounterDefinitions");
        boolean dataIsValid = true;
        if (moClassDefinitions.length > 32 || moClassDefinitions.length == 0) {
            this.error("Couldn't register counters, due to invalid number of MO class elements: " + moClassDefinitions.length);
            return false;
        }
        for (int moClassIdx = 0; moClassIdx < moClassDefinitions.length; ++moClassIdx) {
            PmSignals.PmcciCounterRegistrationItem[] counterDefs;
            PmSignals.PmcciMoClassItem moClassDef = moClassDefinitions[moClassIdx];
            if (moClassDef.moClassName == null || moClassDef.moClassName.length() == 0) {
                this.error("Invalid MoClassName!");
                dataIsValid = false;
                continue;
            }
            for (int moClassIdy = moClassIdx + 1; moClassIdy < moClassDefinitions.length; ++moClassIdy) {
                PmSignals.PmcciMoClassItem moClassDef2 = moClassDefinitions[moClassIdy];
                if (moClassDef.moClassId == moClassDef2.moClassId) {
                    this.error("Data inconsistency, muliple instances with identical MoClassId: " + moClassDef.moClassId);
                    dataIsValid = false;
                }
                if (!moClassDef.moClassName.equals(moClassDef2.moClassName)) continue;
                this.error("Data inconsistency, muliple instances with identical MoClassName: " + moClassDef.moClassName);
                dataIsValid = false;
            }
            if (moClassDef.maxNumberOfMoInstances > 8192L || moClassDef.maxNumberOfMoInstances == 0L) {
                this.error("Couldn't register counters, for MoClassName: " + moClassDef.moClassName + " due to invalid max number of MO instances: " + moClassDef.maxNumberOfMoInstances);
                dataIsValid = false;
            }
            if (moClassDef.moClassId >= 32) {
                this.error("Couldn't register counters, for MoClassName: " + moClassDef.moClassName + " due to invalid MO class id: " + moClassDef.moClassId + ", maximum id: " + 32);
                dataIsValid = false;
            }
            if ((counterDefs = moClassDef.counterRegistrationItems).length > 1024 || counterDefs.length == 0) {
                this.error("Couldn't register counters, for MoClassName: " + moClassDef.moClassName + " due to invalid max number of counters: " + counterDefs.length);
                return false;
            }
            for (int counterIdx = 0; counterIdx < counterDefs.length; ++counterIdx) {
                PmSignals.PmcciCounterRegistrationItem counterDef = counterDefs[counterIdx];
                if (counterDef.counterName == null || counterDef.counterName.length() == 0) {
                    this.error("Invalid CounterName, for MoClassName: " + moClassDef.moClassName);
                    dataIsValid = false;
                    continue;
                }
                for (int counterIdy = counterIdx + 1; counterIdy < counterDefs.length; ++counterIdy) {
                    PmSignals.PmcciCounterRegistrationItem counterDef2 = counterDefs[counterIdy];
                    if (counterDef.counterId == counterDef2.counterId) {
                        this.error("Data inconsistency, muliple instances with identical CounterId: " + counterDef.counterId + " for MoClassName: " + moClassDef.moClassName);
                        dataIsValid = false;
                    }
                    if (!counterDef.counterName.equals(counterDef2.counterName)) continue;
                    this.error("Data inconsistency, muliple instances with identical CounterName: " + counterDef.counterName + " for MoClassName: " + moClassDef.moClassName);
                    dataIsValid = false;
                }
                if (counterDef.multiplicity > 256 || counterDef.multiplicity == 0) {
                    this.error("Couldn't register counters, for MoClassName: " + moClassDef.moClassName + " CounterName: " + counterDef.counterName + " due to invalid multiplicity: " + counterDef.multiplicity);
                    dataIsValid = false;
                }
                if (counterDef.size > 8 || counterDef.size == 0) {
                    this.error("Couldn't register counters, for MoClassName: " + moClassDef.moClassName + " CounterName: " + counterDef.counterName + " due to invalid size: " + counterDef.size);
                    dataIsValid = false;
                }
                if (counterDef.collectionMethod > 2 || counterDef.collectionMethod == 0) {
                    this.error("Couldn't register counters, for MoClassName: " + moClassDef.moClassName + " CounterName: " + counterDef.counterName + " due to invalid collectionMethod: " + counterDef.collectionMethod);
                    dataIsValid = false;
                }
                if (counterDef.aggregationType <= 5 && counterDef.aggregationType != 0) continue;
                this.error("Couldn't register counters, for MoClassName: " + moClassDef.moClassName + " CounterName: " + counterDef.counterName + " due to invalid aggregationType: " + counterDef.aggregationType);
                dataIsValid = false;
            }
        }
        return dataIsValid;
    }

    public boolean validateInstantCounterItems(PmSignals.PmcciInstantCounterCollectItem[] instantCounterCollectItems) {
        int noOfCounterValues = 0;
        boolean dataIsValid = true;
        PmClassCounterDefinition classCounterDef = this.m_classCounterDefs.findClassCounterDefinitionById(this.m_fetchInstantCountersState.m_moClassId);
        int counterIdx = 0;
        for (int i = 0; i < instantCounterCollectItems.length; ++i) {
            PmSignals.PmcciInstantCounterCollectItem instantCounterCollectItem = instantCounterCollectItems[i];
            PmSignals.PmcciInstantCounterValueItem instantCounterValueItem = instantCounterCollectItem.valueItem;
            if (this.m_fetchInstantCountersState.m_counterIds[counterIdx] != instantCounterValueItem.counterId) {
                this.error("Nonmatching counter id: " + instantCounterValueItem.counterId + ", expected: " + this.m_fetchInstantCountersState.m_counterIds[counterIdx] + ", MO class id: " + this.m_fetchInstantCountersState.m_moClassId);
                dataIsValid = false;
                continue;
            }
            PmCounterDefinition counterDef = classCounterDef.findCounterDefinitionById(instantCounterValueItem.counterId);
            noOfCounterValues += counterDef.multiplicity;
            i += counterDef.multiplicity - 1;
            ++counterIdx;
        }
        if (noOfCounterValues != instantCounterCollectItems.length) {
            this.error("Wrong number of counter values: " + instantCounterCollectItems.length + ", expected: " + noOfCounterValues + ", MO class id: " + this.m_fetchInstantCountersState.m_moClassId);
            dataIsValid = false;
        }
        return dataIsValid;
    }

    public String validateMeasurementObjects(PmSignals.PmcciMeasobjItem[] measurementObjects) {
        this.enter("validateMeasurementObjects");
        String errorMessage = null;
        PmClassInstances copyClassInstances = this.m_classInstances.typeSafeClone();
        for (int i = 0; i < measurementObjects.length; ++i) {
            PmSignals.PmcciMeasobjItem measurementObject = measurementObjects[i];
            PmClassCounterDefinition classCounterDef = this.m_classCounterDefs.findClassCounterDefinitionById(measurementObject.moClassId);
            if (classCounterDef == null) {
                errorMessage = "Non-registered moClassId: " + measurementObject.moClassId + " MoInstanceId: " + measurementObject.moInstanceId + " MoLdn: " + measurementObject.measObjLdn;
                break;
            }
            if (measurementObject.moInstanceId > classCounterDef.maxNumberOfMoInstances) {
                errorMessage = "Too large MoInstanceId: " + measurementObject.moInstanceId + " MoClassId: " + measurementObject.moClassId + " MoLdn: " + measurementObject.measObjLdn;
                break;
            }
            if (measurementObject.measObjLdn == null || measurementObject.measObjLdn == "") {
                errorMessage = "Null or empty MoLdn: " + measurementObject.measObjLdn + " MoClassId: " + measurementObject.moClassId + " MoInstanceId: " + measurementObject.moInstanceId;
                break;
            }
            PmClassInstance classInstance = copyClassInstances.getClassInstance(measurementObject.moClassId);
            if (classInstance.findInstanceById(measurementObject.moInstanceId) != null) {
                errorMessage = "Already registered MoInstanceId: " + measurementObject.moInstanceId + " MoClassId: " + measurementObject.moClassId + " MoLdn: " + measurementObject.measObjLdn;
                break;
            }
            if (classInstance.findInstanceByName(measurementObject.measObjLdn) != null) {
                errorMessage = "Already registered MoLdn: " + measurementObject.measObjLdn + " MoClassId: " + measurementObject.moClassId + " MoInstanceId: " + measurementObject.moInstanceId;
                break;
            }
            classInstance.addInstance(new PmInstance(measurementObject.moInstanceId, measurementObject.measObjLdn));
        }
        return errorMessage;
    }

    public void sendPmcciDeregisterMeasobjRcfm(long procedureRef) {
        PmSignals.Send.PmcciDeregisterMeasobjRcfm pmcciDeregisterMeasobjRcfm = new PmSignals.Send.PmcciDeregisterMeasobjRcfm();
        pmcciDeregisterMeasobjRcfm.procedureRef = procedureRef;
        pmcciDeregisterMeasobjRcfm.connectionRef = this.m_serverConnectionRef;
        this.m_proxy.sendSignal(pmcciDeregisterMeasobjRcfm, this.m_pid);
    }

    public void sendPmcciRegisterMeasobjRrej(long procedureRef, String errorMessage) {
        this.error("Sent RBS_IW_PMCCI_REGISTER_MEASOBJ_RREJ with error info: " + errorMessage + " to pid: " + this.m_pid);
        PmSignals.PmErrorInfo pmErrorInfo = new PmSignals.PmErrorInfo();
        pmErrorInfo.errorMessage = errorMessage;
        PmSignals.Send.PmcciRegisterMeasobjRrej pmcciRegisterMeasobjRrej = new PmSignals.Send.PmcciRegisterMeasobjRrej();
        pmcciRegisterMeasobjRrej.procedureRef = procedureRef;
        pmcciRegisterMeasobjRrej.connectionRef = this.m_serverConnectionRef;
        pmcciRegisterMeasobjRrej.errorItem = pmErrorInfo;
        this.m_proxy.sendSignal(pmcciRegisterMeasobjRrej, this.m_pid);
    }

    public void sendPmcciRegisterCountersRrej(long procedureRef, String errorMessage) {
        this.error("Sent RBS_IW_PMCCI_REGISTER_COUNTERS_RREJ with error info: " + errorMessage + " to pid: " + this.m_pid);
        PmSignals.PmErrorInfo errorInfo = new PmSignals.PmErrorInfo();
        errorInfo.errorMessage = errorMessage;
        PmSignals.Send.PmcciRegisterCountersRrej pmcciRegisterCountersRrej = new PmSignals.Send.PmcciRegisterCountersRrej();
        pmcciRegisterCountersRrej.procedureRef = procedureRef;
        pmcciRegisterCountersRrej.connectionRef = this.m_serverConnectionRef;
        pmcciRegisterCountersRrej.errorItem = errorInfo;
        this.m_proxy.sendSignal(pmcciRegisterCountersRrej, this.m_pid);
    }

    public State getState() {
        return (State)this.getCurrentState();
    }

    public PmClassCounterDefinitions getClassCounterDefinitions() {
        return this.m_classCounterDefs;
    }

    public String getServerInstanceName() {
        return this.m_serverInstanceName;
    }

    public long convertCounterValue(PmSignals.PmcciCounterValueItem counterValueItem) {
        long msValue = counterValueItem.msValue;
        long lsValue = counterValueItem.lsValue;
        long result = (msValue << 32) + lsValue;
        return result;
    }

    private void onFailure() {
        this.enter("onFailure");
        this.info("BEGIN - tracing session state: ");
        PmClassCounterDefinition[] classCounterDefinitions = this.m_classCounterDefs.getClassCounterDefs();
        for (int i = 0; i < classCounterDefinitions.length; ++i) {
            int j;
            PmClassCounterDefinition classCounterDefinition = classCounterDefinitions[i];
            if (classCounterDefinition != null) {
                PmCounterDefinition[] counterDefinitions = classCounterDefinition.getCounterDefs();
                this.info("MO class name: " + classCounterDefinition.moClassName);
                this.info("MO class id:   " + classCounterDefinition.moClassId);
                this.info("BEGIN - tracing counter definitions:");
                for (j = 0; j < counterDefinitions.length; ++j) {
                    PmCounterDefinition counterDef = counterDefinitions[j];
                    if (counterDef == null) continue;
                    this.info("Counter id:           " + counterDef.counterId);
                    this.info("Counter name:         " + counterDef.counterName);
                    this.info("Counter multiplicity: " + counterDef.multiplicity);
                }
                this.info("END - tracing counter definitions");
            }
            this.info("BEGIN - tracing MO instances:");
            PmClassInstance[] classInstances = this.m_classInstances.getClassInstances();
            for (j = 0; j < classInstances.length; ++j) {
                PmClassInstance classInstance = classInstances[j];
                if (classInstance == null || classCounterDefinition.moClassId != classInstance.moClassId) continue;
                PmInstance[] instances = classInstance.getInstances();
                for (int k = 0; k < instances.length; ++k) {
                    PmInstance instance = instances[k];
                    if (instance == null) continue;
                    this.info("MO instance id: " + instance.moInstanceId + " MO LDN: " + instance.moInstanceName);
                }
            }
            this.info("END - tracing MO instances");
        }
        this.info("END - tracing session state");
    }

    public static class State
    extends PmBaseState {
        public static final State Setup_Initial = new State(0x500100);
        public static final State Setup_ConnToServerRequest = new State(0x500110);
        public static final State Setup_AwaitingCounters = new State(5243168);
        public static final State Setup_SendingActiveCounters = new State(5243184);
        public static final State Running_Begin = new State(0x500200);
        public static final State Running_Awaiting = new State(0x500200);
        public static final State Running_SendingActiveCounters = new State(5243408);
        public static final State Running_SendingFreezeRequest = new State(0x500220);
        public static final State Running_Frozen = new State(5243440);
        public static final State Running_SendingFetchFrozenRequest = new State(5243456);
        public static final State Running_AwaitingFrozenCounterData = new State(0x500250);
        public static final State Running_SendingFetchInstantRequest = new State(5243488);
        public static final State Running_AwaitingInstantCounterData = new State(5243504);
        public static final State Running_End = new State(0x500800);
        public static final State Terminated_Fault = new State(0x50FFFF);

        public State(int state) {
            super(state);
        }
    }

    private class FrozenRDataStateValues {
        public PmLists.CounterCollectList m_frozenRDataValues = new PmLists.CounterCollectList();
    }

    private class InstantCounterStateValues {
        public int m_moClassId = -1;
        public long m_moInstanceId = -1L;
        public int[] m_counterIds;
        public PmLists.InstantCounterCollectList m_instantRDataValues;

        public InstantCounterStateValues(int length) {
            this.m_counterIds = new int[length];
            this.m_instantRDataValues = new PmLists.InstantCounterCollectList();
        }
    }

    public abstract class BaseActivateCounters {
        protected abstract void action(PmCounterDefinition var1);

        public PmSignals.PmcciActivateCounterItem[] getActiveCounterItems(PmClassCounter[] classCounters) {
            PmCounterDefinition counterDef;
            PmPmcciSession.this.enter("getActiveCounterItems");
            for (int outer = 0; outer < classCounters.length; ++outer) {
                PmClassCounter classCounter = classCounters[outer];
                PmClassCounterDefinition classCounterDef = PmPmcciSession.this.m_classCounterDefs.findClassCounterDefinitionByName(classCounter.moClassName);
                if (classCounterDef == null) {
                    PmPmcciSession.this.debug("Unrecognized counter in activation req, MoClassName: " + classCounter.moClassName);
                    continue;
                }
                PmClassCounter.PmCounter[] counters = classCounter.counters;
                for (int inner = 0; inner < counters.length; ++inner) {
                    PmClassCounter.PmCounter counter = counters[inner];
                    counterDef = classCounterDef.findCounterDefinitionByName(counter.counterName);
                    if (counterDef == null) {
                        PmPmcciSession.this.debug("Unrecognized counter in activation req, MoClassName: " + classCounter.moClassName + " CounterName: " + counter.counterName);
                        continue;
                    }
                    this.action(counterDef);
                }
            }
            PmLists.ActivateCountersList activeCounterItemList = new PmLists.ActivateCountersList();
            PmClassCounterDefinition[] classCounterDefs = PmPmcciSession.this.m_classCounterDefs.getClassCounterDefs();
            for (int outer = 0; outer < classCounterDefs.length; ++outer) {
                PmClassCounterDefinition classCounterDef = classCounterDefs[outer];
                PmCounterDefinition[] counterDefs = classCounterDef.getCounterDefs();
                for (int inner = 0; inner < counterDefs.length; ++inner) {
                    counterDef = counterDefs[inner];
                    if (!counterDef.isCounterActivated()) continue;
                    PmSignals.PmcciActivateCounterItem activeCounterItem = new PmSignals.PmcciActivateCounterItem();
                    activeCounterItem.moClassId = classCounterDef.moClassId;
                    activeCounterItem.counterId = counterDef.counterId;
                    activeCounterItemList.add(activeCounterItem);
                }
            }
            PmSignals.PmcciActivateCounterItem[] activeCounterItems = activeCounterItemList.toArray();
            return activeCounterItems;
        }
    }

    public class DeactivateCounters
    extends BaseActivateCounters {
        protected void action(PmCounterDefinition counterDef) {
            int numberOfReferences = counterDef.deactivateCounter();
            if (0 > numberOfReferences) {
                PmPmcciSession.this.error("Deactivation fault, for counter: " + counterDef.counterName);
            } else if (0 == numberOfReferences) {
                PmPmcciSession.this.debug("Deactivated counter: " + counterDef.counterName);
            } else {
                PmPmcciSession.this.debug("Counter " + counterDef.counterName + " is not deactivated, still referenced # times: " + numberOfReferences);
            }
        }
    }

    public class ActivateCounters
    extends BaseActivateCounters {
        protected void action(PmCounterDefinition counterDef) {
            int numberOfReferences = counterDef.activateCounter();
            if (1 == numberOfReferences) {
                PmPmcciSession.this.debug("Activated counter: " + counterDef.counterName);
            }
        }
    }
}

