/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.pmproxy;

import java.util.Random;
import se.ericsson.crbs.cat.pmapplication.PmThreadSwitcherI;
import se.ericsson.crbs.cat.pmcommon.PmBase;
import se.ericsson.crbs.cat.pmcommon.PmClassCounter;
import se.ericsson.crbs.cat.pmcommon.PmClassCounterDefinition;
import se.ericsson.crbs.cat.pmcommon.PmClassCounterDefinitions;
import se.ericsson.crbs.cat.pmcommon.PmCounterDefinition;
import se.ericsson.crbs.cat.pmcommon.PmCounterRegistrationItem;
import se.ericsson.crbs.cat.pmcommon.PmLists;
import se.ericsson.crbs.cat.pmcommon.PmMaps;
import se.ericsson.crbs.cat.pmpms.PmMeasuredDataI;
import se.ericsson.crbs.cat.pmpms.PmMeasuredInstantData;
import se.ericsson.crbs.cat.pmproxy.PmPmcciSession;
import se.ericsson.crbs.cat.pmproxy.PmProxyI;
import se.ericsson.crbs.cat.pmproxy.PmProxyListenerI;
import se.ericsson.crbs.cat.pmproxy.signals.PmBaseSignal;
import se.ericsson.crbs.cat.pmproxy.signals.PmSignals;
import se.ericsson.crbs.omf.mao.genericmo.attributes.manager.PmCounter;

public class PmSessionHandler
extends PmBase
implements PmProxyListenerI,
PmSignals.Receive.PmSignalReceiver {
    private final long INVALID_CLIENT_CONNECTION_REF = -9999L;
    private final PmMaps.PmariSessionMap m_pmariSessions = new PmMaps.PmariSessionMap();
    private final PmMaps.PmcciSessionMap m_pmcciSessions = new PmMaps.PmcciSessionMap();
    private final long m_supportedPmariProcotolRevision = 1L;
    private final Random m_random = new Random();
    private final PmProxyI m_proxy;
    private final Callback m_callback;
    private final PmThreadSwitcherI m_threadSwitcher;
    private final PmcciSessionProcessor m_freezeCountersProcessor = new FreezeCountersProcessor();
    private final PmcciSessionProcessor m_reportCountersProcessor = new ReportCountersProcessor();
    private final PmcciSessionProcessor m_reportInstantCountersProcessor = new ReportInstantCountersProcessor();
    private final PmcciSessionProcessor m_checkUpdatingActiveProcessor = new ActivateCountersProcessor();

    public PmSessionHandler(PmProxyI proxy, Callback callback, PmThreadSwitcherI threadSwitcher) {
        this.enter("PmSessionHandler");
        this.m_proxy = proxy;
        this.m_callback = callback;
        this.m_threadSwitcher = threadSwitcher;
        this.general("PmSessionHandler: Listening for PMARI and PMCCI signals");
        this.m_proxy.registerSignals(this, PmSignals.Receive.SignalDescriptors);
    }

    public PmSessionHandler(PmProxyI proxy, Callback callback, PmThreadSwitcherI threadSwitcher, int seed) {
        this(proxy, callback, threadSwitcher);
        this.m_random.setSeed(seed);
    }

    private int getSessionId() {
        return this.m_random.nextInt(1000000000);
    }

    public boolean activateCounters(PmClassCounter[] activatedClassCounters) {
        this.enter("activateCounters");
        return this.processPmcciSessions(new ActivateCountersProcessor(activatedClassCounters));
    }

    public boolean deactivateCounters(PmClassCounter[] deactivatedClassCounters) {
        this.enter("deactivateCounters");
        return this.processPmcciSessions(new DeactivateCountersProcessor(deactivatedClassCounters));
    }

    public boolean freezeCounters() {
        this.enter("freezeCounters");
        return this.processPmcciSessions(this.m_freezeCountersProcessor);
    }

    public boolean reportCounters() {
        this.enter("reportCounters");
        return this.processPmcciSessions(this.m_reportCountersProcessor);
    }

    public boolean reportInstantCounters(String moLDN, String moClassName, String[] counterNames) {
        this.enter("reportInstantCounters");
        return this.processPmcciSessions(new ReportInstantCountersProcessor(moLDN, moClassName, counterNames));
    }

    public void enableCountersForReporting(PmClassCounter[] enabledClassCounters) {
        this.enter("enableCountersForReporting");
        PmPmcciSession[] sessions = this.m_pmcciSessions.getValues();
        for (int iter = 0; iter < sessions.length; ++iter) {
            PmPmcciSession session = sessions[iter];
            session.enableCountersForReporting(enabledClassCounters);
        }
    }

    public void compareCounterRegistrations(PmLists.PmCounterRegistrationItemList counterRegistrationItems) {
        String oamCounterName;
        this.enter("compareCounterRegistrations");
        PmClassCounterDefinitions oamClassCounterDefinitions = new PmClassCounterDefinitions();
        long oamMaxNumberOfMoInstances = 9999L;
        for (int i = 0; i < counterRegistrationItems.size(); ++i) {
            PmCounterRegistrationItem oamMoClassCounterType = counterRegistrationItems.get(i);
            String oamMoClassName = oamMoClassCounterType.moClassName;
            int oamMoClassId = i;
            PmClassCounterDefinition oamClassCounterDefinition = oamClassCounterDefinitions.getClassCounterDefinition(oamMoClassId, oamMaxNumberOfMoInstances, oamMoClassName);
            PmCounter[] oamCounters = oamMoClassCounterType.pmCounters;
            int j = 0;
            while (j < oamCounters.length) {
                PmCounter oamCounter = oamCounters[j];
                int oamCounterId = j++;
                oamCounterName = oamCounter.getCounterName();
                int oamCounterMultiplicity = oamCounter.getMultiplicity();
                PmCounterDefinition oamCounterDefinition = new PmCounterDefinition(oamCounterId, oamCounterName, oamCounterMultiplicity);
                oamClassCounterDefinition.addCounterDefinition(oamCounterDefinition);
            }
        }
        PmPmcciSession[] sessions = this.m_pmcciSessions.getValues();
        for (int iter = 0; iter < sessions.length; ++iter) {
            PmPmcciSession session = sessions[iter];
            String serverInstanceName = session.getServerInstanceName();
            PmClassCounterDefinitions pmcciClassCounterDefinitions = session.getClassCounterDefinitions();
            PmClassCounterDefinition[] pmcciClassCounterDefs = pmcciClassCounterDefinitions.getClassCounterDefs();
            for (int i = 0; i < pmcciClassCounterDefs.length; ++i) {
                PmClassCounterDefinition pmcciClassCounterDef = pmcciClassCounterDefs[i];
                String pmcciMoClassName = pmcciClassCounterDef.moClassName;
                PmClassCounterDefinition oamClassCounterDefinition = oamClassCounterDefinitions.findClassCounterDefinitionByName(pmcciMoClassName);
                if (oamClassCounterDefinition == null) {
                    this.info("For PMCCI service name (" + serverInstanceName + "), found inconsistent counter registrations.");
                    this.info("Could not find MoClassName (" + pmcciMoClassName + ") among MoClasses registered via OAM.");
                    continue;
                }
                PmCounterDefinition[] pmcciCounterDefs = pmcciClassCounterDef.getCounterDefs();
                boolean printOnce = true;
                for (int j = 0; j < pmcciCounterDefs.length; ++j) {
                    PmCounterDefinition pmcciCounterDef = pmcciCounterDefs[j];
                    String pmcciCounterName = pmcciCounterDef.counterName;
                    PmCounterDefinition oamCounterDefinition = oamClassCounterDefinition.findCounterDefinitionByName(pmcciCounterName);
                    if (oamCounterDefinition != null) continue;
                    if (printOnce) {
                        this.info("For PMCCI service name (" + serverInstanceName + "), found inconsistent counter registrations.");
                    }
                    this.info("Could not find CounterName (" + pmcciCounterName + ") for MoClassName (" + pmcciMoClassName + ") among counters registered via OAM.");
                    printOnce = false;
                }
            }
        }
        PmClassCounterDefinition[] oamClassCounterDefs = oamClassCounterDefinitions.getClassCounterDefs();
        for (int i = 0; i < oamClassCounterDefs.length; ++i) {
            PmClassCounterDefinition oamClassCounterDef = oamClassCounterDefs[i];
            String oamMoClassName = oamClassCounterDef.moClassName;
            boolean foundOamMoClass = false;
            for (int iter = 0; iter < sessions.length; ++iter) {
                PmPmcciSession session = sessions[iter];
                PmClassCounterDefinitions pmcciClassCounterDefinitions = session.getClassCounterDefinitions();
                PmClassCounterDefinition pmcciClassCounterDefinition = pmcciClassCounterDefinitions.findClassCounterDefinitionByName(oamMoClassName);
                if (pmcciClassCounterDefinition == null) continue;
                foundOamMoClass = true;
                break;
            }
            if (!foundOamMoClass) {
                this.info("Could not find MoClassName (" + oamMoClassName + ") among MoClasses registered via the PmCounterAggregator.");
                continue;
            }
            PmCounterDefinition[] oamCounterDefs = oamClassCounterDef.getCounterDefs();
            for (int j = 0; j < oamCounterDefs.length; ++j) {
                PmCounterDefinition oamCounterDef = oamCounterDefs[j];
                oamCounterName = oamCounterDef.counterName;
                boolean foundOamCounter = false;
                for (int iter = 0; iter < sessions.length; ++iter) {
                    PmCounterDefinition pmcciCounterDefinition;
                    PmPmcciSession session = sessions[iter];
                    PmClassCounterDefinitions pmcciClassCounterDefinitions = session.getClassCounterDefinitions();
                    PmClassCounterDefinition pmcciClassCounterDefinition = pmcciClassCounterDefinitions.findClassCounterDefinitionByName(oamMoClassName);
                    if (pmcciClassCounterDefinition == null || (pmcciCounterDefinition = pmcciClassCounterDefinition.findCounterDefinitionByName(oamCounterName)) == null) continue;
                    foundOamCounter = true;
                    break;
                }
                if (foundOamCounter) continue;
                this.info("Could not find CounterName (" + oamCounterName + ") for MoClassName (" + oamMoClassName + ") among counters registered via the PmCounterAggregator.");
            }
        }
    }

    public void checkUpdatingActive() {
        this.enter("checkUpdatingActive");
        int count = this.countProcessingPmcciSessions(this.m_checkUpdatingActiveProcessor);
        if (count == 0) {
            this.m_callback.sessionHandler_allSessionsAreDoneUpdatingActive();
        }
    }

    public void checkFreezeCountersStatus() {
        this.enter("checkFreezeCountersStatus");
        int count = this.countProcessingPmcciSessions(this.m_freezeCountersProcessor);
        if (count == 0) {
            this.m_callback.sessionHandler_allSessionsAreDoneFreezing();
        }
    }

    public void checkReportCountersStatus() {
        this.enter("checkReportCountersStatus");
        int count = this.countProcessingPmcciSessions(this.m_reportCountersProcessor);
        if (count == 0) {
            this.m_callback.sessionHandler_allSessionsAreDoneReporting();
        }
    }

    public void checkReportInstantCountersStatus() {
        this.enter("checkReportInstantCountersStatus");
        int count = this.countProcessingPmcciSessions(this.m_reportInstantCountersProcessor);
        if (count == 0) {
            this.m_callback.sessionHandler_allSessionsAreDoneReportingInstantCounters();
        }
    }

    public void terminateNonRespondingSessions() {
        this.enter("terminateNonRespondingSessions");
        PmPmcciSession[] sessions = this.m_pmcciSessions.getValues();
        for (int iter = 0; iter < sessions.length; ++iter) {
            PmPmcciSession session = sessions[iter];
            if (session.isTerminated()) continue;
            session.terminateNonResponding();
        }
    }

    public void handlePmariConnToServerReq(PmSignals.Receive.PmariConnToServerReq signal) {
        this.enter("handlePmariConnToServerReq");
        long[] protRevArray = signal.supportedProtocolRevisionsList;
        boolean found = false;
        for (int i = 0; i < protRevArray.length; ++i) {
            if (protRevArray[i] != 1L) continue;
            found = true;
        }
        if (!found) {
            StringBuffer errorBuff = new StringBuffer();
            errorBuff.append("No matching PMARI protocol revision, supported: ");
            errorBuff.append(1L);
            errorBuff.append(" Requested:");
            for (int i = 0; i < protRevArray.length; ++i) {
                errorBuff.append(" ");
                errorBuff.append(protRevArray[i]);
            }
            errorBuff.append(" For pid: ");
            errorBuff.append(this.m_proxy.getSenderPid(signal));
            this.error(errorBuff.toString());
            PmSignals.Send.PmariConnToServerRej pmariConnectionRej = new PmSignals.Send.PmariConnToServerRej();
            pmariConnectionRej.procedureRef = signal.procedureRef;
            pmariConnectionRej.connectionRef = 0L;
            pmariConnectionRej.errorCode = 1L;
            this.m_proxy.sendSignal(pmariConnectionRej, this.m_proxy.getSenderPid(signal));
            return;
        }
        long serverConnectionRef = this.getSessionId();
        if (!this.addPmariSession(serverConnectionRef, signal.connectionRef)) {
            this.error("Failed to add PMARI session for serverConnectionRef: " + serverConnectionRef);
            PmSignals.Send.PmariConnToServerRej pmariConnectionRej = new PmSignals.Send.PmariConnToServerRej();
            pmariConnectionRej.procedureRef = signal.procedureRef;
            pmariConnectionRej.connectionRef = 0L;
            pmariConnectionRej.errorCode = 99L;
            this.m_proxy.sendSignal(pmariConnectionRej, this.m_proxy.getSenderPid(signal));
            return;
        }
        this.general("Created new PMARI session: " + serverConnectionRef);
        PmSignals.Send.PmariConnToServerCfm pmariConnectionCfm = new PmSignals.Send.PmariConnToServerCfm();
        pmariConnectionCfm.procedureRef = signal.procedureRef;
        pmariConnectionCfm.connectionRef = serverConnectionRef;
        pmariConnectionCfm.selectedProtocolRevision = 1L;
        this.m_proxy.sendSignal(pmariConnectionCfm, this.m_proxy.getSenderPid(signal));
    }

    public void handlePmariRegisterAgentReq(PmSignals.Receive.PmariRegisterAgentReq signal) {
        this.enter("handlePmariRegisterAgentReq");
        long clientConnectionRef = this.getPmariClientConnectionRef(signal.connectionRef);
        if (clientConnectionRef == -9999L) {
            return;
        }
        PmSignals.Send.PmariRegisterAgentCfm pmariRegisterAgentCfm = new PmSignals.Send.PmariRegisterAgentCfm();
        pmariRegisterAgentCfm.procedureRef = signal.procedureRef;
        pmariRegisterAgentCfm.connectionRef = clientConnectionRef;
        this.m_proxy.sendSignal(pmariRegisterAgentCfm, this.m_proxy.getSenderPid(signal));
        String serverInstanceName = signal.serverInstanceName;
        this.general("Looking for Aggregator service: " + serverInstanceName);
        int aggregatorPid = this.m_proxy.huntForServiceName(serverInstanceName);
        this.general("Found Aggregator PMCCI service at pid: " + aggregatorPid);
        this.createPmcciSession(aggregatorPid, serverInstanceName);
    }

    public void handlePmcciConnToServerCfm(PmSignals.Receive.PmcciConnToServerCfm signal) {
        this.enter("handlePmcciConnToServerCfm");
        PmPmcciSession session = this.getPmcciSession(signal.connectionRef);
        if (session == null) {
            return;
        }
        session.connToServerCfm(signal.procedureRef, signal.connectionRef, signal.selectedProtocolRevision);
    }

    public void handlePmcciConnToServerRej(PmSignals.Receive.PmcciConnToServerRej signal) {
        this.enter("handlePmcciConnToServerRej");
        PmPmcciSession session = this.getPmcciSession(signal.procedureRef);
        if (session == null) {
            return;
        }
        session.connToServerRej(signal.procedureRef, signal.connectionRef, signal.errorCode);
    }

    public void handlePmcciRegisterCountersRreq2(PmSignals.Receive.PmcciRegisterCountersRreq2 signal) {
        this.enter("handlePmcciRegisterCountersRreq2");
        PmPmcciSession session = this.getPmcciSession(signal.connectionRef);
        if (session == null) {
            return;
        }
        session.registerCounters(signal.procedureRef, signal.moreDataExists != 0, signal.moClassItems);
    }

    public void handlePmcciRegisterMeasobjRreq2(PmSignals.Receive.PmcciRegisterMeasobjRreq2 signal) {
        this.enter("handlePmcciRegisterMeasobjRreq2");
        PmPmcciSession session = this.getPmcciSession(signal.connectionRef);
        if (session == null) {
            return;
        }
        session.registerMeasurementObjects(signal.procedureRef, signal.usePmFwkMoInstanceIdService != 0, signal.measobjItems);
    }

    public void handlePmcciDeregisterMeasobjRreq2(PmSignals.Receive.PmcciDeregisterMeasobjRreq2 signal) {
        this.enter("handlePmcciDeregisterMeasobjRreq2");
        PmPmcciSession session = this.getPmcciSession(signal.connectionRef);
        if (session == null) {
            return;
        }
        session.deregisterMeasurementObjects(signal.procedureRef, signal.measobjItems);
    }

    public void handlePmcciSetActiveCountersCfm(PmSignals.Receive.PmcciSetActiveCountersCfm signal) {
        this.enter("handlePmcciSetActiveCountersCfm");
        PmPmcciSession session = this.getPmcciSession(signal.connectionRef);
        if (session == null) {
            return;
        }
        boolean needToCountActiveCounters = session.setActiveCountersCfm(signal.procedureRef);
        if (needToCountActiveCounters) {
            this.checkUpdatingActive();
        }
    }

    public void handlePmcciSetActiveCountersRej(PmSignals.Receive.PmcciSetActiveCountersRej signal) {
        this.enter("handlePmcciSetActiveCountersRej");
        PmPmcciSession session = this.getPmcciSession(signal.connectionRef);
        if (session == null) {
            return;
        }
        boolean needToCountActiveCounters = session.setActiveCountersRej(signal.procedureRef, signal.errorItem.errorMessage);
        if (needToCountActiveCounters) {
            this.checkUpdatingActive();
        }
    }

    public void handlePmcciFreezeCountersCfm(PmSignals.Receive.PmcciFreezeCountersCfm signal) {
        this.enter("handlePmcciFreezeCountersCfm");
        PmPmcciSession session = this.getPmcciSession(signal.connectionRef);
        if (session == null) {
            return;
        }
        session.freezeCountersCfm(signal.procedureRef);
        this.checkFreezeCountersStatus();
    }

    public void handlePmcciFetchFrozenCountersCfm(PmSignals.Receive.PmcciFetchFrozenCountersCfm signal) {
        this.enter("handlePmcciFetchFrozenCountersCfm");
        PmPmcciSession session = this.getPmcciSession(signal.connectionRef);
        if (session == null) {
            return;
        }
        session.fetchFrozenCountersCfm(signal.procedureRef);
        this.checkReportCountersStatus();
    }

    public void handlePmcciFetchFrozenCountersRej(PmSignals.Receive.PmcciFetchFrozenCountersRej signal) {
        this.enter("handlePmcciFetchFrozenCountersRej");
        PmPmcciSession session = this.getPmcciSession(signal.connectionRef);
        if (session == null) {
            return;
        }
        session.fetchFrozenCountersRej(signal.procedureRef, signal.errorItem.errorMessage);
        this.checkReportCountersStatus();
    }

    public void handlePmcciFetchFrozenCountersRdata(PmSignals.Receive.PmcciFetchFrozenCountersRdata signal) {
        this.enter("handlePmcciFetchFrozenCountersRdata");
        PmPmcciSession session = this.getPmcciSession(signal.connectionRef);
        if (session == null) {
            return;
        }
        session.fetchFrozenCountersRdata(signal.procedureRef, signal.moreDataExists != 0, signal.counterCollectItems);
        this.checkReportCountersStatus();
    }

    public void handlePmcciFetchInstantCountersCfm(PmSignals.Receive.PmcciFetchInstantCountersCfm signal) {
        this.enter("handlePmcciFetchInstantCountersCfm");
        PmPmcciSession session = this.getPmcciSession(signal.connectionRef);
        if (session == null) {
            return;
        }
        session.fetchInstantCountersCfm(signal.procedureRef, signal.moClassId, signal.moInstanceId);
        this.checkReportInstantCountersStatus();
    }

    public void handlePmcciFetchInstantCountersRej(PmSignals.Receive.PmcciFetchInstantCountersRej signal) {
        this.enter("handlePmcciFetchInstantCountersRej");
        PmPmcciSession session = this.getPmcciSession(signal.connectionRef);
        if (session == null) {
            return;
        }
        session.fetchInstantCountersRej(signal.procedureRef, signal.moClassId, signal.moInstanceId, signal.errorItem.errorMessage);
        this.checkReportInstantCountersStatus();
    }

    public void handlePmcciFetchInstantCountersRdata(PmSignals.Receive.PmcciFetchInstantCountersRdata signal) {
        this.enter("handlePmcciFetchInstantCountersRdata");
        PmPmcciSession session = this.getPmcciSession(signal.connectionRef);
        if (session == null) {
            this.error("Could not locate session with connectionRef: " + signal.connectionRef);
            return;
        }
        session.fetchInstantCountersRdata(signal.procedureRef, signal.moreDataExists != 0, signal.moClassId, signal.moInstanceId, signal.instantCounterCollectItems);
        this.checkReportInstantCountersStatus();
    }

    public void createPmcciSession(int pid, String serverInstanceName) {
        this.enter("createPmcciSession");
        long clientConnectionRef = this.getSessionId();
        PmPmcciSession session = new PmPmcciSession(this.m_proxy, pid, this.m_callback, this.m_threadSwitcher, serverInstanceName);
        if (!this.addPmcciSession(clientConnectionRef, session)) {
            return;
        }
        this.general("New PMCCI session created for pid: " + pid + " id: " + clientConnectionRef);
        session.start(clientConnectionRef);
    }

    public boolean processPmcciSessions(PmcciSessionProcessor processor) {
        this.enter("processPmcciSessions");
        PmPmcciSession[] sessions = this.m_pmcciSessions.getValues();
        this.general("Total count of sessions: " + sessions.length);
        boolean res = false;
        int count = 0;
        for (int iter = 0; iter < sessions.length; ++iter) {
            PmPmcciSession session = sessions[iter];
            if (session.isTerminated()) continue;
            res |= processor.processPmcciSession(session);
            ++count;
        }
        this.general("Total count of processed sessions: " + count);
        return res;
    }

    public int countProcessingPmcciSessions(PmcciSessionProcessor processor) {
        this.enter("countProcessingPmcciSessions");
        int count = 0;
        PmPmcciSession[] sessions = this.m_pmcciSessions.getValues();
        this.general("Total count of sessions: " + sessions.length);
        for (int iter = 0; iter < sessions.length; ++iter) {
            PmPmcciSession session = sessions[iter];
            if (!processor.isProcessing(session)) continue;
            ++count;
        }
        this.general("Total count of matching sessions: " + count);
        return count;
    }

    public void receiveSignal(PmBaseSignal signal) {
        this.enter("receiveSignal");
        if (signal == null) {
            this.error("Signal must not be null");
            return;
        }
        if (!PmSignals.Receive.receiveSignal(this, signal)) {
            this.error("Unrecognized signal: " + signal.toString());
        }
    }

    public boolean addPmariSession(long serverConnectionRef, long clientConnectionRef) {
        this.enter("addPmariSession");
        if (!this.m_pmariSessions.add(serverConnectionRef, clientConnectionRef)) {
            this.error("Failed to add PMARI session for serverConnectionRef: " + serverConnectionRef);
            return false;
        }
        return true;
    }

    public long getPmariClientConnectionRef(long serverConnectionRef) {
        this.enter("getPmariClientConnectionRef");
        long clientConnectionRef = this.m_pmariSessions.get(serverConnectionRef, -9999L);
        if (clientConnectionRef == -9999L) {
            this.error("No PMARI session found for serverConnectionRef: " + serverConnectionRef);
        }
        return clientConnectionRef;
    }

    public boolean addPmcciSession(long clientConnectionRef, PmPmcciSession session) {
        this.enter("addPmcciSession");
        if (!this.m_pmcciSessions.add(clientConnectionRef, session)) {
            this.error("Failed to add PMCCI session for clientConnectionRef:" + clientConnectionRef);
            return false;
        }
        return true;
    }

    public PmPmcciSession getPmcciSession(long clientConnectionRef) {
        this.enter("getPmcciSession " + clientConnectionRef);
        PmPmcciSession session = this.m_pmcciSessions.get(clientConnectionRef);
        if (session == null) {
            this.error("No PMCCI Session found for clientConnectionRef: " + clientConnectionRef);
        } else if (session.isTerminated()) {
            this.error("Received unexpected action towards PMCCI session with clientConnectionRef: " + clientConnectionRef + " in state terminated! ");
            return null;
        }
        return session;
    }

    public boolean hasRunningSessions() {
        this.enter("hasRunningSessions");
        PmPmcciSession[] sessions = this.m_pmcciSessions.getValues();
        this.general("Total count of sessions: " + sessions.length);
        for (int iter = 0; iter < sessions.length; ++iter) {
            PmPmcciSession session = sessions[iter];
            if (!session.isRunning()) continue;
            this.enter("Session is running and awaiting");
            return true;
        }
        return false;
    }

    public class ReportInstantCountersProcessor
    implements PmcciSessionProcessor {
        private String moLDN;
        private String moClassName;
        private String[] counterNames;

        public ReportInstantCountersProcessor() {
        }

        public ReportInstantCountersProcessor(String moLDN, String moClassName, String[] counterNames) {
            this.moLDN = moLDN;
            this.moClassName = moClassName;
            this.counterNames = counterNames;
        }

        public boolean isProcessing(PmPmcciSession session) {
            return session.isReportingInstantCounters();
        }

        public boolean processPmcciSession(PmPmcciSession session) {
            if (session.hasRegisteredMoLdn(this.moClassName, this.moLDN)) {
                PmSessionHandler.this.general("Calling reportInstantCounters for a session");
                return session.reportInstantCounters(this.moLDN, this.counterNames);
            }
            PmSessionHandler.this.general("Skipped reportInstantCounters for a session");
            return false;
        }
    }

    public class ReportCountersProcessor
    implements PmcciSessionProcessor {
        public boolean isProcessing(PmPmcciSession session) {
            return session.isReportingCounters();
        }

        public boolean processPmcciSession(PmPmcciSession session) {
            return session.reportCounters();
        }
    }

    public class FreezeCountersProcessor
    implements PmcciSessionProcessor {
        public boolean isProcessing(PmPmcciSession session) {
            return session.isFreezingCounters();
        }

        public boolean processPmcciSession(PmPmcciSession session) {
            return session.freezeCounters();
        }
    }

    public class DeactivateCountersProcessor
    implements PmcciSessionProcessor {
        private final PmClassCounter[] m_deactivatedClassCounters;

        public DeactivateCountersProcessor() {
            this.m_deactivatedClassCounters = new PmClassCounter[0];
        }

        public DeactivateCountersProcessor(PmClassCounter[] deactivatedClassCounters) {
            this.m_deactivatedClassCounters = deactivatedClassCounters;
        }

        public boolean isProcessing(PmPmcciSession session) {
            return session.isUpdatingActive();
        }

        public boolean processPmcciSession(PmPmcciSession session) {
            return session.deactivateCounters(this.m_deactivatedClassCounters);
        }
    }

    public class ActivateCountersProcessor
    implements PmcciSessionProcessor {
        private PmClassCounter[] m_activatedClassCounters;

        public ActivateCountersProcessor() {
            this.m_activatedClassCounters = new PmClassCounter[0];
        }

        public ActivateCountersProcessor(PmClassCounter[] activatedClassCounters) {
            this.m_activatedClassCounters = activatedClassCounters;
        }

        public boolean isProcessing(PmPmcciSession session) {
            return session.isUpdatingActive();
        }

        public boolean processPmcciSession(PmPmcciSession session) {
            return session.activateCounters(this.m_activatedClassCounters);
        }
    }

    public static interface PmcciSessionProcessor {
        public boolean isProcessing(PmPmcciSession var1);

        public boolean processPmcciSession(PmPmcciSession var1);
    }

    public static interface Callback {
        public boolean sessionHandler_registerCounters();

        public boolean sessionHandler_reportCounterValues(PmMeasuredDataI[] var1, boolean var2);

        public boolean sessionHandler_reportInstantCounterValues(PmMeasuredInstantData var1);

        public boolean sessionHandler_allSessionsAreDoneUpdatingActive();

        public boolean sessionHandler_allSessionsAreDoneFreezing();

        public boolean sessionHandler_allSessionsAreDoneReporting();

        public boolean sessionHandler_allSessionsAreDoneReportingInstantCounters();

        public PmMeasuredDataI sessionHandler_createMeasuredDataContainer(String[] var1, String[] var2);
    }
}

