/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.neal;

import PerformanceIRPConstDefs.ObservationClass;
import PerformanceIRPConstDefs.ObservationObject;
import java.lang.reflect.Field;
import org.omg.CORBA.UserException;
import se.ericsson.cello.neal.NealRuntimeException;
import se.ericsson.cello.neal.cm.NameValue;

public class CppOamException
extends NealRuntimeException {
    private static final String DEFAULT_INFO = "";
    private static final String DEFAULT_TAG = "";
    protected static final NameValue[] DEFAULT_VARIABLES = new NameValue[0];
    private static final String INFO_FIELD = "info";
    private static final String REASON_FIELD = "reason";
    private static final String OBSERVATION_OBJECT_LIST = "observation_object_list";
    private static final String OBSERVATION_CLASS_LIST = "observation_class_list";
    private static final String NOT_SUPPORTED_PARAMETERS = "notSupportedParameters";
    private static final String NE_LIST = "ne_list";
    private static final String OBSERVATION_OBJECT = "observation_object";
    private static final String TAG_INDICATOR = " TAG :\"";
    private static final String INDENTION = "   ";
    protected static final String VARIABLES_INDICATOR = " VARIABLES :";
    private Throwable originalException;
    private String tag = "";
    private String info = "";
    private NameValue[] variables = DEFAULT_VARIABLES;
    private String message = null;

    public CppOamException(UserException userException) {
        this(null, userException);
    }

    public CppOamException(String string, UserException userException) {
        super(string, userException);
        this.originalException = userException;
        if (userException != null) {
            this.info = this.extractCauseInfo(userException);
            this.tag = this.extractCauseTag(userException, this.info);
            this.variables = this.extractCauseVariables(userException, this.info);
            this.message = this.isSubString(TAG_INDICATOR, this.info) ? this.constructMessage(this.tag, this.variables, "") : this.constructMessage(this.tag, this.variables, this.info);
        }
        if (string != null) {
            this.message = string + ": " + this.message;
        }
    }

    public CppOamException(String string) {
        if (string != null) {
            this.info = string;
            this.tag = this.extractExceptionName(this);
            this.variables = DEFAULT_VARIABLES;
            this.message = string;
        }
    }

    private String extractCauseInfo(UserException userException) {
        String string = "";
        Class<?> clazz = ((Object)((Object)userException)).getClass();
        Field[] fieldArray = clazz.getDeclaredFields();
        for (int i = 0; i < fieldArray.length; ++i) {
            String string2 = fieldArray[i].getName();
            if (string2.equals(INFO_FIELD) || string2.equals(REASON_FIELD)) {
                try {
                    string = (String)fieldArray[i].get((Object)userException);
                }
                catch (Exception exception) {
                    string = "";
                }
                break;
            }
            if (string2.equals(OBSERVATION_OBJECT_LIST)) {
                try {
                    ObservationObject[] observationObjectArray = (ObservationObject[])fieldArray[i].get((Object)userException);
                    string = this.parseObservationObjectArray(observationObjectArray);
                }
                catch (Exception exception) {
                    string = "";
                }
                break;
            }
            if (string2.equals(OBSERVATION_CLASS_LIST)) {
                try {
                    ObservationClass[] observationClassArray = (ObservationClass[])fieldArray[i].get((Object)userException);
                    string = this.parseObservationClassArray(observationClassArray);
                }
                catch (Exception exception) {
                    string = "";
                }
                break;
            }
            if (string2.equals(NOT_SUPPORTED_PARAMETERS)) {
                try {
                    String[] stringArray = (String[])fieldArray[i].get((Object)userException);
                    string = this.parseStringArray("Parameters: ", stringArray);
                }
                catch (Exception exception) {
                    string = "";
                }
                break;
            }
            if (string2.equals(NE_LIST)) {
                try {
                    String[] stringArray = (String[])fieldArray[i].get((Object)userException);
                    string = this.parseStringArray("Network Elements: ", stringArray);
                }
                catch (Exception exception) {
                    string = "";
                }
                break;
            }
            if (!string2.equals(OBSERVATION_OBJECT)) continue;
            try {
                ObservationObject observationObject = (ObservationObject)fieldArray[i].get((Object)userException);
                string = this.parseObservationObject(observationObject);
            }
            catch (Exception exception) {
                string = "";
            }
            break;
        }
        if (string == null) {
            string = "";
        }
        return string;
    }

    private String extractCauseTag(Throwable throwable, String string) {
        String string2 = "";
        string2 = this.isSubString(TAG_INDICATOR, string) ? this.extractInfoTextTag(string) : this.extractExceptionName(this.originalException);
        if (string2 == null) {
            string2 = "";
        }
        return string2;
    }

    private NameValue[] extractCauseVariables(Throwable throwable, String string) {
        NameValue[] nameValueArray = DEFAULT_VARIABLES;
        if (this.isSubString(VARIABLES_INDICATOR, string)) {
            nameValueArray = this.extractInfoTextVariables(string);
        }
        if (nameValueArray == null) {
            nameValueArray = DEFAULT_VARIABLES;
        }
        return nameValueArray;
    }

    private String extractExceptionName(Throwable throwable) {
        Class<?> clazz = throwable.getClass();
        String string = clazz.getName();
        int n = string.lastIndexOf(".") + 1;
        return string.substring(n);
    }

    private String constructMessage(String string, NameValue[] nameValueArray, String string2) {
        StringBuffer stringBuffer = new StringBuffer(string);
        for (int i = 0; i < nameValueArray.length; ++i) {
            stringBuffer.append("\n");
            stringBuffer.append(nameValueArray[i].getName());
            stringBuffer.append(": ");
            stringBuffer.append(nameValueArray[i].getValue());
        }
        if (string2 != null && string2.length() != 0) {
            stringBuffer.append("\n");
            stringBuffer.append(string2);
        }
        CppOamException.indentNewLines(stringBuffer);
        return stringBuffer.toString();
    }

    private static void indentNewLines(StringBuffer stringBuffer) {
        for (int i = 0; i < stringBuffer.length() - 1; ++i) {
            if (stringBuffer.charAt(i) != '\n') continue;
            stringBuffer.insert(++i, INDENTION);
            i += INDENTION.length();
        }
        if (stringBuffer.charAt(stringBuffer.length() - 1) != '\n') {
            stringBuffer.append('\n');
        }
    }

    private boolean isSubString(String string, String string2) {
        boolean bl = true;
        int n = string2.indexOf(string);
        if (n == -1) {
            bl = false;
        }
        return bl;
    }

    protected NameValue[] extractInfoTextVariables(String string) {
        return DEFAULT_VARIABLES;
    }

    private String extractInfoTextTag(String string) {
        int n = string.indexOf(TAG_INDICATOR);
        if (n == -1) {
            return "";
        }
        int n2 = string.indexOf("\"", (n += TAG_INDICATOR.length()) + 1);
        if (n2 <= n) {
            return "";
        }
        return string.substring(n, n2);
    }

    private String parseObservationObject(ObservationObject observationObject) {
        String string = "";
        if (observationObject != null) {
            ObservationObject[] observationObjectArray = new ObservationObject[]{observationObject};
            string = this.parseObservationObjectArray(observationObjectArray);
        }
        return string;
    }

    private String parseObservationObjectArray(ObservationObject[] observationObjectArray) {
        StringBuffer stringBuffer = new StringBuffer();
        if (observationObjectArray != null) {
            for (int i = 0; i < observationObjectArray.length; ++i) {
                String[] stringArray = observationObjectArray[i].instance_list;
                if (stringArray == null || stringArray.length <= 0) continue;
                stringBuffer.append("Instances: ");
                for (int j = 0; j < stringArray.length; ++j) {
                    stringBuffer.append(stringArray[j]);
                    stringBuffer.append(" ");
                }
                String[] stringArray2 = observationObjectArray[i].instance_attribute_list;
                if (stringArray2 == null || stringArray2.length <= 0) continue;
                stringBuffer.append(" Attributes: ");
                for (int j = 0; j < stringArray2.length; ++j) {
                    stringBuffer.append(stringArray2[j]);
                    if (j < stringArray2.length - 1) {
                        stringBuffer.append(" ");
                        continue;
                    }
                    stringBuffer.append("\n");
                }
            }
        }
        String string = "";
        if (stringBuffer.length() > 0) {
            string = stringBuffer.toString();
        }
        return string;
    }

    private String parseObservationClassArray(ObservationClass[] observationClassArray) {
        StringBuffer stringBuffer = new StringBuffer();
        if (observationClassArray != null) {
            for (int i = 0; i < observationClassArray.length; ++i) {
                String string = observationClassArray[i].object_class_name;
                stringBuffer.append("Class: " + string);
                String[] stringArray = observationClassArray[i].class_attribute_list;
                if (stringArray == null || stringArray.length <= 0) continue;
                stringBuffer.append(" Attributes: ");
                for (int j = 0; j < stringArray.length; ++j) {
                    stringBuffer.append(stringArray[j]);
                    if (j < stringArray.length - 1) {
                        stringBuffer.append(" ");
                        continue;
                    }
                    stringBuffer.append("\n");
                }
            }
        }
        String string = "";
        if (stringBuffer.length() > 0) {
            string = stringBuffer.toString();
        }
        return string;
    }

    private String parseStringArray(String string, String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        if (stringArray != null && stringArray.length > 0) {
            stringBuffer.append(string);
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i];
                stringBuffer.append(string2 + " ");
            }
            stringBuffer.append("\n");
        }
        String string3 = "";
        if (stringBuffer.length() > 0) {
            string3 = stringBuffer.toString();
        }
        return string3;
    }

    public Throwable getCause() {
        return super.getCause();
    }

    public String getCauseTag() {
        return this.tag;
    }

    public String getRawInfo() {
        return this.info;
    }

    public NameValue[] getCauseVariables() {
        return this.variables;
    }

    public String getMessage() {
        return this.message;
    }
}

