/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.neal.cm;

import ConfigExtended.ConfigNotification;
import ConfigExtended.NotificationConsumer;
import ConfigExtended.NotificationConsumerHelper;
import ConfigExtended.NotificationConsumerOperations;
import ConfigExtended.NotificationConsumerPOATie;
import EDU.oswego.cs.dl.util.concurrent.ClockDaemon;
import java.util.HashMap;
import java.util.Map;
import se.ericsson.cello.neal.Node;
import se.ericsson.cello.neal.cm.CelloCmSubscription;
import se.ericsson.cello.neal.cm.CmException;
import se.ericsson.cello.neal.cm.CmNotificationConsumer;
import se.ericsson.cello.neal.cm.CmNotifier;
import se.ericsson.cello.neal.cm.CmSubscriptionMgr;
import se.ericsson.cello.neal.cm.Mo;
import se.ericsson.cello.neal.cm.NotificationType;
import se.ericsson.cello.neal.cm.Scope;
import se.ericsson.cello.neal.internal.NealLog;
import se.ericsson.cello.neal.internal.ServiceContext;

class CmNotificationConsumerImpl
implements NotificationConsumerOperations,
Runnable {
    private static final boolean DEBUG = false;
    private static Map _callbackTable = new HashMap();
    private ClockDaemon _timer;
    private CmNotificationConsumer _consumer;
    private CmSubscriptionMgr _subscriptionMgr;
    private ServiceContext serviceContext;
    private NotificationConsumer _corbaRef;

    private static void debug(String string) {
    }

    private CmNotificationConsumerImpl(CmNotificationConsumer cmNotificationConsumer, ServiceContext serviceContext) {
        this._consumer = cmNotificationConsumer;
        this.serviceContext = serviceContext;
        this._subscriptionMgr = new CmSubscriptionMgr();
        this._timer = new ClockDaemon();
        this._timer.executePeriodically(60000L, this, true);
    }

    public boolean equals(Object object) {
        if (object != null && object.getClass().equals(this.getClass())) {
            CmNotificationConsumerImpl cmNotificationConsumerImpl = (CmNotificationConsumerImpl)object;
            return this.getClientConsumer().equals(cmNotificationConsumerImpl.getClientConsumer());
        }
        return false;
    }

    public int hashCode() {
        return this.getClientConsumer().hashCode();
    }

    static synchronized CmNotificationConsumerImpl create(CmNotificationConsumer cmNotificationConsumer, ServiceContext serviceContext) {
        CmNotificationConsumerImpl cmNotificationConsumerImpl = CmNotificationConsumerImpl.lookup(cmNotificationConsumer, serviceContext.getNode());
        if (cmNotificationConsumerImpl == null) {
            cmNotificationConsumerImpl = new CmNotificationConsumerImpl(cmNotificationConsumer, serviceContext);
            NotificationConsumerPOATie notificationConsumerPOATie = new NotificationConsumerPOATie(cmNotificationConsumerImpl);
            serviceContext.connect(notificationConsumerPOATie);
            NotificationConsumer notificationConsumer = NotificationConsumerHelper.narrow(serviceContext.servant_to_reference(notificationConsumerPOATie));
            cmNotificationConsumerImpl.setReference(notificationConsumer);
            _callbackTable.put(new NodeAndClientContainer(cmNotificationConsumer, serviceContext.getNode()), cmNotificationConsumerImpl);
        }
        return cmNotificationConsumerImpl;
    }

    static synchronized CmNotificationConsumerImpl lookup(CmNotificationConsumer cmNotificationConsumer, Node node) {
        return (CmNotificationConsumerImpl)_callbackTable.get(new NodeAndClientContainer(cmNotificationConsumer, node));
    }

    static synchronized void delete(CmNotificationConsumer cmNotificationConsumer, ServiceContext serviceContext) {
        Node node = serviceContext.getNode();
        CmNotificationConsumerImpl cmNotificationConsumerImpl = CmNotificationConsumerImpl.lookup(cmNotificationConsumer, node);
        if (cmNotificationConsumerImpl != null) {
            CmNotificationConsumerImpl.debug("CmNotificationConsumerImpl#delete: " + cmNotificationConsumerImpl);
            cmNotificationConsumerImpl.delete();
            _callbackTable.remove(new NodeAndClientContainer(cmNotificationConsumer, node));
            cmNotificationConsumerImpl.serviceContext.getNealOrb().disconnect(cmNotificationConsumerImpl.getReference());
        }
    }

    void delete() {
        try {
            this._subscriptionMgr.unsubscribeAll();
        }
        catch (Exception exception) {
            NealLog.warning("Could not unsubscribe all subscriptions");
        }
        this._subscriptionMgr.removeAll();
        this._timer.shutDown();
    }

    void cleanUpIfNoMoreSubscription() {
        CmNotificationConsumerImpl.debug("Enter cleanUpIfNoMoreSubscription()");
        if (this._subscriptionMgr.isEmpty()) {
            CmNotificationConsumerImpl.debug("cleanUpIfNoMoreSubscription(): spawning thread that will delete!");
            Runnable runnable = new Runnable(){

                public void run() {
                    try {
                        CmNotificationConsumerImpl.delete(CmNotificationConsumerImpl.this._consumer, CmNotificationConsumerImpl.this.serviceContext);
                        CmNotificationConsumerImpl.debug("       cleanUpIfNoMoreSubscription(): spawned thread finnished deleting!");
                    }
                    catch (CmException cmException) {
                        CmNotificationConsumerImpl.debug(cmException.toString());
                    }
                }
            };
            new Thread(runnable).start();
        }
    }

    synchronized CelloCmSubscription subscribe(Mo mo, NotificationType notificationType, String[] stringArray, Scope scope, ServiceContext serviceContext) {
        CelloCmSubscription celloCmSubscription = new CelloCmSubscription(this._subscriptionMgr, mo, notificationType, stringArray, scope, this, serviceContext);
        CelloCmSubscription celloCmSubscription2 = this._subscriptionMgr.lookup(celloCmSubscription);
        if (celloCmSubscription2 == null) {
            celloCmSubscription.subscribe();
            NealLog.fine("Created new subscription with ID " + celloCmSubscription.getSubscriptionId());
            this._subscriptionMgr.add(celloCmSubscription);
            return celloCmSubscription;
        }
        NealLog.fine("Identical subscription exists, only increase reference count");
        celloCmSubscription2.subscribe();
        return celloCmSubscription2;
    }

    public void push(ConfigNotification[] configNotificationArray) {
        CmNotifier cmNotifier = new CmNotifier(configNotificationArray, this._consumer);
        cmNotifier.run();
    }

    public void run() {
        CmNotificationConsumerImpl.debug("CmNotificationConsumerImpl#run()");
        this._subscriptionMgr.keepAlive();
    }

    CmNotificationConsumer getClientConsumer() {
        return this._consumer;
    }

    NotificationConsumer getReference() {
        return this._corbaRef;
    }

    void setReference(NotificationConsumer notificationConsumer) {
        this._corbaRef = notificationConsumer;
    }

    private static class NodeAndClientContainer {
        CmNotificationConsumer _consumer;
        Node _node;

        NodeAndClientContainer(CmNotificationConsumer cmNotificationConsumer, Node node) {
            this._consumer = cmNotificationConsumer;
            this._node = node;
        }

        public boolean equals(Object object) {
            if (object != null && object.getClass() == this.getClass()) {
                NodeAndClientContainer nodeAndClientContainer = (NodeAndClientContainer)object;
                if (this._consumer.equals(nodeAndClientContainer._consumer)) {
                    if (this._node == null) {
                        return nodeAndClientContainer._node == null;
                    }
                    return ((Object)this._node).equals(nodeAndClientContainer._node);
                }
            }
            return false;
        }

        public int hashCode() {
            return this._consumer.hashCode();
        }
    }
}

