/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.nia.proxy;

import enea.ose.system.AttachSignal;
import enea.ose.system.InSignal;
import enea.ose.system.OseProcess;
import enea.ose.system.Signal;
import se.ericsson.cello.nia.NIAAddressInfo;
import se.ericsson.cello.nia.NIAMgr;
import se.ericsson.cello.nia.proxy.IpomNiajiChange2Ind;
import se.ericsson.cello.nia.proxy.IpomNiajiChangeInd;
import se.ericsson.cello.nia.proxy.IpomNiajiGetNodeIpAddressesInfoCfm;
import se.ericsson.cello.nia.proxy.IpomNiajiGetNodeIpAddressesInfoReq;
import se.ericsson.cello.nia.proxy.IpomNiajiInitiateServiceCfm;
import se.ericsson.cello.nia.proxy.IpomNiajiInitiateServiceReq;
import se.ericsson.cello.nia.proxy.IpomNiajiNotifySubscribeReq;
import se.ericsson.cello.nia.proxy.IpomNiajiTerminateServiceCfm;
import se.ericsson.cello.nia.proxy.IpomNiajiTerminateServiceReq;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.support.sigutil.OseNameServer;
import se.ericsson.cello.support.sigutil.PortManager;
import se.ericsson.cello.support.sigutil.SignalHelper;
import se.ericsson.cello.support.sigutil.SignalObserver;
import se.ericsson.cello.support.sigutil.SignalPort;
import se.ericsson.cello.support.sigutil.SubscriptionObserver;

public class NIAProxy
implements SubscriptionObserver,
SignalObserver {
    private static NIAProxy instance;
    private NIAMgr myNIAMgr = null;
    private SignalPort signalPort = PortManager.instance();
    private static OseProcess op;
    private static boolean initiated;
    private static final int MAX_NO_OF_RETRIES = 5;
    private static final String SERVICE_NAME = "IPOM_NIAJI_SERVICE_NAME";
    private static final Class NIA_CHANGE_IND;
    private static final Class NIA_CHANGE2_IND;
    private static final int PV_FIRST = 3;
    private static final int PV_SECOND = 2;
    private static final int PV_THIRD = 1;
    private static final int IPOM_NIAJI_OK = 0;
    private static final int IPOM_NIAJI_INVALID_PV = 1;
    private static final int TRACEGROUP = 5;
    private static final int RECEIVE_TIMEOUT = 15000;

    public synchronized void serviceAdded(String string) {
        MessageLog.trace((int)5, this.getClass(), (String)"serviceAdded: IPOM_NIAJI_SERVICE_NAME");
        if (op != null) {
            if (op.equals((Object)OseNameServer.lookup((String)SERVICE_NAME))) {
                this.sendIpomNiajiTerminateServiceReq();
            }
        }
        if (initiated = this.init()) {
            MessageLog.trace((int)5, this.getClass(), (String)"init() called successfully.");
        } else {
            MessageLog.trace((int)5, this.getClass(), (String)"init() returned false, retrying.");
            initiated = this.retryNegotiation();
            if (!initiated) {
                MessageLog.traceError(this.getClass(), (String)"Failed to intiate NIA service, Node IP Address indications will not be received. ORB will not be restarted if Node IP Address changes.");
            }
        }
    }

    public synchronized void serviceRemoved(String string) {
        block3: {
            block2: {
                MessageLog.trace((int)5, this.getClass(), (String)"serviceRemoved: IPOM_NIAJI_SERVICE_NAME");
                if (op == null) break block2;
                if (op.equals((Object)OseNameServer.lookup((String)SERVICE_NAME))) break block3;
            }
            op = null;
            initiated = false;
        }
    }

    public void signalReceived(InSignal inSignal) {
        MessageLog.trace((int)5, this.getClass(), (String)("signalReceived: " + inSignal.getClass()));
        if (inSignal.getClass().equals(NIA_CHANGE_IND)) {
            int n = ((IpomNiajiChangeInd)inSignal).getNodeIpAddress();
            String string = ((IpomNiajiChangeInd)inSignal).getNodeInterfaceName();
            if (this.myNIAMgr != null) {
                this.myNIAMgr.notifyIpAddressChanged(this.ipAddrInt2String(n), string);
            } else {
                MessageLog.info(this.getClass(), (String)"Failed to notify NIAMgr about IP address change notifications, no subscription has been made.");
            }
        } else if (inSignal.getClass().equals(NIA_CHANGE2_IND)) {
            if (this.myNIAMgr != null) {
                boolean bl = false;
                boolean bl2 = false;
                boolean bl3 = false;
                boolean bl4 = false;
                NIAAddressInfo[] nIAAddressInfoArray = new NIAAddressInfo[2];
                bl = ((IpomNiajiChange2Ind)inSignal).getAddrIsChangedIPv4() > 0;
                bl2 = ((IpomNiajiChange2Ind)inSignal).getAddrIsValidIPv4() > 0;
                bl3 = ((IpomNiajiChange2Ind)inSignal).getAddrIsChangedIPv6() > 0;
                bl4 = ((IpomNiajiChange2Ind)inSignal).getAddrIsValidIPv6() > 0;
                nIAAddressInfoArray[0] = new NIAAddressInfo(true, bl, bl2, ((IpomNiajiChange2Ind)inSignal).getNodeAddressIPv4(), ((IpomNiajiChange2Ind)inSignal).getNodeInterfaceNameIPv4());
                nIAAddressInfoArray[1] = new NIAAddressInfo(false, bl3, bl4, ((IpomNiajiChange2Ind)inSignal).getNodeAddressIPv6(), ((IpomNiajiChange2Ind)inSignal).getNodeInterfaceNameIPv6());
                this.myNIAMgr.notifyIpAddressChanged(nIAAddressInfoArray);
            } else {
                MessageLog.info(this.getClass(), (String)"Failed to notify NIAMgr about IP address change notifications, no subscription has been made.");
            }
        } else {
            MessageLog.info(this.getClass(), (String)("Received unknown signal: " + inSignal.getClass()));
        }
    }

    public void subscribe(NIAMgr nIAMgr) {
        this.myNIAMgr = nIAMgr;
    }

    private String ipAddrInt2String(int n) {
        long l = n < 0 ? 0x100000000L + (long)n : (long)n;
        String string = Long.toString(l >>> 24) + "." + Long.toString(l >>> 16 & 0xFFL) + "." + Long.toString(l >>> 8 & 0xFFL) + "." + Long.toString(l & 0xFFL);
        return string;
    }

    public static NIAProxy instance() {
        if (instance == null) {
            instance = new NIAProxy();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NIAAddressInfo[] getNIAAddressInfo() {
        if (!initiated) {
            boolean bl = Boolean.getBoolean("is.nia.published");
            int n = bl ? 10000 : 100;
            NIAProxy nIAProxy = this;
            synchronized (nIAProxy) {
                if (!initiated) {
                    try {
                        this.wait(n);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }
        if (initiated) {
            return this.sendIpomNiajiGetNodeIPAddressesInfoReq();
        }
        MessageLog.trace((int)5, this.getClass(), (String)"getNIAAddressInfo(): return value null. NIA service has not been initiated. Node address information will not be received.");
        return null;
    }

    private NIAProxy() {
        this.signalPort.addSignalObserver((SignalObserver)this, NIA_CHANGE_IND);
        this.signalPort.addSignalObserver((SignalObserver)this, NIA_CHANGE2_IND);
        OseNameServer.addSubscriptionObserver((String)SERVICE_NAME, (SubscriptionObserver)this);
    }

    private synchronized boolean init() {
        boolean bl = true;
        OseProcess oseProcess = null;
        oseProcess = OseNameServer.lookup((String)SERVICE_NAME);
        op = oseProcess;
        MessageLog.trace((int)5, this.getClass(), (String)("In init(), op = : " + op));
        if (oseProcess == null) {
            MessageLog.trace((int)5, this.getClass(), (String)"init(), op == null");
            bl = false;
        } else {
            bl = this.sendIpomNiajiInitiateServiceReq();
            if (bl) {
                this.sendIpomNiajiNotifySubscribeReq();
                this.notifyAll();
            }
        }
        return bl;
    }

    private synchronized boolean retryNegotiation() {
        boolean bl = this.init();
        for (int i = 0; !bl && i < 5; ++i) {
            try {
                Thread.sleep(5000L);
                bl = this.init();
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return bl;
    }

    protected boolean sendIpomNiajiInitiateServiceReq() {
        boolean bl = true;
        int n = 0;
        int n2 = 0;
        IpomNiajiInitiateServiceReq ipomNiajiInitiateServiceReq = new IpomNiajiInitiateServiceReq(3, 2, 1);
        Signal signal = SignalHelper.sendAndReceiveAttachedClean((OseProcess)op, (Signal)ipomNiajiInitiateServiceReq, (Class)IpomNiajiInitiateServiceCfm.class, (int)15000);
        if (signal != null) {
            if (signal instanceof IpomNiajiInitiateServiceCfm) {
                MessageLog.trace((int)5, this.getClass(), (String)(" sendIpomNiajiInitiateServiceReq() confirmed, pv = : " + ((IpomNiajiInitiateServiceCfm)signal).getPreferredPV()));
                n2 = ((IpomNiajiInitiateServiceCfm)signal).getPreferredPV();
                n = ((IpomNiajiInitiateServiceCfm)signal).getResult();
                if (n != 0) {
                    bl = false;
                    MessageLog.trace((int)5, this.getClass(), (String)(" sendIpomNiajiInitiateServiceReq(), received result = : " + ((IpomNiajiInitiateServiceCfm)signal).getResult() + " ,preferred PV = : " + n2));
                }
            } else if (signal instanceof AttachSignal) {
                bl = false;
                MessageLog.trace((int)5, this.getClass(), (String)" sendIpomNiajiInitiateServiceReq(), receiver process terminated: IPOM_NIAJI_SERVICE_NAME");
            } else {
                MessageLog.info(this.getClass(), (String)(" sendIpomNiajiInitiateServiceReq(), received rspSig:  " + signal.getClass()));
                bl = false;
            }
        } else {
            MessageLog.info(this.getClass(), (String)" sendIpomNiajiInitiateServiceReq(). No response signal, rspSig == null.");
            bl = false;
        }
        return bl;
    }

    protected void sendIpomNiajiTerminateServiceReq() {
        IpomNiajiTerminateServiceReq ipomNiajiTerminateServiceReq = new IpomNiajiTerminateServiceReq();
        Signal signal = SignalHelper.sendAndReceiveAttachedClean((OseProcess)op, (Signal)ipomNiajiTerminateServiceReq, (Class)IpomNiajiTerminateServiceCfm.class, (int)15000);
        if (signal != null) {
            if (signal instanceof IpomNiajiTerminateServiceCfm) {
                MessageLog.trace((int)5, this.getClass(), (String)" sendIpomNiajiTerminateServiceReq(), received IpomNiajiTerminateServiceCfm");
            } else {
                MessageLog.info(this.getClass(), (String)(" sendIpomNiajiTerminateServiceReq(), received rspSig:  " + signal.getClass()));
            }
        }
    }

    protected void sendIpomNiajiNotifySubscribeReq() {
        IpomNiajiNotifySubscribeReq ipomNiajiNotifySubscribeReq = new IpomNiajiNotifySubscribeReq();
        OseProcess oseProcess = this.signalPort.getOseProcess();
        SignalHelper.sendWithSender((OseProcess)op, (OseProcess)oseProcess, (Signal)ipomNiajiNotifySubscribeReq);
    }

    protected NIAAddressInfo[] sendIpomNiajiGetNodeIPAddressesInfoReq() {
        IpomNiajiGetNodeIpAddressesInfoReq ipomNiajiGetNodeIpAddressesInfoReq = new IpomNiajiGetNodeIpAddressesInfoReq();
        Signal signal = SignalHelper.sendAndReceiveAttachedClean((OseProcess)op, (Signal)ipomNiajiGetNodeIpAddressesInfoReq, (Class)IpomNiajiGetNodeIpAddressesInfoCfm.class, (int)15000);
        if (signal != null) {
            if (signal instanceof IpomNiajiGetNodeIpAddressesInfoCfm) {
                MessageLog.trace((int)5, this.getClass(), (String)" sendIpomNiajiGetNodeIPAddressesInfoReq(), received IpomNiajiGetNodeIpAddressesInfoCfm");
                boolean bl = false;
                boolean bl2 = false;
                NIAAddressInfo[] nIAAddressInfoArray = new NIAAddressInfo[2];
                bl = ((IpomNiajiGetNodeIpAddressesInfoCfm)signal).getAddrIsValidIPv4() > 0;
                bl2 = ((IpomNiajiGetNodeIpAddressesInfoCfm)signal).getAddrIsValidIPv6() > 0;
                nIAAddressInfoArray[0] = new NIAAddressInfo(true, false, bl, ((IpomNiajiGetNodeIpAddressesInfoCfm)signal).getNodeAddressIPv4(), ((IpomNiajiGetNodeIpAddressesInfoCfm)signal).getNodeInterfaceNameIPv4());
                nIAAddressInfoArray[1] = new NIAAddressInfo(false, false, bl2, ((IpomNiajiGetNodeIpAddressesInfoCfm)signal).getNodeAddressIPv6(), ((IpomNiajiGetNodeIpAddressesInfoCfm)signal).getNodeInterfaceNameIPv6());
                return nIAAddressInfoArray;
            }
            MessageLog.info(this.getClass(), (String)(" sendIpomNiajiGetNodeIPAddressesInfoReq(), received rspSig:  " + signal.getClass()));
            return null;
        }
        return null;
    }

    static {
        op = null;
        initiated = false;
        NIA_CHANGE_IND = IpomNiajiChangeInd.class;
        NIA_CHANGE2_IND = IpomNiajiChange2Ind.class;
    }
}

