/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.mimparser.model;

import java.util.Iterator;
import org.xml.sax.Attributes;
import se.ericsson.cello.mimparser.MomCorbaTypeAttribute;
import se.ericsson.cello.mimparser.MomEntity;
import se.ericsson.cello.mimparser.MomEnumMember;
import se.ericsson.cello.mimparser.MomEnumRef;
import se.ericsson.cello.mimparser.MomSequence;
import se.ericsson.cello.mimparser.model.MimModelImpl;
import se.ericsson.cello.mimparser.parser.MomParser;
import se.ericsson.cello.mimparser.state.DescriptionSettable;

public abstract class MomBase
implements MomEntity,
DescriptionSettable {
    private static final String LEFT_PAREN = "(";
    private static final String COMMA = ",";
    private static final String RIGHT_PAREN = ")";
    private String xmlType;
    protected String description;
    private String name;
    private String applicationTag;
    private MimModelImpl model;
    private int id;

    public MomBase(String xmlType, Attributes attributes, MimModelImpl model, int id) {
        this.xmlType = xmlType;
        this.name = attributes.getValue("name");
        this.model = model;
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        if (this.description == null && this.getModel().getContentLevel() == 2) {
            MomParser.reParseMomBase(this);
        }
        return this.description;
    }

    public String getDescriptionWithoutReparse() {
        return this.description;
    }

    public String getXmlType() {
        return this.xmlType;
    }

    public String getApplicationTag() {
        return this.applicationTag;
    }

    public void setApplicationTag(String anApplicationTag) {
        this.applicationTag = anApplicationTag;
    }

    public MimModelImpl getModel() {
        return this.model;
    }

    public int getId() {
        return this.id;
    }

    void setId(int id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    protected String appendDefaultValues(MomEntity momEntity) {
        Object value;
        StringBuffer buffer = new StringBuffer();
        if (momEntity instanceof MomSequence) {
            Iterator iter = ((MomSequence)momEntity).getDefaultValues();
            int nrOfDefaultValues = 0;
            if (iter.hasNext()) {
                buffer.append(LEFT_PAREN);
            }
            while (iter.hasNext()) {
                String object = (String)iter.next();
                buffer.append(object + COMMA);
                ++nrOfDefaultValues;
            }
            if (nrOfDefaultValues != 0) {
                buffer.deleteCharAt(buffer.length() - 1);
                buffer.append(RIGHT_PAREN);
            }
        }
        if (momEntity instanceof MomCorbaTypeAttribute && (value = ((MomCorbaTypeAttribute)momEntity).getDefault()) != null) {
            buffer.append(value);
        }
        if (momEntity instanceof MomEnumRef) {
            MomEnumRef enumRef = (MomEnumRef)momEntity;
            Integer value2 = enumRef.getDefault();
            Iterator values = ((MomEnumRef)momEntity).getEnum().getMembers();
            String name = null;
            while (values.hasNext()) {
                MomEnumMember enumMember = (MomEnumMember)values.next();
                if (!enumMember.getValue().equals(value2)) continue;
                name = enumMember.getName();
                break;
            }
            buffer.append(name);
        }
        return buffer.toString();
    }
}

