/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.mimparser.parser;

import java.io.File;
import java.io.FileReader;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import se.ericsson.cello.mimparser.MimModel;
import se.ericsson.cello.mimparser.model.MimModelImpl;
import se.ericsson.cello.mimparser.model.MomBase;
import se.ericsson.cello.mimparser.parser.ParseInfo;
import se.ericsson.cello.mimparser.state.InitialState;
import se.ericsson.cello.mimparser.statemachine.StateHandler;
import se.ericsson.cello.mimparser.statemachine.StateMachine;

public class MomParser {
    private MimModelImpl mimModel = null;
    private static final String JAR_FILE_INDICATOR = "jar:file:";
    private static final String JAR_HTTP_INDICATOR = "jar:http:";
    private static final String JAR_DTD_SUFFIX = "!/mp.dtd";
    private static XMLReader xmlReader = null;

    public MimModel parse(String momFile, int contentLevel, XMLReader xmlReader) {
        this.mimModel = new MimModelImpl(momFile, contentLevel);
        if (xmlReader != null) {
            this.mimModel.setXMLReader(xmlReader);
            MomParser.setXmlReader(xmlReader);
        }
        ParseInfo parseInfo = new ParseInfo(contentLevel, this.mimModel);
        return this.parse(momFile, parseInfo);
    }

    public static void setXmlReader(XMLReader xmlReader) {
        MomParser.xmlReader = xmlReader;
    }

    public static void reParseMomBase(MomBase mb) {
        MomParser mp = new MomParser();
        mp.reparse(mb, new HashMap(0));
    }

    public static void reParseMomBase(MomBase mb, Map momBases) {
        MomParser mp = new MomParser();
        mp.reparse(mb, momBases);
    }

    private void reparse(MomBase mb, Map momBases) {
        MimModelImpl originMimModel = mb.getModel();
        String momFile = originMimModel.getMomFile();
        XMLReader clientXmlReader = null;
        if (this.mimModel != null && this.mimModel.getXMLReader() != null) {
            clientXmlReader = this.mimModel.getXMLReader();
        }
        if (clientXmlReader == null) {
            clientXmlReader = xmlReader;
        }
        this.mimModel = new MimModelImpl(momFile, 2);
        if (clientXmlReader != null) {
            this.mimModel.setXMLReader(clientXmlReader);
        }
        ParseInfo parseInfo = new ParseInfo(2, this.mimModel, mb, momBases);
        this.parse(momFile, parseInfo);
    }

    private MimModel parse(String momFile, ParseInfo parseInfo) {
        this.readMomFile(momFile, parseInfo);
        if (!parseInfo.isReparse()) {
            this.resolveReferences();
            this.resolveRelationships();
        }
        return this.mimModel;
    }

    private void readMomFile(String momFile, ParseInfo parseInfo) {
        InputStream jarInputStream = null;
        StateHandler handler = new StateHandler(new StateMachine(new InitialState(this.mimModel), parseInfo));
        boolean isJarFile = this.checkIfJarFile(momFile);
        if (isJarFile) {
            jarInputStream = this.createXmlInputStream(momFile);
        }
        try {
            XMLReader clientSuppliedXMLReader = this.mimModel.getXMLReader();
            if (clientSuppliedXMLReader != null) {
                clientSuppliedXMLReader.setContentHandler(handler);
                InputSource is = null;
                if (isJarFile) {
                    is = new InputSource(jarInputStream);
                    this.setDtdStream(momFile, handler);
                } else {
                    is = new InputSource(new FileReader(new File(momFile)));
                }
                clientSuppliedXMLReader.parse(is);
            } else {
                SAXParserFactory factory = SAXParserFactory.newInstance();
                SAXParser saxParser = factory.newSAXParser();
                saxParser.getXMLReader().setErrorHandler(new ErrorHandler(){

                    public void error(SAXParseException exception) throws SAXException {
                        MomParser.this.mimModel.addToWarningList("ErrorHandler: " + exception.toString());
                    }

                    public void fatalError(SAXParseException exception) throws SAXException {
                        MomParser.this.mimModel.addToWarningList("ErrorHandler: " + exception.toString());
                    }

                    public void warning(SAXParseException exception) throws SAXException {
                        MomParser.this.mimModel.addToWarningList("ErrorHandler: " + exception.toString());
                    }
                });
                if (isJarFile) {
                    this.setDtdStream(momFile, handler);
                    saxParser.parse(jarInputStream, handler, "");
                } else {
                    saxParser.parse(new File(momFile), (DefaultHandler)handler);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e.toString());
        }
    }

    private void resolveReferences() {
        this.mimModel.resolveReferences();
    }

    private void resolveRelationships() {
        this.mimModel.resolveRelationships();
    }

    private boolean checkIfJarFile(String momFile) {
        String startOfName;
        boolean isJar = false;
        if (momFile.length() > JAR_FILE_INDICATOR.length() && ((startOfName = momFile.substring(0, JAR_FILE_INDICATOR.length())).equalsIgnoreCase(JAR_FILE_INDICATOR) || startOfName.equalsIgnoreCase(JAR_HTTP_INDICATOR))) {
            isJar = true;
        }
        return isJar;
    }

    private InputStream createXmlInputStream(String momFile) {
        InputStream stream = null;
        try {
            URL url = new URL(momFile);
            URLConnection urlConnection = url.openConnection();
            stream = urlConnection.getInputStream();
        }
        catch (Exception exc) {
            String errString = "MomParser.createXmlInputStream() Can not read jar-xml file. Filename=" + momFile + "  exception=" + exc.toString();
            throw new RuntimeException(errString);
        }
        return stream;
    }

    private InputStream createDtdInputStream(String dtdPath) {
        InputStream stream = null;
        try {
            URL url = new URL(dtdPath);
            URLConnection urlConnection = url.openConnection();
            stream = urlConnection.getInputStream();
        }
        catch (Exception exc) {
            String errString = "MomParser.createDtdInputStream() Can not read dtd file. dtdPath=" + dtdPath + "  exception=" + exc.toString();
            throw new RuntimeException(errString);
        }
        return stream;
    }

    private void setDtdStream(String momFile, StateHandler handler) {
        int nameSeparatorIndex = momFile.indexOf("!");
        if (nameSeparatorIndex == -1) {
            throw new RuntimeException("MomParser.setDtdStream() The jar-xml fileName=" + momFile + " does not contain a ! character");
        }
        String dtdPath = momFile.substring(0, nameSeparatorIndex);
        dtdPath = dtdPath + JAR_DTD_SUFFIX;
        InputStream dtdInputStream = this.createDtdInputStream(dtdPath);
        handler.setDtdStream(dtdInputStream);
    }
}

