/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.mimparser.state;

import org.xml.sax.Attributes;
import se.ericsson.cello.mimparser.MomClass;
import se.ericsson.cello.mimparser.model.DirectionalAssociationImpl;
import se.ericsson.cello.mimparser.model.DomainExtensionImpl;
import se.ericsson.cello.mimparser.model.MomAssociationEndImpl;
import se.ericsson.cello.mimparser.model.MomCardinalityImpl;
import se.ericsson.cello.mimparser.model.MomHasClassImpl;
import se.ericsson.cello.mimparser.model.MomRelationshipEndInfoImpl;
import se.ericsson.cello.mimparser.model.MomRelationshipImpl;
import se.ericsson.cello.mimparser.state.ApplicationTagState;
import se.ericsson.cello.mimparser.state.DeletionPolicySettable;
import se.ericsson.cello.mimparser.state.DeletionPolicyState;
import se.ericsson.cello.mimparser.state.DescriptionSettable;
import se.ericsson.cello.mimparser.state.DescriptionState;
import se.ericsson.cello.mimparser.state.DomainExtensionState;
import se.ericsson.cello.mimparser.state.HasClassState;
import se.ericsson.cello.mimparser.state.MaxMinSettable;
import se.ericsson.cello.mimparser.state.MaxState;
import se.ericsson.cello.mimparser.state.MinState;
import se.ericsson.cello.mimparser.state.MomBaseState;
import se.ericsson.cello.mimparser.statemachine.StateMachine;

class ToState
extends MomBaseState
implements MaxMinSettable,
DescriptionSettable,
DeletionPolicySettable {
    private MomRelationshipImpl momRelationship;
    private MomAssociationEndImpl associationEnd = null;
    private static String[] allPossibleToElements = new String[]{"associationEnd", "supported"};

    public ToState(MomRelationshipImpl moRelationship, DirectionalAssociationImpl associationImpl, StateMachine stateMachine, String returnTag, Attributes attributes) {
        super(returnTag);
        this.momRelationship = moRelationship;
        if (returnTag.equals("associationEnd")) {
            this.momRelationship.setToName(attributes.getValue("name"));
            this.associationEnd = new MomAssociationEndImpl(returnTag, attributes, stateMachine.getParseInfo().getMimModel(), stateMachine.getParseInfo().getNextId());
            associationImpl.addAssociationEndTo(this.associationEnd);
        }
    }

    public void startElement(StateMachine stateMachine, String name, Attributes attributes) {
        stateMachine.getParseInfo().getMimModel();
        if (name.equals("description")) {
            stateMachine.pushState(new DescriptionState(this));
        } else if (name.equals("applicationTag")) {
            stateMachine.pushState(new ApplicationTagState(this));
        } else if (name.equals("hasClass")) {
            MomClass momClass = stateMachine.getParseInfo().getMimModel().getClass(attributes.getValue("name"));
            MomHasClassImpl hasClass = new MomHasClassImpl(attributes, momClass);
            this.associationEnd.setHasClass(hasClass);
            stateMachine.pushState(new HasClassState(hasClass));
            this.momRelationship.setToElementName(attributes.getValue("name"));
        } else if (name.equals("min")) {
            stateMachine.pushState(new MinState(this));
        } else if (name.equals("max")) {
            stateMachine.pushState(new MaxState(this));
        } else if (name.equals("deletionPolicy")) {
            stateMachine.pushState(new DeletionPolicyState(this));
        } else if (name.equals("domainExtension")) {
            DomainExtensionImpl domainObject = new DomainExtensionImpl(name, attributes, stateMachine.getParseInfo().getMimModel(), stateMachine.getParseInfo().getNextId());
            this.associationEnd.setDomain(domainObject);
            stateMachine.pushState(new DomainExtensionState(domainObject));
        }
    }

    public void setDescription(String description) {
        MomRelationshipEndInfoImpl endInfo = this.getEndInfo();
        endInfo.setDescription(description);
    }

    public void setApplicationTag(String applicationTag) {
        MomRelationshipEndInfoImpl endInfo = this.getEndInfo();
        endInfo.setApplicationTag(applicationTag);
    }

    public void addMinValue(String minValue) {
        MomCardinalityImpl cardinality = this.getCardinality();
        cardinality.setMin(minValue);
    }

    public void addMaxValue(String maxValue) {
        MomCardinalityImpl cardinality = this.getCardinality();
        cardinality.setMax(maxValue);
    }

    private MomRelationshipEndInfoImpl getEndInfo() {
        MomRelationshipEndInfoImpl endInfo = (MomRelationshipEndInfoImpl)this.momRelationship.getToInfo();
        if (endInfo == null) {
            endInfo = new MomRelationshipEndInfoImpl();
            this.momRelationship.setToInfo(endInfo);
        }
        return endInfo;
    }

    private MomCardinalityImpl getCardinality() {
        MomCardinalityImpl cardinality = (MomCardinalityImpl)this.momRelationship.getToCardinality();
        if (cardinality == null) {
            cardinality = new MomCardinalityImpl(null);
            this.momRelationship.setToCardinality(cardinality);
        }
        return cardinality;
    }

    public static boolean isToElement(String elementName) {
        boolean isType = false;
        for (int i = 0; i < allPossibleToElements.length; ++i) {
            if (!elementName.equals(allPossibleToElements[i])) continue;
            isType = true;
            break;
        }
        return isType;
    }

    public void endElement(StateMachine stateMachine, String name) {
        if (name.equals(this.getReturnTag())) {
            if (this.momRelationship.getAssociationType().equals("biDirectionalAssociation")) {
                this.momRelationship.createNewRelationshipWithReversedDirection();
            }
            stateMachine.popState();
        }
    }

    public void setDeletionPolicy(String deletionPolicy) {
        this.associationEnd.setDeletionPolicy(deletionPolicy);
    }
}

