/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.swmanagement;

import java.util.Collection;
import java.util.Enumeration;
import java.util.LinkedList;
import se.ericsson.cello.equipment.MultipleSwAllocationsAllowed;
import se.ericsson.cello.equipment.SubrackMo;
import se.ericsson.cello.equipment.SwAllocationMarker;
import se.ericsson.cello.equipment.intma.SwAllocationAccess;
import se.ericsson.cello.managedelement.MoDataRecoveryHelper;
import se.ericsson.cello.managedelement.WebServerReserver;
import se.ericsson.cello.mao.MoAttributeValidator;
import se.ericsson.cello.mao.Reservable;
import se.ericsson.cello.mao.UpgradeTrace;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.IllegalArgumentTypeException;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.ManagedObjectBase;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.moframework.ReferenceAttribute;
import se.ericsson.cello.moframework.SequenceAttribute;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.moframework.TransactionRequiredException;
import se.ericsson.cello.property.PropertyChangeHandler;
import se.ericsson.cello.swmanagement.RepertoireMo;
import se.ericsson.cello.swmanagement.SlotConfigurationValidator;
import se.ericsson.cello.swmanagement.SwAllocationMo;
import se.ericsson.cello.swmanagement.suaccess.RepertoireMoSU_Access;
import se.ericsson.cello.swmanagement.suaccess.SwAllocationMoSU_Access;
import se.ericsson.cello.swmanagement.swmaccess.SwAllocationPropertiesExtended;
import se.ericsson.cello.swmanagement.swmaccess.SwAllocationPropertyChangeEvent;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.cello.transaction.Resource;
import se.ericsson.cello.util.library.Lib;

public class SwAllocationMoImpl
extends ManagedObjectBase
implements SwAllocationMo,
SwAllocationAccess,
SwAllocationMarker,
SwAllocationMoSU_Access,
WebServerReserver,
Resource {
    Coordinator myCoordinator = null;
    SwAllocationPropertyChangeEvent mySwAllocationPropertyChangeEvent = null;
    private MoData data;
    private StringAttribute userLabel;
    private StringAttribute role;
    private SequenceAttribute repertoireList;
    private SequenceAttribute slotList;
    static final String[] SUPPORTED_VERSIONS = new String[]{"SU_1", "SU_2", "SU_3"};
    private boolean myAddedRepertoire = false;
    private boolean myAddedSlot = false;
    private static final int MO_DATA_REVISION_3_1 = 3000;
    private static final int MO_DATA_REVISION_3_2 = 3020;
    private static final int MO_DATA_REVISION_LATEST = 3020;

    public static synchronized ManagedObject create(ManagedObject managedObject, AttrList attrList, String string, ManagedObject managedObject2, Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug((Class)SwAllocationMoImpl.class, (int)70, (String)"create( ManagedObject parent, AttrList attributes, String identity, ManagedObject source, Coordinator context )", (String)("parent: " + managedObject.getType() + "\n\tattributes: " + Lib.toString((AttrList)attrList) + "\n\tidentity: " + string + "\n\tsource: " + managedObject2 + "\n\tcontext: " + Lib.toString((Coordinator)coordinator)));
        MoAttributeValidator.checkTransaction((Coordinator)coordinator);
        MoAttributeValidator.checkIdentity((String)"SwAllocation", (String)string);
        MoAttributeValidator.checkParent((ManagedObject)managedObject, (String)"SwManagement");
        String string2 = MoAttributeValidator.checkAndGetStringAttributeWithLength((String)"userLabel", (AttrList)attrList, (boolean)false, (String)"", (String)"SwAllocation", (int)128, (int)0);
        String string3 = MoAttributeValidator.checkAndGetStringAttribute((String)"role", (AttrList)attrList, (boolean)true, (String)"", (String)"SwAllocation");
        SwAllocationMoImpl.checkOtherAttributes(attrList);
        return new SwAllocationMoImpl(managedObject, string, string2, string3, coordinator);
    }

    private SwAllocationMoImpl(ManagedObject managedObject, String string, String string2, String string3, Coordinator coordinator) throws MoAccessException {
        super(managedObject, "SwAllocation", string, coordinator);
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"SwAllocationMoImpl( ManagedObject parent, String identity, String checkedUserLabel, String checkedRole, Coordinator context )", (String)("parent: " + managedObject.getType() + "\n\tidentity: " + string + "\n\tuserL: " + string2 + "\n\trole: " + string3 + "\n\tcontext: " + Lib.toString((Coordinator)coordinator)));
        this.data = new MoData(this.getLocalDistinguishedName(), this.getType(), true, coordinator);
        this.userLabel = new StringAttribute("userLabel", true, string2);
        this.role = new StringAttribute("role", true, string3);
        this.repertoireList = new SequenceAttribute("repertoireList", true);
        this.slotList = new SequenceAttribute("slotList", true);
        this.data.registerPersistentAttr((Attribute)this.userLabel);
        this.data.registerPersistentAttr((Attribute)this.role);
        this.data.registerPersistentAttr((Attribute)this.repertoireList);
        this.data.registerPersistentAttr((Attribute)this.slotList);
        this.data.setRevision(3020);
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
    }

    public SwAllocationMoImpl(MoData moData) throws MoNameAlreadyTakenException {
        super(moData.getLocalDistinguishedName());
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"SwAllocationMoImpl(MoData recoveredData)", (String)("recoveredData: " + moData));
        this.data = moData;
        MoDataRecoveryHelper moDataRecoveryHelper = new MoDataRecoveryHelper(this.data, (ManagedObject)this);
        moDataRecoveryHelper.assertMoDataRevision(3020);
        moDataRecoveryHelper.assertAttribute("userLabel");
        moDataRecoveryHelper.assertAttribute("role");
        moDataRecoveryHelper.assertAttribute("repertoireList");
        moDataRecoveryHelper.assertAttribute("slotList");
        this.userLabel = (StringAttribute)moData.getAttribute("userLabel");
        this.role = (StringAttribute)moData.getAttribute("role");
        this.repertoireList = (SequenceAttribute)moData.getAttribute("repertoireList");
        this.slotList = (SequenceAttribute)moData.getAttribute("slotList");
    }

    public void delete(Coordinator coordinator) throws MoAccessException {
        Enumeration enumeration;
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"delete(Coordinator context)", (String)("context: " + Lib.toString((Coordinator)coordinator)));
        Enumeration enumeration2 = this.slotList.elements();
        while (enumeration2.hasMoreElements()) {
            enumeration = ((ReferenceAttribute)enumeration2.nextElement()).getValue(coordinator);
            ((Reservable)enumeration).release((ManagedObject)this, coordinator);
        }
        enumeration = this.repertoireList.elements();
        while (enumeration.hasMoreElements()) {
            ManagedObject managedObject = ((ReferenceAttribute)enumeration.nextElement()).getValue(coordinator);
            ((Reservable)managedObject).release((ManagedObject)this, coordinator);
        }
        super.delete(coordinator);
        this.data.delete(coordinator);
    }

    public String[] getSupportedVersions() {
        return SUPPORTED_VERSIONS;
    }

    public String getUserLabel(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getUserLabel(Coordinator c)", (String)("c: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.userLabel.getValue(coordinator);
    }

    public void setUserLabel(String string, Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"setUserLabel(String value, Coordinator c)", (String)("value: " + string + "\n\tc: " + Lib.toString((Coordinator)coordinator)));
        MoAttributeValidator.checkStringWithLength((String)string, (String)"userLabel", (String)"SwAllocation", (int)128, (int)0);
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        this.userLabel.setValue(string);
    }

    public String getRole(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getRole(Coordinator c)", (String)("c: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.role.getValue(coordinator);
    }

    public void setRole(String string, Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"setRole(String value, Coordinator c)", (String)("value: " + string + "\n\tc: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        this.role.setValue(string);
    }

    public ManagedObject[] getRepertoireList(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getRepertoireList(Coordinator c)", (String)("c: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        ManagedObject[] managedObjectArray = new ManagedObject[this.repertoireList.size()];
        Enumeration enumeration = this.repertoireList.elements();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            managedObjectArray[n++] = ((ReferenceAttribute)enumeration.nextElement()).getValue(coordinator);
        }
        return managedObjectArray;
    }

    private Collection getRepertoires(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getRepertoires(Coordinator aCoordinator)", (String)("aCoordinator: " + Lib.toString((Coordinator)coordinator)));
        ManagedObject[] managedObjectArray = this.getRepertoireList(coordinator);
        LinkedList<ManagedObject> linkedList = new LinkedList<ManagedObject>();
        if (managedObjectArray != null) {
            for (int i = 0; i < managedObjectArray.length; ++i) {
                linkedList.add(managedObjectArray[i]);
            }
        }
        UpgradeTrace.debug(this.getClass(), (int)71, (String)"getRepertoires(Coordinator aCoordinator)", (String)("RETURNS - theRepertoireMos: " + linkedList));
        return linkedList;
    }

    private Collection getSlots(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getSlots(Coordinator aCoordinator)");
        ManagedObject[] managedObjectArray = this.getSlotList(coordinator);
        LinkedList<ManagedObject> linkedList = new LinkedList<ManagedObject>();
        if (managedObjectArray != null) {
            for (int i = 0; i < managedObjectArray.length; ++i) {
                linkedList.add(managedObjectArray[i]);
            }
        }
        return linkedList;
    }

    public ManagedObject[] getSlotList(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getSlotList(Coordinator c)", (String)("c: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        ManagedObject[] managedObjectArray = new ManagedObject[this.slotList.size()];
        Enumeration enumeration = this.slotList.elements();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            managedObjectArray[n++] = ((ReferenceAttribute)enumeration.nextElement()).getValue(coordinator);
        }
        return managedObjectArray;
    }

    public String getSwAllocationId(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getSwAllocationId(Coordinator c)", (String)("c: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.getNamingAttributeValue();
    }

    public void actionAddRepertoire(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"actionAddRepertoire(ManagedObject aRepertoire, Coordinator c)", (String)("repertoire: " + managedObject + "\n\tc: " + Lib.toString((Coordinator)coordinator)));
        MoAttributeValidator.checkTransaction((Coordinator)coordinator);
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        if (managedObject == null || !managedObject.getType().equals("Repertoire")) {
            throw new IllegalArgumentTypeException((ManagedObject)this, "Repertoire");
        }
        if (!this.containsRepertoire(managedObject, coordinator)) {
            try {
                SlotConfigurationValidator.checkIfAddRepertoireAllowed((RepertoireMo)managedObject, this, coordinator);
                this.registerResource(coordinator);
                this.repertoireList.addElement((Attribute)new ReferenceAttribute("", false, managedObject));
                ((Reservable)managedObject).reserve((ManagedObject)this, coordinator);
                this.mySwAllocationPropertyChangeEvent.addAddedRepertoire((RepertoireMoSU_Access)managedObject);
                this.myAddedRepertoire = true;
            }
            catch (MoAccessException moAccessException) {
                UpgradeTrace.error(this.getClass(), (String)"actionAddRepertoire(ManagedObject aRepertoire, Coordinator c)", (String)("MoAccessException caught: " + (Object)((Object)moAccessException)), (Throwable)moAccessException);
                throw moAccessException;
            }
        }
    }

    public void actionAddRepertoires(ManagedObject[] managedObjectArray, Coordinator coordinator) throws MoAccessException {
        int n;
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"actionAddRepertoires(ManagedObject [] repertoires, Coordinator c)", (String)("repertoires: " + Lib.toString((ManagedObject[])managedObjectArray) + "\n\tc: " + Lib.toString((Coordinator)coordinator)));
        MoAttributeValidator.checkTransaction((Coordinator)coordinator);
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        for (n = 0; n < managedObjectArray.length; ++n) {
            if (managedObjectArray[n].getType().equals("Repertoire")) continue;
            throw new IllegalArgumentTypeException((ManagedObject)this, "Repertoire");
        }
        for (n = 0; n < managedObjectArray.length; ++n) {
            if (this.containsRepertoire(managedObjectArray[n], coordinator)) continue;
            SlotConfigurationValidator.checkIfAddRepertoireAllowed((RepertoireMo)managedObjectArray[n], this, coordinator);
            this.registerResource(coordinator);
            this.repertoireList.addElement((Attribute)new ReferenceAttribute("", false, managedObjectArray[n]));
            ((Reservable)managedObjectArray[n]).reserve((ManagedObject)this, coordinator);
            this.mySwAllocationPropertyChangeEvent.addAddedRepertoire((RepertoireMoSU_Access)managedObjectArray[n]);
            this.myAddedRepertoire = true;
        }
    }

    public void actionDeleteRepertoire(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"actionDeleteRepertoire(ManagedObject aRepertoire, Coordinator c)", (String)("repertoire: " + managedObject + "\n\tc: " + Lib.toString((Coordinator)coordinator)));
        MoAttributeValidator.checkTransaction((Coordinator)coordinator);
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        boolean bl = false;
        Enumeration enumeration = this.repertoireList.elements();
        while (enumeration.hasMoreElements()) {
            ReferenceAttribute referenceAttribute = (ReferenceAttribute)enumeration.nextElement();
            if (managedObject == null || !managedObject.equals(referenceAttribute.getValue(coordinator))) continue;
            this.registerResource(coordinator);
            this.repertoireList.removeElement((Attribute)referenceAttribute);
            ((Reservable)managedObject).release((ManagedObject)this, coordinator);
            this.mySwAllocationPropertyChangeEvent.addDeletedRepertoire((RepertoireMoSU_Access)managedObject);
            bl = true;
            break;
        }
        if (!bl) {
            throw new IllegalArgumentTypeException((ManagedObject)this, " Repertoire : " + managedObject + " not found");
        }
    }

    public void actionAddSlot(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"actionAddSlot(ManagedObject aSlot, Coordinator c)", (String)("slot: " + managedObject + "\n\tc: " + Lib.toString((Coordinator)coordinator)));
        MoAttributeValidator.checkTransaction((Coordinator)coordinator);
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        if (managedObject == null) {
            throw new IllegalArgumentTypeException((ManagedObject)this, " Slot: " + null + " not found");
        }
        if (managedObject instanceof SubrackMo) {
            throw new IllegalArgumentTypeException((ManagedObject)this, managedObject.toString());
        }
        if (!(managedObject instanceof Reservable)) {
            throw new IllegalArgumentTypeException((ManagedObject)this, managedObject.toString());
        }
        if (!this.containsSlot(managedObject, coordinator)) {
            if (managedObject instanceof MultipleSwAllocationsAllowed) {
                SlotConfigurationValidator.checkIfAddSlotAllowed((MultipleSwAllocationsAllowed)managedObject, this, coordinator);
            }
            this.registerResource(coordinator);
            this.slotList.addElement((Attribute)new ReferenceAttribute("", false, managedObject));
            ((Reservable)managedObject).reserve((ManagedObject)this, coordinator);
            this.mySwAllocationPropertyChangeEvent.addAddedSlot(managedObject);
            this.myAddedSlot = true;
        }
    }

    public void actionAddSlots(ManagedObject[] managedObjectArray, Coordinator coordinator) throws MoAccessException {
        int n;
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"actionAddSlots(ManagedObject [] slots, Coordinator c)", (String)("slots: " + Lib.toString((ManagedObject[])managedObjectArray) + "\n\tc: " + Lib.toString((Coordinator)coordinator)));
        MoAttributeValidator.checkTransaction((Coordinator)coordinator);
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        for (n = 0; n < managedObjectArray.length; ++n) {
            if (managedObjectArray[n] instanceof SubrackMo) {
                throw new IllegalArgumentTypeException((ManagedObject)this, managedObjectArray[n].toString());
            }
            if (managedObjectArray[n] instanceof Reservable) continue;
            throw new IllegalArgumentTypeException((ManagedObject)this, managedObjectArray[n].toString());
        }
        for (n = 0; n < managedObjectArray.length; ++n) {
            if (this.containsSlot(managedObjectArray[n], coordinator)) continue;
            if (managedObjectArray[n] instanceof MultipleSwAllocationsAllowed) {
                SlotConfigurationValidator.checkIfAddSlotAllowed((MultipleSwAllocationsAllowed)managedObjectArray[n], this, coordinator);
            }
            this.registerResource(coordinator);
            this.slotList.addElement((Attribute)new ReferenceAttribute("", false, managedObjectArray[n]));
            ((Reservable)managedObjectArray[n]).reserve((ManagedObject)this, coordinator);
            this.mySwAllocationPropertyChangeEvent.addAddedSlot(managedObjectArray[n]);
            this.myAddedSlot = true;
        }
    }

    public void actionDeleteSlot(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"actionDeleteSlot(ManagedObject aSlot, Coordinator c)", (String)("slot: " + managedObject + "\n\tc: " + Lib.toString((Coordinator)coordinator)));
        MoAttributeValidator.checkTransaction((Coordinator)coordinator);
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        boolean bl = false;
        ReferenceAttribute referenceAttribute = null;
        Enumeration enumeration = this.slotList.elements();
        while (enumeration.hasMoreElements()) {
            referenceAttribute = (ReferenceAttribute)enumeration.nextElement();
            if (managedObject == null || !managedObject.equals(referenceAttribute.getValue(coordinator))) continue;
            this.registerResource(coordinator);
            this.slotList.removeElement((Attribute)referenceAttribute);
            ((Reservable)managedObject).release((ManagedObject)this, coordinator);
            this.mySwAllocationPropertyChangeEvent.addDeletedSlot(managedObject);
            bl = true;
            break;
        }
        if (!bl) {
            throw new IllegalArgumentTypeException((ManagedObject)this, " Slot: " + managedObject + " not found");
        }
    }

    public void actionDeleteAllRepertoires(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"actionDeleteAllRepertoires(Coordinator c)", (String)("c: " + Lib.toString((Coordinator)coordinator)));
        MoAttributeValidator.checkTransaction((Coordinator)coordinator);
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        Enumeration enumeration = this.repertoireList.elements();
        while (enumeration.hasMoreElements()) {
            ManagedObject managedObject = ((ReferenceAttribute)enumeration.nextElement()).getValue(coordinator);
            this.registerResource(coordinator);
            ((Reservable)managedObject).release((ManagedObject)this, coordinator);
            this.mySwAllocationPropertyChangeEvent.addDeletedRepertoire((RepertoireMoSU_Access)managedObject);
        }
        this.repertoireList.setValue((Attribute[])new ReferenceAttribute[0]);
    }

    public void actionDeleteAllSlots(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"actionDeleteAllSlotss(Coordinator c)", (String)("c: " + Lib.toString((Coordinator)coordinator)));
        MoAttributeValidator.checkTransaction((Coordinator)coordinator);
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        Enumeration enumeration = this.slotList.elements();
        while (enumeration.hasMoreElements()) {
            ManagedObject managedObject = ((ReferenceAttribute)enumeration.nextElement()).getValue(coordinator);
            this.registerResource(coordinator);
            ((Reservable)managedObject).release((ManagedObject)this, coordinator);
            this.mySwAllocationPropertyChangeEvent.addDeletedSlot(managedObject);
        }
        this.slotList.setValue((Attribute[])new ReferenceAttribute[0]);
    }

    public String getType() {
        return "SwAllocation";
    }

    public boolean containsRepertoire(RepertoireMoSU_Access repertoireMoSU_Access, Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"containsRepertoire(RepertoireMoSU_Access aRepertoire, Coordinator c)", (String)("aRepertoire: " + repertoireMoSU_Access + "\n\tc: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        Enumeration enumeration = this.repertoireList.elements();
        while (enumeration.hasMoreElements()) {
            ReferenceAttribute referenceAttribute = (ReferenceAttribute)enumeration.nextElement();
            if (!repertoireMoSU_Access.equals(referenceAttribute.getValue(coordinator))) continue;
            return true;
        }
        return false;
    }

    public boolean containsRepertoire(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"containsRepertoire(ManagedObject aRepertoire, Coordinator c)", (String)("aRepertoire: " + managedObject + "\n\tc: " + Lib.toString((Coordinator)coordinator)));
        if (managedObject instanceof RepertoireMoSU_Access) {
            return this.containsRepertoire((RepertoireMoSU_Access)managedObject, coordinator);
        }
        return false;
    }

    boolean containsSlot(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"containsSlot(ManagedObject aSlot, Coordinator c)", (String)("slot: " + managedObject + "\n\tc: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        Enumeration enumeration = this.slotList.elements();
        while (enumeration.hasMoreElements()) {
            ReferenceAttribute referenceAttribute = (ReferenceAttribute)enumeration.nextElement();
            if (!managedObject.equals(referenceAttribute.getValue(coordinator))) continue;
            return true;
        }
        return false;
    }

    private static void checkOtherAttributes(AttrList attrList) throws NoSuchAttributeException {
        UpgradeTrace.debug((Class)SwAllocationMoImpl.class, (int)70, (String)"checkOtherAttributes( AttrList attributes )", (String)("attributes: " + Lib.toString((AttrList)attrList)));
        int n = attrList.size();
        if (n != 0) {
            throw new NoSuchAttributeException(attrList.getName(0), "SwAllocation");
        }
    }

    private boolean isRegistered(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"isRegistered(Coordinator aCoordinator)", (String)("aCoordinator: " + Lib.toString((Coordinator)coordinator)));
        boolean bl = false;
        if (this.myCoordinator != null && this.myCoordinator.isSameTransaction(coordinator)) {
            bl = true;
        }
        UpgradeTrace.debug(this.getClass(), (int)71, (String)"isRegistered(Coordinator aCoordinator)", (String)("RETURNS - " + bl));
        return bl;
    }

    private synchronized void registerResource(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"registerResource(Coordinator aCoordinator)", (String)("aCoordinator: " + Lib.toString((Coordinator)coordinator)));
        try {
            if (!this.isRegistered(coordinator)) {
                this.myCoordinator = coordinator;
                this.myCoordinator.registerResource((Resource)this);
                this.mySwAllocationPropertyChangeEvent = new SwAllocationPropertyChangeEvent(this, new SwAllocationPropertiesExtended(this.getSlots(null), this.isAddedSlot(), this.getRepertoires(null), this.isAddedRepertoire()), this);
            }
        }
        catch (InactiveTransactionException inactiveTransactionException) {
            UpgradeTrace.info(this.getClass(), (String)"registerResource(Coordinator aCoordinator)", (String)("InactiveTransactionException caught when trying to register a resource in a transaction.\n\taCoordinator: " + Lib.toString((Coordinator)coordinator) + "\n\tException data: " + (Object)((Object)inactiveTransactionException)));
            this.myCoordinator = null;
            throw new TransactionRequiredException();
        }
    }

    public boolean prepare() {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"prepare( )");
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"commit()");
        try {
            block4: {
                try {
                    if (this.mySwAllocationPropertyChangeEvent == null || this.myCoordinator == null) break block4;
                    this.mySwAllocationPropertyChangeEvent.setNewSwAllocationProperties(new SwAllocationPropertiesExtended(this.getSlots(null), this.isAddedSlot(), this.getRepertoires(null), this.isAddedRepertoire()));
                    PropertyChangeHandler.instance().firePropertyChange("SwAllocationConfigurationChange", null, (Object)this.mySwAllocationPropertyChangeEvent);
                    UpgradeTrace.debug(this.getClass(), (int)72, (String)"commit()", (String)("FIRED - mySwAllocationPropertyChangeEvent: " + this.mySwAllocationPropertyChangeEvent));
                }
                catch (Throwable throwable) {
                    UpgradeTrace.error(this.getClass(), (String)"commit()", (String)"Throwable caught (ignored i.e. the listener of event SwAllocationPropertyChangeEvent will not be sent)", (Throwable)throwable);
                    Object var3_2 = null;
                    this.mySwAllocationPropertyChangeEvent = null;
                    this.myCoordinator = null;
                    this.myAddedRepertoire = false;
                    this.myAddedSlot = false;
                }
            }
            Object var3_1 = null;
            this.mySwAllocationPropertyChangeEvent = null;
            this.myCoordinator = null;
            this.myAddedRepertoire = false;
            this.myAddedSlot = false;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.mySwAllocationPropertyChangeEvent = null;
            this.myCoordinator = null;
            this.myAddedRepertoire = false;
            this.myAddedSlot = false;
            throw throwable;
        }
    }

    public void rollback() {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"rollback( )");
        this.mySwAllocationPropertyChangeEvent = null;
        this.myCoordinator = null;
        this.myAddedRepertoire = false;
        this.myAddedSlot = false;
    }

    private boolean isAddedRepertoire() {
        return this.myAddedRepertoire;
    }

    private boolean isAddedSlot() {
        return this.myAddedSlot;
    }
}

