/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.gui;

import java.net.URL;
import java.util.StringTokenizer;
import javax.swing.JApplet;
import se.ericsson.cello.support.gui.guilib.comp.Log;

public class FindCodeBase {
    private JApplet applet = null;
    private String jarfiles = null;

    public FindCodeBase(JApplet applet, String jarfiles) {
        this.applet = applet;
        this.jarfiles = jarfiles;
    }

    public URL getCodeBase() {
        if (this.applet == null || this.jarfiles == null) {
            return null;
        }
        String custom_appl_archives_str = this.applet.getParameter("CUSTOM_APPL_ARCHIVES");
        URL emas_url = this.applet.getCodeBase();
        String protocol = emas_url.getProtocol();
        String host = emas_url.getHost();
        int emas_port = emas_url.getPort();
        String emas_file = emas_url.getFile();
        StringTokenizer str_to_pars = new StringTokenizer(custom_appl_archives_str, ",");
        boolean found_the_jar = false;
        String str = null;
        String newCodeBase = null;
        while (str_to_pars.hasMoreTokens() && !found_the_jar) {
            str = str_to_pars.nextToken();
            if (!str.endsWith(this.jarfiles)) continue;
            found_the_jar = true;
        }
        if (found_the_jar) {
            int index = str.lastIndexOf(this.jarfiles);
            newCodeBase = str.substring(0, index);
        }
        String new_file = this.parseCodeBase(emas_file, newCodeBase);
        URL the_url = null;
        try {
            the_url = new URL(protocol, host, emas_port, new_file);
        }
        catch (Exception e) {
            Log.logError("Error find code base for external application", e);
            return null;
        }
        return the_url;
    }

    private String parseCodeBase(String emas_code_base, String ext_code_base) {
        StringTokenizer st = new StringTokenizer(emas_code_base, "/");
        StringTokenizer dots = new StringTokenizer(ext_code_base, "..");
        int numberOfMoveupDir = dots.countTokens();
        int numberOfDirInOrg = st.countTokens();
        int toMoveUpDir = numberOfDirInOrg - numberOfMoveupDir;
        String newCodeBase = "";
        Object str = null;
        boolean stop = false;
        int numberOfDir = 0;
        while (!stop && st.hasMoreTokens()) {
            if (numberOfDir < toMoveUpDir) {
                newCodeBase = newCodeBase + "/" + st.nextToken();
                ++numberOfDir;
                continue;
            }
            stop = true;
        }
        int numberOfLoops = 0;
        StringTokenizer newExt = new StringTokenizer(ext_code_base, "/");
        while (newExt.hasMoreTokens()) {
            if (numberOfLoops >= numberOfMoveupDir) {
                newCodeBase = newCodeBase + "/" + newExt.nextToken();
            } else {
                newExt.nextToken();
            }
            ++numberOfLoops;
        }
        return newCodeBase;
    }
}

