/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Action;
import se.ericsson.cello.support.gui.IndexServiceQueryView;
import se.ericsson.cello.support.gui.LDNIndexService;
import se.ericsson.cello.support.gui.guilib.comp.Log;
import se.ericsson.cello.support.gui.guilib.infra.AbstractApplicationController;

public class IndexServiceQueryController
extends AbstractApplicationController
implements ActionListener {
    private IndexServiceQueryView viewer = null;

    protected void init() {
        this.getApplication().setTitle("EMAS_INDEX_SERVICE", null);
        this.viewer = (IndexServiceQueryView)this.getView();
        this.viewer.addActionListener(this);
    }

    public boolean canStop() {
        return true;
    }

    public void actionPerformed(ActionEvent event) {
        Log.log(7, "Action event" + event.toString());
        String cmd = event.getActionCommand();
        if (cmd == "btDone") {
            this.getApplication().stopApplication();
        } else if (cmd == "btSearch") {
            this.getApplication().setStatus("");
            this.performQuery();
        } else {
            this.getApplication().setStatus("");
        }
    }

    protected void performQuery() {
        if (null == this.viewer.getSearchString()) {
            return;
        }
        if (this.viewer.getSearchString().trim().length() < 1) {
            this.viewer.setSearchResultActions(new Action[0]);
            return;
        }
        Action[] searchResult = null;
        LDNIndexService indexService = LDNIndexService.getInstance();
        Log.trace("search for " + this.viewer.getSearchString() + "\n matching " + this.viewer.getSearchType());
        searchResult = indexService.getHyperlinks(this.viewer.getSearchString(), this.viewer.getSearchType(), null, null);
        this.viewer.setSearchResultActions(searchResult);
    }
}

