/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JTextField;
import se.ericsson.cello.support.gui.gengui.GenButton;
import se.ericsson.cello.support.gui.gengui.GenGui;
import se.ericsson.cello.support.gui.gengui.GenLabel;
import se.ericsson.cello.support.gui.gengui.GenList;
import se.ericsson.cello.support.gui.gengui.GenTranslatableStringComboBox;
import se.ericsson.cello.support.gui.gengui.GuiConstants;
import se.ericsson.cello.support.gui.guilib.comp.Log;
import se.ericsson.cello.support.gui.guilib.infra.AbstractApplicationView;

public class IndexServiceQueryView
extends AbstractApplicationView
implements ActionListener {
    protected GenGui genGui;
    protected JTextField inputField;
    protected GenTranslatableStringComboBox matchCriterium;
    protected GenButton btnSearch;
    protected GenButton btnDone;
    protected GenList searchResultGenList;
    protected GenButton btnHelp;
    private GenButton btnGoTo;
    private GenButton btnCopyLDN;
    protected JList searchResult;
    protected ActionListModel searchResultModel;
    static final String[] availableMatchCriteria = new String[]{"INDEX_SERVICE_EQUALS", "INDEX_SERVICE_STARTSWITH", "INDEX_SERVICE_ENDSWITH", "INDEX_SERVICE_CONTAINS"};
    static final int[] ldnMatchType = new int[]{4, 1, 2, 3};
    static final String ACT_DONE = "btDone";
    static final String ACT_SEARCH = "btSearch";
    static final String ACT_RESULT_SELECTED = "hyperlink selected";
    static final String ACT_HELP = "help";
    static final String ACT_GOTO = "btGoTo";
    static final String ACT_COPY_LDN = "btCopyLdn";

    public Dimension getPreferredSize() {
        return new Dimension(580, 450);
    }

    public void actionPerformed(ActionEvent event) {
        int index;
        Log.log(7, "Action event" + event.toString());
        this.getApplication().setStatus("");
        String cmd = event.getActionCommand();
        if (cmd == ACT_GOTO) {
            int index2 = this.searchResult.getSelectedIndex();
            if (index2 >= 0) {
                this.searchResultModel.executeActionAt(index2, null);
            }
        } else if (cmd.equals(ACT_COPY_LDN) && (index = this.searchResult.getSelectedIndex()) >= 0) {
            String ldnString = this.searchResultModel.getLDN(index);
            JTextField tf = new JTextField(ldnString);
            tf.selectAll();
            tf.copy();
        }
    }

    public JMenu[] getMenus() {
        return null;
    }

    public JComponent[] getToolBarComponents() {
        return null;
    }

    protected void init() {
        this.setLayout(new BoxLayout(this, 1));
        this.genGui = new GenGui();
        if (this.genGui == null) {
            Log.logError("Creation of GenGui for IndexServiceQueryView failed.");
            return;
        }
        GenLabel expl1 = new GenLabel("SEARCH_EXPL_1");
        GenLabel expl2 = new GenLabel("SEARCH_EXPL_2");
        GenLabel listheader = new GenLabel("INDEX_SERVICE_RESULT");
        this.matchCriterium = new GenTranslatableStringComboBox("", availableMatchCriteria);
        this.searchResultGenList = new GenList("", new String[0]);
        this.searchResultGenList.setUnderneath(true);
        this.searchResultGenList.setBackground(Color.white);
        this.searchResult = (JList)this.searchResultGenList.getFieldComponent();
        this.searchResult.setBackground(Color.white);
        this.searchResultModel = new ActionListModel();
        this.searchResult.setModel(this.searchResultModel);
        this.searchResult.setSelectionMode(0);
        this.searchResult.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseMoved(MouseEvent e) {
                int index = IndexServiceQueryView.this.searchResult.locationToIndex(e.getPoint());
                if (index > -1) {
                    String l = IndexServiceQueryView.this.searchResultModel.getLDN(index);
                    IndexServiceQueryView.this.getApplication().setStatus(l);
                } else {
                    IndexServiceQueryView.this.getApplication().setStatus("");
                }
                e.consume();
            }
        });
        this.genGui.add(this.searchResultGenList);
        this.searchResultGenList.getParent().setBackground(Color.white);
        this.btnSearch = this.genGui.addButton("INDEX_SERVICE_SEARCH_BTN");
        this.btnGoTo = this.genGui.addButton("INDEX_SERVICE_GOTO");
        this.btnGoTo.setToolTipText("INDEX_SERVICE_GOTO_TT");
        this.btnGoTo.setActionListener(this, ACT_GOTO);
        this.btnCopyLDN = this.genGui.addButton("INDEX_SERVICE_COPY_LDN");
        JButton dummyB = new JButton("Copy LDN");
        Dimension dummydim = dummyB.getPreferredSize();
        int w = dummydim.width > 100 ? dummydim.width : 100;
        this.btnCopyLDN.setPreferredSize(new Dimension(w, GuiConstants.HEIGHT_BUTTON));
        this.btnCopyLDN.setToolTipText("INDEX_SERVICE_COPY_LDN_TT");
        this.btnCopyLDN.setActionListener(this, ACT_COPY_LDN);
        this.btnDone = this.genGui.addButton("GSL_CLOSE");
        this.genGui.setEscButton(this.btnDone);
        this.btnHelp = this.genGui.addButton("HELP_BTN");
        this.putClientProperty("HELP_KEY", "GSL_SEARCH_BUTTON_HELP");
        this.btnHelp.putClientProperty("HELP_KEY", "GSL_SEARCH_BUTTON_HELP");
        this.btnHelp.putClientProperty("HELP_ENABLE", "");
        float f = 0.0f;
        this.matchCriterium.setAlignmentX(f);
        expl1.setAlignmentX(f);
        expl2.setAlignmentX(f);
        JPanel fill1 = new JPanel();
        Dimension d = new Dimension(25, 25);
        fill1.setMinimumSize(d);
        fill1.setMaximumSize(d);
        fill1.setPreferredSize(d);
        fill1.setAlignmentX(f);
        JPanel searchFieldP = new JPanel(new FlowLayout(0));
        searchFieldP.setAlignmentX(f);
        searchFieldP.add(new GenLabel("INDEX_SERVICE_SEARCH"));
        this.inputField = new JTextField(30);
        this.inputField.setBackground(Color.white);
        searchFieldP.add(this.matchCriterium);
        searchFieldP.add(this.inputField);
        this.add(searchFieldP);
        this.add(expl1);
        this.add(expl2);
        this.add(fill1);
        this.add(listheader);
        this.genGui.setAlignmentX(f);
        this.add(this.genGui);
        this.genGui.start();
        Log.log(7, "buildGUI OK");
    }

    void addActionListener(ActionListener listener) {
        this.btnSearch.setActionListener(listener, ACT_SEARCH);
        this.btnDone.setActionListener(listener, ACT_DONE);
        this.btnHelp.setActionListener(listener, ACT_HELP);
    }

    public String getSearchString() {
        return this.inputField.getText();
    }

    public int getSearchType() {
        int selected = this.matchCriterium.getSelectedIndex();
        return ldnMatchType[selected];
    }

    public void setSearchResultActions(Action[] actions) {
        this.searchResultModel.clear();
        for (int i = 0; i < actions.length; ++i) {
            this.searchResultModel.addElement(actions[i]);
        }
    }

    protected static class ActionListModel
    extends DefaultListModel {
        protected ActionListModel() {
        }

        public Object getElementAt(int index) {
            AbstractAction a = (AbstractAction)super.getElementAt(index);
            return a.getValue("Name");
        }

        public String getLDN(int index) {
            AbstractAction a = (AbstractAction)super.getElementAt(index);
            return (String)a.getValue("LDN");
        }

        public void executeActionAt(int index, ActionEvent e) {
            AbstractAction a = (AbstractAction)super.getElementAt(index);
            a.actionPerformed(e);
        }
    }
}

