/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.gui;

import java.util.Enumeration;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import se.ericsson.cello.support.gui.SplashWindow;
import se.ericsson.cello.support.gui.guilib.comp.Log;
import se.ericsson.cello.support.gui.guilib.infra.AbstractApplet;
import se.ericsson.cello.support.gui.guilib.infra.EmasSystemProperties;
import se.ericsson.cello.support.gui.guilib.infra.GuilibResourceBundle;

public class MainWindowApplet
extends AbstractApplet {
    public static final String SPLASH_BUNDLE_KEY = "gsl.splash.bundle.name";
    public static final String SPLASH_BUNDLE_DEFAULT = "se.ericsson.cello.support.gui.resources.language.SplashWindowBundle";
    public static final String INSTALL_PARAM_FILE_KEY = "gsl.installationparameters.file";
    public static final String INSTALL_PARAM_FILE_DEFAULT = "InstallationParameters";
    private ResourceBundle bundle;
    private String initFramework = "";
    private String initSecurity = "";
    private Properties prop = null;
    private static AbstractApplet myRef = null;
    private SplashWindow splash = null;

    public String getApplicationClassName() {
        SplashWindow splash = SplashWindow.getInstance();
        splash.setStatusBar(this.initFramework);
        return "se.ericsson.cello.support.gui.MainWindowApplication";
    }

    public String getSplashWindowBundleName() {
        String bundleName = null;
        bundleName = this.prop.getProperty(SPLASH_BUNDLE_KEY, SPLASH_BUNDLE_DEFAULT);
        if (bundleName == null || bundleName.equals("")) {
            bundleName = SPLASH_BUNDLE_DEFAULT;
        }
        return bundleName;
    }

    public ResourceBundle getResourceBundle() {
        String bundleName = this.getSplashWindowBundleName();
        return GuilibResourceBundle.getBundle(bundleName, this.getClass().getClassLoader());
    }

    void loadBundle(String bundleName, Locale locale, Properties env) {
        Log.logNotify("loadBundle: " + bundleName + " " + locale);
        Log.assertion(!bundleName.equals(""), "Not allowed to specify empty string as bundle name");
        Log.measure("loadBundle", true, "Loading bundle");
        try {
            ResourceBundle bundle = GuilibResourceBundle.getBundle(bundleName, this.getClass().getClassLoader());
            Enumeration<String> enume = bundle.getKeys();
            while (enume.hasMoreElements()) {
                String key = enume.nextElement();
                env.put(key, bundle.getObject(key));
                String value = (String)env.get(key);
            }
        }
        catch (Throwable t) {
            String msg = "Could not create ResourceBundle: " + bundleName;
            Log.logNotify(msg);
            Log.assertion(false, msg);
        }
        Log.measure("loadBundle", false);
    }

    public MainWindowApplet() {
        myRef = this;
        this.splash = SplashWindow.getInstance();
        new SplashThread().start();
    }

    public void startSplash() {
        String revision;
        this.prop = new Properties();
        String instPropFile = EmasSystemProperties.getProperty(INSTALL_PARAM_FILE_KEY, INSTALL_PARAM_FILE_DEFAULT);
        if (instPropFile == null || instPropFile.equals("")) {
            instPropFile = INSTALL_PARAM_FILE_DEFAULT;
        }
        this.loadBundle(instPropFile, null, this.prop);
        Log.setMeasurementInfoOn(Boolean.getBoolean("gsl.measurementinfoon"));
        Log.measure("securityandframework", true, "Loading security and framework");
        Log.logNotify("MainWindowApplet() : instantiating SplashWindow");
        try {
            this.bundle = this.getResourceBundle();
        }
        catch (MissingResourceException e) {
            Log.logError("Missing splashWindow resource : " + e.getKey());
        }
        SplashWindow.setProperties(this.prop);
        SplashWindow.setBundle(this.bundle);
        this.splash.setProductName(this.bundle.getString("productname"));
        String prodNo = MainWindowApplet.getApplet().getParameter("CUSTOM_APPL_PROD_NO");
        if (prodNo == null) {
            prodNo = "Missing Product Number";
        }
        if ((revision = MainWindowApplet.getApplet().getParameter("CUSTOM_APPL_REV")) == null) {
            revision = "Missing revision";
        }
        String releaseVersion = prodNo + " " + revision;
        this.splash.setVersion(releaseVersion);
        this.splash.setLicenseTo(this.bundle.getString("licenseto"));
        this.splash.setLicenseName(this.bundle.getString("licensename"));
        this.splash.setLicenseCompany(this.bundle.getString("licensecompany"));
        this.splash.setLicenseNumber(this.bundle.getString("licensenumber"));
        this.splash.setCopyrightLabel(this.bundle.getString("copyrightlabel"));
        this.initFramework = this.bundle.getString("status.initframework");
        this.initSecurity = this.bundle.getString("status.initsecurity");
        this.splash.displaySplash();
        this.splash.setProductImage(this.bundle.getString("product_GIF"));
        this.splash.setLogoImage(this.bundle.getString("logo_GIF"));
        this.splash.setProgressBarImage(this.bundle.getString("progressBar_GIF"));
        this.splash.setStatusBar(this.initSecurity);
        this.splash.hideOptionsButton();
        this.splash.enableOptionsButton();
    }

    protected static AbstractApplet getReference() {
        if (myRef == null) {
            myRef = new MainWindowApplet();
        }
        return myRef;
    }

    private class SplashThread
    extends Thread {
        public void run() {
            while (AbstractApplet.getApplet() == null || !EmasSystemProperties.isInitialized()) {
                try {
                    SplashThread.sleep(1L);
                }
                catch (InterruptedException interruptedException) {}
            }
            MainWindowApplet.this.startSplash();
        }
    }
}

