/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.gui;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.Vector;
import se.ericsson.cello.support.gui.ElementType;
import se.ericsson.cello.support.gui.MenuModel;
import se.ericsson.cello.support.gui.TaskMenuEntry;
import se.ericsson.cello.support.gui.guilib.comp.Log;
import se.ericsson.cello.support.gui.guilib.infra.EmasSystemProperties;

class MenuController {
    public MenuModel model;
    private TaskMenuEntry[] taskMenu = null;
    private HashMap taskMap = null;
    private Vector menuEntries = null;
    private static final char LINK = 'l';
    private static final char FOLDER = 'f';
    private static final String DEFAULT_TARGET_FILE_PATH_NAME = "/se/ericsson/cello/support/gui/resources/TaskConfigurationFile.txt";
    private static final String TARGET_FILE_PATH_NAME = "emas.mainwindow.mainmenu.filename";

    MenuController(MenuModel model) {
        Log.trace("MenuController()");
        this.model = model;
        this.taskMap = new HashMap();
    }

    void destroy() {
        Log.trace("destroy()");
        this.menuEntries = null;
        this.taskMenu = null;
    }

    public void start() {
        Log.trace("start()");
        try {
            BufferedReader dataInputStream = new BufferedReader(new InputStreamReader(MenuController.class.getResourceAsStream(EmasSystemProperties.getProperty(TARGET_FILE_PATH_NAME, DEFAULT_TARGET_FILE_PATH_NAME))));
            String linewithMenuEntry = dataInputStream.readLine();
            this.menuEntries = new Vector();
            while (linewithMenuEntry != null) {
                this.FillVector(linewithMenuEntry);
                linewithMenuEntry = dataInputStream.readLine();
            }
            dataInputStream.close();
            this.model.updateMenu(this.getMenu());
        }
        catch (IOException ofe) {
            Log.logError("start()", ofe);
        }
    }

    public void updateMenu(TaskMenuEntry[] menu) {
        Log.trace("updateMenu(" + menu + " )");
        this.model.updateMenu(menu);
    }

    public TaskMenuEntry[] getMenu() {
        Object[] taskMenuEntries = new TaskMenuEntry[this.menuEntries.size()];
        try {
            this.menuEntries.copyInto(taskMenuEntries);
            return taskMenuEntries;
        }
        catch (Exception e) {
            Log.logError("Exception getMenu", e);
            return null;
        }
    }

    public TaskMenuEntry getTaskEntry(String tag) {
        return (TaskMenuEntry)this.taskMap.get(tag);
    }

    private void FillVector(String line) {
        StringTokenizer tokens = new StringTokenizer(line, " ;");
        boolean fillVector = true;
        TaskMenuEntry taskMenuEntry = new TaskMenuEntry();
        if (tokens.countTokens() < 6) {
            fillVector = false;
        } else {
            taskMenuEntry.tag = tokens.nextToken();
            taskMenuEntry.translations = tokens.nextToken();
            try {
                taskMenuEntry.indentLevel = Short.parseShort(tokens.nextToken());
            }
            catch (NumberFormatException nfe) {
                fillVector = false;
            }
            String type = tokens.nextToken();
            type = type.trim();
            switch (type.charAt(0)) {
                case 'l': {
                    taskMenuEntry.type = ElementType.LINK;
                    break;
                }
                case 'f': {
                    taskMenuEntry.type = ElementType.FOLDER;
                    break;
                }
                default: {
                    fillVector = false;
                }
            }
            taskMenuEntry.initialVisible = Boolean.valueOf(tokens.nextToken());
            taskMenuEntry.link = tokens.nextToken();
            if (tokens.hasMoreTokens()) {
                try {
                    taskMenuEntry.nonguilib = Boolean.valueOf(tokens.nextToken());
                }
                catch (Exception x) {
                    x.printStackTrace();
                    fillVector = false;
                }
            } else {
                taskMenuEntry.nonguilib = false;
            }
            taskMenuEntry.method_id = tokens.hasMoreTokens() ? tokens.nextToken() : null;
            taskMenuEntry.codebase_jarfile = tokens.hasMoreTokens() ? tokens.nextToken() : null;
            taskMenuEntry.parameterClass = tokens.hasMoreTokens() ? tokens.nextToken() : null;
        }
        if (fillVector) {
            this.menuEntries.addElement(taskMenuEntry);
            if (taskMenuEntry.tag != null) {
                this.taskMap.put(taskMenuEntry.tag, taskMenuEntry);
            }
        } else {
            taskMenuEntry = null;
            Log.trace("FillVector() -line cannot be parsed : " + line);
        }
    }
}

