/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.AbstractAction;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JPanel;
import se.ericsson.cello.support.gui.gengui.GenButton;
import se.ericsson.cello.support.gui.gengui.GenGui;
import se.ericsson.cello.support.gui.gengui.GenLabel;
import se.ericsson.cello.support.gui.gengui.GenList;
import se.ericsson.cello.support.gui.gengui.GuiConstants;
import se.ericsson.cello.support.gui.guilib.comp.Log;
import se.ericsson.cello.support.gui.guilib.infra.AbstractApplicationView;

public class ReservedByServiceView
extends AbstractApplicationView {
    protected GenGui genGui;
    protected GenButton btnDone;
    protected GenButton btnGoTo;
    protected GenButton btnCopyLDN;
    protected GenList reserversGenList;
    protected JList searchResult;
    protected ActionListModel searchResultModel;
    static final String ACT_DONE = "btDone";
    static final String ACT_GOTO = "btGoTo";
    static final String ACT_COPY_LDN = "btCopyLdn";

    public Dimension getPreferredSize() {
        return new Dimension(580, 450);
    }

    public JMenu[] getMenus() {
        return null;
    }

    public JComponent[] getToolBarComponents() {
        return null;
    }

    protected void init() {
        this.setLayout(new BoxLayout(this, 1));
        this.genGui = new GenGui();
        if (this.genGui == null) {
            Log.logError("Creation of GenGui for ReservedByServiceView failed.");
            return;
        }
        GenLabel expl1 = new GenLabel("RESERVEDBY_EXPL_1");
        GenLabel expl2 = new GenLabel("RESERVEDBY_EXPL_2");
        GenLabel listheader = new GenLabel("RESERVEDBY_SERVICE_RESULT");
        this.reserversGenList = new GenList("", new String[0]);
        this.reserversGenList.setUnderneath(true);
        this.reserversGenList.setBackground(Color.white);
        this.searchResult = (JList)this.reserversGenList.getFieldComponent();
        this.searchResult.setBackground(Color.white);
        this.searchResultModel = new ActionListModel();
        this.searchResult.setModel(this.searchResultModel);
        this.searchResult.setSelectionMode(0);
        this.searchResult.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseMoved(MouseEvent e) {
                int index = ReservedByServiceView.this.searchResult.locationToIndex(e.getPoint());
                if (index > -1) {
                    String l = ReservedByServiceView.this.searchResultModel.getLDN(index);
                    ReservedByServiceView.this.getApplication().setStatus(l);
                } else {
                    ReservedByServiceView.this.getApplication().setStatus("");
                }
                e.consume();
            }
        });
        this.genGui.add(this.reserversGenList);
        this.reserversGenList.getParent().setBackground(Color.white);
        this.btnGoTo = this.genGui.addButton("RESERVEDBY_SERVICE_GOTO");
        this.btnGoTo.setToolTipText("RESERVEDBY_SERVICE_GOTO_TT");
        this.btnCopyLDN = this.genGui.addButton("RESERVEDBY_SERVICE_COPY_LDN");
        this.btnCopyLDN.setToolTipText("RESERVEDBY_SERVICE_COPY_LDN_TT");
        JButton dummyB = new JButton("Copy LDN");
        Dimension dummydim = dummyB.getPreferredSize();
        int w = dummydim.width > 100 ? dummydim.width : 100;
        this.btnCopyLDN.setPreferredSize(new Dimension(w, GuiConstants.HEIGHT_BUTTON));
        this.btnDone = this.genGui.addButton("GSL_CLOSE");
        this.genGui.setEscButton(this.btnDone);
        float f = 0.0f;
        expl1.setAlignmentX(f);
        expl2.setAlignmentX(f);
        JPanel fill1 = new JPanel();
        Dimension d = new Dimension(25, 25);
        fill1.setMinimumSize(d);
        fill1.setMaximumSize(d);
        fill1.setPreferredSize(d);
        fill1.setAlignmentX(f);
        this.add(expl1);
        this.add(expl2);
        this.add(fill1);
        this.add(listheader);
        this.genGui.setAlignmentX(f);
        this.add(this.genGui);
        this.genGui.start();
        Log.log(7, "buildGUI OK");
    }

    protected static class ActionListModel
    extends DefaultListModel {
        protected ActionListModel() {
        }

        public Object getElementAt(int index) {
            AbstractAction a = (AbstractAction)super.getElementAt(index);
            return a.getValue("Name");
        }

        public String getLDN(int index) {
            AbstractAction a = (AbstractAction)super.getElementAt(index);
            return (String)a.getValue("LDN");
        }

        public void executeActionAt(int index, ActionEvent e) {
            AbstractAction a = (AbstractAction)super.getElementAt(index);
            a.actionPerformed(e);
        }
    }
}

