/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.gui;

import java.awt.Dimension;
import java.text.MessageFormat;
import java.util.Properties;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import se.ericsson.cello.support.gui.AbstractViewElement;
import se.ericsson.cello.support.gui.EmasGuilibMediator;
import se.ericsson.cello.support.gui.MainWindowController;
import se.ericsson.cello.support.gui.PropertiesHelper;
import se.ericsson.cello.support.gui.guilib.comp.IconHelper;
import se.ericsson.cello.support.gui.guilib.comp.Log;

public abstract class ViewElementCreator {
    protected Vector subtrees = new Vector();
    protected String creatorId;

    public ViewElementCreator() {
        this.creatorId = "";
    }

    public ViewElementCreator(String aCreatorId) {
        this.creatorId = aCreatorId;
    }

    public ViewElementCreator findCreator(String creatorIdToFind) {
        if (this.creatorId.equals(creatorIdToFind)) {
            return this;
        }
        for (int i = 0; i < this.subtrees.size(); ++i) {
            ViewElementCreator subtree = (ViewElementCreator)this.subtrees.elementAt(i);
            ViewElementCreator foundCreator = subtree.findCreator(creatorIdToFind);
            if (foundCreator == null) continue;
            return foundCreator;
        }
        return null;
    }

    public abstract AbstractViewElement[] createInstances(AbstractViewElement var1);

    public void add(ViewElementCreator subtree) {
        this.subtrees.add(subtree);
    }

    public void remove(ViewElementCreator subtree) {
        this.subtrees.remove(subtree);
    }

    public AbstractViewElement[] expand(AbstractViewElement elt) {
        Vector children = new Vector();
        AbstractViewElement[][] tempChildrenList = new AbstractViewElement[this.subtrees.size()][];
        int totalLength = 0;
        for (int i = 0; i < this.subtrees.size(); ++i) {
            tempChildrenList[i] = ((ViewElementCreator)this.subtrees.elementAt(i)).createInstances(elt);
            totalLength += tempChildrenList[i].length;
        }
        AbstractViewElement[] childReturnArray = new AbstractViewElement[totalLength];
        int counter = 0;
        for (int i = 0; i < tempChildrenList.length; ++i) {
            for (int j = 0; j < tempChildrenList[i].length; ++j) {
                childReturnArray[counter++] = tempChildrenList[i][j];
            }
        }
        return childReturnArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Log.logNotify("dispose");
        Vector vector = this.subtrees;
        synchronized (vector) {
            for (int i = 0; i < this.subtrees.size(); ++i) {
                ((ViewElementCreator)this.subtrees.elementAt(i)).dispose();
            }
        }
        this.subtrees.clear();
    }

    protected Object showConfirmDialog(String msgKey, Object[] msgArgs, String titleKey, Object[] titleArgs, int msgType, String iconName) {
        String msg = null;
        String title = null;
        String presentViewBundle = null;
        Properties properties = null;
        MainWindowController refMainWindowController = EmasGuilibMediator.getReference().getMainWindowReference();
        presentViewBundle = refMainWindowController.getCurrentView().getResourceBundleBasename();
        if (presentViewBundle != null) {
            properties = new PropertiesHelper("/" + presentViewBundle.replace('.', '/') + ".properties");
        }
        Icon icon = IconHelper.createIcon(iconName);
        if (msgKey != null && !msgKey.equals("")) {
            msg = properties.getProperty(msgKey);
            if (msgArgs != null && msg != null) {
                msg = MessageFormat.format(msg, msgArgs);
            }
        }
        if (titleKey != null && !titleKey.equals("")) {
            title = properties.getProperty(titleKey);
            if (titleArgs != null && title != null) {
                title = MessageFormat.format(title, titleArgs);
            }
        }
        if (msg == null) {
            msg = "MISSING_MESSAGE_IN_BUNDLE : " + presentViewBundle;
        }
        if (title == null) {
            title = "MISSING_TITLE";
        }
        JTextArea txt = new JTextArea(msg);
        txt.setEditable(false);
        txt.setBackground(refMainWindowController.getView().getBackground());
        txt.setFont(refMainWindowController.getView().getFont());
        txt.setLineWrap(true);
        txt.setWrapStyleWord(true);
        txt.setCaretPosition(0);
        JScrollPane scrollPane = new JScrollPane(txt, 20, 31);
        JOptionPane pane = new JOptionPane(scrollPane, msgType);
        pane.setPreferredSize(new Dimension(400, 120));
        JDialog dialog = pane.createDialog(refMainWindowController.getView(), title);
        dialog.setResizable(true);
        dialog.setModal(true);
        dialog.show();
        return pane.getValue();
    }
}

